/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import java.security.InvalidParameterException;
import java.util.Objects;
import org.qtproject.qt.android.QtEmbeddedLoader;
import org.qtproject.qt.android.QtEmbeddedViewInterface;
import org.qtproject.qt.android.QtEmbeddedViewInterfaceFactory;
import org.qtproject.qt.android.QtLoader;
import org.qtproject.qt.android.QtNative;
import org.qtproject.qt.android.QtWindow;

abstract class QtView
extends ViewGroup
implements QtNative.AppStateDetailsListener {
    private static final String TAG = "QtView";
    protected QtWindow m_window;
    protected long m_windowReference;
    protected long m_parentWindowReference;
    protected QtWindowListener m_windowListener;
    protected final QtEmbeddedViewInterface m_viewInterface;

    protected abstract void createWindow(long var1);

    static native void createRootWindow(View var0, int var1, int var2, int var3, int var4);

    static native void deleteWindow(long var0);

    private static native void setWindowVisible(long var0, boolean var2);

    private static native void resizeWindow(long var0, int var2, int var3, int var4, int var5);

    QtView(Context context) {
        super(context);
        QtNative.registerAppStateListener(this);
        this.m_viewInterface = QtEmbeddedViewInterfaceFactory.create(context);
        this.addOnLayoutChangeListener((view, n, n2, n3, n4, n5, n6, n7, n8) -> {
            if (this.m_windowReference != 0L) {
                int n9 = n7 - n5;
                int n10 = n8 - n6;
                int n11 = n3 - n;
                int n12 = n4 - n2;
                if (n9 != n11 || n10 != n12 || n != n5 || n2 != n6) {
                    QtView.resizeWindow(this.m_windowReference, n, n2, n11, n12);
                }
            }
        });
        if (this.getId() == -1) {
            this.setId(View.generateViewId());
        }
    }

    QtView(Context context, String string2) throws InvalidParameterException {
        this(context);
        if (string2 == null || string2.isEmpty()) {
            throw new InvalidParameterException("QtView: argument 'appLibName' may not be empty or null");
        }
        this.loadQtLibraries(string2);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.m_viewInterface.addView(this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.destroyWindow();
        this.m_viewInterface.removeView(this);
    }

    public void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (this.m_window != null) {
            this.m_window.layout(0, 0, n3 - n, n4 - n2);
        }
    }

    protected void onMeasure(int n, int n2) {
        this.measureChildren(n, n2);
        int n3 = this.getChildCount();
        int n4 = 0;
        int n5 = 0;
        this.measureChildren(n, n2);
        for (int i = 0; i < n3; ++i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            n5 = Math.max(n5, view.getMeasuredWidth());
            n4 = Math.max(n4, view.getMeasuredHeight());
        }
        n4 = Math.max(n4, this.getSuggestedMinimumHeight());
        n5 = Math.max(n5, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(QtView.resolveSize((int)n5, (int)n), QtView.resolveSize((int)n4, (int)n2));
    }

    void setQtWindowListener(QtWindowListener qtWindowListener) {
        this.m_windowListener = qtWindowListener;
    }

    void loadQtLibraries(String string2) {
        QtEmbeddedLoader qtEmbeddedLoader;
        try {
            qtEmbeddedLoader = QtEmbeddedLoader.getEmbeddedLoader(this.getContext());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)TAG, (String)Objects.requireNonNull(illegalArgumentException.getMessage()));
            QtEmbeddedViewInterfaceFactory.remove(this.getContext());
            return;
        }
        qtEmbeddedLoader.setMainLibraryName(string2);
        QtLoader.LoadingResult loadingResult = qtEmbeddedLoader.loadQtLibraries();
        if (loadingResult == QtLoader.LoadingResult.Failed) {
            QtEmbeddedViewInterfaceFactory.remove(this.getContext());
        } else {
            this.m_viewInterface.startQtApplication(qtEmbeddedLoader.getApplicationParameters(), qtEmbeddedLoader.getMainLibraryPath());
        }
    }

    void setWindowReference(long l) {
        this.m_windowReference = l;
    }

    long windowReference() {
        return this.m_windowReference;
    }

    void setWindowVisible(boolean bl) {
        if (this.m_windowReference != 0L) {
            QtView.setWindowVisible(this.m_windowReference, true);
        }
    }

    void addQtWindow(QtWindow qtWindow, long l, long l2) {
        this.setWindowReference(l);
        this.m_parentWindowReference = l2;
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(() -> {
            this.m_window = qtWindow;
            this.m_window.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            this.addView((View)this.m_window, 0);
            this.setWindowVisible(true);
            if (this.m_windowListener != null) {
                this.m_windowListener.onQtWindowLoaded();
            }
        });
    }

    void destroyWindow() {
        if (this.m_parentWindowReference != 0L) {
            QtView.deleteWindow(this.m_parentWindowReference);
        }
        this.m_parentWindowReference = 0L;
        this.setWindowReference(0L);
    }

    QtWindow getQtWindow() {
        return this.m_window;
    }

    @Override
    public void onAppStateDetailsChanged(QtNative.ApplicationStateDetails applicationStateDetails) {
        ViewGroup viewGroup;
        if (!applicationStateDetails.isStarted && (viewGroup = (ViewGroup)this.getParent()) != null) {
            viewGroup.removeView((View)this);
        }
    }

    static interface QtWindowListener {
        public void onQtWindowLoaded();
    }
}

