/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.speech;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import android.speech.tts.Voice;
import android.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

class QtTextToSpeech {
    private static final String UTTERANCE_ID = "UtteranceId";
    private static final String SYNTHESIZE_ID = "SynthesizeId";
    private TextToSpeech mTts;
    private final long mId;
    private boolean mInitialized = false;
    private float mPitch = 1.0f;
    private float mRate = 1.0f;
    private float mVolume = 1.0f;
    private static final String TAG = "QtTextToSpeech";
    private final TextToSpeech.OnInitListener mTtsChangeListener = new TextToSpeech.OnInitListener(){

        public void onInit(int n) {
            if (n == 0) {
                QtTextToSpeech.this.mInitialized = true;
                QtTextToSpeech.this.notifyReady(QtTextToSpeech.this.mId);
                Log.d((String)QtTextToSpeech.TAG, (String)"TTS initialized");
            } else {
                QtTextToSpeech.this.mInitialized = false;
                QtTextToSpeech.this.notifyError(QtTextToSpeech.this.mId, 1L);
                Log.w((String)QtTextToSpeech.TAG, (String)"TTS initialization failed");
            }
        }
    };
    private String utteranceTAG = "UtteranceProgressListener";
    private final UtteranceProgressListener mTtsUtteranceProgressListener = new UtteranceProgressListener(){

        public void onDone(String string) {
            Log.d((String)QtTextToSpeech.this.utteranceTAG, (String)"onDone");
            if (string.equals(QtTextToSpeech.UTTERANCE_ID)) {
                QtTextToSpeech.this.notifyReady(QtTextToSpeech.this.mId);
            } else if (string.equals(QtTextToSpeech.SYNTHESIZE_ID)) {
                QtTextToSpeech.this.notifyEndSynthesis(QtTextToSpeech.this.mId);
            }
        }

        public void onError(String string) {
            this.onError(string, -1);
        }

        public void onError(String string, int n) {
            Log.w((String)QtTextToSpeech.this.utteranceTAG, (String)"onError");
            if (string.equals(QtTextToSpeech.UTTERANCE_ID)) {
                switch (n) {
                    default: 
                }
                QtTextToSpeech.this.notifyError(QtTextToSpeech.this.mId, 4L);
            }
        }

        public void onStart(String string) {
            Log.d((String)QtTextToSpeech.this.utteranceTAG, (String)"onStart");
            if (string.equals(QtTextToSpeech.UTTERANCE_ID)) {
                QtTextToSpeech.this.notifySpeaking(QtTextToSpeech.this.mId);
            }
        }

        public void onRangeStart(String string, int n, int n2, int n3) {
            Log.w((String)"UtteranceProgressListener", (String)"onRangeStart");
            if (string.equals(QtTextToSpeech.UTTERANCE_ID)) {
                QtTextToSpeech.this.notifyRangeStart(QtTextToSpeech.this.mId, n, n2, n3);
            }
        }

        public void onBeginSynthesis(String string, int n, int n2, int n3) {
            Log.d((String)QtTextToSpeech.this.utteranceTAG, (String)"onBeginSynthesis");
            if (string.equals(QtTextToSpeech.SYNTHESIZE_ID)) {
                switch (n2) {
                    case 3: {
                        n2 = 1;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                    case 4: {
                        n2 = 4;
                        break;
                    }
                    default: {
                        n2 = 0;
                    }
                }
                QtTextToSpeech.this.notifyBeginSynthesis(QtTextToSpeech.this.mId, n, n2, n3);
            }
        }

        public void onAudioAvailable(String string, byte[] byArray) {
            Log.d((String)QtTextToSpeech.this.utteranceTAG, (String)"onAudioAvailable");
            if (string.equals(QtTextToSpeech.SYNTHESIZE_ID)) {
                QtTextToSpeech.this.notifyAudioAvailable(QtTextToSpeech.this.mId, byArray);
            }
        }
    };

    native void notifyError(long var1, long var3);

    native void notifyReady(long var1);

    native void notifySpeaking(long var1);

    native void notifyRangeStart(long var1, int var3, int var4, int var5);

    native void notifyBeginSynthesis(long var1, int var3, int var4, int var5);

    native void notifyAudioAvailable(long var1, byte[] var3);

    native void notifyEndSynthesis(long var1);

    QtTextToSpeech(Context context, long l, String string) {
        float f;
        this.mId = l;
        this.mTts = string.isEmpty() ? new TextToSpeech(context, this.mTtsChangeListener) : new TextToSpeech(context, this.mTtsChangeListener, string);
        this.mTts.setOnUtteranceProgressListener(this.mTtsUtteranceProgressListener);
        ContentResolver contentResolver = context.getContentResolver();
        try {
            f = Settings.Secure.getFloat((ContentResolver)contentResolver, (String)"tts_default_pitch");
            this.mPitch = f / 100.0f;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            this.mPitch = 1.0f;
        }
        try {
            f = Settings.Secure.getFloat((ContentResolver)contentResolver, (String)"tts_default_rate");
            this.mRate = f / 100.0f;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            this.mRate = 1.0f;
        }
    }

    void say(String string) {
        Log.d((String)TAG, (String)("TTS say(): " + string));
        int n = -1;
        Bundle bundle = new Bundle();
        bundle.putFloat("volume", this.mVolume);
        n = this.mTts.speak((CharSequence)string, 0, bundle, UTTERANCE_ID);
        Log.d((String)TAG, (String)("TTS say() result: " + Integer.toString(n)));
        if (n == -1) {
            this.notifyError(this.mId, 3L);
        }
    }

    int synthesize(String string) {
        Log.d((String)TAG, (String)("TTS synthesize(): " + string));
        int n = -1;
        Bundle bundle = new Bundle();
        bundle.putFloat("volume", this.mVolume);
        File file = new File("/dev/null");
        n = this.mTts.synthesizeToFile((CharSequence)string, bundle, file, SYNTHESIZE_ID);
        Log.d((String)TAG, (String)("TTS synthesize() result: " + Integer.toString(n)));
        if (n == -1) {
            this.notifyError(this.mId, 3L);
        }
        return -1;
    }

    void stop() {
        Log.d((String)TAG, (String)"Stopping TTS");
        this.mTts.stop();
    }

    float pitch() {
        return this.mPitch;
    }

    int setPitch(float f) {
        if (Float.compare(f, this.mPitch) == 0) {
            return -1;
        }
        int n = this.mTts.setPitch(f);
        if (n == 0) {
            this.mPitch = f;
        } else {
            this.notifyError(this.mId, 2L);
        }
        return n;
    }

    float rate() {
        return this.mRate;
    }

    int setRate(float f) {
        if (Float.compare(f, this.mRate) == 0) {
            return -1;
        }
        int n = this.mTts.setSpeechRate(f);
        if (n == 0) {
            this.mRate = f;
        } else {
            this.notifyError(this.mId, 2L);
        }
        return n;
    }

    void shutdown() {
        this.mTts.shutdown();
    }

    float volume() {
        return this.mVolume;
    }

    int setVolume(float f) {
        if (Float.compare(f, this.mVolume) == 0) {
            return -1;
        }
        this.mVolume = f;
        return 0;
    }

    boolean setLocale(Locale locale) {
        int n = this.mTts.setLanguage(locale);
        return n != -2 && n != -1;
    }

    List<Object> getAvailableVoices() {
        if (this.mInitialized && Build.VERSION.SDK_INT >= 21) {
            return new ArrayList<Object>(this.mTts.getVoices());
        }
        return new ArrayList<Object>();
    }

    List<Locale> getAvailableLocales() {
        if (this.mInitialized && Build.VERSION.SDK_INT >= 21) {
            Set set = this.mTts.getAvailableLanguages();
            ArrayList<Locale> arrayList = new ArrayList<Locale>();
            for (Locale locale : set) {
                String string = locale.getLanguage();
                String string2 = locale.getCountry();
                if (string.equals(locale.getISO3Language())) {
                    string = this.convertLanguageCodeThreeDigitToTwoDigit(string);
                }
                if (string2.equals(locale.getISO3Country())) {
                    string2 = this.convertCountryCodeThreeDigitToTwoDigit(string2);
                }
                arrayList.add(new Locale(string, string2));
            }
            return arrayList;
        }
        return new ArrayList<Locale>();
    }

    Locale getLocale() {
        Locale locale = this.mTts.getLanguage();
        if (locale == null) {
            return null;
        }
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        if (string.equals(locale.getISO3Language())) {
            string = this.convertLanguageCodeThreeDigitToTwoDigit(string);
        }
        if (string2.equals(locale.getISO3Country())) {
            string2 = this.convertCountryCodeThreeDigitToTwoDigit(string2);
        }
        return new Locale(string, string2);
    }

    Object getVoice() {
        if (this.mInitialized && Build.VERSION.SDK_INT >= 21) {
            return this.mTts.getVoice();
        }
        return null;
    }

    boolean setVoice(String string) {
        if (!this.mInitialized) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            for (Voice voice : this.mTts.getVoices()) {
                if (!voice.getName().equals(string)) continue;
                int n = this.mTts.setVoice(voice);
                if (n != 0) break;
                return true;
            }
        }
        return false;
    }

    private String convertLanguageCodeThreeDigitToTwoDigit(String string) {
        String[] stringArray;
        for (String string2 : stringArray = Locale.getISOLanguages()) {
            if (!string.equals(new Locale(string2).getISO3Language())) continue;
            return string2;
        }
        return string;
    }

    private String convertCountryCodeThreeDigitToTwoDigit(String string) {
        String[] stringArray;
        for (String string2 : stringArray = Locale.getISOCountries()) {
            if (!string.equals(new Locale("en", string2).getISO3Country())) continue;
            return string2;
        }
        return string;
    }
}

