/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.multimedia;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.util.Range;
import android.view.Surface;
import java.util.ArrayList;
import java.util.List;
import org.qtproject.qt.android.UsedFromNativeCode;
import org.qtproject.qt.android.multimedia.QtExifDataHandler;
import org.qtproject.qt.android.multimedia.QtVideoDeviceManager;

@TargetApi(value=23)
class QtCamera2 {
    CameraDevice mCameraDevice = null;
    QtVideoDeviceManager mVideoDeviceManager = null;
    HandlerThread mBackgroundThread;
    Handler mBackgroundHandler;
    ImageReader mImageReader = null;
    ImageReader mCapturedPhotoReader = null;
    CameraManager mCameraManager;
    CameraCaptureSession mCaptureSession;
    CaptureRequest.Builder mPreviewRequestBuilder;
    CaptureRequest mPreviewRequest;
    String mCameraId;
    List<Surface> mTargetSurfaces = new ArrayList<Surface>();
    private static final int STATE_PREVIEW = 0;
    private static final int STATE_WAITING_FOCUS_LOCK = 1;
    private static final int STATE_WAITING_EXPOSURE_PRECAPTURE = 2;
    private static final int STATE_WAITING_EXPOSURE_NON_PRECAPTURE = 3;
    private static final int STATE_PICTURE_TAKEN = 4;
    private int mState = 0;
    private static int MaxNumberFrames = 12;
    private static final int DEFAULT_FLASH_MODE = 1;
    private static final int DEFAULT_TORCH_MODE = 0;
    private static final int DEFAULT_AF_MODE = 0;
    private static final float DEFAULT_ZOOM_FACTOR = 1.0f;
    private final SyncedMembers mSyncedMembers = new SyncedMembers();
    private Range<Integer> mFpsRange = null;
    private QtExifDataHandler mExifDataHandler = null;
    CameraDevice.StateCallback mStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(CameraDevice cameraDevice) {
            if (QtCamera2.this.mCameraDevice != null) {
                QtCamera2.this.mCameraDevice.close();
            }
            QtCamera2.this.mCameraDevice = cameraDevice;
            QtCamera2.this.onCameraOpened(QtCamera2.this.mCameraId);
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            cameraDevice.close();
            if (QtCamera2.this.mCameraDevice == cameraDevice) {
                QtCamera2.this.mCameraDevice = null;
            }
            QtCamera2.this.onCameraDisconnect(QtCamera2.this.mCameraId);
        }

        public void onError(CameraDevice cameraDevice, int n) {
            cameraDevice.close();
            if (QtCamera2.this.mCameraDevice == cameraDevice) {
                QtCamera2.this.mCameraDevice = null;
            }
            QtCamera2.this.onCameraError(QtCamera2.this.mCameraId, n);
        }
    };
    CameraCaptureSession.StateCallback mCaptureStateCallback = new CameraCaptureSession.StateCallback(){

        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            QtCamera2.this.mCaptureSession = cameraCaptureSession;
            QtCamera2.this.onCaptureSessionConfigured(QtCamera2.this.mCameraId);
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            QtCamera2.this.onCaptureSessionConfigureFailed(QtCamera2.this.mCameraId);
        }

        public void onActive(CameraCaptureSession cameraCaptureSession) {
            super.onActive(cameraCaptureSession);
            QtCamera2.this.onSessionActive(QtCamera2.this.mCameraId);
        }

        public void onClosed(CameraCaptureSession cameraCaptureSession) {
            super.onClosed(cameraCaptureSession);
            QtCamera2.this.onSessionClosed(QtCamera2.this.mCameraId);
        }
    };
    CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureFailed(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, CaptureFailure captureFailure) {
            super.onCaptureFailed(cameraCaptureSession, captureRequest, captureFailure);
            QtCamera2.this.onCaptureSessionFailed(QtCamera2.this.mCameraId, captureFailure.getReason(), captureFailure.getFrameNumber());
        }

        private void handleCaptureFocusLock(CaptureResult captureResult) {
            boolean bl;
            Integer n = (Integer)captureResult.get(CaptureResult.CONTROL_AF_STATE);
            if (n == null) {
                QtCamera2.this.capturePhoto();
                return;
            }
            int n2 = n;
            boolean bl2 = bl = n2 == 4 || n2 == 5;
            if (bl) {
                Integer n3 = (Integer)captureResult.get(CaptureResult.CONTROL_AE_STATE);
                if (n3 == null || n3 == 2) {
                    QtCamera2.this.mState = 4;
                    QtCamera2.this.capturePhoto();
                } else {
                    try {
                        QtCamera2.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
                        QtCamera2.this.mState = 2;
                        QtCamera2.this.mCaptureSession.capture(QtCamera2.this.mPreviewRequestBuilder.build(), QtCamera2.this.mCaptureCallback, QtCamera2.this.mBackgroundHandler);
                    }
                    catch (CameraAccessException cameraAccessException) {
                        Log.w((String)"QtCamera2", (String)("Cannot get access to the camera: " + (Object)((Object)cameraAccessException)));
                    }
                }
            }
        }

        private void handleCaptureExposurePrecapture(CaptureResult captureResult) {
            Integer n = (Integer)captureResult.get(CaptureResult.CONTROL_AE_STATE);
            if (n == null || n == 5) {
                QtCamera2.this.mState = 3;
            }
        }

        private void handleCaptureExposureNonPrecapture(CaptureResult captureResult) {
            Integer n = (Integer)captureResult.get(CaptureResult.CONTROL_AE_STATE);
            if (n == null || n != 5) {
                QtCamera2.this.mState = 4;
                QtCamera2.this.capturePhoto();
            }
        }

        private void process(CaptureResult captureResult) {
            switch (QtCamera2.this.mState) {
                case 1: {
                    this.handleCaptureFocusLock(captureResult);
                    break;
                }
                case 2: {
                    this.handleCaptureExposurePrecapture(captureResult);
                    break;
                }
                case 3: {
                    this.handleCaptureExposureNonPrecapture(captureResult);
                    break;
                }
            }
        }

        public void onCaptureProgressed(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, CaptureResult captureResult) {
            this.process(captureResult);
        }

        public void onCaptureCompleted(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
            this.process((CaptureResult)totalCaptureResult);
        }
    };
    ImageReader.OnImageAvailableListener mOnPhotoAvailableListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader imageReader) {
            QtCamera2.this.onPhotoAvailable(QtCamera2.this.mCameraId, imageReader.acquireLatestImage());
        }
    };
    ImageReader.OnImageAvailableListener mOnImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader imageReader) {
            try {
                Image image = imageReader.acquireLatestImage();
                if (image != null) {
                    QtCamera2.this.onFrameAvailable(QtCamera2.this.mCameraId, image);
                }
            }
            catch (IllegalStateException illegalStateException) {
                Log.e((String)"QtCamera2", (String)("Image processing taking too long. Let's wait 0,5s more " + illegalStateException));
                try {
                    Thread.sleep(500L);
                    QtCamera2.this.onFrameAvailable(QtCamera2.this.mCameraId, imageReader.acquireLatestImage());
                }
                catch (IllegalStateException | InterruptedException exception) {
                    Log.e((String)"QtCamera2", (String)("Will not wait anymore. Restart camera session. " + exception));
                    String string = QtCamera2.this.mCameraId;
                    QtCamera2.this.stopAndClose();
                    QtCamera2.this.addImageReader(QtCamera2.this.mImageReader.getWidth(), QtCamera2.this.mImageReader.getHeight(), QtCamera2.this.mImageReader.getImageFormat());
                    QtCamera2.this.open(string);
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    public void resetControlProperties() {
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            this.mSyncedMembers.mFlashMode = 1;
            this.mSyncedMembers.mTorchMode = 0;
            this.mSyncedMembers.mAFMode = 0;
            this.mSyncedMembers.mZoomFactor = 1.0f;
        }
    }

    native void onCameraOpened(String var1);

    native void onCameraDisconnect(String var1);

    native void onCameraError(String var1, int var2);

    native void onCaptureSessionConfigured(String var1);

    native void onCaptureSessionConfigureFailed(String var1);

    native void onSessionActive(String var1);

    native void onSessionClosed(String var1);

    native void onCaptureSessionFailed(String var1, int var2, long var3);

    QtCamera2(Context context) {
        this.mCameraManager = (CameraManager)context.getSystemService("camera");
        this.mVideoDeviceManager = new QtVideoDeviceManager(context);
        this.startBackgroundThread();
    }

    void startBackgroundThread() {
        this.mBackgroundThread = new HandlerThread("CameraBackground");
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
    }

    @UsedFromNativeCode
    void stopBackgroundThread() {
        this.mBackgroundThread.quitSafely();
        try {
            this.mBackgroundThread.join();
            this.mBackgroundThread = null;
            this.mBackgroundHandler = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    boolean open(String string) {
        try {
            this.mCameraId = string;
            this.mCameraManager.openCamera(string, this.mStateCallback, this.mBackgroundHandler);
            return true;
        }
        catch (Exception exception) {
            Log.w((String)"QtCamera2", (String)("Failed to open camera:" + exception));
            return false;
        }
    }

    native void onPhotoAvailable(String var1, Image var2);

    native void onFrameAvailable(String var1, Image var2);

    @UsedFromNativeCode
    void prepareCamera(int n, int n2, int n3, int n4, int n5) {
        this.addImageReader(n, n2, n3);
        this.setFrameRate(n4, n5);
    }

    private void addImageReader(int n, int n2, int n3) {
        if (this.mImageReader != null) {
            this.removeSurface(this.mImageReader.getSurface());
        }
        if (this.mCapturedPhotoReader != null) {
            this.removeSurface(this.mCapturedPhotoReader.getSurface());
        }
        this.mImageReader = ImageReader.newInstance((int)n, (int)n2, (int)n3, (int)MaxNumberFrames);
        this.mImageReader.setOnImageAvailableListener(this.mOnImageAvailableListener, this.mBackgroundHandler);
        this.addSurface(this.mImageReader.getSurface());
        this.mCapturedPhotoReader = ImageReader.newInstance((int)n, (int)n2, (int)n3, (int)MaxNumberFrames);
        this.mCapturedPhotoReader.setOnImageAvailableListener(this.mOnPhotoAvailableListener, this.mBackgroundHandler);
        this.addSurface(this.mCapturedPhotoReader.getSurface());
    }

    private void setFrameRate(int n, int n2) {
        this.mFpsRange = n <= 0 || n2 <= 0 ? null : new Range((Comparable)Integer.valueOf(n), (Comparable)Integer.valueOf(n2));
    }

    boolean addSurface(Surface surface) {
        if (this.mTargetSurfaces.contains(surface)) {
            return true;
        }
        return this.mTargetSurfaces.add(surface);
    }

    boolean removeSurface(Surface surface) {
        return this.mTargetSurfaces.remove(surface);
    }

    @UsedFromNativeCode
    void clearSurfaces() {
        this.mTargetSurfaces.clear();
    }

    @UsedFromNativeCode
    boolean createSession() {
        if (this.mCameraDevice == null) {
            return false;
        }
        try {
            this.mCameraDevice.createCaptureSession(this.mTargetSurfaces, this.mCaptureStateCallback, this.mBackgroundHandler);
            return true;
        }
        catch (Exception exception) {
            Log.w((String)"QtCamera2", (String)("Failed to create a capture session:" + exception));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    boolean start(int n) {
        if (this.mCameraDevice == null) {
            return false;
        }
        if (this.mCaptureSession == null) {
            return false;
        }
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            try {
                this.mPreviewRequestBuilder = this.mCameraDevice.createCaptureRequest(n);
                this.mPreviewRequestBuilder.addTarget(this.mImageReader.getSurface());
                this.mSyncedMembers.mAFMode = 0;
                for (int n2 : this.mVideoDeviceManager.getAllAvailableAfModes(this.mCameraId)) {
                    if (n2 != 4) continue;
                    this.mSyncedMembers.mAFMode = n2;
                    break;
                }
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)this.mSyncedMembers.mFlashMode);
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)this.mSyncedMembers.mTorchMode);
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)this.mSyncedMembers.mAFMode);
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_CAPTURE_INTENT, (Object)3);
                if (this.mSyncedMembers.mZoomFactor != 1.0f) {
                    this.updateZoom(this.mPreviewRequestBuilder, this.mSyncedMembers.mZoomFactor);
                }
                if (this.mFpsRange != null) {
                    this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, this.mFpsRange);
                }
                this.mPreviewRequest = this.mPreviewRequestBuilder.build();
                this.mCaptureSession.setRepeatingRequest(this.mPreviewRequest, this.mCaptureCallback, this.mBackgroundHandler);
                this.mSyncedMembers.mIsStarted = true;
                return true;
            }
            catch (Exception exception) {
                Log.w((String)"QtCamera2", (String)("Failed to start preview:" + exception));
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    void stopAndClose() {
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            try {
                if (null != this.mCaptureSession) {
                    this.mCaptureSession.close();
                    this.mCaptureSession = null;
                }
                if (null != this.mCameraDevice) {
                    this.mCameraDevice.close();
                    this.mCameraDevice = null;
                }
                this.mCameraId = "";
                this.mTargetSurfaces.clear();
            }
            catch (Exception exception) {
                Log.w((String)"QtCamera2", (String)("Failed to stop and close:" + exception));
            }
            this.mSyncedMembers.mIsStarted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void capturePhoto() {
        int n = 0;
        float f = 0.0f;
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            n = this.mSyncedMembers.mFlashMode;
            f = this.mSyncedMembers.mZoomFactor;
        }
        try {
            syncedMembers = this.mCameraDevice.createCaptureRequest(2);
            syncedMembers.addTarget(this.mCapturedPhotoReader.getSurface());
            syncedMembers.set(CaptureRequest.CONTROL_AE_MODE, n);
            if (f != 1.0f) {
                this.updateZoom((CaptureRequest.Builder)syncedMembers, f);
            }
            StillPhotoCaptureSessionCallback stillPhotoCaptureSessionCallback = new StillPhotoCaptureSessionCallback();
            this.mCaptureSession.capture(syncedMembers.build(), (CameraCaptureSession.CaptureCallback)stillPhotoCaptureSessionCallback, this.mBackgroundHandler);
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    void takePhoto() {
        int n = 0;
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            n = this.mSyncedMembers.mAFMode;
        }
        try {
            if (n == 4) {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
                this.mState = 1;
                this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, this.mBackgroundHandler);
            } else {
                this.capturePhoto();
            }
        }
        catch (CameraAccessException cameraAccessException) {
            Log.w((String)"QtCamera2", (String)("Cannot get access to the camera: " + (Object)((Object)cameraAccessException)));
        }
    }

    @UsedFromNativeCode
    void saveExifToFile(String string) {
        if (this.mExifDataHandler != null) {
            this.mExifDataHandler.save(string);
        } else {
            Log.e((String)"QtCamera2", (String)("No Exif data that could be saved to " + string));
        }
    }

    private Rect getScalerCropRegion(float f) {
        Rect rect = this.mVideoDeviceManager.getActiveArraySize(this.mCameraId);
        float f2 = 1.0f;
        if (f != 0.0f) {
            f2 = 1.0f / f;
        }
        int n = rect.width() - (int)((float)rect.width() * f2);
        int n2 = rect.height() - (int)((float)rect.height() * f2);
        return new Rect(n / 2, n2 / 2, rect.width() - n / 2, rect.height() - n2 / 2);
    }

    private void updateZoom(CaptureRequest.Builder builder, float f) {
        if (Build.VERSION.SDK_INT < 30) {
            builder.set(CaptureRequest.SCALER_CROP_REGION, (Object)this.getScalerCropRegion(f));
        } else {
            builder.set(CaptureRequest.CONTROL_ZOOM_RATIO, (Object)Float.valueOf(f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    void zoomTo(float f) {
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            this.mSyncedMembers.mZoomFactor = f;
            if (!this.mSyncedMembers.mIsStarted) {
                return;
            }
            this.updateZoom(this.mPreviewRequestBuilder, f);
            this.mPreviewRequest = this.mPreviewRequestBuilder.build();
            try {
                this.mCaptureSession.setRepeatingRequest(this.mPreviewRequest, this.mCaptureCallback, this.mBackgroundHandler);
            }
            catch (Exception exception) {
                Log.w((String)"QtCamera2", (String)("Failed to set zoom:" + exception));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    void setFlashMode(String string) {
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            int n = this.mVideoDeviceManager.stringToControlAEMode(string);
            if (n < 0) {
                Log.w((String)"QtCamera2", (String)"Unknown flash mode");
                return;
            }
            this.mSyncedMembers.mFlashMode = n;
            if (!this.mSyncedMembers.mIsStarted) {
                return;
            }
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)this.mSyncedMembers.mFlashMode);
            this.mPreviewRequest = this.mPreviewRequestBuilder.build();
            try {
                this.mCaptureSession.setRepeatingRequest(this.mPreviewRequest, this.mCaptureCallback, this.mBackgroundHandler);
            }
            catch (Exception exception) {
                Log.w((String)"QtCamera2", (String)("Failed to set flash mode:" + exception));
            }
        }
    }

    private int getTorchModeValue(boolean bl) {
        return bl ? 2 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    void setTorchMode(boolean bl) {
        SyncedMembers syncedMembers = this.mSyncedMembers;
        synchronized (syncedMembers) {
            this.mSyncedMembers.mTorchMode = this.getTorchModeValue(bl);
            if (this.mSyncedMembers.mIsStarted) {
                this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)this.mSyncedMembers.mTorchMode);
                this.mPreviewRequest = this.mPreviewRequestBuilder.build();
                try {
                    this.mCaptureSession.setRepeatingRequest(this.mPreviewRequest, this.mCaptureCallback, this.mBackgroundHandler);
                }
                catch (Exception exception) {
                    Log.w((String)"QtCamera2", (String)("Failed to set flash mode:" + exception));
                }
            }
        }
    }

    class SyncedMembers {
        private boolean mIsStarted = false;
        private int mFlashMode = 1;
        private int mTorchMode = 0;
        private int mAFMode = 0;
        private float mZoomFactor = 1.0f;

        SyncedMembers() {
        }
    }

    class StillPhotoCaptureSessionCallback
    extends CameraCaptureSession.CaptureCallback {
        StillPhotoCaptureSessionCallback() {
        }

        public void onCaptureCompleted(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
            try {
                QtCamera2.this.mExifDataHandler = new QtExifDataHandler((CaptureResult)totalCaptureResult);
                QtCamera2.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
                QtCamera2.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)0);
                QtCamera2.this.mPreviewRequest = QtCamera2.this.mPreviewRequestBuilder.build();
                QtCamera2.this.mState = 0;
                QtCamera2.this.mCaptureSession.setRepeatingRequest(QtCamera2.this.mPreviewRequest, QtCamera2.this.mCaptureCallback, QtCamera2.this.mBackgroundHandler);
            }
            catch (CameraAccessException cameraAccessException) {
                cameraAccessException.printStackTrace();
            }
            catch (NullPointerException nullPointerException) {
                Log.e((String)"QtCamera2", (String)"Null-pointer access exception thrown when finalizing still photo capture. This should not be possible.");
                nullPointerException.printStackTrace();
            }
        }
    }
}

