/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.bluetooth;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.util.Log;

class QtBluetoothUtility {
    private static final String TAG = "QtBluetoothUtility";
    private static boolean isScanRequiresLocationChecked = false;
    private static boolean scanRequiresLocation = true;

    QtBluetoothUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean bluetoothScanRequiresLocation(Context context) {
        Log.d((String)TAG, (String)"Checking if Location is required for bluetooth scan");
        if (isScanRequiresLocationChecked) {
            Log.d((String)TAG, (String)("Using cached result for scan needing location: " + scanRequiresLocation));
            return scanRequiresLocation;
        }
        if (Build.VERSION.SDK_INT < 31) {
            Log.d((String)TAG, (String)"SDK version is below 31, assuming Location needed");
            scanRequiresLocation = true;
            isScanRequiresLocationChecked = true;
            return scanRequiresLocation;
        }
        if (context == null) {
            Log.w((String)TAG, (String)"No context object provided");
            return false;
        }
        try (XmlResourceParser xmlResourceParser = null;){
            AssetManager assetManager = context.createPackageContext(context.getPackageName(), 0).getAssets();
            xmlResourceParser = assetManager.openXmlResourceParser(0, "AndroidManifest.xml");
            int n = xmlResourceParser.getEventType();
            while (n != 1) {
                if (n == 2 && xmlResourceParser.getName().equals("uses-permission")) {
                    int n2;
                    String string = null;
                    int n3 = 0;
                    for (n2 = 0; n2 < xmlResourceParser.getAttributeCount(); n2 += 1) {
                        String string2 = xmlResourceParser.getAttributeName(n2);
                        if (string2.equals("name")) {
                            string = xmlResourceParser.getAttributeValue(n2);
                            continue;
                        }
                        if (!string2.equals("usesPermissionFlags")) continue;
                        String string3 = xmlResourceParser.getAttributeValue(n2);
                        n3 = string3.startsWith("0x") ? Integer.parseInt(string3.substring(2), 16) : Integer.parseInt(string3);
                    }
                    if (string.equals("android.permission.BLUETOOTH_SCAN")) {
                        if ((n3 & 0x10000) != 0) {
                            Log.d((String)TAG, (String)"BLUETOOTH_SCAN with 'neverForLocation' found");
                            scanRequiresLocation = false;
                        } else {
                            Log.d((String)TAG, (String)"BLUETOOTH_SCAN without 'neverForLocation' found");
                            scanRequiresLocation = true;
                        }
                        isScanRequiresLocationChecked = true;
                        n2 = scanRequiresLocation ? 1 : 0;
                        return n2 != 0;
                    }
                }
                n = xmlResourceParser.nextToken();
            }
        }
        Log.d((String)TAG, (String)"BLUETOOTH_SCAN permission not found");
        isScanRequiresLocationChecked = true;
        return scanRequiresLocation;
    }
}

