/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Point;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.HashMap;

@SuppressLint(value={"ViewConstructor"})
class EditContextView
extends LinearLayout
implements View.OnClickListener {
    static final int CUT_BUTTON = 1;
    static final int COPY_BUTTON = 2;
    static final int PASTE_BUTTON = 4;
    static final int SELECT_ALL_BUTTON = 8;
    HashMap<Integer, ContextButton> m_buttons = new HashMap(4);
    OnClickListener m_onClickListener;

    public void onClick(View view) {
        ContextButton contextButton = (ContextButton)view;
        this.m_onClickListener.contextButtonClicked(contextButton.m_buttonId);
    }

    void addButton(int n) {
        ContextButton contextButton = new ContextButton(this.getContext(), n);
        this.m_buttons.put(n, contextButton);
        this.addView((View)contextButton);
    }

    void updateButtons(int n) {
        ContextButton contextButton = this.m_buttons.get(17039363);
        if (contextButton != null) {
            contextButton.setVisibility((n & 1) != 0 ? 0 : 8);
        }
        if ((contextButton = this.m_buttons.get(0x1040001)) != null) {
            contextButton.setVisibility((n & 2) != 0 ? 0 : 8);
        }
        if ((contextButton = this.m_buttons.get(17039371)) != null) {
            contextButton.setVisibility((n & 4) != 0 ? 0 : 8);
        }
        if ((contextButton = this.m_buttons.get(17039373)) != null) {
            contextButton.setVisibility((n & 8) != 0 ? 0 : 8);
        }
    }

    Point getCalculatedSize() {
        Point point = new Point(0, 0);
        for (ContextButton contextButton : this.m_buttons.values()) {
            if (contextButton.getVisibility() != 0) continue;
            contextButton.measure(0, 0);
            point.x += contextButton.getMeasuredWidth();
            point.y = Math.max(point.y, contextButton.getMeasuredHeight());
        }
        point.x += this.getPaddingLeft() + this.getPaddingRight();
        point.y += this.getPaddingTop() + this.getPaddingBottom();
        return point;
    }

    EditContextView(Context context, OnClickListener onClickListener) {
        super(context);
        this.m_onClickListener = onClickListener;
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.addButton(17039363);
        this.addButton(0x1040001);
        this.addButton(17039371);
        this.addButton(17039373);
    }

    private class ContextButton
    extends TextView {
        int m_buttonId;

        ContextButton(Context context, int n) {
            super(context);
            this.m_buttonId = n;
            this.setText(n);
            this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 1.0f));
            this.setGravity(17);
            this.setTextColor(this.getResources().getColor(17170442, context.getTheme()));
            EditContextView.this.setBackground(this.getResources().getDrawable(17301529, context.getTheme()));
            float f = this.getResources().getDisplayMetrics().density;
            int n2 = (int)(16.0f * f + 0.5f);
            int n3 = (int)(8.0f * f + 0.5f);
            this.setPadding(n2, n3, n2, n3);
            this.setSingleLine();
            this.setEllipsize(TextUtils.TruncateAt.END);
            this.setOnClickListener(EditContextView.this);
        }
    }

    static interface OnClickListener {
        public void contextButtonClicked(int var1);
    }
}

