/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.AnimatedStateListDrawable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.RotateDrawable;
import android.graphics.drawable.ScaleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.util.Xml;
import android.view.ContextThemeWrapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;

class ExtractStyle {
    final int[] viewDrawableStatesState = new int[]{16842908, 16842909, 16842910, 0x10100A1, 16842919, 16843518, 16843547, 16843623, 16843624, 16843625};
    final int[] EMPTY_STATE_SET = new int[0];
    final int[] ENABLED_STATE_SET = new int[]{16842910};
    final int[] FOCUSED_STATE_SET = new int[]{16842908};
    final int[] SELECTED_STATE_SET = new int[]{0x10100A1};
    final int[] PRESSED_STATE_SET = new int[]{16842919};
    final int[] WINDOW_FOCUSED_STATE_SET = new int[]{16842909};
    final int[] ENABLED_FOCUSED_STATE_SET = this.stateSetUnion(this.ENABLED_STATE_SET, this.FOCUSED_STATE_SET);
    final int[] ENABLED_SELECTED_STATE_SET = this.stateSetUnion(this.ENABLED_STATE_SET, this.SELECTED_STATE_SET);
    final int[] ENABLED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.ENABLED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] FOCUSED_SELECTED_STATE_SET = this.stateSetUnion(this.FOCUSED_STATE_SET, this.SELECTED_STATE_SET);
    final int[] FOCUSED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.FOCUSED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] SELECTED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.SELECTED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] ENABLED_FOCUSED_SELECTED_STATE_SET = this.stateSetUnion(this.ENABLED_FOCUSED_STATE_SET, this.SELECTED_STATE_SET);
    final int[] ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.ENABLED_FOCUSED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.ENABLED_SELECTED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.FOCUSED_SELECTED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.ENABLED_FOCUSED_SELECTED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] PRESSED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] PRESSED_SELECTED_STATE_SET = this.stateSetUnion(this.PRESSED_STATE_SET, this.SELECTED_STATE_SET);
    final int[] PRESSED_SELECTED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_SELECTED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] PRESSED_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_STATE_SET, this.FOCUSED_STATE_SET);
    final int[] PRESSED_FOCUSED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_FOCUSED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] PRESSED_FOCUSED_SELECTED_STATE_SET = this.stateSetUnion(this.PRESSED_FOCUSED_STATE_SET, this.SELECTED_STATE_SET);
    final int[] PRESSED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_FOCUSED_SELECTED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] PRESSED_ENABLED_STATE_SET = this.stateSetUnion(this.PRESSED_STATE_SET, this.ENABLED_STATE_SET);
    final int[] PRESSED_ENABLED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_ENABLED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] PRESSED_ENABLED_SELECTED_STATE_SET = this.stateSetUnion(this.PRESSED_ENABLED_STATE_SET, this.SELECTED_STATE_SET);
    final int[] PRESSED_ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_ENABLED_SELECTED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] PRESSED_ENABLED_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_ENABLED_STATE_SET, this.FOCUSED_STATE_SET);
    final int[] PRESSED_ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_ENABLED_FOCUSED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final int[] PRESSED_ENABLED_FOCUSED_SELECTED_STATE_SET = this.stateSetUnion(this.PRESSED_ENABLED_FOCUSED_STATE_SET, this.SELECTED_STATE_SET);
    final int[] PRESSED_ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET = this.stateSetUnion(this.PRESSED_ENABLED_FOCUSED_SELECTED_STATE_SET, this.WINDOW_FOCUSED_STATE_SET);
    final Resources.Theme m_theme;
    final String m_extractPath;
    final int defaultBackgroundColor;
    final int defaultTextColor;
    final boolean m_minimal;
    final int[] DrawableStates = new int[]{16842914, 0x10100A0, 16842910, 16842908, 16842919, 0x10100A1, 16842909, 0x1020000, 16843597, 16843518, 16843547};
    final String[] DrawableStatesLabels = new String[]{"active", "checked", "enabled", "focused", "pressed", "selected", "window_focused", "background", "multiline", "activated", "accelerated"};
    final String[] DisableDrawableStatesLabels = new String[]{"inactive", "unchecked", "disabled", "not_focused", "no_pressed", "unselected", "window_not_focused", "background", "multiline", "activated", "accelerated"};
    final String[] sScaleTypeArray = new String[]{"MATRIX", "FIT_XY", "FIT_START", "FIT_CENTER", "FIT_END", "CENTER", "CENTER_CROP", "CENTER_INSIDE"};
    Context m_context;
    private final HashMap<String, DrawableCache> m_drawableCache = new HashMap();
    private static boolean m_missingNormalStyle = false;
    private static boolean m_missingDarkStyle = false;
    private static String m_stylePath = null;
    private static boolean m_extractMinimal = false;
    private static final String QtTAG = "QtExtractStyle";

    private static boolean isUiModeDark(Configuration configuration) {
        return (configuration.uiMode & 0x30) == 32;
    }

    static String setup(Context context, String string2, int n) {
        int n2;
        String string3 = context.getApplicationInfo().dataDir;
        m_stylePath = string3 + "/qt-reserved-files/android-style/" + n + "/";
        if (string2.equals("none")) {
            return m_stylePath;
        }
        if (string2.isEmpty()) {
            string2 = "minimal";
        }
        if (!(string2.equals("default") || string2.equals("full") || string2.equals("minimal") || string2.equals("none"))) {
            Log.e((String)QtTAG, (String)("Invalid extract_android_style option \"" + string2 + "\", defaulting to \"minimal\""));
            string2 = "minimal";
        }
        if (string2.equals("default") && (n2 = context.getApplicationInfo().targetSdkVersion) < 28 && Build.VERSION.SDK_INT >= 28) {
            Log.e((String)QtTAG, (String)"extract_android_style option set to \"none\" when targetSdkVersion is less then 28");
            string2 = "none";
        }
        n2 = !new File(m_stylePath + "darkUiMode/style.json").exists() ? 1 : 0;
        m_missingDarkStyle = Build.VERSION.SDK_INT > 28 && n2 != 0;
        m_missingNormalStyle = !new File(m_stylePath + "style.json").exists();
        m_extractMinimal = string2.equals("minimal");
        ExtractStyle.runIfNeeded(context, ExtractStyle.isUiModeDark(context.getResources().getConfiguration()));
        return m_stylePath;
    }

    static void runIfNeeded(Context context, boolean bl) {
        if (m_stylePath == null) {
            return;
        }
        if (bl) {
            if (m_missingDarkStyle) {
                new ExtractStyle(context, m_stylePath + "darkUiMode/", m_extractMinimal);
                m_missingDarkStyle = false;
            }
        } else if (m_missingNormalStyle) {
            new ExtractStyle(context, m_stylePath, m_extractMinimal);
            m_missingNormalStyle = false;
        }
    }

    ExtractStyle(Context context, String string2, boolean bl) {
        this.m_minimal = bl;
        this.m_extractPath = string2 + "/";
        boolean bl2 = new File(this.m_extractPath).mkdirs();
        if (!bl2) {
            Log.w((String)"Qt JAVA", (String)"Cannot create Android style directory.");
        }
        this.m_context = context;
        this.m_theme = context.getTheme();
        TypedArray typedArray = this.m_theme.obtainStyledAttributes(new int[]{0x1010031, 16842806, 16842904});
        this.defaultBackgroundColor = typedArray.getColor(0, 0);
        int n = typedArray.getColor(1, 0xFFFFFF);
        if (n == 0xFFFFFF) {
            n = typedArray.getColor(2, 0xFFFFFF);
        }
        this.defaultTextColor = n;
        typedArray.recycle();
        try {
            SimpleJsonWriter simpleJsonWriter = new SimpleJsonWriter(this.m_extractPath + "style.json");
            simpleJsonWriter.beginObject();
            try {
                simpleJsonWriter.name("defaultStyle").value(this.extractDefaultPalette());
                this.extractWindow(simpleJsonWriter);
                simpleJsonWriter.name("buttonStyle").value(this.extractTextAppearanceInformation(16842824, "QPushButton"));
                simpleJsonWriter.name("spinnerStyle").value(this.extractTextAppearanceInformation(0x1010081, "QComboBox"));
                this.extractProgressBar(simpleJsonWriter, 16842872, "progressBarStyleHorizontal", "QProgressBar");
                this.extractProgressBar(simpleJsonWriter, 16842874, "progressBarStyleLarge", null);
                this.extractProgressBar(simpleJsonWriter, 16842873, "progressBarStyleSmall", null);
                this.extractProgressBar(simpleJsonWriter, 0x1010077, "progressBarStyle", null);
                this.extractAbsSeekBar(simpleJsonWriter);
                this.extractSwitch(simpleJsonWriter);
                this.extractCompoundButton(simpleJsonWriter, 16842860, "checkboxStyle", "QCheckBox");
                simpleJsonWriter.name("editTextStyle").value(this.extractTextAppearanceInformation(16842862, "QLineEdit"));
                this.extractCompoundButton(simpleJsonWriter, 16842878, "radioButtonStyle", "QRadioButton");
                simpleJsonWriter.name("textViewStyle").value(this.extractTextAppearanceInformation(16842884, "QWidget"));
                simpleJsonWriter.name("scrollViewStyle").value(this.extractTextAppearanceInformation(0x1010080, "QAbstractScrollArea"));
                this.extractListView(simpleJsonWriter);
                simpleJsonWriter.name("listSeparatorTextViewStyle").value(this.extractTextAppearanceInformation(16843272, null));
                this.extractItemsStyle(simpleJsonWriter);
                this.extractCompoundButton(simpleJsonWriter, 16842827, "buttonStyleToggle", null);
                this.extractCalendar(simpleJsonWriter);
                this.extractToolBar(simpleJsonWriter);
                simpleJsonWriter.name("actionButtonStyle").value(this.extractTextAppearanceInformation(16843480, "QToolButton"));
                simpleJsonWriter.name("actionBarTabTextStyle").value(this.extractTextAppearanceInformation(16843509, null));
                simpleJsonWriter.name("actionBarTabStyle").value(this.extractTextAppearanceInformation(16843507, null));
                simpleJsonWriter.name("actionOverflowButtonStyle").value(this.extractImageViewInformation(16843510, null));
                this.extractTabBar(simpleJsonWriter);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            simpleJsonWriter.endObject();
            simpleJsonWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static native int[] extractNativeChunkInfo20(long var0);

    private int[] stateSetUnion(int[] nArray, int[] nArray2) {
        try {
            int n = nArray.length;
            int n2 = nArray2.length;
            int[] nArray3 = new int[n + n2];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int n6 : this.viewDrawableStatesState) {
                if (n4 < n && nArray[n4] == n6) {
                    nArray3[n3++] = n6;
                    ++n4;
                } else if (n5 < n2 && nArray2[n5] == n6) {
                    nArray3[n3++] = n6;
                    ++n5;
                }
                assert (n3 <= 1 || nArray3[n3 - 1] > nArray3[n3 - 2]);
            }
            return nArray3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    Field getAccessibleField(Class<?> clazz, String string2) {
        try {
            Field field = clazz.getDeclaredField(string2);
            field.setAccessible(true);
            return field;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    Field tryGetAccessibleField(Class<?> clazz, String string2) {
        if (clazz == null) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(string2);
            field.setAccessible(true);
            return field;
        }
        catch (Exception exception) {
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                Field field = this.tryGetAccessibleField(clazz2, string2);
                if (field == null) continue;
                return field;
            }
            return this.tryGetAccessibleField(clazz.getSuperclass(), string2);
        }
    }

    JSONObject getColorStateList(ColorStateList colorStateList) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("EMPTY_STATE_SET", colorStateList.getColorForState(this.EMPTY_STATE_SET, 0));
            jSONObject.put("WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("SELECTED_STATE_SET", colorStateList.getColorForState(this.SELECTED_STATE_SET, 0));
            jSONObject.put("SELECTED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.SELECTED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("FOCUSED_STATE_SET", colorStateList.getColorForState(this.FOCUSED_STATE_SET, 0));
            jSONObject.put("FOCUSED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.FOCUSED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("FOCUSED_SELECTED_STATE_SET", colorStateList.getColorForState(this.FOCUSED_SELECTED_STATE_SET, 0));
            jSONObject.put("FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("ENABLED_STATE_SET", colorStateList.getColorForState(this.ENABLED_STATE_SET, 0));
            jSONObject.put("ENABLED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.ENABLED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("ENABLED_SELECTED_STATE_SET", colorStateList.getColorForState(this.ENABLED_SELECTED_STATE_SET, 0));
            jSONObject.put("ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("ENABLED_FOCUSED_STATE_SET", colorStateList.getColorForState(this.ENABLED_FOCUSED_STATE_SET, 0));
            jSONObject.put("ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("ENABLED_FOCUSED_SELECTED_STATE_SET", colorStateList.getColorForState(this.ENABLED_FOCUSED_SELECTED_STATE_SET, 0));
            jSONObject.put("ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_STATE_SET, 0));
            jSONObject.put("PRESSED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_SELECTED_STATE_SET", colorStateList.getColorForState(this.PRESSED_SELECTED_STATE_SET, 0));
            jSONObject.put("PRESSED_SELECTED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_SELECTED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_FOCUSED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_FOCUSED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_FOCUSED_SELECTED_STATE_SET", colorStateList.getColorForState(this.PRESSED_FOCUSED_SELECTED_STATE_SET, 0));
            jSONObject.put("PRESSED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_ENABLED_STATE_SET", colorStateList.getColorForState(this.PRESSED_ENABLED_STATE_SET, 0));
            jSONObject.put("PRESSED_ENABLED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_ENABLED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_ENABLED_SELECTED_STATE_SET", colorStateList.getColorForState(this.PRESSED_ENABLED_SELECTED_STATE_SET, 0));
            jSONObject.put("PRESSED_ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_ENABLED_SELECTED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_ENABLED_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_ENABLED_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_ENABLED_FOCUSED_WINDOW_FOCUSED_STATE_SET, 0));
            jSONObject.put("PRESSED_ENABLED_FOCUSED_SELECTED_STATE_SET", colorStateList.getColorForState(this.PRESSED_ENABLED_FOCUSED_SELECTED_STATE_SET, 0));
            jSONObject.put("PRESSED_ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET", colorStateList.getColorForState(this.PRESSED_ENABLED_FOCUSED_SELECTED_WINDOW_FOCUSED_STATE_SET, 0));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    JSONObject getStatesList(int[] nArray) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (int n : nArray) {
            boolean bl = false;
            for (int i = 0; i < this.DrawableStates.length; ++i) {
                if (n == this.DrawableStates[i]) {
                    jSONObject.put(this.DrawableStatesLabels[i], true);
                    bl = true;
                    break;
                }
                if (n != -this.DrawableStates[i]) continue;
                jSONObject.put(this.DrawableStatesLabels[i], false);
                bl = true;
                break;
            }
            if (bl) continue;
            jSONObject.put("unhandled_state_" + n, n > 0);
        }
        return jSONObject;
    }

    String getStatesName(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : nArray) {
            boolean bl = false;
            for (int i = 0; i < this.DrawableStates.length; ++i) {
                if (n == this.DrawableStates[i]) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("__");
                    }
                    stringBuilder.append(this.DrawableStatesLabels[i]);
                    bl = true;
                    break;
                }
                if (n != -this.DrawableStates[i]) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("__");
                }
                stringBuilder.append(this.DisableDrawableStatesLabels[i]);
                bl = true;
                break;
            }
            if (bl) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append(n);
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return "empty";
    }

    private JSONObject getLayerDrawable(Object object, String string2) {
        JSONObject jSONObject = new JSONObject();
        LayerDrawable layerDrawable = (LayerDrawable)object;
        int n = layerDrawable.getNumberOfLayers();
        try {
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < n; ++i) {
                int n2 = layerDrawable.getId(i);
                if (n2 == -1) {
                    n2 = i;
                }
                JSONObject jSONObject2 = this.getDrawable(layerDrawable.getDrawable(i), string2 + "__" + n2, null);
                jSONObject2.put("id", n2);
                jSONArray.put((Object)jSONObject2);
            }
            jSONObject.put("type", (Object)"layer");
            Rect rect = new Rect();
            if (layerDrawable.getPadding(rect)) {
                jSONObject.put("padding", (Object)this.getJsonRect(rect));
            }
            jSONObject.put("layers", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    private JSONObject getStateListDrawable(Object object, String string2) {
        JSONObject jSONObject = new JSONObject();
        try {
            StateListDrawable stateListDrawable = (StateListDrawable)object;
            JSONArray jSONArray = new JSONArray();
            int n = Build.VERSION.SDK_INT < 29 ? ((Integer)StateListDrawable.class.getMethod("getStateCount", new Class[0]).invoke((Object)stateListDrawable, new Object[0])).intValue() : stateListDrawable.getStateCount();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject2 = new JSONObject();
                Drawable drawable2 = (Drawable)StateListDrawable.class.getMethod("getStateDrawable", Integer.TYPE).invoke((Object)stateListDrawable, i);
                int[] nArray = (int[])StateListDrawable.class.getMethod("getStateSet", Integer.TYPE).invoke((Object)stateListDrawable, i);
                if (nArray != null) {
                    jSONObject2.put("states", (Object)this.getStatesList(nArray));
                }
                jSONObject2.put("drawable", (Object)this.getDrawable(drawable2, string2 + "__" + (nArray != null ? this.getStatesName(nArray) : "state_pos_" + i), null));
                jSONArray.put((Object)jSONObject2);
            }
            jSONObject.put("type", (Object)"stateslist");
            Rect rect = new Rect();
            if (stateListDrawable.getPadding(rect)) {
                jSONObject.put("padding", (Object)this.getJsonRect(rect));
            }
            jSONObject.put("stateslist", (Object)jSONArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    private JSONObject getGradientDrawable(GradientDrawable gradientDrawable) {
        JSONObject jSONObject = new JSONObject();
        try {
            Rect rect;
            int[] nArray;
            jSONObject.put("type", (Object)"gradient");
            Drawable.ConstantState constantState = gradientDrawable.getConstantState();
            Class<?> clazz = constantState.getClass();
            jSONObject.put("shape", clazz.getField("mShape").getInt(constantState));
            jSONObject.put("gradient", clazz.getField("mGradient").getInt(constantState));
            GradientDrawable.Orientation orientation = (GradientDrawable.Orientation)clazz.getField("mOrientation").get(constantState);
            if (orientation != null) {
                jSONObject.put("orientation", (Object)orientation.name());
            }
            if ((nArray = (int[])clazz.getField("mGradientColors").get(constantState)) != null) {
                jSONObject.put("colors", (Object)this.getJsonArray(nArray, 0, nArray.length));
            }
            jSONObject.put("positions", (Object)this.getJsonArray((float[])clazz.getField("mPositions").get(constantState)));
            jSONObject.put("strokeWidth", clazz.getField("mStrokeWidth").getInt(constantState));
            jSONObject.put("strokeDashWidth", (double)clazz.getField("mStrokeDashWidth").getFloat(constantState));
            jSONObject.put("strokeDashGap", (double)clazz.getField("mStrokeDashGap").getFloat(constantState));
            jSONObject.put("radius", (double)clazz.getField("mRadius").getFloat(constantState));
            float[] fArray = (float[])clazz.getField("mRadiusArray").get(constantState);
            if (fArray != null) {
                jSONObject.put("radiusArray", (Object)this.getJsonArray(fArray));
            }
            if ((rect = (Rect)clazz.getField("mPadding").get(constantState)) != null) {
                jSONObject.put("padding", (Object)this.getJsonRect(rect));
            }
            jSONObject.put("width", clazz.getField("mWidth").getInt(constantState));
            jSONObject.put("height", clazz.getField("mHeight").getInt(constantState));
            jSONObject.put("innerRadiusRatio", (double)clazz.getField("mInnerRadiusRatio").getFloat(constantState));
            jSONObject.put("thicknessRatio", (double)clazz.getField("mThicknessRatio").getFloat(constantState));
            jSONObject.put("innerRadius", clazz.getField("mInnerRadius").getInt(constantState));
            jSONObject.put("thickness", clazz.getField("mThickness").getInt(constantState));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    private JSONObject getRotateDrawable(RotateDrawable rotateDrawable, String string2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("type", (Object)"rotate");
            Drawable.ConstantState constantState = rotateDrawable.getConstantState();
            Class<?> clazz = constantState.getClass();
            jSONObject.put("drawable", (Object)this.getDrawable(rotateDrawable.getClass().getMethod("getDrawable", new Class[0]).invoke((Object)rotateDrawable, new Object[0]), string2, null));
            jSONObject.put("pivotX", (double)this.getAccessibleField(clazz, "mPivotX").getFloat(constantState));
            jSONObject.put("pivotXRel", this.getAccessibleField(clazz, "mPivotXRel").getBoolean(constantState));
            jSONObject.put("pivotY", (double)this.getAccessibleField(clazz, "mPivotY").getFloat(constantState));
            jSONObject.put("pivotYRel", this.getAccessibleField(clazz, "mPivotYRel").getBoolean(constantState));
            jSONObject.put("fromDegrees", (double)this.getAccessibleField(clazz, "mFromDegrees").getFloat(constantState));
            jSONObject.put("toDegrees", (double)this.getAccessibleField(clazz, "mToDegrees").getFloat(constantState));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    private JSONObject getAnimationDrawable(AnimationDrawable animationDrawable, String string2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("type", (Object)"animation");
            jSONObject.put("oneshot", animationDrawable.isOneShot());
            int n = animationDrawable.getNumberOfFrames();
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("duration", animationDrawable.getDuration(i));
                jSONObject2.put("drawable", (Object)this.getDrawable(animationDrawable.getFrame(i), string2 + "__" + i, null));
                jSONArray.put((Object)jSONObject2);
            }
            jSONObject.put("frames", (Object)jSONArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    private JSONObject getJsonRect(Rect rect) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("left", rect.left);
        jSONObject.put("top", rect.top);
        jSONObject.put("right", rect.right);
        jSONObject.put("bottom", rect.bottom);
        return jSONObject;
    }

    private JSONArray getJsonArray(int[] nArray, int n, int n2) {
        JSONArray jSONArray = new JSONArray();
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            jSONArray.put(nArray[i]);
        }
        return jSONArray;
    }

    private JSONArray getJsonArray(float[] fArray) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        if (fArray != null) {
            for (float f : fArray) {
                jSONArray.put((double)f);
            }
        }
        return jSONArray;
    }

    private JSONObject getJsonChunkInfo(int[] nArray) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (nArray == null) {
            return jSONObject;
        }
        jSONObject.put("xdivs", (Object)this.getJsonArray(nArray, 3, nArray[0]));
        jSONObject.put("ydivs", (Object)this.getJsonArray(nArray, 3 + nArray[0], nArray[1]));
        jSONObject.put("colors", (Object)this.getJsonArray(nArray, 3 + nArray[0] + nArray[1], nArray[2]));
        return jSONObject;
    }

    private JSONObject findPatchesMarings(Drawable drawable2) throws JSONException, IllegalAccessException {
        NinePatch ninePatch;
        Field field = this.tryGetAccessibleField(NinePatchDrawable.class, "mNinePatch");
        if (field != null) {
            ninePatch = (NinePatch)field.get(drawable2);
        } else {
            Object object = this.getAccessibleField(NinePatchDrawable.class, "mNinePatchState").get(drawable2);
            ninePatch = (NinePatch)this.getAccessibleField(Objects.requireNonNull(object).getClass(), "mNinePatch").get(object);
        }
        return this.getJsonChunkInfo(ExtractStyle.extractNativeChunkInfo20(this.getAccessibleField(Objects.requireNonNull(ninePatch).getClass(), "mNativeChunk").getLong(ninePatch)));
    }

    private JSONObject getRippleDrawable(Object object, String string2, Rect rect) {
        JSONObject jSONObject = this.getLayerDrawable(object, string2);
        JSONObject jSONObject2 = new JSONObject();
        try {
            Class<?> clazz = Class.forName("android.graphics.drawable.RippleDrawable");
            Object object2 = this.getAccessibleField(clazz, "mState").get(object);
            jSONObject2.put("mask", (Object)this.getDrawable((Drawable)this.getAccessibleField(clazz, "mMask").get(object), string2, rect));
            if (object2 != null) {
                jSONObject2.put("maxRadius", this.getAccessibleField(object2.getClass(), "mMaxRadius").getInt(object2));
                ColorStateList colorStateList = (ColorStateList)this.getAccessibleField(object2.getClass(), "mColor").get(object2);
                if (colorStateList != null) {
                    jSONObject2.put("color", (Object)this.getColorStateList(colorStateList));
                }
            }
            jSONObject.put("ripple", (Object)jSONObject2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    private HashMap<Long, Long> getStateTransitions(Object object) throws Exception {
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        int n = this.getAccessibleField(object.getClass(), "mSize").getInt(object);
        long[] lArray = (long[])this.getAccessibleField(object.getClass(), "mKeys").get(object);
        long[] lArray2 = (long[])this.getAccessibleField(object.getClass(), "mValues").get(object);
        for (int i = 0; i < n; ++i) {
            if (lArray == null || lArray2 == null) continue;
            hashMap.put(lArray[i], lArray2[i]);
        }
        return hashMap;
    }

    private HashMap<Integer, Integer> getStateIds(Object object) throws Exception {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = this.getAccessibleField(object.getClass(), "mSize").getInt(object);
        int[] nArray = (int[])this.getAccessibleField(object.getClass(), "mKeys").get(object);
        int[] nArray2 = (int[])this.getAccessibleField(object.getClass(), "mValues").get(object);
        for (int i = 0; i < n; ++i) {
            if (nArray == null || nArray2 == null) continue;
            hashMap.put(nArray[i], nArray2[i]);
        }
        return hashMap;
    }

    private int findStateIndex(int n, HashMap<Integer, Integer> hashMap) {
        for (Map.Entry<Integer, Integer> entry : hashMap.entrySet()) {
            if (n != entry.getValue()) continue;
            return entry.getKey();
        }
        return -1;
    }

    private JSONObject getAnimatedStateListDrawable(Object object, String string2) {
        JSONObject jSONObject = this.getStateListDrawable(object, string2);
        try {
            Class<?> clazz = Class.forName("android.graphics.drawable.AnimatedStateListDrawable");
            Object object2 = this.getAccessibleField(clazz, "mState").get(object);
            if (object2 != null) {
                Class<?> clazz2 = object2.getClass();
                HashMap<Integer, Integer> hashMap = this.getStateIds(Objects.requireNonNull(this.getAccessibleField(clazz2, "mStateIds").get(object2)));
                HashMap<Long, Long> hashMap2 = this.getStateTransitions(Objects.requireNonNull(this.getAccessibleField(clazz2, "mTransitions").get(object2)));
                for (Map.Entry<Long, Long> entry : hashMap2.entrySet()) {
                    int n = this.findStateIndex(entry.getKey().intValue(), hashMap);
                    int n2 = this.findStateIndex((int)(entry.getKey() >> 32), hashMap);
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("from", n2);
                    jSONObject2.put("to", n);
                    jSONObject2.put("reverse", entry.getValue() >> 32 != 0L);
                    JSONArray jSONArray = jSONObject.getJSONArray("stateslist");
                    JSONObject jSONObject3 = jSONArray.getJSONObject(entry.getValue().intValue());
                    jSONObject3.put("transition", (Object)jSONObject2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    private JSONObject getVPath(Object object) throws Exception {
        JSONObject jSONObject = new JSONObject();
        Class<?> clazz = object.getClass();
        jSONObject.put("type", (Object)"path");
        jSONObject.put("name", this.tryGetAccessibleField(clazz, "mPathName").get(object));
        Object[] objectArray = (Object[])this.tryGetAccessibleField(clazz, "mNodes").get(object);
        JSONArray jSONArray = new JSONArray();
        if (objectArray != null) {
            for (Object object2 : objectArray) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("type", (Object)String.valueOf(this.getAccessibleField(object2.getClass(), "mType").getChar(object2)));
                jSONObject2.put("params", (Object)this.getJsonArray((float[])this.getAccessibleField(object2.getClass(), "mParams").get(object2)));
                jSONArray.put((Object)jSONObject2);
            }
            jSONObject.put("nodes", (Object)jSONArray);
        }
        jSONObject.put("isClip", (Object)((Boolean)clazz.getMethod("isClipPath", new Class[0]).invoke(object, new Object[0])));
        if (this.tryGetAccessibleField(clazz, "mStrokeColor") == null) {
            return jSONObject;
        }
        jSONObject.put("strokeColor", this.getAccessibleField(clazz, "mStrokeColor").getInt(object));
        jSONObject.put("strokeWidth", (double)this.getAccessibleField(clazz, "mStrokeWidth").getFloat(object));
        jSONObject.put("fillColor", this.getAccessibleField(clazz, "mFillColor").getInt(object));
        jSONObject.put("strokeAlpha", (double)this.getAccessibleField(clazz, "mStrokeAlpha").getFloat(object));
        jSONObject.put("fillRule", this.getAccessibleField(clazz, "mFillRule").getInt(object));
        jSONObject.put("fillAlpha", (double)this.getAccessibleField(clazz, "mFillAlpha").getFloat(object));
        jSONObject.put("trimPathStart", (double)this.getAccessibleField(clazz, "mTrimPathStart").getFloat(object));
        jSONObject.put("trimPathEnd", (double)this.getAccessibleField(clazz, "mTrimPathEnd").getFloat(object));
        jSONObject.put("trimPathOffset", (double)this.getAccessibleField(clazz, "mTrimPathOffset").getFloat(object));
        jSONObject.put("strokeLineCap", (Object)((Paint.Cap)this.getAccessibleField(clazz, "mStrokeLineCap").get(object)));
        jSONObject.put("strokeLineJoin", (Object)((Paint.Join)this.getAccessibleField(clazz, "mStrokeLineJoin").get(object)));
        jSONObject.put("strokeMiterlimit", (double)this.getAccessibleField(clazz, "mStrokeMiterlimit").getFloat(object));
        return jSONObject;
    }

    private JSONObject getVGroup(Object object) throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("type", (Object)"group");
        Class<?> clazz = object.getClass();
        jSONObject.put("name", this.getAccessibleField(clazz, "mGroupName").get(object));
        jSONObject.put("rotate", (double)this.getAccessibleField(clazz, "mRotate").getFloat(object));
        jSONObject.put("pivotX", (double)this.getAccessibleField(clazz, "mPivotX").getFloat(object));
        jSONObject.put("pivotY", (double)this.getAccessibleField(clazz, "mPivotY").getFloat(object));
        jSONObject.put("scaleX", (double)this.getAccessibleField(clazz, "mScaleX").getFloat(object));
        jSONObject.put("scaleY", (double)this.getAccessibleField(clazz, "mScaleY").getFloat(object));
        jSONObject.put("translateX", (double)this.getAccessibleField(clazz, "mTranslateX").getFloat(object));
        jSONObject.put("translateY", (double)this.getAccessibleField(clazz, "mTranslateY").getFloat(object));
        ArrayList arrayList = (ArrayList)this.getAccessibleField(clazz, "mChildren").get(object);
        JSONArray jSONArray = new JSONArray();
        if (arrayList != null) {
            for (Object e : arrayList) {
                if (clazz.isInstance(e)) {
                    jSONArray.put((Object)this.getVGroup(e));
                    continue;
                }
                jSONArray.put((Object)this.getVPath(e));
            }
            jSONObject.put("children", (Object)jSONArray);
        }
        return jSONObject;
    }

    private JSONObject getVectorDrawable(Object object) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("type", (Object)"vector");
            Class<?> clazz = Class.forName("android.graphics.drawable.VectorDrawable");
            Object object2 = this.getAccessibleField(clazz, "mVectorState").get(object);
            Class<?> clazz2 = Objects.requireNonNull(object2).getClass();
            ColorStateList colorStateList = (ColorStateList)this.getAccessibleField(clazz2, "mTint").get(object2);
            if (colorStateList != null) {
                jSONObject.put("tintList", (Object)this.getColorStateList(colorStateList));
                jSONObject.put("tintMode", (Object)((PorterDuff.Mode)this.getAccessibleField(clazz2, "mTintMode").get(object2)));
            }
            Object object3 = this.getAccessibleField(clazz2, "mVPathRenderer").get(object2);
            Class<?> clazz3 = Objects.requireNonNull(object3).getClass();
            jSONObject.put("baseWidth", (double)this.getAccessibleField(clazz3, "mBaseWidth").getFloat(object3));
            jSONObject.put("baseHeight", (double)this.getAccessibleField(clazz3, "mBaseHeight").getFloat(object3));
            jSONObject.put("viewportWidth", (double)this.getAccessibleField(clazz3, "mViewportWidth").getFloat(object3));
            jSONObject.put("viewportHeight", (double)this.getAccessibleField(clazz3, "mViewportHeight").getFloat(object3));
            jSONObject.put("rootAlpha", this.getAccessibleField(clazz3, "mRootAlpha").getInt(object3));
            jSONObject.put("rootName", this.getAccessibleField(clazz3, "mRootName").get(object3));
            jSONObject.put("rootGroup", (Object)this.getVGroup(Objects.requireNonNull(this.getAccessibleField(clazz3, "mRootGroup").get(object3))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    JSONObject getDrawable(Object object, String string2, Rect rect) {
        Object object2;
        if (object == null || this.m_minimal) {
            return null;
        }
        DrawableCache drawableCache = this.m_drawableCache.get(string2);
        if (drawableCache != null) {
            if (drawableCache.drawable.equals(object)) {
                return drawableCache.object;
            }
            Log.e((String)"Qt JAVA", (String)("Different drawable objects points to the same file name \"" + string2 + "\""));
        }
        JSONObject jSONObject = new JSONObject();
        Bitmap bitmap = null;
        if (object instanceof Bitmap) {
            bitmap = (Bitmap)object;
        } else if (object instanceof BitmapDrawable) {
            object2 = (BitmapDrawable)object;
            bitmap = object2.getBitmap();
            try {
                jSONObject.put("gravity", object2.getGravity());
                jSONObject.put("tileModeX", (Object)object2.getTileModeX());
                jSONObject.put("tileModeY", (Object)object2.getTileModeY());
                jSONObject.put("antialias", (Object)((Boolean)BitmapDrawable.class.getMethod("hasAntiAlias", new Class[0]).invoke(object2, new Object[0])));
                jSONObject.put("mipMap", (Object)((Boolean)BitmapDrawable.class.getMethod("hasMipMap", new Class[0]).invoke(object2, new Object[0])));
                jSONObject.put("tintMode", (Object)((PorterDuff.Mode)BitmapDrawable.class.getMethod("getTintMode", new Class[0]).invoke(object2, new Object[0])));
                ColorStateList colorStateList = (ColorStateList)BitmapDrawable.class.getMethod("getTint", new Class[0]).invoke(object2, new Object[0]);
                if (colorStateList != null) {
                    jSONObject.put("tintList", (Object)this.getColorStateList(colorStateList));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            if (object instanceof RippleDrawable) {
                return this.getRippleDrawable(object, string2, rect);
            }
            if (object instanceof AnimatedStateListDrawable) {
                return this.getAnimatedStateListDrawable(object, string2);
            }
            if (object instanceof VectorDrawable) {
                return this.getVectorDrawable(object);
            }
            if (object instanceof ScaleDrawable) {
                return this.getDrawable(((ScaleDrawable)object).getDrawable(), string2, null);
            }
            if (object instanceof LayerDrawable) {
                return this.getLayerDrawable(object, string2);
            }
            if (object instanceof StateListDrawable) {
                return this.getStateListDrawable(object, string2);
            }
            if (object instanceof GradientDrawable) {
                return this.getGradientDrawable((GradientDrawable)object);
            }
            if (object instanceof RotateDrawable) {
                return this.getRotateDrawable((RotateDrawable)object, string2);
            }
            if (object instanceof AnimationDrawable) {
                return this.getAnimationDrawable((AnimationDrawable)object, string2);
            }
            if (object instanceof ClipDrawable) {
                try {
                    jSONObject.put("type", (Object)"clipDrawable");
                    Drawable.ConstantState constantState = ((ClipDrawable)object).getConstantState();
                    jSONObject.put("drawable", (Object)this.getDrawable(this.getAccessibleField(constantState.getClass(), "mDrawable").get(constantState), string2, null));
                    if (null != rect) {
                        jSONObject.put("padding", (Object)this.getJsonRect(rect));
                    } else {
                        Rect rect2 = new Rect();
                        if (((Drawable)object).getPadding(rect2)) {
                            jSONObject.put("padding", (Object)this.getJsonRect(rect2));
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return jSONObject;
            }
            if (object instanceof ColorDrawable) {
                bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Drawable drawable2 = (Drawable)object;
                drawable2.setBounds(0, 0, 1, 1);
                drawable2.draw(new Canvas(bitmap));
                try {
                    jSONObject.put("type", (Object)"color");
                    jSONObject.put("color", bitmap.getPixel(0, 0));
                    if (null != rect) {
                        jSONObject.put("padding", (Object)this.getJsonRect(rect));
                    } else {
                        Rect rect3 = new Rect();
                        if (drawable2.getPadding(rect3)) {
                            jSONObject.put("padding", (Object)this.getJsonRect(rect3));
                        }
                    }
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                return jSONObject;
            }
            if (object instanceof InsetDrawable) {
                try {
                    InsetDrawable insetDrawable = (InsetDrawable)object;
                    Object object3 = this.getAccessibleField(InsetDrawable.class, "mState").get(insetDrawable);
                    Rect rect4 = new Rect();
                    boolean bl = insetDrawable.getPadding(rect4);
                    return this.getDrawable(this.getAccessibleField(Objects.requireNonNull(object3).getClass(), "mDrawable").get(object3), string2, (Rect)(bl ? rect4 : null));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                object2 = (Drawable)object;
                int n = object2.getIntrinsicWidth();
                int n2 = object2.getIntrinsicHeight();
                object2.setLevel(10000);
                if (n < 1 || n2 < 1) {
                    n = 100;
                    n2 = 100;
                }
                bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                object2.setBounds(0, 0, n, n2);
                object2.draw(new Canvas(bitmap));
                if (object instanceof NinePatchDrawable) {
                    NinePatchDrawable ninePatchDrawable = (NinePatchDrawable)object;
                    try {
                        jSONObject.put("type", (Object)"9patch");
                        jSONObject.put("drawable", (Object)this.getDrawable(bitmap, string2, null));
                        if (rect != null) {
                            jSONObject.put("padding", (Object)this.getJsonRect(rect));
                        } else {
                            Rect rect5 = new Rect();
                            if (ninePatchDrawable.getPadding(rect5)) {
                                jSONObject.put("padding", (Object)this.getJsonRect(rect5));
                            }
                        }
                        jSONObject.put("chunkInfo", (Object)this.findPatchesMarings((Drawable)object2));
                        return jSONObject;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        try {
            string2 = this.m_extractPath + string2 + ".png";
            object2 = new FileOutputStream(string2);
            if (bitmap != null) {
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)object2);
            }
            ((FileOutputStream)object2).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            jSONObject.put("type", (Object)"image");
            jSONObject.put("path", (Object)string2);
            if (bitmap != null) {
                jSONObject.put("width", bitmap.getWidth());
                jSONObject.put("height", bitmap.getHeight());
            }
            this.m_drawableCache.put(string2, new DrawableCache(jSONObject, object));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    private TypedArray obtainStyledAttributes(int n, int[] nArray) {
        TypedValue typedValue = new TypedValue();
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(this.m_context, this.m_theme);
        contextThemeWrapper.getTheme().resolveAttribute(n, typedValue, true);
        return contextThemeWrapper.obtainStyledAttributes(typedValue.data, nArray);
    }

    private ArrayList<Integer> getArrayListFromIntArray(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n : nArray) {
            arrayList.add(n);
        }
        return arrayList;
    }

    void extractViewInformation(int n, JSONObject jSONObject, String string2) {
        this.extractViewInformation(n, jSONObject, string2, null);
    }

    void extractViewInformation(int n, JSONObject jSONObject, String string2, AttributeSet attributeSet) {
        try {
            TypedValue typedValue = new TypedValue();
            ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(this.m_context, this.m_theme);
            contextThemeWrapper.getTheme().resolveAttribute(n, typedValue, true);
            int[] nArray = new int[]{0x1010166, 16842964, 16842965, 16842966, 16842967, 16842968, 16842969, 16842962, 16842963, 0x10100D0, 0x10100D1, 0x10100DD, 16842970, 16842971, 16842981, 16842982, 16842983, 16842985, 16842972, 16842984, 16843379, 16843285, 16843358, 16842974, 16842975, 16842879, 16843432, 16843433, 16842851, 16842852, 16842853, 0x1010066, 16842855, 16843342, 16843286, 16843460, 0x10100E1, 16842978, 16842979, 16842980, 16843071, 0x1010140, 16843375, 16843457, 16843699, 16843700};
            Arrays.sort(nArray);
            TypedArray typedArray = attributeSet != null ? this.m_theme.obtainStyledAttributes(attributeSet, nArray, n, 0) : this.obtainStyledAttributes(n, nArray);
            ArrayList<Integer> arrayList = this.getArrayListFromIntArray(nArray);
            if (null != string2) {
                jSONObject.put("qtClass", (Object)string2);
            }
            jSONObject.put("defaultBackgroundColor", this.defaultBackgroundColor);
            jSONObject.put("defaultTextColorPrimary", this.defaultTextColor);
            jSONObject.put("TextView_digits", (Object)typedArray.getText(arrayList.indexOf(0x1010166)));
            jSONObject.put("View_background", (Object)this.getDrawable(typedArray.getDrawable(arrayList.indexOf(16842964)), n + "_View_background", null));
            jSONObject.put("View_padding", typedArray.getDimensionPixelSize(arrayList.indexOf(16842965), -1));
            jSONObject.put("View_paddingLeft", typedArray.getDimensionPixelSize(arrayList.indexOf(16842966), -1));
            jSONObject.put("View_paddingTop", typedArray.getDimensionPixelSize(arrayList.indexOf(16842967), -1));
            jSONObject.put("View_paddingRight", typedArray.getDimensionPixelSize(arrayList.indexOf(16842968), -1));
            jSONObject.put("View_paddingBottom", typedArray.getDimensionPixelSize(arrayList.indexOf(16842969), -1));
            jSONObject.put("View_paddingBottom", typedArray.getDimensionPixelOffset(arrayList.indexOf(16842962), 0));
            jSONObject.put("View_scrollY", typedArray.getDimensionPixelOffset(arrayList.indexOf(16842963), 0));
            jSONObject.put("View_id", typedArray.getResourceId(arrayList.indexOf(0x10100D0), -1));
            jSONObject.put("View_tag", (Object)typedArray.getText(arrayList.indexOf(0x10100D1)));
            jSONObject.put("View_fitsSystemWindows", typedArray.getBoolean(arrayList.indexOf(0x10100DD), false));
            jSONObject.put("View_focusable", typedArray.getBoolean(arrayList.indexOf(16842970), false));
            jSONObject.put("View_focusableInTouchMode", typedArray.getBoolean(arrayList.indexOf(16842971), false));
            jSONObject.put("View_clickable", typedArray.getBoolean(arrayList.indexOf(16842981), false));
            jSONObject.put("View_longClickable", typedArray.getBoolean(arrayList.indexOf(16842982), false));
            jSONObject.put("View_saveEnabled", typedArray.getBoolean(arrayList.indexOf(16842983), true));
            jSONObject.put("View_duplicateParentState", typedArray.getBoolean(arrayList.indexOf(16842985), false));
            jSONObject.put("View_visibility", typedArray.getInt(arrayList.indexOf(16842972), 0));
            jSONObject.put("View_drawingCacheQuality", typedArray.getInt(arrayList.indexOf(16842984), 0));
            jSONObject.put("View_contentDescription", (Object)typedArray.getString(arrayList.indexOf(16843379)));
            jSONObject.put("View_soundEffectsEnabled", typedArray.getBoolean(arrayList.indexOf(16843285), true));
            jSONObject.put("View_hapticFeedbackEnabled", typedArray.getBoolean(arrayList.indexOf(16843358), true));
            jSONObject.put("View_scrollbars", typedArray.getInt(arrayList.indexOf(16842974), 0));
            jSONObject.put("View_fadingEdge", typedArray.getInt(arrayList.indexOf(16842975), 0));
            jSONObject.put("View_scrollbarStyle", typedArray.getInt(arrayList.indexOf(16842879), 0));
            jSONObject.put("View_scrollbarFadeDuration", typedArray.getInt(arrayList.indexOf(16843432), 0));
            jSONObject.put("View_scrollbarDefaultDelayBeforeFade", typedArray.getInt(arrayList.indexOf(16843433), 0));
            jSONObject.put("View_scrollbarSize", typedArray.getDimensionPixelSize(arrayList.indexOf(16842851), -1));
            jSONObject.put("View_scrollbarThumbHorizontal", (Object)this.getDrawable(typedArray.getDrawable(arrayList.indexOf(16842852)), n + "_View_scrollbarThumbHorizontal", null));
            jSONObject.put("View_scrollbarThumbVertical", (Object)this.getDrawable(typedArray.getDrawable(arrayList.indexOf(16842853)), n + "_View_scrollbarThumbVertical", null));
            jSONObject.put("View_scrollbarTrackHorizontal", (Object)this.getDrawable(typedArray.getDrawable(arrayList.indexOf(0x1010066)), n + "_View_scrollbarTrackHorizontal", null));
            jSONObject.put("View_scrollbarTrackVertical", (Object)this.getDrawable(typedArray.getDrawable(arrayList.indexOf(16842855)), n + "_View_scrollbarTrackVertical", null));
            jSONObject.put("View_isScrollContainer", typedArray.getBoolean(arrayList.indexOf(16843342), false));
            jSONObject.put("View_keepScreenOn", typedArray.getBoolean(arrayList.indexOf(16843286), false));
            jSONObject.put("View_filterTouchesWhenObscured", typedArray.getBoolean(arrayList.indexOf(16843460), false));
            jSONObject.put("View_nextFocusLeft", typedArray.getResourceId(arrayList.indexOf(0x10100E1), -1));
            jSONObject.put("View_nextFocusRight", typedArray.getResourceId(arrayList.indexOf(16842978), -1));
            jSONObject.put("View_nextFocusUp", typedArray.getResourceId(arrayList.indexOf(16842979), -1));
            jSONObject.put("View_nextFocusDown", typedArray.getResourceId(arrayList.indexOf(16842980), -1));
            jSONObject.put("View_minWidth", typedArray.getDimensionPixelSize(arrayList.indexOf(16843071), 0));
            jSONObject.put("View_minHeight", typedArray.getDimensionPixelSize(arrayList.indexOf(0x1010140), 0));
            jSONObject.put("View_onClick", (Object)typedArray.getString(arrayList.indexOf(16843375)));
            jSONObject.put("View_overScrollMode", typedArray.getInt(arrayList.indexOf(16843457), 1));
            jSONObject.put("View_paddingStart", typedArray.getDimensionPixelSize(arrayList.indexOf(16843699), 0));
            jSONObject.put("View_paddingEnd", typedArray.getDimensionPixelSize(arrayList.indexOf(16843700), 0));
            typedArray.recycle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    JSONObject extractTextAppearance(int n) {
        return this.extractTextAppearance(n, false);
    }

    @SuppressLint(value={"ResourceType"})
    JSONObject extractTextAppearance(int n, boolean bl) {
        int[] nArray = new int[]{16842901, 16842903, 16842904, 16842902, 16843660, 16842906, 16842907, 0x1010099};
        Arrays.sort(nArray);
        TypedArray typedArray = bl ? this.m_theme.obtainStyledAttributes(n, nArray) : this.obtainStyledAttributes(n, nArray);
        ArrayList<Integer> arrayList = this.getArrayListFromIntArray(nArray);
        JSONObject jSONObject = new JSONObject();
        try {
            ColorStateList colorStateList;
            int n2 = arrayList.indexOf(16842901);
            if (typedArray.hasValue(n2)) {
                jSONObject.put("TextAppearance_textSize", typedArray.getDimensionPixelSize(n2, 15));
            }
            if (typedArray.hasValue(n2 = arrayList.indexOf(16842903))) {
                jSONObject.put("TextAppearance_textStyle", typedArray.getInt(n2, -1));
            }
            if ((colorStateList = typedArray.getColorStateList(arrayList.indexOf(16842904))) != null) {
                jSONObject.put("TextAppearance_textColor", (Object)this.getColorStateList(colorStateList));
            }
            if (typedArray.hasValue(n2 = arrayList.indexOf(16842902))) {
                jSONObject.put("TextAppearance_typeface", typedArray.getInt(n2, -1));
            }
            if (typedArray.hasValue(n2 = arrayList.indexOf(16843660))) {
                jSONObject.put("TextAppearance_textAllCaps", typedArray.getBoolean(n2, false));
            }
            if ((colorStateList = typedArray.getColorStateList(arrayList.indexOf(16842906))) != null) {
                jSONObject.put("TextAppearance_textColorHint", (Object)this.getColorStateList(colorStateList));
            }
            if ((colorStateList = typedArray.getColorStateList(arrayList.indexOf(16842907))) != null) {
                jSONObject.put("TextAppearance_textColorLink", (Object)this.getColorStateList(colorStateList));
            }
            if (typedArray.hasValue(n2 = arrayList.indexOf(0x1010099))) {
                jSONObject.put("TextAppearance_textColorHighlight", typedArray.getColor(n2, 0));
            }
            typedArray.recycle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    JSONObject extractTextAppearanceInformation(int n, String string2) {
        return this.extractTextAppearanceInformation(n, string2, 16842804, null);
    }

    JSONObject extractTextAppearanceInformation(int n, String string2, int n2, AttributeSet attributeSet) {
        JSONObject jSONObject = new JSONObject();
        this.extractViewInformation(n, jSONObject, string2, attributeSet);
        if (n2 == -1) {
            n2 = 16842804;
        }
        try {
            ArrayList<Integer> arrayList;
            TypedArray typedArray;
            int[] nArray;
            TypedValue typedValue = new TypedValue();
            ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(this.m_context, this.m_theme);
            contextThemeWrapper.getTheme().resolveAttribute(n, typedValue, true);
            int[] nArray2 = new int[]{n2};
            TypedArray typedArray2 = contextThemeWrapper.obtainStyledAttributes(typedValue.data, nArray2);
            int n3 = typedArray2.getResourceId(0, -1);
            typedArray2.recycle();
            int n4 = 15;
            int n5 = -1;
            int n6 = -1;
            int n7 = 0;
            boolean bl = false;
            if (n3 != -1) {
                nArray = new int[]{16842901, 16842903, 16842902, 16843660, 0x1010099};
                Arrays.sort(nArray);
                typedArray = this.m_theme.obtainStyledAttributes(n3, nArray);
                arrayList = this.getArrayListFromIntArray(nArray);
                n4 = typedArray.getDimensionPixelSize(arrayList.indexOf(16842901), 15);
                n5 = typedArray.getInt(arrayList.indexOf(16842903), -1);
                n6 = typedArray.getInt(arrayList.indexOf(16842902), -1);
                n7 = typedArray.getColor(arrayList.indexOf(0x1010099), 0);
                bl = typedArray.getBoolean(arrayList.indexOf(16843660), false);
                typedArray.recycle();
            }
            nArray = new int[]{16843115, 16843112, 16843109, 0x1010166, 16843111, 16843114, 16843113, 16843086, 16843102, 0x10100B0, 0x10100B1, 16843119, 16843117, 0x1010170, 16843118, 16843666, 16843667, 16843091, 0x1010171, 16843618, 0x1010120, 16843092, 0x1010155, 16843094, 0x1010140, 16843095, 0x101011F, 16843096, 16843097, 16843098, 16843071, 16842927, 0x1010150, 16843087, 16843099, 16843101, 16842923, 16843293, 16843103, 16843090, 0x1010160, 0x1010151, 16843116, 0x1010161, 16843106, 16843107, 16843108, 0x101000E, 0x1010099, 16842904, 16842906, 16842907, 16842901, 16842902, 16842903, 16843100, 16843287, 16843288, 0x1010220, 16843364, 16843365, 16843366, 16843299, 16843461, 16843462, 16843463, 16843542, 16843660};
            Arrays.sort(nArray);
            typedArray = contextThemeWrapper.obtainStyledAttributes(typedValue.data, nArray);
            arrayList = this.getArrayListFromIntArray(nArray);
            n4 = typedArray.getDimensionPixelSize(arrayList.indexOf(16842901), n4);
            n5 = typedArray.getInt(arrayList.indexOf(16842903), n5);
            n6 = typedArray.getInt(arrayList.indexOf(16842902), n6);
            n7 = typedArray.getColor(arrayList.indexOf(0x1010099), n7);
            bl = typedArray.getBoolean(arrayList.indexOf(16843660), bl);
            ColorStateList colorStateList = typedArray.getColorStateList(arrayList.indexOf(16842904));
            ColorStateList colorStateList2 = typedArray.getColorStateList(arrayList.indexOf(16842906));
            ColorStateList colorStateList3 = typedArray.getColorStateList(arrayList.indexOf(16842907));
            jSONObject.put("TextAppearance_textSize", n4);
            jSONObject.put("TextAppearance_textStyle", n5);
            jSONObject.put("TextAppearance_typeface", n6);
            jSONObject.put("TextAppearance_textColorHighlight", n7);
            jSONObject.put("TextAppearance_textAllCaps", bl);
            if (colorStateList != null) {
                jSONObject.put("TextAppearance_textColor", (Object)this.getColorStateList(colorStateList));
            }
            if (colorStateList2 != null) {
                jSONObject.put("TextAppearance_textColorHint", (Object)this.getColorStateList(colorStateList2));
            }
            if (colorStateList3 != null) {
                jSONObject.put("TextAppearance_textColorLink", (Object)this.getColorStateList(colorStateList3));
            }
            jSONObject.put("TextView_editable", typedArray.getBoolean(arrayList.indexOf(16843115), false));
            jSONObject.put("TextView_inputMethod", (Object)typedArray.getText(arrayList.indexOf(16843112)));
            jSONObject.put("TextView_numeric", typedArray.getInt(arrayList.indexOf(16843109), 0));
            jSONObject.put("TextView_digits", (Object)typedArray.getText(arrayList.indexOf(0x1010166)));
            jSONObject.put("TextView_phoneNumber", typedArray.getBoolean(arrayList.indexOf(16843111), false));
            jSONObject.put("TextView_autoText", typedArray.getBoolean(arrayList.indexOf(16843114), false));
            jSONObject.put("TextView_capitalize", typedArray.getInt(arrayList.indexOf(16843113), -1));
            jSONObject.put("TextView_bufferType", typedArray.getInt(arrayList.indexOf(16843086), 0));
            jSONObject.put("TextView_selectAllOnFocus", typedArray.getBoolean(arrayList.indexOf(16843102), false));
            jSONObject.put("TextView_autoLink", typedArray.getInt(arrayList.indexOf(0x10100B0), 0));
            jSONObject.put("TextView_linksClickable", typedArray.getBoolean(arrayList.indexOf(0x10100B1), true));
            jSONObject.put("TextView_drawableLeft", (Object)this.getDrawable(typedArray.getDrawable(arrayList.indexOf(16843119)), n + "_TextView_drawableLeft", null));
            jSONObject.put("TextView_drawableTop", (Object)this.getDrawable(typedArray.getDrawable(arrayList.indexOf(16843117)), n + "_TextView_drawableTop", null));
            jSONObject.put("TextView_drawableRight", (Object)this.getDrawable(typedArray.getDrawable(arrayList.indexOf(0x1010170)), n + "_TextView_drawableRight", null));
            jSONObject.put("TextView_drawableBottom", (Object)this.getDrawable(typedArray.getDrawable(arrayList.indexOf(16843118)), n + "_TextView_drawableBottom", null));
            jSONObject.put("TextView_drawableStart", (Object)this.getDrawable(typedArray.getDrawable(arrayList.indexOf(16843666)), n + "_TextView_drawableStart", null));
            jSONObject.put("TextView_drawableEnd", (Object)this.getDrawable(typedArray.getDrawable(arrayList.indexOf(16843667)), n + "_TextView_drawableEnd", null));
            jSONObject.put("TextView_maxLines", typedArray.getInt(arrayList.indexOf(16843091), -1));
            jSONObject.put("TextView_drawablePadding", typedArray.getDimensionPixelSize(arrayList.indexOf(0x1010171), 0));
            try {
                jSONObject.put("TextView_textCursorDrawable", (Object)this.getDrawable(typedArray.getDrawable(arrayList.indexOf(16843618)), n + "_TextView_textCursorDrawable", null));
            }
            catch (Exception exception) {
                jSONObject.put("TextView_textCursorDrawable", (Object)this.getDrawable(this.m_context.getResources().getDrawable(typedArray.getResourceId(arrayList.indexOf(16843618), 0), this.m_theme), n + "_TextView_textCursorDrawable", null));
            }
            jSONObject.put("TextView_maxLines", typedArray.getInt(arrayList.indexOf(16843091), -1));
            jSONObject.put("TextView_maxHeight", typedArray.getDimensionPixelSize(arrayList.indexOf(0x1010120), -1));
            jSONObject.put("TextView_lines", typedArray.getInt(arrayList.indexOf(16843092), -1));
            jSONObject.put("TextView_height", typedArray.getDimensionPixelSize(arrayList.indexOf(0x1010155), -1));
            jSONObject.put("TextView_minLines", typedArray.getInt(arrayList.indexOf(16843094), -1));
            jSONObject.put("TextView_minHeight", typedArray.getDimensionPixelSize(arrayList.indexOf(0x1010140), -1));
            jSONObject.put("TextView_maxEms", typedArray.getInt(arrayList.indexOf(16843095), -1));
            jSONObject.put("TextView_maxWidth", typedArray.getDimensionPixelSize(arrayList.indexOf(0x101011F), -1));
            jSONObject.put("TextView_ems", typedArray.getInt(arrayList.indexOf(16843096), -1));
            jSONObject.put("TextView_width", typedArray.getDimensionPixelSize(arrayList.indexOf(16843097), -1));
            jSONObject.put("TextView_minEms", typedArray.getInt(arrayList.indexOf(16843098), -1));
            jSONObject.put("TextView_minWidth", typedArray.getDimensionPixelSize(arrayList.indexOf(16843071), -1));
            jSONObject.put("TextView_gravity", typedArray.getInt(arrayList.indexOf(16842927), -1));
            jSONObject.put("TextView_hint", (Object)typedArray.getText(arrayList.indexOf(0x1010150)));
            jSONObject.put("TextView_text", (Object)typedArray.getText(arrayList.indexOf(16843087)));
            jSONObject.put("TextView_scrollHorizontally", typedArray.getBoolean(arrayList.indexOf(16843099), false));
            jSONObject.put("TextView_singleLine", typedArray.getBoolean(arrayList.indexOf(16843101), false));
            jSONObject.put("TextView_ellipsize", typedArray.getInt(arrayList.indexOf(16842923), -1));
            jSONObject.put("TextView_marqueeRepeatLimit", typedArray.getInt(arrayList.indexOf(16843293), 3));
            jSONObject.put("TextView_includeFontPadding", typedArray.getBoolean(arrayList.indexOf(16843103), true));
            jSONObject.put("TextView_cursorVisible", typedArray.getBoolean(arrayList.indexOf(0x1010160), true));
            jSONObject.put("TextView_maxLength", typedArray.getInt(arrayList.indexOf(0x1010160), -1));
            jSONObject.put("TextView_textScaleX", (double)typedArray.getFloat(arrayList.indexOf(0x1010151), 1.0f));
            jSONObject.put("TextView_freezesText", typedArray.getBoolean(arrayList.indexOf(16843116), false));
            jSONObject.put("TextView_shadowColor", typedArray.getInt(arrayList.indexOf(0x1010161), 0));
            jSONObject.put("TextView_shadowDx", (double)typedArray.getFloat(arrayList.indexOf(16843106), 0.0f));
            jSONObject.put("TextView_shadowDy", (double)typedArray.getFloat(arrayList.indexOf(16843107), 0.0f));
            jSONObject.put("TextView_shadowRadius", (double)typedArray.getFloat(arrayList.indexOf(16843108), 0.0f));
            jSONObject.put("TextView_enabled", typedArray.getBoolean(arrayList.indexOf(0x101000E), true));
            jSONObject.put("TextView_password", typedArray.getBoolean(arrayList.indexOf(16843100), false));
            jSONObject.put("TextView_lineSpacingExtra", typedArray.getDimensionPixelSize(arrayList.indexOf(16843287), 0));
            jSONObject.put("TextView_lineSpacingMultiplier", (double)typedArray.getFloat(arrayList.indexOf(16843288), 1.0f));
            jSONObject.put("TextView_inputType", typedArray.getInt(arrayList.indexOf(0x1010220), 0));
            jSONObject.put("TextView_imeOptions", typedArray.getInt(arrayList.indexOf(16843364), 0));
            jSONObject.put("TextView_imeActionLabel", (Object)typedArray.getText(arrayList.indexOf(16843365)));
            jSONObject.put("TextView_imeActionId", typedArray.getInt(arrayList.indexOf(16843366), 0));
            jSONObject.put("TextView_privateImeOptions", (Object)typedArray.getString(arrayList.indexOf(16843299)));
            try {
                jSONObject.put("TextView_textSelectHandleLeft", (Object)this.getDrawable(typedArray.getDrawable(arrayList.indexOf(16843461)), n + "_TextView_textSelectHandleLeft", null));
            }
            catch (Exception exception) {
                jSONObject.put("TextView_textSelectHandleLeft", (Object)this.getDrawable(this.m_context.getResources().getDrawable(typedArray.getResourceId(arrayList.indexOf(16843461), 0), this.m_theme), n + "_TextView_textSelectHandleLeft", null));
            }
            try {
                jSONObject.put("TextView_textSelectHandleRight", (Object)this.getDrawable(typedArray.getDrawable(arrayList.indexOf(16843462)), n + "_TextView_textSelectHandleRight", null));
            }
            catch (Exception exception) {
                jSONObject.put("TextView_textSelectHandleRight", (Object)this.getDrawable(this.m_context.getResources().getDrawable(typedArray.getResourceId(arrayList.indexOf(16843462), 0), this.m_theme), n + "_TextView_textSelectHandleRight", null));
            }
            try {
                jSONObject.put("TextView_textSelectHandle", (Object)this.getDrawable(typedArray.getDrawable(arrayList.indexOf(16843463)), n + "_TextView_textSelectHandle", null));
            }
            catch (Exception exception) {
                jSONObject.put("TextView_textSelectHandle", (Object)this.getDrawable(this.m_context.getResources().getDrawable(typedArray.getResourceId(arrayList.indexOf(16843463), 0), this.m_theme), n + "_TextView_textSelectHandle", null));
            }
            jSONObject.put("TextView_textIsSelectable", typedArray.getBoolean(arrayList.indexOf(16843542), false));
            typedArray.recycle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    JSONObject extractImageViewInformation(int n, String string2) {
        JSONObject jSONObject = new JSONObject();
        try {
            int n2;
            this.extractViewInformation(n, jSONObject, string2);
            int[] nArray = new int[]{0x1010119, 0x1010122, 0x101011E, 0x101011F, 0x1010120, 0x101011D, 16843043, 0x1010121};
            Arrays.sort(nArray);
            TypedArray typedArray = this.obtainStyledAttributes(n, nArray);
            ArrayList<Integer> arrayList = this.getArrayListFromIntArray(nArray);
            Drawable drawable2 = typedArray.getDrawable(arrayList.indexOf(0x1010119));
            if (drawable2 != null) {
                jSONObject.put("ImageView_src", (Object)this.getDrawable(drawable2, n + "_ImageView_src", null));
            }
            jSONObject.put("ImageView_baselineAlignBottom", typedArray.getBoolean(arrayList.indexOf(0x1010122), false));
            jSONObject.put("ImageView_adjustViewBounds", typedArray.getBoolean(arrayList.indexOf(0x1010122), false));
            jSONObject.put("ImageView_maxWidth", typedArray.getDimensionPixelSize(arrayList.indexOf(0x101011F), Integer.MAX_VALUE));
            jSONObject.put("ImageView_maxHeight", typedArray.getDimensionPixelSize(arrayList.indexOf(0x1010120), Integer.MAX_VALUE));
            int n3 = typedArray.getInt(arrayList.indexOf(0x101011D), -1);
            if (n3 >= 0) {
                jSONObject.put("ImageView_scaleType", (Object)this.sScaleTypeArray[n3]);
            }
            if ((n2 = typedArray.getInt(arrayList.indexOf(0x1010121), 0)) != 0) {
                jSONObject.put("ImageView_tint", n2);
            }
            jSONObject.put("ImageView_cropToPadding", typedArray.getBoolean(arrayList.indexOf(16843043), false));
            typedArray.recycle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    void extractCompoundButton(SimpleJsonWriter simpleJsonWriter, int n, String string2, String string3) {
        JSONObject jSONObject = this.extractTextAppearanceInformation(n, string3);
        TypedValue typedValue = new TypedValue();
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(this.m_context, this.m_theme);
        contextThemeWrapper.getTheme().resolveAttribute(n, typedValue, true);
        int[] nArray = new int[]{0x1010107};
        TypedArray typedArray = contextThemeWrapper.obtainStyledAttributes(typedValue.data, nArray);
        Drawable drawable2 = typedArray.getDrawable(0);
        typedArray.recycle();
        try {
            if (drawable2 != null) {
                jSONObject.put("CompoundButton_button", (Object)this.getDrawable(drawable2, n + "_CompoundButton_button", null));
            }
            simpleJsonWriter.name(string2).value(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void extractProgressBarInfo(JSONObject jSONObject, int n) {
        try {
            int[] nArray = new int[]{16843071, 0x101011F, 0x1010140, 0x1010120, 16843069, 16843068, 16843067};
            Arrays.sort(nArray);
            TypedArray typedArray = this.obtainStyledAttributes(n, nArray);
            ArrayList<Integer> arrayList = this.getArrayListFromIntArray(nArray);
            jSONObject.put("ProgressBar_indeterminateDuration", typedArray.getInt(arrayList.indexOf(16843069), 4000));
            jSONObject.put("ProgressBar_minWidth", typedArray.getDimensionPixelSize(arrayList.indexOf(16843071), 24));
            jSONObject.put("ProgressBar_maxWidth", typedArray.getDimensionPixelSize(arrayList.indexOf(0x101011F), 48));
            jSONObject.put("ProgressBar_minHeight", typedArray.getDimensionPixelSize(arrayList.indexOf(0x1010140), 24));
            jSONObject.put("ProgressBar_maxHeight", typedArray.getDimensionPixelSize(arrayList.indexOf(0x1010120), 28));
            jSONObject.put("ProgressBar_progress_id", 16908301);
            jSONObject.put("ProgressBar_secondaryProgress_id", 16908303);
            Drawable drawable2 = typedArray.getDrawable(arrayList.indexOf(16843068));
            if (drawable2 != null) {
                jSONObject.put("ProgressBar_progressDrawable", (Object)this.getDrawable(drawable2, n + "_ProgressBar_progressDrawable", null));
            }
            if ((drawable2 = typedArray.getDrawable(arrayList.indexOf(16843067))) != null) {
                jSONObject.put("ProgressBar_indeterminateDrawable", (Object)this.getDrawable(drawable2, n + "_ProgressBar_indeterminateDrawable", null));
            }
            typedArray.recycle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void extractProgressBar(SimpleJsonWriter simpleJsonWriter, int n, String string2, String string3) {
        JSONObject jSONObject = this.extractTextAppearanceInformation(0x1010077, string3);
        try {
            this.extractProgressBarInfo(jSONObject, n);
            simpleJsonWriter.name(string2).value(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void extractAbsSeekBar(SimpleJsonWriter simpleJsonWriter) {
        JSONObject jSONObject = this.extractTextAppearanceInformation(16842875, "QSlider");
        this.extractProgressBarInfo(jSONObject, 16842875);
        try {
            int[] nArray = new int[]{16843074, 16843075};
            Arrays.sort(nArray);
            TypedArray typedArray = this.obtainStyledAttributes(16842875, nArray);
            ArrayList<Integer> arrayList = this.getArrayListFromIntArray(nArray);
            Drawable drawable2 = typedArray.getDrawable(arrayList.indexOf(16843074));
            if (drawable2 != null) {
                jSONObject.put("SeekBar_thumb", (Object)this.getDrawable(drawable2, "16842875_SeekBar_thumb", null));
            }
            jSONObject.put("SeekBar_thumbOffset", typedArray.getDimensionPixelOffset(arrayList.indexOf(16843075), -1));
            typedArray.recycle();
            simpleJsonWriter.name("seekBarStyle").value(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void extractSwitch(SimpleJsonWriter simpleJsonWriter) {
        JSONObject jSONObject = new JSONObject();
        try {
            Drawable drawable2;
            int[] nArray = new int[]{16843074, 16843631, 16843630, 16843044, 16843045, 16843632, 16843633, 16843634, 16843949, 16843852};
            Arrays.sort(nArray);
            TypedArray typedArray = this.obtainStyledAttributes(16843839, nArray);
            ArrayList<Integer> arrayList = this.getArrayListFromIntArray(nArray);
            Drawable drawable3 = typedArray.getDrawable(arrayList.indexOf(16843074));
            if (drawable3 != null) {
                jSONObject.put("Switch_thumb", (Object)this.getDrawable(drawable3, "16843839_Switch_thumb", null));
            }
            if ((drawable2 = typedArray.getDrawable(arrayList.indexOf(16843631))) != null) {
                jSONObject.put("Switch_track", (Object)this.getDrawable(drawable2, "16843839_Switch_track", null));
            }
            jSONObject.put("Switch_textOn", (Object)typedArray.getText(arrayList.indexOf(16843044)));
            jSONObject.put("Switch_textOff", (Object)typedArray.getText(arrayList.indexOf(16843045)));
            jSONObject.put("Switch_switchMinWidth", typedArray.getDimensionPixelSize(arrayList.indexOf(16843632), 0));
            jSONObject.put("Switch_switchPadding", typedArray.getDimensionPixelSize(arrayList.indexOf(16843633), 0));
            jSONObject.put("Switch_thumbTextPadding", typedArray.getDimensionPixelSize(arrayList.indexOf(16843634), 0));
            jSONObject.put("Switch_showText", typedArray.getBoolean(arrayList.indexOf(16843949), true));
            jSONObject.put("Switch_splitTrack", typedArray.getBoolean(arrayList.indexOf(16843852), false));
            int n = typedArray.getResourceId(arrayList.indexOf(16843630), -1);
            jSONObject.put("Switch_switchTextAppearance", (Object)this.extractTextAppearance(n, true));
            typedArray.recycle();
            simpleJsonWriter.name("switchStyle").value(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    JSONObject extractCheckedTextView(String string2) {
        JSONObject jSONObject = this.extractTextAppearanceInformation(16843720, string2);
        try {
            int[] nArray = new int[]{0x1010108};
            Arrays.sort(nArray);
            TypedArray typedArray = this.obtainStyledAttributes(16843839, nArray);
            ArrayList<Integer> arrayList = this.getArrayListFromIntArray(nArray);
            Drawable drawable2 = typedArray.getDrawable(arrayList.indexOf(0x1010108));
            if (drawable2 != null) {
                jSONObject.put("CheckedTextView_checkMark", (Object)this.getDrawable(drawable2, string2 + "_CheckedTextView_checkMark", null));
            }
            typedArray.recycle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    private JSONObject extractItemStyle(int n, String string2) {
        try {
            XmlResourceParser xmlResourceParser = this.m_context.getResources().getLayout(n);
            int n2 = xmlResourceParser.next();
            while (n2 != 2 && n2 != 1) {
                n2 = xmlResourceParser.next();
            }
            if (n2 != 2) {
                return null;
            }
            AttributeSet attributeSet = Xml.asAttributeSet((XmlPullParser)xmlResourceParser);
            String string3 = xmlResourceParser.getName();
            if (string3.equals("TextView")) {
                return this.extractTextAppearanceInformation(16842884, string2, 16843678, attributeSet);
            }
            if (string3.equals("CheckedTextView")) {
                return this.extractCheckedTextView(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private void extractItemsStyle(SimpleJsonWriter simpleJsonWriter) {
        try {
            JSONObject jSONObject = this.extractItemStyle(17367043, "simple_list_item");
            if (jSONObject != null) {
                simpleJsonWriter.name("simple_list_item").value(jSONObject);
            }
            if ((jSONObject = this.extractItemStyle(17367045, "simple_list_item_checked")) != null) {
                simpleJsonWriter.name("simple_list_item_checked").value(jSONObject);
            }
            if ((jSONObject = this.extractItemStyle(0x1090010, "simple_list_item_multiple_choice")) != null) {
                simpleJsonWriter.name("simple_list_item_multiple_choice").value(jSONObject);
            }
            if ((jSONObject = this.extractItemStyle(17367055, "simple_list_item_single_choice")) != null) {
                simpleJsonWriter.name("simple_list_item_single_choice").value(jSONObject);
            }
            if ((jSONObject = this.extractItemStyle(17367048, "simple_spinner_item")) != null) {
                simpleJsonWriter.name("simple_spinner_item").value(jSONObject);
            }
            if ((jSONObject = this.extractItemStyle(0x1090009, "simple_spinner_dropdown_item")) != null) {
                simpleJsonWriter.name("simple_spinner_dropdown_item").value(jSONObject);
            }
            if ((jSONObject = this.extractItemStyle(17367050, "simple_dropdown_item_1line")) != null) {
                simpleJsonWriter.name("simple_dropdown_item_1line").value(jSONObject);
            }
            if ((jSONObject = this.extractItemStyle(17367061, "simple_selectable_list_item")) != null) {
                simpleJsonWriter.name("simple_selectable_list_item").value(jSONObject);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void extractListView(SimpleJsonWriter simpleJsonWriter) {
        JSONObject jSONObject = this.extractTextAppearanceInformation(16842868, "QListView");
        try {
            int[] nArray = new int[]{16843049, 16843050};
            Arrays.sort(nArray);
            TypedArray typedArray = this.obtainStyledAttributes(16842868, nArray);
            ArrayList<Integer> arrayList = this.getArrayListFromIntArray(nArray);
            Drawable drawable2 = typedArray.getDrawable(arrayList.indexOf(16843049));
            if (drawable2 != null) {
                jSONObject.put("ListView_divider", (Object)this.getDrawable(drawable2, "16842868_ListView_divider", null));
            }
            jSONObject.put("ListView_dividerHeight", typedArray.getDimensionPixelSize(arrayList.indexOf(16843050), 0));
            typedArray.recycle();
            simpleJsonWriter.name("listViewStyle").value(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void extractCalendar(SimpleJsonWriter simpleJsonWriter) {
        JSONObject jSONObject = this.extractTextAppearanceInformation(16843613, "QCalendarWidget");
        try {
            int[] nArray = new int[]{16843581, 16843587, 16843586, 16843582, 16843585, 16843588, 16843589, 16843590, 16843591, 16843593, 16843592};
            Arrays.sort(nArray);
            TypedArray typedArray = this.obtainStyledAttributes(16843613, nArray);
            ArrayList<Integer> arrayList = this.getArrayListFromIntArray(nArray);
            Drawable drawable2 = typedArray.getDrawable(arrayList.indexOf(16843591));
            if (drawable2 != null) {
                jSONObject.put("CalendarView_selectedDateVerticalBar", (Object)this.getDrawable(drawable2, "16843613_CalendarView_selectedDateVerticalBar", null));
            }
            int n = typedArray.getResourceId(arrayList.indexOf(16843593), -1);
            jSONObject.put("CalendarView_dateTextAppearance", (Object)this.extractTextAppearance(n, true));
            n = typedArray.getResourceId(arrayList.indexOf(16843592), -1);
            jSONObject.put("CalendarView_weekDayTextAppearance", (Object)this.extractTextAppearance(n, true));
            jSONObject.put("CalendarView_firstDayOfWeek", typedArray.getInt(arrayList.indexOf(16843581), 0));
            jSONObject.put("CalendarView_focusedMonthDateColor", typedArray.getColor(arrayList.indexOf(16843587), 0));
            jSONObject.put("CalendarView_selectedWeekBackgroundColor", typedArray.getColor(arrayList.indexOf(16843586), 0));
            jSONObject.put("CalendarView_showWeekNumber", typedArray.getBoolean(arrayList.indexOf(16843582), true));
            jSONObject.put("CalendarView_shownWeekCount", typedArray.getInt(arrayList.indexOf(16843585), 6));
            jSONObject.put("CalendarView_unfocusedMonthDateColor", typedArray.getColor(arrayList.indexOf(16843588), 0));
            jSONObject.put("CalendarView_weekNumberColor", typedArray.getColor(arrayList.indexOf(16843589), 0));
            jSONObject.put("CalendarView_weekSeparatorLineColor", typedArray.getColor(arrayList.indexOf(16843590), 0));
            typedArray.recycle();
            simpleJsonWriter.name("calendarViewStyle").value(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void extractToolBar(SimpleJsonWriter simpleJsonWriter) {
        JSONObject jSONObject = this.extractTextAppearanceInformation(16843946, "QToolBar");
        try {
            int[] nArray = new int[]{16842964, 16843658, 16843659, 16843049, 16843565};
            Arrays.sort(nArray);
            TypedArray typedArray = this.obtainStyledAttributes(16843946, nArray);
            ArrayList<Integer> arrayList = this.getArrayListFromIntArray(nArray);
            Drawable drawable2 = typedArray.getDrawable(arrayList.indexOf(16842964));
            if (drawable2 != null) {
                jSONObject.put("ActionBar_background", (Object)this.getDrawable(drawable2, "16843946_ActionBar_background", null));
            }
            if ((drawable2 = typedArray.getDrawable(arrayList.indexOf(16843658))) != null) {
                jSONObject.put("ActionBar_backgroundStacked", (Object)this.getDrawable(drawable2, "16843946_ActionBar_backgroundStacked", null));
            }
            if ((drawable2 = typedArray.getDrawable(arrayList.indexOf(16843659))) != null) {
                jSONObject.put("ActionBar_backgroundSplit", (Object)this.getDrawable(drawable2, "16843946_ActionBar_backgroundSplit", null));
            }
            if ((drawable2 = typedArray.getDrawable(arrayList.indexOf(16843049))) != null) {
                jSONObject.put("ActionBar_divider", (Object)this.getDrawable(drawable2, "16843946_ActionBar_divider", null));
            }
            jSONObject.put("ActionBar_itemPadding", typedArray.getDimensionPixelSize(arrayList.indexOf(16843565), 0));
            typedArray.recycle();
            simpleJsonWriter.name("actionBarStyle").value(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void extractTabBar(SimpleJsonWriter simpleJsonWriter) {
        JSONObject jSONObject = this.extractTextAppearanceInformation(16843508, "QTabBar");
        try {
            int[] nArray = new int[]{16843561, 16843562, 16843049};
            Arrays.sort(nArray);
            TypedArray typedArray = this.obtainStyledAttributes(16843507, nArray);
            ArrayList<Integer> arrayList = this.getArrayListFromIntArray(nArray);
            Drawable drawable2 = typedArray.getDrawable(arrayList.indexOf(16843049));
            if (drawable2 != null) {
                jSONObject.put("LinearLayout_divider", (Object)this.getDrawable(drawable2, "16843507_LinearLayout_divider", null));
            }
            jSONObject.put("LinearLayout_showDividers", typedArray.getInt(arrayList.indexOf(16843561), 0));
            jSONObject.put("LinearLayout_dividerPadding", typedArray.getDimensionPixelSize(arrayList.indexOf(16843562), 0));
            typedArray.recycle();
            simpleJsonWriter.name("actionBarTabBarStyle").value(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void extractWindow(SimpleJsonWriter simpleJsonWriter) {
        JSONObject jSONObject = new JSONObject();
        try {
            Drawable drawable2;
            int[] nArray = new int[]{16842836, 0x1010055};
            Arrays.sort(nArray);
            TypedArray typedArray = this.obtainStyledAttributes(16842870, nArray);
            ArrayList<Integer> arrayList = this.getArrayListFromIntArray(nArray);
            Drawable drawable3 = typedArray.getDrawable(arrayList.indexOf(16842836));
            if (drawable3 != null) {
                jSONObject.put("Window_windowBackground", (Object)this.getDrawable(drawable3, "16842870_Window_windowBackground", null));
            }
            if ((drawable2 = typedArray.getDrawable(arrayList.indexOf(0x1010055))) != null) {
                jSONObject.put("Window_windowFrame", (Object)this.getDrawable(drawable2, "16842870_Window_windowFrame", null));
            }
            typedArray.recycle();
            simpleJsonWriter.name("windowStyle").value(jSONObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private JSONObject extractDefaultPalette() {
        JSONObject jSONObject = this.extractTextAppearance(16842804);
        try {
            jSONObject.put("defaultBackgroundColor", this.defaultBackgroundColor);
            jSONObject.put("defaultTextColorPrimary", this.defaultTextColor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
    }

    static class SimpleJsonWriter {
        private final OutputStreamWriter m_writer;
        private boolean m_addComma = false;
        private int m_indentLevel = 0;

        SimpleJsonWriter(String string2) throws FileNotFoundException {
            this.m_writer = new OutputStreamWriter(new FileOutputStream(string2));
        }

        void close() throws IOException {
            this.m_writer.close();
        }

        private void writeIndent() throws IOException {
            this.m_writer.write(" ", 0, this.m_indentLevel);
        }

        void beginObject() throws IOException {
            this.writeIndent();
            this.m_writer.write("{\n");
            ++this.m_indentLevel;
            this.m_addComma = false;
        }

        void endObject() throws IOException {
            this.m_writer.write("\n");
            this.writeIndent();
            this.m_writer.write("}\n");
            --this.m_indentLevel;
            this.m_addComma = false;
        }

        SimpleJsonWriter name(String string2) throws IOException {
            if (this.m_addComma) {
                this.m_writer.write(",\n");
            }
            this.writeIndent();
            this.m_writer.write(JSONObject.quote((String)string2) + ": ");
            this.m_addComma = true;
            return this;
        }

        void value(JSONObject jSONObject) throws IOException {
            this.m_writer.write(jSONObject.toString());
        }
    }

    static class DrawableCache {
        JSONObject object;
        Object drawable;

        DrawableCache(JSONObject jSONObject, Object object) {
            this.object = jSONObject;
            this.drawable = object;
        }
    }
}

