/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.app.Activity;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.UriPermission;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.View;
import java.lang.ref.WeakReference;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.qtproject.qt.android.QtThread;
import org.qtproject.qt.android.UsedFromNativeCode;

public class QtNative {
    private static WeakReference<Activity> m_activity = null;
    private static WeakReference<Service> m_service = null;
    private static final Object m_mainActivityMutex = new Object();
    private static final ApplicationStateDetails m_stateDetails = new ApplicationStateDetails();
    static final String QtTAG = "Qt JAVA";
    private static final ArrayList<Runnable> m_lostActions = new ArrayList();
    private static final QtThread m_qtThread = new QtThread();
    private static ClassLoader m_classLoader = null;
    private static final Runnable runPendingCppRunnablesRunnable = QtNative::runPendingCppRunnables;
    private static final ArrayList<AppStateDetailsListener> m_appStateListeners = new ArrayList();
    private static final Object m_appStateListenersLock = new Object();

    @UsedFromNativeCode
    static ClassLoader classLoader() {
        return m_classLoader;
    }

    static void setClassLoader(ClassLoader classLoader) {
        m_classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setActivity(Activity activity) {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            m_activity = new WeakReference<Activity>(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setService(Service service) {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            m_service = new WeakReference<Service>(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    static Activity activity() {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            return m_activity != null ? (Activity)m_activity.get() : null;
        }
    }

    static boolean isActivityValid() {
        return m_activity != null && m_activity.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    static Service service() {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            return m_service != null ? (Service)m_service.get() : null;
        }
    }

    static boolean isServiceValid() {
        return m_service != null && m_service.get() != null;
    }

    @UsedFromNativeCode
    static Context getContext() {
        if (QtNative.isActivityValid()) {
            return (Context)m_activity.get();
        }
        return QtNative.service();
    }

    @UsedFromNativeCode
    static String[] getStringArray(String string2) {
        return string2.split(",");
    }

    private static String getCurrentMethodNameLog() {
        return new Exception().getStackTrace()[1].getMethodName() + ": ";
    }

    private static Uri getUriWithValidPermission(Context context, String string2, String string3) {
        Uri uri;
        try {
            uri = Uri.parse((String)string2);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            return null;
        }
        try {
            String string4 = uri.getScheme();
            if (string4 != null && string4.compareTo("content") != 0) {
                return uri;
            }
            List list = context.getContentResolver().getPersistedUriPermissions();
            String string5 = uri.getPath();
            for (int i = 0; i < list.size(); ++i) {
                Uri uri2 = ((UriPermission)list.get(i)).getUri();
                boolean bl = ((UriPermission)list.get(i)).isReadPermission();
                if (!string3.equals("r")) {
                    bl = ((UriPermission)list.get(i)).isWritePermission();
                }
                if (!Objects.equals(uri2.getPath(), string5) || !bl) continue;
                return uri2;
            }
            return uri;
        }
        catch (SecurityException securityException) {
            Log.e((String)QtTAG, (String)(QtNative.getCurrentMethodNameLog() + securityException));
            return uri;
        }
    }

    @UsedFromNativeCode
    static boolean openURL(Context context, String string2, String string3) {
        Uri uri = QtNative.getUriWithValidPermission(context, string2, "r");
        if (uri == null) {
            Log.e((String)QtTAG, (String)(QtNative.getCurrentMethodNameLog() + "received invalid/null Uri"));
            return false;
        }
        try {
            Activity activity;
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            intent.addFlags(1);
            if (!string3.isEmpty()) {
                intent.setDataAndType(uri, string3);
            }
            if ((activity = QtNative.activity()) == null) {
                Log.w((String)QtTAG, (String)"openURL(): The activity reference is null");
                return false;
            }
            activity.startActivity(intent);
            return true;
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)(QtNative.getCurrentMethodNameLog() + exception));
            return false;
        }
    }

    static QtThread getQtThread() {
        return m_qtThread;
    }

    static ApplicationStateDetails getStateDetails() {
        return m_stateDetails;
    }

    static void setStarted(boolean bl) {
        QtNative.m_stateDetails.isStarted = bl;
        QtNative.notifyAppStateDetailsChanged(m_stateDetails);
    }

    @UsedFromNativeCode
    static void notifyNativePluginIntegrationReady(boolean bl) {
        QtNative.m_stateDetails.nativePluginIntegrationReady = bl;
        QtNative.notifyNativePluginIntegrationReadyChanged(bl);
        QtNative.notifyAppStateDetailsChanged(m_stateDetails);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setApplicationState(int n) {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            QtNative.m_stateDetails.state = n;
            if (n == 4) {
                for (Runnable runnable : m_lostActions) {
                    QtNative.runAction(runnable);
                }
                m_lostActions.clear();
            }
        }
        QtNative.updateApplicationState(n);
        QtNative.notifyAppStateDetailsChanged(m_stateDetails);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerAppStateListener(AppStateDetailsListener appStateDetailsListener) {
        Object object = m_appStateListenersLock;
        synchronized (object) {
            if (!m_appStateListeners.contains(appStateDetailsListener)) {
                m_appStateListeners.add(appStateDetailsListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterAppStateListener(AppStateDetailsListener appStateDetailsListener) {
        Object object = m_appStateListenersLock;
        synchronized (object) {
            m_appStateListeners.remove(appStateDetailsListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyNativePluginIntegrationReadyChanged(boolean bl) {
        Object object = m_appStateListenersLock;
        synchronized (object) {
            for (AppStateDetailsListener appStateDetailsListener : m_appStateListeners) {
                appStateDetailsListener.onNativePluginIntegrationReadyChanged(bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyAppStateDetailsChanged(ApplicationStateDetails applicationStateDetails) {
        Object object = m_appStateListenersLock;
        synchronized (object) {
            for (AppStateDetailsListener appStateDetailsListener : m_appStateListeners) {
                appStateDetailsListener.onAppStateDetailsChanged(applicationStateDetails);
            }
        }
    }

    static void runAction(Runnable runnable) {
        QtNative.runAction(runnable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runAction(Runnable runnable, boolean bl) {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            Looper looper = Looper.getMainLooper();
            Handler handler = new Handler(looper);
            if (bl) {
                boolean bl2;
                boolean bl3 = QtNative.m_stateDetails.state != 0 && QtNative.m_stateDetails.state != 1;
                boolean bl4 = bl2 = QtNative.isActivityValid() && bl3 || QtNative.isServiceValid();
                if (!bl2 || !handler.post(runnable)) {
                    m_lostActions.add(runnable);
                }
            } else {
                handler.post(runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    private static void runPendingCppRunnablesOnAndroidThread() {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            if (QtNative.isActivityValid()) {
                if (QtNative.m_stateDetails.state == 4) {
                    ((Activity)m_activity.get()).runOnUiThread(runPendingCppRunnablesRunnable);
                } else {
                    QtNative.runAction(runPendingCppRunnablesRunnable);
                }
            } else {
                Looper looper = Looper.getMainLooper();
                Thread thread = looper.getThread();
                if (thread.equals(Thread.currentThread())) {
                    runPendingCppRunnablesRunnable.run();
                } else {
                    Handler handler = new Handler(looper);
                    handler.post(runPendingCppRunnablesRunnable);
                }
            }
        }
    }

    @UsedFromNativeCode
    private static void setViewVisibility(View view, boolean bl) {
        QtNative.runAction(() -> view.setVisibility(bl ? 0 : 8));
    }

    static void startApplication(String string2, String string3) {
        m_qtThread.run(() -> {
            String string4 = string3 + " " + string2;
            if (!QtNative.startQtAndroidPlugin(string4)) {
                Log.e((String)QtTAG, (String)"An error occurred while starting the Qt Android plugin");
            }
        });
        m_qtThread.post(QtNative::startQtApplication);
        QtNative.waitForServiceSetup();
        QtNative.m_stateDetails.isStarted = true;
        QtNative.notifyAppStateDetailsChanged(m_stateDetails);
    }

    static void quitApp() {
        QtNative.runAction(() -> {
            QtNative.quitQtAndroidPlugin();
            if (QtNative.isActivityValid()) {
                ((Activity)m_activity.get()).finish();
            }
            if (QtNative.isServiceValid()) {
                ((Service)m_service.get()).stopSelf();
            }
            QtNative.m_stateDetails.isStarted = false;
            QtNative.notifyAppStateDetailsChanged(m_stateDetails);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedFromNativeCode
    static int checkSelfPermission(String string2) {
        Object object = m_mainActivityMutex;
        synchronized (object) {
            Context context = QtNative.getContext();
            PackageManager packageManager = context.getPackageManager();
            return packageManager.checkPermission(string2, context.getPackageName());
        }
    }

    @UsedFromNativeCode
    private static byte[][] getSSLCertificates() {
        Object object;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        try {
            object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ((TrustManagerFactory)object).init((KeyStore)null);
            for (TrustManager trustManager : ((TrustManagerFactory)object).getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
                for (X509Certificate x509Certificate : x509TrustManager.getAcceptedIssuers()) {
                    byte[] byArray = x509Certificate.getEncoded();
                    arrayList.add(byArray);
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)"Failed to get certificates", (Throwable)exception);
        }
        object = new byte[arrayList.size()][];
        object = (byte[][])arrayList.toArray((T[])object);
        return object;
    }

    @UsedFromNativeCode
    private static String[] listAssetContent(AssetManager assetManager, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String[] stringArray = assetManager.list(string2);
            if (stringArray != null) {
                for (String string3 : stringArray) {
                    try {
                        String[] stringArray2 = assetManager.list(string2.length() > 0 ? string2 + "/" + string3 : string3);
                        if (stringArray2 != null && stringArray2.length > 0) {
                            string3 = string3 + "/";
                        }
                        arrayList.add(string3);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList.toArray(new String[0]);
    }

    static native boolean startQtAndroidPlugin(String var0);

    static native void startQtApplication();

    static native void waitForServiceSetup();

    static native void quitQtCoreApplication();

    static native void quitQtAndroidPlugin();

    static native void terminateQt();

    static native boolean updateNativeActivity();

    static native void updateWindow();

    static native void updateApplicationState(int var0);

    static native void updateLocale();

    static native boolean onPrepareOptionsMenu(Menu var0);

    static native boolean onOptionsItemSelected(int var0, boolean var1);

    static native void onOptionsMenuClosed(Menu var0);

    static native void onCreateContextMenu(ContextMenu var0);

    static native void fillContextMenu(Menu var0);

    static native boolean onContextItemSelected(int var0, boolean var1);

    static native void onContextMenuClosed(Menu var0);

    static native void onActivityResult(int var0, int var1, Intent var2);

    public static native void onNewIntent(Intent var0);

    static native void runPendingCppRunnables();

    static native void sendRequestPermissionsResult(int var0, String[] var1, int[] var2);

    static native IBinder onBind(Intent var0);

    static class ApplicationStateDetails {
        int state = 0;
        boolean nativePluginIntegrationReady = false;
        boolean isStarted = false;

        ApplicationStateDetails() {
        }
    }

    static class ApplicationState {
        static final int ApplicationSuspended = 0;
        static final int ApplicationHidden = 1;
        static final int ApplicationInactive = 2;
        static final int ApplicationActive = 4;

        ApplicationState() {
        }
    }

    static interface AppStateDetailsListener {
        default public void onAppStateDetailsChanged(ApplicationStateDetails applicationStateDetails) {
        }

        default public void onNativePluginIntegrationReadyChanged(boolean bl) {
        }
    }
}

