/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.multimedia;

import android.content.Context;
import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.util.Range;
import android.util.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.qtproject.qt.android.UsedFromNativeCode;

class QtVideoDeviceManager {
    CameraManager mCameraManager;
    Map<String, CameraCharacteristics> cache;
    static final int maxResolution = 8294400;

    @UsedFromNativeCode
    QtVideoDeviceManager(Context context) {
        this.mCameraManager = (CameraManager)context.getSystemService("camera");
        this.cache = new WeakHashMap<String, CameraCharacteristics>();
    }

    CameraCharacteristics getCameraCharacteristics(String string) {
        if (this.cache.containsKey(string)) {
            return this.cache.get(string);
        }
        try {
            CameraCharacteristics cameraCharacteristics = this.mCameraManager.getCameraCharacteristics(string);
            this.cache.put(string, cameraCharacteristics);
            return cameraCharacteristics;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static boolean isSoftwareCodec(String string) {
        return (string = string.toLowerCase()).startsWith("omx.google.") || string.startsWith("c2.android.") || !string.startsWith("omx.") && !string.startsWith("c2.");
    }

    private static String[] getHWVideoCodecs(CODEC cODEC) {
        MediaCodecList mediaCodecList = new MediaCodecList(0);
        MediaCodecInfo[] mediaCodecInfoArray = mediaCodecList.getCodecInfos();
        HashSet<String> hashSet = new HashSet<String>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoArray) {
            String[] stringArray;
            CODEC cODEC2;
            CODEC cODEC3 = cODEC2 = mediaCodecInfo.isEncoder() ? CODEC.ENCODER : CODEC.DECODER;
            if (cODEC2 != cODEC || QtVideoDeviceManager.isSoftwareCodec(mediaCodecInfo.getName())) continue;
            for (String string : stringArray = mediaCodecInfo.getSupportedTypes()) {
                if (!string.startsWith("video/")) continue;
                hashSet.add(string.substring(6));
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    static String[] getHWVideoDecoders() {
        return QtVideoDeviceManager.getHWVideoCodecs(CODEC.DECODER);
    }

    static String[] getHWVideoEncoders() {
        return QtVideoDeviceManager.getHWVideoCodecs(CODEC.ENCODER);
    }

    @UsedFromNativeCode
    String[] getCameraIdList() {
        try {
            return this.mCameraManager.getCameraIdList();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @UsedFromNativeCode
    int getSensorOrientation(String string) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics == null) {
            return 0;
        }
        return (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
    }

    @UsedFromNativeCode
    int getLensFacing(String string) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics == null) {
            return 0;
        }
        return (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
    }

    @UsedFromNativeCode
    String[] getFpsRange(String string) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics == null) {
            return new String[0];
        }
        Range[] rangeArray = (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        String[] stringArray = new String[rangeArray.length];
        for (int i = 0; i < rangeArray.length; ++i) {
            stringArray[i] = rangeArray[i].toString();
        }
        return stringArray;
    }

    @UsedFromNativeCode
    float[] getZoomRange(String string) {
        Range range;
        float[] fArray = new float[]{1.0f, 1.0f};
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics == null) {
            return fArray;
        }
        if (Build.VERSION.SDK_INT >= 30 && (range = (Range)cameraCharacteristics.get(CameraCharacteristics.CONTROL_ZOOM_RATIO_RANGE)) != null) {
            fArray[0] = ((Float)range.getLower()).floatValue();
            fArray[1] = ((Float)range.getUpper()).floatValue();
        }
        if (fArray[1] == 1.0f) {
            fArray[1] = ((Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
        }
        return fArray;
    }

    Rect getActiveArraySize(String string) {
        Rect rect = new Rect();
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics != null) {
            rect = (Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        }
        return rect;
    }

    @UsedFromNativeCode
    String[] getStreamConfigurationsSizes(String string, int n) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics == null) {
            return new String[0];
        }
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        Size[] sizeArray = streamConfigurationMap.getOutputSizes(n);
        if (sizeArray == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < sizeArray.length; ++i) {
            if (sizeArray[i].getWidth() * sizeArray[i].getHeight() > 8294400) continue;
            arrayList.add(sizeArray[i].toString());
        }
        return arrayList.toArray(new String[0]);
    }

    int stringToControlAEMode(String string) {
        switch (string) {
            case "off": {
                return 1;
            }
            case "auto": {
                return 2;
            }
            case "on": {
                return 3;
            }
            case "redeye": {
                return 4;
            }
            case "external": {
                return 5;
            }
        }
        return -1;
    }

    String controlAEModeToString(int n) {
        switch (n) {
            case 1: {
                return "off";
            }
            case 2: {
                return "auto";
            }
            case 3: {
                return "on";
            }
            case 4: {
                return "redeye";
            }
            case 5: {
                return "external";
            }
        }
        return "unknown";
    }

    @UsedFromNativeCode
    int[] getAllAvailableAfModes(String string) {
        if (string.isEmpty()) {
            return new int[0];
        }
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics == null) {
            return new int[0];
        }
        int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        return nArray != null ? nArray : new int[]{};
    }

    @UsedFromNativeCode
    boolean isAfModeSupported(String string, int n) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        boolean bl = Arrays.stream(this.getAllAvailableAfModes(string)).anyMatch(n2 -> n2 == n);
        if (bl) {
            if (n == 4) {
                return true;
            }
            if (n == 0 && this.isManualFocusDistanceSupported(string)) {
                return true;
            }
        }
        return false;
    }

    @UsedFromNativeCode
    String[] getSupportedQCameraFocusModesAsStrings(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isAfModeSupported(string, 4)) {
            arrayList.add("FocusModeAuto");
        }
        if (this.isAfModeSupported(string, 0) && this.isManualFocusDistanceSupported(string)) {
            arrayList.add("FocusModeManual");
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    @UsedFromNativeCode
    String[] getSupportedFlashModes(String string) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics == null) {
            return new String[0];
        }
        int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.controlAEModeToString(nArray[i]));
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    float getLensInfoMinimumFocusDistance(String string) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics == null) {
            return -1.0f;
        }
        Float f = (Float)cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE);
        if (f == null) {
            return -1.0f;
        }
        return f.floatValue();
    }

    boolean isManualFocusDistanceSupported(String string) {
        return this.getLensInfoMinimumFocusDistance(string) > 0.0f;
    }

    static boolean isEmulator() {
        return Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.HARDWARE.contains("goldfish") || Build.HARDWARE.contains("ranchu") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.PRODUCT.contains("sdk") || Build.PRODUCT.contains("vbox86p") || Build.PRODUCT.contains("emulator") || Build.PRODUCT.contains("simulator");
    }

    @UsedFromNativeCode
    boolean isTorchModeSupported(String string) {
        boolean bl = false;
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics != null) {
            bl = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        }
        return bl;
    }

    private static enum CODEC {
        DECODER,
        ENCODER;

    }
}

