/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import org.qtproject.qt.android.CursorHandle;
import org.qtproject.qt.android.EditPopupMenu;
import org.qtproject.qt.android.QtClipboardManager;
import org.qtproject.qt.android.QtInputConnection;

class QtEditText
extends View {
    int m_initialCapsMode = 0;
    int m_imeOptions = 0;
    int m_inputType = 1;
    boolean m_optionsChanged = false;
    QtInputConnection m_inputConnection = null;
    private final int ImhHiddenText = 1;
    private final int ImhSensitiveData = 2;
    private final int ImhNoAutoUppercase = 4;
    private final int ImhPreferNumbers = 8;
    private final int ImhPreferUppercase = 16;
    private final int ImhPreferLowercase = 32;
    private final int ImhNoPredictiveText = 64;
    private final int ImhDate = 128;
    private final int ImhTime = 256;
    private final int ImhPreferLatin = 512;
    private final int ImhMultiLine = 1024;
    private final int ImhDigitsOnly = 65536;
    private final int ImhFormattedNumbersOnly = 131072;
    private final int ImhUppercaseOnly = 262144;
    private final int ImhLowercaseOnly = 524288;
    private final int ImhDialableCharactersOnly = 0x100000;
    private final int ImhEmailCharactersOnly = 0x200000;
    private final int ImhUrlCharactersOnly = 0x400000;
    private final int ImhLatinOnly = 0x800000;
    private final QtInputConnection.QtInputConnectionListener m_qtInputConnectionListener;
    static final int CursorHandleNotShown = 0;
    static final int CursorHandleShowNormal = 1;
    static final int CursorHandleShowSelection = 2;
    static final int CursorHandleShowEdit = 256;
    private CursorHandle m_cursorHandle;
    private CursorHandle m_leftSelectionHandle;
    private CursorHandle m_rightSelectionHandle;
    private final EditPopupMenu m_editPopupMenu;

    QtEditText(Context context, QtInputConnection.QtInputConnectionListener qtInputConnectionListener) {
        super(context);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.m_qtInputConnectionListener = qtInputConnectionListener;
        this.m_editPopupMenu = new EditPopupMenu(this);
    }

    private void setImeOptions(int n) {
        if (this.m_imeOptions == n) {
            return;
        }
        this.m_imeOptions = n;
        this.m_optionsChanged = true;
    }

    private void setInitialCapsMode(int n) {
        if (this.m_initialCapsMode == n) {
            return;
        }
        this.m_initialCapsMode = n;
        this.m_optionsChanged = true;
    }

    private void setInputType(int n) {
        if (this.m_inputType == n) {
            return;
        }
        this.m_inputType = n;
        this.m_optionsChanged = true;
    }

    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        editorInfo.inputType = this.m_inputType;
        editorInfo.imeOptions = this.m_imeOptions;
        editorInfo.initialCapsMode = this.m_initialCapsMode;
        this.m_inputConnection = new QtInputConnection(this, this.m_qtInputConnectionListener);
        return this.m_inputConnection;
    }

    public boolean onCheckIsTextEditor() {
        return true;
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (null != this.m_inputConnection) {
            this.m_inputConnection.restartImmInput();
        }
        return super.onKeyDown(n, keyEvent);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    void setEditTextOptions(int n, int n2) {
        int n3 = 0;
        int n4 = this.imeOptionsFromEnterKeyType(n);
        int n5 = 1;
        if ((n2 & 0x30008) != 0) {
            n5 = 2;
            if ((n2 & 0x20000) != 0) {
                n5 |= 0x3000;
            }
            if ((n2 & 1) != 0) {
                n5 |= 0x10;
            }
        } else if ((n2 & 0x100000) != 0) {
            n5 = 3;
        } else if ((n2 & 0x180) != 0) {
            n5 = 4;
            if ((n2 & 0x180) != 384) {
                n5 = (n2 & 0x80) != 0 ? (n5 |= 0x10) : (n5 |= 0x20);
            }
        } else {
            if ((n2 & 1) != 0) {
                n5 |= 0x80;
            } else if ((n2 & 2) != 0 || this.isDisablePredictiveTextWorkaround(n2)) {
                n5 |= 0x90;
            } else if ((n2 & 0x400000) != 0) {
                n5 |= 0x10;
                if (n == 0) {
                    n4 = 2;
                }
            } else if ((n2 & 0x200000) != 0) {
                n5 |= 0x20;
            }
            if ((n2 & 0x400) != 0) {
                n5 |= 0x20000;
                n4 = 6;
            }
            if ((n2 & 0x43) != 0) {
                n5 |= 0x80000;
            }
            if ((n2 & 0x40000) != 0) {
                n3 |= 0x1000;
                n5 |= 0x1000;
            } else if ((n2 & 0x80000) == 0 && (n2 & 4) == 0) {
                n3 |= 0x4000;
                n5 |= 0x4000;
            }
        }
        if (n == 0 && (n2 & 0x400) != 0) {
            n4 = 0x40000000;
        }
        this.setInitialCapsMode(n3);
        this.setImeOptions(n4);
        this.setInputType(n5);
    }

    private int imeOptionsFromEnterKeyType(int n) {
        int n2 = 6;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                n2 = 0x40000000;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 5;
                break;
            }
            case 7: {
                n2 = 7;
            }
        }
        return n2;
    }

    int getSelectionHandleBottom() {
        if (this.m_cursorHandle != null) {
            return this.m_cursorHandle.bottom();
        }
        if (this.m_leftSelectionHandle != null && this.m_rightSelectionHandle != null) {
            return Math.max(this.m_leftSelectionHandle.bottom(), this.m_rightSelectionHandle.bottom());
        }
        return 0;
    }

    int getSelectionHandleWidth() {
        if (this.m_leftSelectionHandle != null && this.m_rightSelectionHandle != null) {
            return Math.max(this.m_leftSelectionHandle.width(), this.m_rightSelectionHandle.width());
        }
        if (this.m_cursorHandle != null) {
            return this.m_cursorHandle.width();
        }
        return 0;
    }

    void updateHandles(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        boolean bl2;
        switch (n & 0xFF) {
            case 0: {
                if (this.m_cursorHandle != null) {
                    this.m_cursorHandle.hide();
                    this.m_cursorHandle = null;
                }
                if (this.m_rightSelectionHandle == null) break;
                this.m_rightSelectionHandle.hide();
                this.m_leftSelectionHandle.hide();
                this.m_rightSelectionHandle = null;
                this.m_leftSelectionHandle = null;
                break;
            }
            case 1: {
                if (this.m_cursorHandle == null) {
                    this.m_cursorHandle = new CursorHandle((Activity)this.getContext(), this, 1, 16843463, false);
                }
                this.m_cursorHandle.setPosition(n5, n6);
                if (this.m_rightSelectionHandle == null) break;
                this.m_rightSelectionHandle.hide();
                this.m_leftSelectionHandle.hide();
                this.m_rightSelectionHandle = null;
                this.m_leftSelectionHandle = null;
                break;
            }
            case 2: {
                if (this.m_rightSelectionHandle == null) {
                    this.m_leftSelectionHandle = new CursorHandle((Activity)this.getContext(), this, 2, !bl ? 16843461 : 16843462, bl);
                    this.m_rightSelectionHandle = new CursorHandle((Activity)this.getContext(), this, 3, !bl ? 16843462 : 16843461, bl);
                }
                this.m_leftSelectionHandle.setPosition(n5, n6);
                this.m_rightSelectionHandle.setPosition(n7, n8);
                if (this.m_cursorHandle != null) {
                    this.m_cursorHandle.hide();
                    this.m_cursorHandle = null;
                }
                n |= 0x100;
            }
        }
        if (!QtClipboardManager.hasClipboardText(this.getContext())) {
            n4 &= 0xFFFFFFFB;
        }
        boolean bl3 = bl2 = (n & 0x100) == 256 && n4 != 0;
        if (bl2) {
            this.m_editPopupMenu.setPosition(n2, n3, n4);
        } else {
            this.m_editPopupMenu.hide();
        }
    }

    private boolean isDisablePredictiveTextWorkaround(int n) {
        return (n & 0x40) != 0 && System.getenv("QT_ANDROID_ENABLE_WORKAROUND_TO_DISABLE_PREDICTIVE_TEXT") != null;
    }
}

