/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.annotation.TargetApi;
import android.os.Build;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.TextAttribute;
import org.qtproject.qt.android.QtEditText;
import org.qtproject.qt.android.QtExtractedText;
import org.qtproject.qt.android.QtNativeInputConnection;

class QtInputConnection
extends BaseInputConnection {
    private static final int ID_SELECT_ALL = 16908319;
    private static final int ID_CUT = 0x1020020;
    private static final int ID_COPY = 0x1020021;
    private static final int ID_PASTE = 0x1020022;
    private static final int ID_COPY_URL = 16908323;
    private static final int ID_SWITCH_INPUT_METHOD = 16908324;
    private static final int ID_ADD_TO_DICTIONARY = 16908330;
    private static final int KEYBOARD_CHECK_DELAY_MS = 100;
    private static final String QtTAG = "QtInputConnection";
    private final QtInputConnectionListener m_qtInputConnectionListener;
    private final QtEditText m_view;
    private final InputMethodManager m_imm;

    private void setClosing(boolean bl) {
        if (bl) {
            this.m_view.postDelayed(new HideKeyboardRunnable(), 100L);
        } else if (this.m_qtInputConnectionListener != null) {
            this.m_qtInputConnectionListener.onSetClosing(false);
        }
    }

    QtInputConnection(QtEditText qtEditText, QtInputConnectionListener qtInputConnectionListener) {
        super((View)qtEditText, true);
        this.m_view = qtEditText;
        this.m_imm = (InputMethodManager)this.m_view.getContext().getSystemService("input_method");
        this.m_qtInputConnectionListener = qtInputConnectionListener;
    }

    void restartImmInput() {
        if (QtNativeInputConnection.fullscreenMode() && this.m_imm != null) {
            this.m_imm.restartInput((View)this.m_view);
        }
    }

    public boolean beginBatchEdit() {
        this.setClosing(false);
        return QtNativeInputConnection.beginBatchEdit();
    }

    public boolean reportFullscreenMode(boolean bl) {
        QtNativeInputConnection.reportFullscreenMode(bl);
        return Build.VERSION.SDK_INT < 26;
    }

    public boolean endBatchEdit() {
        this.setClosing(false);
        return QtNativeInputConnection.endBatchEdit();
    }

    public boolean commitCompletion(CompletionInfo completionInfo) {
        this.setClosing(false);
        return QtNativeInputConnection.commitCompletion(completionInfo.getText().toString(), completionInfo.getPosition());
    }

    public boolean commitText(CharSequence charSequence, int n) {
        this.setClosing(false);
        this.restartImmInput();
        return QtNativeInputConnection.commitText(charSequence.toString(), n);
    }

    public boolean deleteSurroundingText(int n, int n2) {
        this.setClosing(false);
        return QtNativeInputConnection.deleteSurroundingText(n, n2);
    }

    public boolean finishComposingText() {
        this.setClosing(true);
        return QtNativeInputConnection.finishComposingText();
    }

    public int getCursorCapsMode(int n) {
        return QtNativeInputConnection.getCursorCapsMode(n);
    }

    public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int n) {
        QtExtractedText qtExtractedText = QtNativeInputConnection.getExtractedText(extractedTextRequest.hintMaxChars, extractedTextRequest.hintMaxLines, n);
        if (qtExtractedText == null) {
            return null;
        }
        ExtractedText extractedText = new ExtractedText();
        extractedText.partialEndOffset = qtExtractedText.partialEndOffset;
        extractedText.partialStartOffset = qtExtractedText.partialStartOffset;
        extractedText.selectionEnd = qtExtractedText.selectionEnd;
        extractedText.selectionStart = qtExtractedText.selectionStart;
        extractedText.startOffset = qtExtractedText.startOffset;
        extractedText.text = qtExtractedText.text;
        return extractedText;
    }

    public CharSequence getSelectedText(int n) {
        return QtNativeInputConnection.getSelectedText(n);
    }

    public CharSequence getTextAfterCursor(int n, int n2) {
        return QtNativeInputConnection.getTextAfterCursor(n, n2);
    }

    public CharSequence getTextBeforeCursor(int n, int n2) {
        return QtNativeInputConnection.getTextBeforeCursor(n, n2);
    }

    public boolean performContextMenuAction(int n) {
        switch (n) {
            case 16908319: {
                this.restartImmInput();
                return QtNativeInputConnection.selectAll();
            }
            case 0x1020021: {
                this.restartImmInput();
                return QtNativeInputConnection.copy();
            }
            case 16908323: {
                this.restartImmInput();
                return QtNativeInputConnection.copyURL();
            }
            case 0x1020020: {
                this.restartImmInput();
                return QtNativeInputConnection.cut();
            }
            case 0x1020022: {
                this.restartImmInput();
                return QtNativeInputConnection.paste();
            }
            case 16908324: {
                if (this.m_imm != null) {
                    this.m_imm.showInputMethodPicker();
                }
                return true;
            }
            case 16908330: {
                return true;
            }
        }
        return super.performContextMenuAction(n);
    }

    public boolean sendKeyEvent(KeyEvent keyEvent) {
        this.finishComposingText();
        if (keyEvent.getKeyCode() == 66 && this.m_view != null) {
            switch (this.m_view.m_imeOptions) {
                case 5: {
                    KeyEvent keyEvent2 = new KeyEvent(keyEvent.getDownTime(), keyEvent.getEventTime(), keyEvent.getAction(), 61, keyEvent.getRepeatCount(), keyEvent.getMetaState());
                    return super.sendKeyEvent(keyEvent2);
                }
                case 7: {
                    KeyEvent keyEvent3 = new KeyEvent(keyEvent.getDownTime(), keyEvent.getEventTime(), keyEvent.getAction(), 61, keyEvent.getRepeatCount(), 1);
                    return super.sendKeyEvent(keyEvent3);
                }
                case 0x40000000: {
                    this.restartImmInput();
                    break;
                }
                default: {
                    if (this.m_qtInputConnectionListener == null) break;
                    this.m_qtInputConnectionListener.onSendKeyEventDefaultCase();
                }
            }
        }
        return super.sendKeyEvent(keyEvent);
    }

    public boolean setComposingText(CharSequence charSequence, int n) {
        this.setClosing(false);
        return QtNativeInputConnection.setComposingText(charSequence.toString(), n);
    }

    @TargetApi(value=33)
    public boolean setComposingText(CharSequence charSequence, int n, TextAttribute textAttribute) {
        return this.setComposingText(charSequence, n);
    }

    @TargetApi(value=33)
    public boolean setComposingRegion(int n, int n2, TextAttribute textAttribute) {
        return this.setComposingRegion(n, n2);
    }

    @TargetApi(value=33)
    public boolean commitText(CharSequence charSequence, int n, TextAttribute textAttribute) {
        return this.commitText(charSequence, n);
    }

    @TargetApi(value=34)
    public boolean replaceText(int n, int n2, CharSequence charSequence, int n3, TextAttribute textAttribute) {
        this.setClosing(false);
        return QtNativeInputConnection.replaceText(n, n2, charSequence.toString(), n3);
    }

    public boolean setComposingRegion(int n, int n2) {
        this.setClosing(false);
        return QtNativeInputConnection.setComposingRegion(n, n2);
    }

    public boolean setSelection(int n, int n2) {
        this.setClosing(false);
        return QtNativeInputConnection.setSelection(n, n2);
    }

    static interface QtInputConnectionListener {
        public void onSetClosing(boolean var1);

        public void onHideKeyboardRunnableDone(boolean var1, long var2);

        public void onSendKeyEventDefaultCase();

        public void onEditTextChanged(QtEditText var1);

        public boolean keyboardTransitionInProgress();

        public boolean isKeyboardHidden();
    }

    class HideKeyboardRunnable
    implements Runnable {
        private int m_numberOfAttempts = 10;

        HideKeyboardRunnable() {
        }

        @Override
        public void run() {
            if (QtInputConnection.this.m_qtInputConnectionListener == null) {
                Log.w((String)QtInputConnection.QtTAG, (String)"HideKeyboardRunnable: QtInputConnectionListener is null");
                return;
            }
            if (QtInputConnection.this.m_qtInputConnectionListener.keyboardTransitionInProgress() && this.m_numberOfAttempts > 0) {
                --this.m_numberOfAttempts;
                QtInputConnection.this.m_view.postDelayed(this, 100L);
                return;
            }
            if (QtInputConnection.this.m_qtInputConnectionListener.isKeyboardHidden()) {
                QtInputConnection.this.m_qtInputConnectionListener.onHideKeyboardRunnableDone(false, System.nanoTime());
            }
        }
    }
}

