/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.system.Os;
import android.util.Log;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import org.qtproject.qt.android.QtNative;

abstract class QtLoader {
    protected static final String QtTAG = "QtLoader";
    private final Resources m_resources;
    private final String m_packageName;
    private String m_preferredAbi = null;
    private String m_nativeLibrariesDir = null;
    private ClassLoader m_classLoader;
    protected ComponentInfo m_contextInfo;
    protected String m_mainLibPath;
    protected String m_mainLibName;
    protected String m_applicationParameters = "";
    protected HashMap<String, String> m_environmentVariables = new HashMap();
    protected static QtLoader m_instance = null;
    protected boolean m_librariesLoaded;

    QtLoader(ContextWrapper contextWrapper) throws IllegalArgumentException {
        this.m_resources = contextWrapper.getResources();
        this.m_packageName = contextWrapper.getPackageName();
        Context context = contextWrapper.getBaseContext();
        if (!(context instanceof Activity) && !(context instanceof Service)) {
            throw new IllegalArgumentException("QtLoader: Context is not an instance of Activity or Service");
        }
        this.initClassLoader(context);
        this.initStaticClasses(context);
        try {
            this.initContextInfo(context);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new IllegalArgumentException("QtLoader: No ComponentInfo found for given Context", nameNotFoundException);
        }
    }

    protected void initContextInfo(Context context) throws PackageManager.NameNotFoundException {
        if (context instanceof Activity) {
            this.m_contextInfo = context.getPackageManager().getActivityInfo(((Activity)context).getComponentName(), 128);
        } else if (context instanceof Service) {
            this.m_contextInfo = context.getPackageManager().getServiceInfo(new ComponentName(context, context.getClass()), 128);
        }
    }

    protected void extractContextMetaData(Context context) {
        this.setEnvironmentVariable("QT_ANDROID_FONTS", "Roboto;Droid Sans;Droid Sans Fallback");
        String string2 = "Droid Sans Mono;Droid Sans;Droid Sans Fallback";
        this.setEnvironmentVariable("QT_ANDROID_FONTS_MONOSPACE", string2);
        this.setEnvironmentVariable("QT_ANDROID_FONTS_SERIF", "Droid Serif");
        this.setEnvironmentVariable("HOME", context.getFilesDir().getAbsolutePath());
        this.setEnvironmentVariable("TMPDIR", context.getCacheDir().getAbsolutePath());
        this.setEnvironmentVariable("QT_BLOCK_EVENT_LOOPS_WHEN_SUSPENDED", this.isBackgroundRunningBlocked());
        this.setEnvironmentVariable("QTRACE_LOCATION", this.getMetaData("android.app.trace_location"));
        this.appendApplicationParameters(this.getMetaData("android.app.arguments"));
    }

    private String isBackgroundRunningBlocked() {
        String string2 = this.getMetaData("android.app.background_running");
        if (string2.compareTo("true") == 0) {
            return "0";
        }
        return "1";
    }

    private ArrayList<String> preferredAbiLibs(String[] stringArray) {
        HashMap hashMap = new HashMap();
        for (String string2 : stringArray) {
            String[] stringArray2 = string2.split(";", 2);
            if (this.m_preferredAbi != null && !stringArray2[0].equals(this.m_preferredAbi)) continue;
            if (!hashMap.containsKey(stringArray2[0])) {
                hashMap.put(stringArray2[0], new ArrayList());
            }
            Objects.requireNonNull((ArrayList)hashMap.get(stringArray2[0])).add(stringArray2[1]);
        }
        if (this.m_preferredAbi != null) {
            if (hashMap.containsKey(this.m_preferredAbi)) {
                return (ArrayList)hashMap.get(this.m_preferredAbi);
            }
            return new ArrayList<String>();
        }
        for (String string2 : Build.SUPPORTED_ABIS) {
            if (!hashMap.containsKey(string2)) continue;
            this.m_preferredAbi = string2;
            return (ArrayList)hashMap.get(string2);
        }
        return new ArrayList<String>();
    }

    private void initStaticClasses(Context context) {
        boolean bl = context instanceof Activity;
        for (String string2 : this.getStaticInitClasses()) {
            try {
                Method method;
                Class<?> clazz = this.m_classLoader.loadClass(string2);
                Object obj = clazz.newInstance();
                if (bl) {
                    try {
                        method = clazz.getMethod("setActivity", Activity.class, Object.class);
                        method.invoke(obj, (Activity)context, this);
                    }
                    catch (NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                        Log.d((String)QtTAG, (String)("Class " + clazz.getName() + " does not implement setActivity method"));
                    }
                } else {
                    try {
                        method = clazz.getMethod("setService", Service.class, Object.class);
                        method.invoke(obj, (Service)context, this);
                    }
                    catch (NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                        Log.d((String)QtTAG, (String)("Class " + clazz.getName() + " does not implement setService method"));
                    }
                }
                try {
                    method = clazz.getMethod("setContext", Context.class);
                    method.invoke(obj, context);
                }
                catch (NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    Log.d((String)QtTAG, (String)("Class " + clazz.getName() + " does not implement setContext method"));
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                Log.d((String)QtTAG, (String)("Could not instantiate class " + string2 + ", " + reflectiveOperationException));
            }
        }
    }

    private void initClassLoader(Context context) {
        String string2 = context.getDir("outdex", 0).getAbsolutePath();
        String string3 = context.getApplicationInfo().sourceDir;
        this.m_classLoader = new DexClassLoader(string3, string2, null, context.getClassLoader());
        QtNative.setClassLoader(this.m_classLoader);
    }

    public String getMainLibraryPath() {
        return this.m_mainLibPath;
    }

    public void setMainLibraryName(String string2) {
        this.m_mainLibName = string2;
    }

    public String getApplicationParameters() {
        return this.m_applicationParameters;
    }

    public void appendApplicationParameters(String string2) {
        if (string2 == null || string2.isEmpty()) {
            return;
        }
        if (!this.m_applicationParameters.isEmpty()) {
            this.m_applicationParameters = this.m_applicationParameters + " ";
        }
        this.m_applicationParameters = this.m_applicationParameters + string2;
    }

    public void setEnvironmentVariable(String string2, String string3) {
        try {
            Os.setenv((String)string2, (String)string3, (boolean)true);
            this.m_environmentVariables.put(string2, string3);
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)("Could not set environment variable:" + string2 + "=" + string3));
            exception.printStackTrace();
        }
    }

    public void setEnvironmentVariables(String string2) {
        if (string2 == null || string2.isEmpty()) {
            return;
        }
        string2 = string2.replaceAll("\t", " ");
        for (String string3 : string2.split(" ")) {
            String[] stringArray = string3.split("=", 2);
            if (stringArray.length < 2 || stringArray[0].isEmpty()) continue;
            this.setEnvironmentVariable(stringArray[0], stringArray[1]);
        }
    }

    private void parseNativeLibrariesDir() {
        if (this.m_contextInfo == null) {
            return;
        }
        if (this.isBundleQtLibs()) {
            String string2 = this.m_contextInfo.applicationInfo.nativeLibraryDir + "/";
            File file = new File(string2);
            if (file.exists()) {
                String[] stringArray = file.list();
                if (file.isDirectory() && stringArray != null && stringArray.length > 0) {
                    this.m_nativeLibrariesDir = string2;
                }
            }
        } else {
            String string3 = this.getApplicationMetaData("android.app.system_libs_prefix");
            if (string3.isEmpty()) {
                string3 = this.getSystemLibsPrefix();
            }
            if (string3.isEmpty()) {
                string3 = "/system/lib/";
                Log.e((String)QtTAG, (String)"Using /system/lib/ as default libraries path. It looks like the app is deployed using Unbundled deployment. It may be necessary to specify the path to the directory where Qt libraries are installed using either android.app.system_libs_prefix metadata variable in your AndroidManifest.xml or QT_ANDROID_SYSTEM_LIBS_PATH in your CMakeLists.txt");
            }
            File file = new File(string3);
            String[] stringArray = file.list();
            if (file.exists()) {
                if (file.isDirectory() && stringArray != null && stringArray.length > 0) {
                    this.m_nativeLibrariesDir = string3;
                } else {
                    Log.e((String)QtTAG, (String)("System library directory " + string3 + " is empty."));
                }
            } else {
                Log.e((String)QtTAG, (String)("System library directory " + string3 + " does not exist."));
            }
        }
        if (this.m_nativeLibrariesDir != null && !this.m_nativeLibrariesDir.endsWith("/")) {
            this.m_nativeLibrariesDir = this.m_nativeLibrariesDir + "/";
        }
    }

    private String getApplicationMetaData(String string2) {
        ApplicationInfo applicationInfo = this.m_contextInfo.applicationInfo;
        if (applicationInfo == null) {
            return "";
        }
        Bundle bundle = applicationInfo.metaData;
        if (bundle == null || !bundle.containsKey(string2)) {
            return "";
        }
        return bundle.getString(string2);
    }

    protected String getMetaData(String string2) {
        if (this.m_contextInfo == null) {
            return "";
        }
        Bundle bundle = this.m_contextInfo.metaData;
        if (bundle == null || !bundle.containsKey(string2)) {
            return "";
        }
        return String.valueOf(bundle.get(string2));
    }

    @SuppressLint(value={"DiscouragedApi"})
    private ArrayList<String> getQtLibrariesList() {
        int n = this.m_resources.getIdentifier("qt_libs", "array", this.m_packageName);
        return this.preferredAbiLibs(this.m_resources.getStringArray(n));
    }

    @SuppressLint(value={"DiscouragedApi"})
    private boolean useLocalQtLibs() {
        int n = this.m_resources.getIdentifier("use_local_qt_libs", "string", this.m_packageName);
        return Integer.parseInt(this.m_resources.getString(n)) == 1;
    }

    @SuppressLint(value={"DiscouragedApi"})
    private boolean isBundleQtLibs() {
        int n = this.m_resources.getIdentifier("bundle_local_qt_libs", "string", this.m_packageName);
        return Integer.parseInt(this.m_resources.getString(n)) == 1;
    }

    @SuppressLint(value={"DiscouragedApi"})
    private String getSystemLibsPrefix() {
        int n = this.m_resources.getIdentifier("system_libs_prefix", "string", this.m_packageName);
        return this.m_resources.getString(n);
    }

    @SuppressLint(value={"DiscouragedApi"})
    private ArrayList<String> getLocalLibrariesList() {
        int n = this.m_resources.getIdentifier("load_local_libs", "array", this.m_packageName);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.preferredAbiLibs(this.m_resources.getStringArray(n))) {
            Collections.addAll(arrayList, string2.split(":"));
        }
        return arrayList;
    }

    @SuppressLint(value={"DiscouragedApi"})
    private ArrayList<String> getStaticInitClasses() {
        int n = this.m_resources.getIdentifier("static_init_classes", "string", this.m_packageName);
        String[] stringArray = this.m_resources.getString(n).split(":");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            if (string2.isEmpty()) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    @SuppressLint(value={"DiscouragedApi"})
    private String[] getBundledLibs() {
        int n = this.m_resources.getIdentifier("bundled_libs", "array", this.m_packageName);
        return this.m_resources.getStringArray(n);
    }

    public LoadingResult loadQtLibraries() {
        if (this.m_librariesLoaded) {
            return LoadingResult.AlreadyLoaded;
        }
        if (!this.useLocalQtLibs()) {
            Log.w((String)QtTAG, (String)"Use local Qt libs is false");
            return LoadingResult.Failed;
        }
        if (this.m_nativeLibrariesDir == null) {
            this.parseNativeLibrariesDir();
        }
        if (this.m_nativeLibrariesDir == null || this.m_nativeLibrariesDir.isEmpty()) {
            Log.e((String)QtTAG, (String)"The native libraries directory is null or empty");
            return LoadingResult.Failed;
        }
        this.setEnvironmentVariable("QT_PLUGIN_PATH", this.m_nativeLibrariesDir);
        this.setEnvironmentVariable("QML_PLUGIN_PATH", this.m_nativeLibrariesDir);
        ArrayList<String> arrayList = this.getQtLibrariesList();
        arrayList.addAll(this.getLocalLibrariesList());
        if (Debug.isDebuggerConnected()) {
            int n = 3000;
            if (Os.getenv((String)"QT_ANDROID_DEBUGGER_MAIN_THREAD_SLEEP_MS") != null) {
                try {
                    n = Integer.parseInt(Os.getenv((String)"QT_ANDROID_DEBUGGER_MAIN_THREAD_SLEEP_MS"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n > 0) {
                Log.i((String)QtTAG, (String)("Sleeping for " + n + "ms, helping the native debugger to settle. Use the env " + "QT_ANDROID_DEBUGGER_MAIN_THREAD_SLEEP_MS" + " variable to change this value."));
                QtNative.getQtThread().sleep(n);
            }
        }
        if (!this.loadLibraries(arrayList)) {
            Log.e((String)QtTAG, (String)"Loading Qt native libraries failed");
            return LoadingResult.Failed;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(this.preferredAbiLibs(this.getBundledLibs()));
        if (!this.loadLibraries(arrayList2)) {
            Log.e((String)QtTAG, (String)"Loading Qt bundled libraries failed");
            return LoadingResult.Failed;
        }
        if (this.m_mainLibName == null) {
            this.m_mainLibName = this.getMetaData("android.app.lib_name");
        }
        if (!this.loadMainLibrary(this.m_mainLibName + "_" + this.m_preferredAbi)) {
            Log.e((String)QtTAG, (String)"Loading main library failed");
            return LoadingResult.Failed;
        }
        this.m_librariesLoaded = true;
        return LoadingResult.Succeeded;
    }

    @SuppressLint(value={"UnsafeDynamicallyLoadedCode"})
    private String loadLibraryHelper(String string2) {
        String string3 = null;
        try {
            File file = new File(string2);
            if (file.exists()) {
                System.load(string2);
                string3 = string2;
            } else {
                Log.e((String)QtTAG, (String)("Can't find '" + string2 + "'"));
            }
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)("Can't load '" + string2 + "'"), (Throwable)exception);
        }
        return string3;
    }

    private ArrayList<String> getLibrariesFullPaths(ArrayList<String> arrayList) {
        if (arrayList == null) {
            return null;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string2 : arrayList) {
            if (!string2.endsWith(".so")) {
                string2 = string2 + ".so";
                string2 = "lib" + string2;
            }
            File file = new File(this.m_nativeLibrariesDir + string2);
            arrayList2.add(file.getAbsolutePath());
        }
        return arrayList2;
    }

    private boolean loadMainLibrary(String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(Collections.singletonList(string2));
        String string3 = this.getLibrariesFullPaths(arrayList).get(0);
        boolean[] blArray = new boolean[]{true};
        QtNative.getQtThread().run(() -> {
            this.m_mainLibPath = this.loadLibraryHelper(string3);
            if (this.m_mainLibPath == null) {
                blArray[0] = false;
            }
        });
        return blArray[0];
    }

    private boolean loadLibraries(ArrayList<String> arrayList) {
        if (arrayList == null) {
            return false;
        }
        ArrayList<String> arrayList2 = this.getLibrariesFullPaths(arrayList);
        boolean[] blArray = new boolean[]{true};
        QtNative.getQtThread().run(() -> {
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string2 = (String)arrayList2.get(i);
                if (this.loadLibraryHelper(string2) != null) continue;
                blArray[0] = false;
                break;
            }
        });
        return blArray[0];
    }

    static enum LoadingResult {
        Succeeded,
        AlreadyLoaded,
        Failed;

    }
}

