/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.text.Spanned;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import java.util.ArrayList;
import org.qtproject.qt.android.ButtonStruct;
import org.qtproject.qt.android.QtNativeDialogHelper;
import org.qtproject.qt.android.UsedFromNativeCode;

class QtMessageDialogHelper {
    private static final String QtTAG = "QtMessageDialogHelper";
    private final Activity m_activity;
    private int m_standardIcon = 0;
    private Spanned m_title;
    private Spanned m_text;
    private Spanned m_informativeText;
    private Spanned m_detailedText;
    private ArrayList<ButtonStruct> m_buttonsList;
    private AlertDialog m_dialog;
    private long m_handler = 0L;
    private Resources.Theme m_theme;

    QtMessageDialogHelper(Activity activity) {
        this.m_activity = activity;
    }

    @UsedFromNativeCode
    void setStandardIcon(int n) {
        this.m_standardIcon = n;
    }

    private Drawable getIconDrawable() {
        if (this.m_standardIcon == 0) {
            return null;
        }
        switch (this.m_standardIcon) {
            case 1: {
                return this.m_activity.getResources().getDrawable(17301659, this.m_activity.getTheme());
            }
            case 2: {
                return this.m_activity.getResources().getDrawable(17301642, this.m_activity.getTheme());
            }
            case 3: {
                return this.m_activity.getResources().getDrawable(17301543, this.m_activity.getTheme());
            }
            case 4: {
                return this.m_activity.getResources().getDrawable(17301568, this.m_activity.getTheme());
            }
        }
        return null;
    }

    @UsedFromNativeCode
    void setTile(String string2) {
        this.m_title = Html.fromHtml((String)string2);
    }

    @UsedFromNativeCode
    void setText(String string2) {
        this.m_text = Html.fromHtml((String)string2);
    }

    @UsedFromNativeCode
    void setInformativeText(String string2) {
        this.m_informativeText = Html.fromHtml((String)string2);
    }

    @UsedFromNativeCode
    void setDetailedText(String string2) {
        this.m_detailedText = Html.fromHtml((String)string2);
    }

    @UsedFromNativeCode
    void addButton(int n, String string2) {
        if (this.m_buttonsList == null) {
            this.m_buttonsList = new ArrayList();
        }
        this.m_buttonsList.add(new ButtonStruct(this, n, string2));
    }

    private Drawable getStyledDrawable(int n) {
        int[] nArray = new int[]{n};
        TypedArray typedArray = this.m_theme.obtainStyledAttributes(nArray);
        Drawable drawable2 = typedArray.getDrawable(0);
        typedArray.recycle();
        return drawable2;
    }

    @UsedFromNativeCode
    void show(long l) {
        this.m_handler = l;
        this.m_activity.runOnUiThread(() -> {
            RelativeLayout.LayoutParams layoutParams;
            TextView textView;
            if (this.m_dialog != null && this.m_dialog.isShowing()) {
                this.m_dialog.dismiss();
            }
            this.m_dialog = new AlertDialog.Builder((Context)this.m_activity).create();
            Window window = this.m_dialog.getWindow();
            if (window != null) {
                this.m_theme = window.getContext().getTheme();
            } else {
                Log.w((String)QtTAG, (String)"show(): cannot set theme from null window!");
            }
            if (this.m_title != null) {
                this.m_dialog.setTitle((CharSequence)this.m_title);
            }
            this.m_dialog.setOnCancelListener(dialogInterface -> QtNativeDialogHelper.dialogResult(this.handler(), -1));
            this.m_dialog.setCancelable(this.m_buttonsList == null);
            this.m_dialog.setCanceledOnTouchOutside(this.m_buttonsList == null);
            this.m_dialog.setIcon(this.getIconDrawable());
            ScrollView scrollView = new ScrollView((Context)this.m_activity);
            RelativeLayout relativeLayout = new RelativeLayout((Context)this.m_activity);
            int n = 1;
            TextView textView2 = null;
            View.OnLongClickListener onLongClickListener = view -> {
                TextView textView = (TextView)view;
                if (textView != null) {
                    ClipboardManager clipboardManager = (ClipboardManager)this.m_activity.getSystemService("clipboard");
                    clipboardManager.setPrimaryClip(ClipData.newPlainText((CharSequence)textView.getText(), (CharSequence)textView.getText()));
                }
                return true;
            };
            if (this.m_text != null) {
                textView = new TextView((Context)this.m_activity);
                textView.setId(n++);
                textView.setOnLongClickListener(onLongClickListener);
                textView.setLongClickable(true);
                textView.setText((CharSequence)this.m_text);
                textView.setTextAppearance(16973892);
                layoutParams = new RelativeLayout.LayoutParams(-1, -2);
                layoutParams.setMargins(16, 8, 16, 8);
                layoutParams.addRule(10);
                relativeLayout.addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
                textView2 = textView;
            }
            if (this.m_informativeText != null) {
                textView = new TextView((Context)this.m_activity);
                textView.setId(n++);
                textView.setOnLongClickListener(onLongClickListener);
                textView.setLongClickable(true);
                textView.setText((CharSequence)this.m_informativeText);
                textView.setTextAppearance(16973892);
                layoutParams = new RelativeLayout.LayoutParams(-1, -2);
                layoutParams.setMargins(16, 8, 16, 8);
                if (textView2 != null) {
                    layoutParams.addRule(3, textView2.getId());
                } else {
                    layoutParams.addRule(10);
                }
                relativeLayout.addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
                textView2 = textView;
            }
            if (this.m_detailedText != null) {
                textView = new TextView((Context)this.m_activity);
                textView.setId(n++);
                textView.setOnLongClickListener(onLongClickListener);
                textView.setLongClickable(true);
                textView.setText((CharSequence)this.m_detailedText);
                textView.setTextAppearance(16973894);
                layoutParams = new RelativeLayout.LayoutParams(-1, -2);
                layoutParams.setMargins(16, 8, 16, 8);
                if (textView2 != null) {
                    layoutParams.addRule(3, textView2.getId());
                } else {
                    layoutParams.addRule(10);
                }
                relativeLayout.addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
                textView2 = textView;
            }
            if (this.m_buttonsList != null) {
                View view2;
                textView = new LinearLayout((Context)this.m_activity);
                textView.setOrientation(0);
                textView.setId(n++);
                boolean bl = true;
                for (ButtonStruct buttonStruct : this.m_buttonsList) {
                    View view3;
                    Button button;
                    try {
                        button = new Button((Context)this.m_activity, null, 16843563);
                    }
                    catch (Exception exception) {
                        button = new Button((Context)this.m_activity);
                        exception.printStackTrace();
                    }
                    button.setText((CharSequence)buttonStruct.m_text);
                    button.setOnClickListener((View.OnClickListener)buttonStruct);
                    if (!bl) {
                        view3 = new View((Context)this.m_activity);
                        try {
                            LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(1, -1);
                            view3.setBackground(this.getStyledDrawable(16843530));
                            textView.addView(view3, (ViewGroup.LayoutParams)layoutParams2);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    view3 = new LinearLayout.LayoutParams(-1, -2, 1.0f);
                    textView.addView((View)button, (ViewGroup.LayoutParams)view3);
                    bl = false;
                }
                try {
                    ButtonStruct buttonStruct;
                    view2 = new View((Context)this.m_activity);
                    view2.setId(n);
                    view2.setBackground(this.getStyledDrawable(16843564));
                    buttonStruct = new RelativeLayout.LayoutParams(-1, 1);
                    buttonStruct.setMargins(0, 10, 0, 0);
                    if (textView2 != null) {
                        buttonStruct.addRule(3, textView2.getId());
                    } else {
                        buttonStruct.addRule(10);
                    }
                    relativeLayout.addView(view2, (ViewGroup.LayoutParams)buttonStruct);
                    textView2 = view2;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                view2 = new RelativeLayout.LayoutParams(-1, -2);
                if (textView2 != null) {
                    view2.addRule(3, textView2.getId());
                } else {
                    view2.addRule(10);
                }
                view2.setMargins(2, 0, 2, 0);
                relativeLayout.addView((View)textView, (ViewGroup.LayoutParams)view2);
            }
            scrollView.addView((View)relativeLayout);
            this.m_dialog.setView((View)scrollView);
            this.m_dialog.show();
        });
    }

    @UsedFromNativeCode
    void hide() {
        this.m_activity.runOnUiThread(() -> {
            if (this.m_dialog != null && this.m_dialog.isShowing()) {
                this.m_dialog.dismiss();
            }
            this.reset();
        });
    }

    long handler() {
        return this.m_handler;
    }

    void reset() {
        this.m_standardIcon = 0;
        this.m_title = null;
        this.m_text = null;
        this.m_informativeText = null;
        this.m_detailedText = null;
        this.m_buttonsList = null;
        this.m_dialog = null;
        this.m_handler = 0L;
    }
}

