/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.bluetooth;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;

class QtBluetoothBroadcastReceiver
extends BroadcastReceiver {
    long qtObject = 0L;
    static Context qtContext = null;
    private static final int TURN_BT_ENABLED = 3330;
    private static final int TURN_BT_DISCOVERABLE = 3331;
    private static final int TURN_BT_DISABLED = 3332;
    static final String ACTION_REQUEST_DISABLE = "android.bluetooth.adapter.action.REQUEST_DISABLE";
    private static final String TAG = "QtBluetoothBroadcastReceiver";

    QtBluetoothBroadcastReceiver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Context context, Intent intent) {
        Context context2 = qtContext;
        synchronized (context2) {
            if (this.qtObject == 0L) {
                return;
            }
            this.jniOnReceive(this.qtObject, context, intent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterReceiver() {
        Context context = qtContext;
        synchronized (context) {
            this.qtObject = 0L;
            try {
                qtContext.unregisterReceiver((BroadcastReceiver)this);
            }
            catch (Exception exception) {
                Log.d((String)TAG, (String)"Trying to unregister a BroadcastReceiver which is not yet registered");
            }
        }
    }

    native void jniOnReceive(long var1, Context var3, Intent var4);

    static void setContext(Context context) {
        qtContext = context;
    }

    static boolean setDisabled() {
        if (!(qtContext instanceof Activity)) {
            Log.w((String)TAG, (String)"Bluetooth cannot be disabled from a service.");
            return false;
        }
        Intent intent = new Intent(ACTION_REQUEST_DISABLE);
        try {
            ((Activity)qtContext).startActivityForResult(intent, 3332);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"setDisabled() failed to initiate Bluetooth disablement");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    static boolean setDiscoverable() {
        if (!(qtContext instanceof Activity)) {
            Log.w((String)TAG, (String)"Discovery mode cannot be enabled from a service.");
            return false;
        }
        Intent intent = new Intent("android.bluetooth.adapter.action.REQUEST_DISCOVERABLE");
        intent.putExtra("android.bluetooth.adapter.extra.DISCOVERABLE_DURATION", 300);
        try {
            ((Activity)qtContext).startActivityForResult(intent, 3331);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"setDiscoverable() failed to initiate Bluetooth discoverability change");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    static boolean setEnabled() {
        if (!(qtContext instanceof Activity)) {
            Log.w((String)TAG, (String)"Bluetooth cannot be enabled from a service.");
            return false;
        }
        Intent intent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
        try {
            ((Activity)qtContext).startActivityForResult(intent, 3330);
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"setEnabled() failed to initiate Bluetooth enablement");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    static boolean setPairingMode(String string, boolean bl) {
        BluetoothManager bluetoothManager = (BluetoothManager)qtContext.getSystemService("bluetooth");
        if (bluetoothManager == null) {
            return false;
        }
        BluetoothAdapter bluetoothAdapter = bluetoothManager.getAdapter();
        if (bluetoothAdapter == null) {
            return false;
        }
        try {
            BluetoothDevice bluetoothDevice = bluetoothAdapter.getRemoteDevice(string);
            String string2 = "createBond";
            if (!bl) {
                string2 = "removeBond";
            }
            Method method = bluetoothDevice.getClass().getMethod(string2, null);
            method.invoke((Object)bluetoothDevice, (Object[])null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    static String[] getConnectedDevices() {
        BluetoothManager bluetoothManager = (BluetoothManager)qtContext.getSystemService("bluetooth");
        if (bluetoothManager == null) {
            Log.w((String)TAG, (String)"Failed to retrieve connected devices");
            return new String[0];
        }
        List list = bluetoothManager.getConnectedDevices(7);
        List list2 = bluetoothManager.getConnectedDevices(8);
        HashSet<String> hashSet = new HashSet<String>();
        for (Object e : list) {
            hashSet.add(e.toString());
        }
        for (Object e : list2) {
            hashSet.add(e.toString());
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }
}

