/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.qtproject.qt.android.QtNative;
import org.qtproject.qt.android.UsedFromNativeCode;

@UsedFromNativeCode
class QtApkFileEngine {
    private static final String QtTAG = QtApkFileEngine.class.getSimpleName();
    private static String m_appApkPath;
    private AssetFileDescriptor m_assetFd;
    private final AssetManager m_assetManager;
    private FileInputStream m_assetInputStream;
    private long m_pos = -1L;

    QtApkFileEngine(Context context) {
        this.m_assetManager = context.getAssets();
    }

    boolean open(String string2) {
        try {
            this.m_assetFd = this.m_assetManager.openNonAssetFd(string2);
            this.m_assetInputStream = this.m_assetFd.createInputStream();
        }
        catch (IOException iOException) {
            Log.e((String)QtTAG, (String)("Failed to open the app APK with " + iOException));
        }
        return this.m_assetInputStream != null;
    }

    boolean close() {
        try {
            if (this.m_assetInputStream != null) {
                this.m_assetInputStream.close();
            }
            if (this.m_assetFd != null) {
                this.m_assetFd.close();
            }
        }
        catch (IOException iOException) {
            Log.e((String)QtTAG, (String)("Failed to close resources with " + iOException));
        }
        return this.m_assetInputStream == null && this.m_assetFd == null;
    }

    long pos() {
        return this.m_pos;
    }

    boolean seek(int n) {
        if (this.m_assetInputStream != null && this.m_assetInputStream.markSupported()) {
            try {
                this.m_assetInputStream.mark(n);
                this.m_assetInputStream.reset();
                this.m_pos = n;
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    MappedByteBuffer getMappedByteBuffer(long l, long l2) {
        try {
            FileChannel fileChannel = this.m_assetInputStream.getChannel();
            long l3 = fileChannel.position() + l;
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, l3, l2);
            mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            fileChannel.close();
            return mappedByteBuffer;
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)("Failed to map APK file to memory with " + exception));
            return null;
        }
    }

    byte[] read(long l) {
        if (this.m_assetInputStream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        byte[] byArray = new byte[1024];
        try {
            int n2;
            int n3;
            int n4;
            while ((long)n < l && (n4 = this.m_assetInputStream.read(byArray, 0, n3 = Math.min(byArray.length, n2 = (int)l - n))) != -1) {
                byteArrayOutputStream.write(byArray, 0, n4);
                n += n4;
            }
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            Log.e((String)QtTAG, (String)("Failed to read content with " + iOException));
        }
        return byteArrayOutputStream.toByteArray();
    }

    static String getAppApkFilePath() {
        if (m_appApkPath != null) {
            return m_appApkPath;
        }
        try {
            Context context = QtNative.getContext();
            PackageManager packageManager = context.getPackageManager();
            m_appApkPath = packageManager.getApplicationInfo((String)context.getPackageName(), (int)0).sourceDir;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)QtTAG, (String)("Failed to get the app APK path with " + (Object)((Object)nameNotFoundException)));
            return null;
        }
        return m_appApkPath;
    }

    static ArrayList<JFileInfo> getApkFileInfos(String string2) {
        ArrayList<JFileInfo> arrayList = new ArrayList<JFileInfo>();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        try (ZipFile zipFile = new ZipFile(string2);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string3 = zipEntry.getName();
                if (!string3.startsWith("lib/")) continue;
                JFileInfo jFileInfo2 = new JFileInfo();
                jFileInfo2.relativePath = string3;
                jFileInfo2.isDir = zipEntry.isDirectory();
                jFileInfo2.size = zipEntry.getSize();
                arrayList.add(jFileInfo2);
                hashSet.add(string3.substring(0, string3.lastIndexOf("/") + 1));
            }
            for (String string3 : hashSet) {
                int n = 0;
                while ((n = string3.indexOf("/", n + 1)) != -1) {
                    String string4 = string3.substring(0, n);
                    hashSet2.add(string4);
                }
            }
            for (String string3 : hashSet2) {
                JFileInfo jFileInfo3 = new JFileInfo();
                jFileInfo3.relativePath = string3;
                jFileInfo3.isDir = true;
                jFileInfo3.size = -1L;
                arrayList.add(jFileInfo3);
            }
            arrayList.sort(Comparator.comparing(jFileInfo -> jFileInfo.relativePath));
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)("Failed to list App's APK files with " + exception));
        }
        return arrayList;
    }

    static class JFileInfo {
        String relativePath;
        boolean isDir;
        long size;

        JFileInfo() {
        }
    }
}

