/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.util.Log;
import java.util.Objects;
import org.qtproject.qt.android.QtLoader;
import org.qtproject.qt.android.QtNative;
import org.qtproject.qt.android.QtServiceLoader;

public class QtServiceBase
extends Service {
    public void onCreate() {
        super.onCreate();
        if (QtNative.getStateDetails().isStarted) {
            Log.w((String)"Qt JAVA", (String)"A QtService tried to start in the same process as an initiated QtActivity. That is not supported. This results in the service functioning as an Android Service detached from Qt.");
            return;
        }
        QtNative.setService(this);
        try {
            QtServiceLoader qtServiceLoader = QtServiceLoader.getServiceLoader(this);
            QtLoader.LoadingResult loadingResult = qtServiceLoader.loadQtLibraries();
            if (loadingResult == QtLoader.LoadingResult.Succeeded) {
                QtNative.startApplication(qtServiceLoader.getApplicationParameters(), qtServiceLoader.getMainLibraryPath());
                QtNative.setApplicationState(1);
            } else if (loadingResult == QtLoader.LoadingResult.Failed) {
                Log.w((String)"Qt JAVA", (String)"QtServiceLoader: failed to load Qt libraries");
                this.stopSelf();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.w((String)"Qt JAVA", (String)Objects.requireNonNull(illegalArgumentException.getMessage()));
            this.stopSelf();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        QtNative.quitQtCoreApplication();
        QtNative.terminateQt();
        QtNative.setService(null);
        QtNative.getQtThread().exit();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBinder onBind(Intent intent) {
        QtServiceBase qtServiceBase = this;
        synchronized (qtServiceBase) {
            return QtNative.onBind(intent);
        }
    }
}

