/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.app.Service;
import android.content.Context;
import android.content.res.Resources;
import android.hardware.display.DisplayManager;
import android.util.DisplayMetrics;
import android.view.View;
import java.util.HashSet;
import org.qtproject.qt.android.QtDisplayManager;
import org.qtproject.qt.android.QtEmbeddedViewInterface;
import org.qtproject.qt.android.QtEmbeddedViewInterfaceFactory;
import org.qtproject.qt.android.QtNative;
import org.qtproject.qt.android.QtView;

class QtServiceEmbeddedDelegate
implements QtEmbeddedViewInterface,
QtNative.AppStateDetailsListener {
    private final Service m_service;
    private final HashSet<QtView> m_views = new HashSet();

    QtServiceEmbeddedDelegate(Service service) {
        this.m_service = service;
        QtNative.registerAppStateListener(this);
        QtNative.setService(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNativePluginIntegrationReadyChanged(boolean bl) {
        QtServiceEmbeddedDelegate qtServiceEmbeddedDelegate = this;
        synchronized (qtServiceEmbeddedDelegate) {
            if (bl) {
                QtNative.runAction(() -> {
                    DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
                    int n = displayMetrics.widthPixels;
                    int n2 = displayMetrics.heightPixels;
                    boolean bl = false;
                    boolean bl2 = false;
                    DisplayManager displayManager = (DisplayManager)this.m_service.getSystemService(DisplayManager.class);
                    QtDisplayManager.setDisplayMetrics(n, n2, 0, 0, n, n2, QtDisplayManager.getXDpi(displayMetrics), QtDisplayManager.getYDpi(displayMetrics), displayMetrics.scaledDensity, displayMetrics.density, QtDisplayManager.getRefreshRate(displayManager.getDisplay(0)));
                });
            }
        }
    }

    @Override
    public void startQtApplication(String string2, String string3) {
        QtNative.startApplication(string2, string3);
    }

    @Override
    public void addView(QtView qtView) {
        if (this.m_views.add(qtView)) {
            QtNative.runAction(() -> this.createRootWindow(qtView));
        }
    }

    @Override
    public void removeView(QtView qtView) {
        this.m_views.remove((Object)qtView);
        if (this.m_views.isEmpty()) {
            this.cleanup();
        }
    }

    private void createRootWindow(QtView qtView) {
        if (this.m_views.contains((Object)qtView)) {
            QtView.createRootWindow((View)qtView, qtView.getLeft(), qtView.getTop(), qtView.getWidth(), qtView.getHeight());
        }
    }

    private void cleanup() {
        QtNative.setApplicationState(0);
        QtNative.unregisterAppStateListener(this);
        QtEmbeddedViewInterfaceFactory.remove((Context)this.m_service);
        QtNative.terminateQt();
        QtNative.setService(null);
        QtNative.getQtThread().exit();
    }
}

