# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
from __future__ import annotations
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".

# mypy: disable-error-code="override, overload-overlap"
"""

# Module `PySide6.QtWidgets`

import PySide6.QtWidgets
import PySide6.QtCore
import PySide6.QtGui

import os
import enum
import typing
import collections
from PySide6.QtCore import Signal, SignalInstance
from shiboken6 import Shiboken


class QAbstractButton(PySide6.QtWidgets.QWidget):

    clicked                  : typing.ClassVar[Signal] = ... # clicked(); clicked(bool)
    pressed                  : typing.ClassVar[Signal] = ... # pressed()
    released                 : typing.ClassVar[Signal] = ... # released()
    toggled                  : typing.ClassVar[Signal] = ... # toggled(bool)

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, text: str | None = ..., icon: PySide6.QtGui.QIcon | None = ..., iconSize: PySide6.QtCore.QSize | None = ..., shortcut: PySide6.QtGui.QKeySequence | None = ..., checkable: bool | None = ..., checked: bool | None = ..., autoRepeat: bool | None = ..., autoExclusive: bool | None = ..., autoRepeatDelay: int | None = ..., autoRepeatInterval: int | None = ..., down: bool | None = ...) -> None: ...

    def animateClick(self, /) -> None: ...
    def autoExclusive(self, /) -> bool: ...
    def autoRepeat(self, /) -> bool: ...
    def autoRepeatDelay(self, /) -> int: ...
    def autoRepeatInterval(self, /) -> int: ...
    def changeEvent(self, e: PySide6.QtCore.QEvent, /) -> None: ...
    def checkStateSet(self, /) -> None: ...
    def click(self, /) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def focusInEvent(self, e: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusOutEvent(self, e: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def group(self, /) -> PySide6.QtWidgets.QButtonGroup: ...
    def hitButton(self, pos: PySide6.QtCore.QPoint, /) -> bool: ...
    def icon(self, /) -> PySide6.QtGui.QIcon: ...
    def iconSize(self, /) -> PySide6.QtCore.QSize: ...
    def isCheckable(self, /) -> bool: ...
    def isChecked(self, /) -> bool: ...
    def isDown(self, /) -> bool: ...
    def keyPressEvent(self, e: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def keyReleaseEvent(self, e: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def mouseMoveEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def nextCheckState(self, /) -> None: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def setAutoExclusive(self, arg__1: bool, /) -> None: ...
    def setAutoRepeat(self, arg__1: bool, /) -> None: ...
    def setAutoRepeatDelay(self, arg__1: int, /) -> None: ...
    def setAutoRepeatInterval(self, arg__1: int, /) -> None: ...
    def setCheckable(self, arg__1: bool, /) -> None: ...
    def setChecked(self, arg__1: bool, /) -> None: ...
    def setDown(self, arg__1: bool, /) -> None: ...
    def setIcon(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, /) -> None: ...
    def setIconSize(self, size: PySide6.QtCore.QSize, /) -> None: ...
    @typing.overload
    def setShortcut(self, key: PySide6.QtCore.Qt.Key, /) -> None: ...
    @typing.overload
    def setShortcut(self, key: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, /) -> None: ...
    def setText(self, text: str, /) -> None: ...
    def shortcut(self, /) -> PySide6.QtGui.QKeySequence: ...
    def text(self, /) -> str: ...
    def timerEvent(self, e: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def toggle(self, /) -> None: ...


class QAbstractGraphicsShapeItem(PySide6.QtWidgets.QGraphicsItem):

    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...

    def brush(self, /) -> PySide6.QtGui.QBrush: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> bool: ...
    def opaqueArea(self, /) -> PySide6.QtGui.QPainterPath: ...
    def pen(self, /) -> PySide6.QtGui.QPen: ...
    def setBrush(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, /) -> None: ...
    def setPen(self, pen: PySide6.QtGui.QPen | PySide6.QtCore.Qt.PenStyle | PySide6.QtGui.QColor, /) -> None: ...


class QAbstractItemDelegate(PySide6.QtCore.QObject):

    closeEditor              : typing.ClassVar[Signal] = ... # closeEditor(QWidget*,QAbstractItemDelegate::EndEditHint); closeEditor(QWidget*)
    commitData               : typing.ClassVar[Signal] = ... # commitData(QWidget*)
    sizeHintChanged          : typing.ClassVar[Signal] = ... # sizeHintChanged(QModelIndex)

    class EndEditHint(enum.Enum):

        NoHint                    = ...  # 0x0
        EditNextItem              = ...  # 0x1
        EditPreviousItem          = ...  # 0x2
        SubmitModelCache          = ...  # 0x3
        RevertModelCache          = ...  # 0x4


    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def createEditor(self, parent: PySide6.QtWidgets.QWidget, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtWidgets.QWidget: ...
    def destroyEditor(self, editor: PySide6.QtWidgets.QWidget, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def editorEvent(self, event: PySide6.QtCore.QEvent, model: PySide6.QtCore.QAbstractItemModel, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def helpEvent(self, event: PySide6.QtGui.QHelpEvent, view: PySide6.QtWidgets.QAbstractItemView, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def paintingRoles(self, /) -> typing.List[int]: ...
    def setEditorData(self, editor: PySide6.QtWidgets.QWidget, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def setModelData(self, editor: PySide6.QtWidgets.QWidget, model: PySide6.QtCore.QAbstractItemModel, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def sizeHint(self, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QSize: ...
    def updateEditorGeometry(self, editor: PySide6.QtWidgets.QWidget, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...


class QAbstractItemView(PySide6.QtWidgets.QAbstractScrollArea):

    activated                : typing.ClassVar[Signal] = ... # activated(QModelIndex)
    clicked                  : typing.ClassVar[Signal] = ... # clicked(QModelIndex)
    doubleClicked            : typing.ClassVar[Signal] = ... # doubleClicked(QModelIndex)
    entered                  : typing.ClassVar[Signal] = ... # entered(QModelIndex)
    iconSizeChanged          : typing.ClassVar[Signal] = ... # iconSizeChanged(QSize)
    pressed                  : typing.ClassVar[Signal] = ... # pressed(QModelIndex)
    viewportEntered          : typing.ClassVar[Signal] = ... # viewportEntered()

    class CursorAction(enum.Enum):

        MoveUp                    = ...  # 0x0
        MoveDown                  = ...  # 0x1
        MoveLeft                  = ...  # 0x2
        MoveRight                 = ...  # 0x3
        MoveHome                  = ...  # 0x4
        MoveEnd                   = ...  # 0x5
        MovePageUp                = ...  # 0x6
        MovePageDown              = ...  # 0x7
        MoveNext                  = ...  # 0x8
        MovePrevious              = ...  # 0x9

    class DragDropMode(enum.Enum):

        NoDragDrop                = ...  # 0x0
        DragOnly                  = ...  # 0x1
        DropOnly                  = ...  # 0x2
        DragDrop                  = ...  # 0x3
        InternalMove              = ...  # 0x4

    class DropIndicatorPosition(enum.Enum):

        OnItem                    = ...  # 0x0
        AboveItem                 = ...  # 0x1
        BelowItem                 = ...  # 0x2
        OnViewport                = ...  # 0x3

    class EditTrigger(enum.Flag):

        NoEditTriggers            = ...  # 0x0
        CurrentChanged            = ...  # 0x1
        DoubleClicked             = ...  # 0x2
        SelectedClicked           = ...  # 0x4
        EditKeyPressed            = ...  # 0x8
        AnyKeyPressed             = ...  # 0x10
        AllEditTriggers           = ...  # 0x1f

    class ScrollHint(enum.Enum):

        EnsureVisible             = ...  # 0x0
        PositionAtTop             = ...  # 0x1
        PositionAtBottom          = ...  # 0x2
        PositionAtCenter          = ...  # 0x3

    class ScrollMode(enum.Enum):

        ScrollPerItem             = ...  # 0x0
        ScrollPerPixel            = ...  # 0x1

    class SelectionBehavior(enum.Enum):

        SelectItems               = ...  # 0x0
        SelectRows                = ...  # 0x1
        SelectColumns             = ...  # 0x2

    class SelectionMode(enum.Enum):

        NoSelection               = ...  # 0x0
        SingleSelection           = ...  # 0x1
        MultiSelection            = ...  # 0x2
        ExtendedSelection         = ...  # 0x3
        ContiguousSelection       = ...  # 0x4

    class State(enum.Enum):

        NoState                   = ...  # 0x0
        DraggingState             = ...  # 0x1
        DragSelectingState        = ...  # 0x2
        EditingState              = ...  # 0x3
        ExpandingState            = ...  # 0x4
        CollapsingState           = ...  # 0x5
        AnimatingState            = ...  # 0x6


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, autoScroll: bool | None = ..., autoScrollMargin: int | None = ..., editTriggers: PySide6.QtWidgets.QAbstractItemView.EditTrigger | None = ..., tabKeyNavigation: bool | None = ..., showDropIndicator: bool | None = ..., dragEnabled: bool | None = ..., dragDropOverwriteMode: bool | None = ..., dragDropMode: PySide6.QtWidgets.QAbstractItemView.DragDropMode | None = ..., defaultDropAction: PySide6.QtCore.Qt.DropAction | None = ..., alternatingRowColors: bool | None = ..., selectionMode: PySide6.QtWidgets.QAbstractItemView.SelectionMode | None = ..., selectionBehavior: PySide6.QtWidgets.QAbstractItemView.SelectionBehavior | None = ..., iconSize: PySide6.QtCore.QSize | None = ..., textElideMode: PySide6.QtCore.Qt.TextElideMode | None = ..., verticalScrollMode: PySide6.QtWidgets.QAbstractItemView.ScrollMode | None = ..., horizontalScrollMode: PySide6.QtWidgets.QAbstractItemView.ScrollMode | None = ..., updateThreshold: int | None = ...) -> None: ...

    def alternatingRowColors(self, /) -> bool: ...
    def autoScrollMargin(self, /) -> int: ...
    def clearSelection(self, /) -> None: ...
    def closeEditor(self, editor: PySide6.QtWidgets.QWidget, hint: PySide6.QtWidgets.QAbstractItemDelegate.EndEditHint, /) -> None: ...
    def closePersistentEditor(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def commitData(self, editor: PySide6.QtWidgets.QWidget, /) -> None: ...
    def currentChanged(self, current: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, previous: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def currentIndex(self, /) -> PySide6.QtCore.QModelIndex: ...
    def dataChanged(self, topLeft: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, bottomRight: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, roles: collections.abc.Sequence[int] = ...) -> None: ...
    def defaultDropAction(self, /) -> PySide6.QtCore.Qt.DropAction: ...
    def dirtyRegionOffset(self, /) -> PySide6.QtCore.QPoint: ...
    def doAutoScroll(self, /) -> None: ...
    def doItemsLayout(self, /) -> None: ...
    def dragDropMode(self, /) -> PySide6.QtWidgets.QAbstractItemView.DragDropMode: ...
    def dragDropOverwriteMode(self, /) -> bool: ...
    def dragEnabled(self, /) -> bool: ...
    def dragEnterEvent(self, event: PySide6.QtGui.QDragEnterEvent, /) -> None: ...
    def dragLeaveEvent(self, event: PySide6.QtGui.QDragLeaveEvent, /) -> None: ...
    def dragMoveEvent(self, event: PySide6.QtGui.QDragMoveEvent, /) -> None: ...
    def dropEvent(self, event: PySide6.QtGui.QDropEvent, /) -> None: ...
    def dropIndicatorPosition(self, /) -> PySide6.QtWidgets.QAbstractItemView.DropIndicatorPosition: ...
    @typing.overload
    def edit(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    @typing.overload
    def edit(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, trigger: PySide6.QtWidgets.QAbstractItemView.EditTrigger, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def editTriggers(self, /) -> PySide6.QtWidgets.QAbstractItemView.EditTrigger: ...
    def editorDestroyed(self, editor: PySide6.QtCore.QObject, /) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def eventFilter(self, object: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def executeDelayedItemsLayout(self, /) -> None: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusNextPrevChild(self, next: bool, /) -> bool: ...
    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def hasAutoScroll(self, /) -> bool: ...
    def horizontalOffset(self, /) -> int: ...
    def horizontalScrollMode(self, /) -> PySide6.QtWidgets.QAbstractItemView.ScrollMode: ...
    def horizontalScrollbarAction(self, action: int, /) -> None: ...
    def horizontalScrollbarValueChanged(self, value: int, /) -> None: ...
    def iconSize(self, /) -> PySide6.QtCore.QSize: ...
    def indexAt(self, point: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QModelIndex: ...
    def indexWidget(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtWidgets.QWidget: ...
    def initViewItemOption(self, option: PySide6.QtWidgets.QStyleOptionViewItem, /) -> None: ...
    def inputMethodEvent(self, event: PySide6.QtGui.QInputMethodEvent, /) -> None: ...
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery, /) -> typing.Any: ...
    def isIndexHidden(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def isPersistentEditorOpen(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    @typing.overload
    def itemDelegate(self, /) -> PySide6.QtWidgets.QAbstractItemDelegate: ...
    @typing.overload
    def itemDelegate(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtWidgets.QAbstractItemDelegate: ...
    def itemDelegateForColumn(self, column: int, /) -> PySide6.QtWidgets.QAbstractItemDelegate: ...
    def itemDelegateForIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtWidgets.QAbstractItemDelegate: ...
    def itemDelegateForRow(self, row: int, /) -> PySide6.QtWidgets.QAbstractItemDelegate: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def keyboardSearch(self, search: str, /) -> None: ...
    def model(self, /) -> PySide6.QtCore.QAbstractItemModel: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def moveCursor(self, cursorAction: PySide6.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide6.QtCore.Qt.KeyboardModifier, /) -> PySide6.QtCore.QModelIndex: ...
    def openPersistentEditor(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def reset(self, /) -> None: ...
    def resetHorizontalScrollMode(self, /) -> None: ...
    def resetVerticalScrollMode(self, /) -> None: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def rootIndex(self, /) -> PySide6.QtCore.QModelIndex: ...
    def rowsAboutToBeRemoved(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, start: int, end: int, /) -> None: ...
    def rowsInserted(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, start: int, end: int, /) -> None: ...
    def scheduleDelayedItemsLayout(self, /) -> None: ...
    def scrollDirtyRegion(self, dx: int, dy: int, /) -> None: ...
    def scrollTo(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def scrollToBottom(self, /) -> None: ...
    def scrollToTop(self, /) -> None: ...
    def selectAll(self, /) -> None: ...
    def selectedIndexes(self, /) -> typing.List[PySide6.QtCore.QModelIndex]: ...
    def selectionBehavior(self, /) -> PySide6.QtWidgets.QAbstractItemView.SelectionBehavior: ...
    def selectionChanged(self, selected: PySide6.QtCore.QItemSelection, deselected: PySide6.QtCore.QItemSelection, /) -> None: ...
    def selectionCommand(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, event: PySide6.QtCore.QEvent | None = ...) -> PySide6.QtCore.QItemSelectionModel.SelectionFlag: ...
    def selectionMode(self, /) -> PySide6.QtWidgets.QAbstractItemView.SelectionMode: ...
    def selectionModel(self, /) -> PySide6.QtCore.QItemSelectionModel: ...
    def setAlternatingRowColors(self, enable: bool, /) -> None: ...
    def setAutoScroll(self, enable: bool, /) -> None: ...
    def setAutoScrollMargin(self, margin: int, /) -> None: ...
    def setCurrentIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def setDefaultDropAction(self, dropAction: PySide6.QtCore.Qt.DropAction, /) -> None: ...
    def setDirtyRegion(self, region: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect, /) -> None: ...
    def setDragDropMode(self, behavior: PySide6.QtWidgets.QAbstractItemView.DragDropMode, /) -> None: ...
    def setDragDropOverwriteMode(self, overwrite: bool, /) -> None: ...
    def setDragEnabled(self, enable: bool, /) -> None: ...
    def setDropIndicatorShown(self, enable: bool, /) -> None: ...
    def setEditTriggers(self, triggers: PySide6.QtWidgets.QAbstractItemView.EditTrigger, /) -> None: ...
    def setHorizontalScrollMode(self, mode: PySide6.QtWidgets.QAbstractItemView.ScrollMode, /) -> None: ...
    def setIconSize(self, size: PySide6.QtCore.QSize, /) -> None: ...
    def setIndexWidget(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setItemDelegate(self, delegate: PySide6.QtWidgets.QAbstractItemDelegate, /) -> None: ...
    def setItemDelegateForColumn(self, column: int, delegate: PySide6.QtWidgets.QAbstractItemDelegate, /) -> None: ...
    def setItemDelegateForRow(self, row: int, delegate: PySide6.QtWidgets.QAbstractItemDelegate, /) -> None: ...
    def setModel(self, model: PySide6.QtCore.QAbstractItemModel | None, /) -> None: ...
    def setRootIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def setSelection(self, rect: PySide6.QtCore.QRect, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag, /) -> None: ...
    def setSelectionBehavior(self, behavior: PySide6.QtWidgets.QAbstractItemView.SelectionBehavior, /) -> None: ...
    def setSelectionMode(self, mode: PySide6.QtWidgets.QAbstractItemView.SelectionMode, /) -> None: ...
    def setSelectionModel(self, selectionModel: PySide6.QtCore.QItemSelectionModel, /) -> None: ...
    def setState(self, state: PySide6.QtWidgets.QAbstractItemView.State, /) -> None: ...
    def setTabKeyNavigation(self, enable: bool, /) -> None: ...
    def setTextElideMode(self, mode: PySide6.QtCore.Qt.TextElideMode, /) -> None: ...
    def setUpdateThreshold(self, threshold: int, /) -> None: ...
    def setVerticalScrollMode(self, mode: PySide6.QtWidgets.QAbstractItemView.ScrollMode, /) -> None: ...
    def showDropIndicator(self, /) -> bool: ...
    def sizeHintForColumn(self, column: int, /) -> int: ...
    def sizeHintForIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QSize: ...
    def sizeHintForRow(self, row: int, /) -> int: ...
    def startAutoScroll(self, /) -> None: ...
    def startDrag(self, supportedActions: PySide6.QtCore.Qt.DropAction, /) -> None: ...
    def state(self, /) -> PySide6.QtWidgets.QAbstractItemView.State: ...
    def stopAutoScroll(self, /) -> None: ...
    def tabKeyNavigation(self, /) -> bool: ...
    def textElideMode(self, /) -> PySide6.QtCore.Qt.TextElideMode: ...
    def timerEvent(self, event: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def update(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def updateEditorData(self, /) -> None: ...
    def updateEditorGeometries(self, /) -> None: ...
    def updateGeometries(self, /) -> None: ...
    def updateThreshold(self, /) -> int: ...
    def verticalOffset(self, /) -> int: ...
    def verticalScrollMode(self, /) -> PySide6.QtWidgets.QAbstractItemView.ScrollMode: ...
    def verticalScrollbarAction(self, action: int, /) -> None: ...
    def verticalScrollbarValueChanged(self, value: int, /) -> None: ...
    def viewportEvent(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def viewportSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def visualRect(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide6.QtCore.QItemSelection, /) -> PySide6.QtGui.QRegion: ...


class QAbstractScrollArea(PySide6.QtWidgets.QFrame):

    class SizeAdjustPolicy(enum.Enum):

        AdjustIgnored             = ...  # 0x0
        AdjustToContentsOnFirstShow = ...  # 0x1
        AdjustToContents          = ...  # 0x2


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, verticalScrollBarPolicy: PySide6.QtCore.Qt.ScrollBarPolicy | None = ..., horizontalScrollBarPolicy: PySide6.QtCore.Qt.ScrollBarPolicy | None = ..., sizeAdjustPolicy: PySide6.QtWidgets.QAbstractScrollArea.SizeAdjustPolicy | None = ...) -> None: ...

    def addScrollBarWidget(self, widget: PySide6.QtWidgets.QWidget, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    def contextMenuEvent(self, arg__1: PySide6.QtGui.QContextMenuEvent, /) -> None: ...
    def cornerWidget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def dragEnterEvent(self, arg__1: PySide6.QtGui.QDragEnterEvent, /) -> None: ...
    def dragLeaveEvent(self, arg__1: PySide6.QtGui.QDragLeaveEvent, /) -> None: ...
    def dragMoveEvent(self, arg__1: PySide6.QtGui.QDragMoveEvent, /) -> None: ...
    def dropEvent(self, arg__1: PySide6.QtGui.QDropEvent, /) -> None: ...
    def event(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    def eventFilter(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent, /) -> bool: ...
    def horizontalScrollBar(self, /) -> PySide6.QtWidgets.QScrollBar: ...
    def horizontalScrollBarPolicy(self, /) -> PySide6.QtCore.Qt.ScrollBarPolicy: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def maximumViewportSize(self, /) -> PySide6.QtCore.QSize: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def scrollBarWidgets(self, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> typing.List[PySide6.QtWidgets.QWidget]: ...
    def scrollContentsBy(self, dx: int, dy: int, /) -> None: ...
    def setCornerWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setHorizontalScrollBar(self, scrollbar: PySide6.QtWidgets.QScrollBar, /) -> None: ...
    def setHorizontalScrollBarPolicy(self, arg__1: PySide6.QtCore.Qt.ScrollBarPolicy, /) -> None: ...
    def setSizeAdjustPolicy(self, policy: PySide6.QtWidgets.QAbstractScrollArea.SizeAdjustPolicy, /) -> None: ...
    def setVerticalScrollBar(self, scrollbar: PySide6.QtWidgets.QScrollBar, /) -> None: ...
    def setVerticalScrollBarPolicy(self, arg__1: PySide6.QtCore.Qt.ScrollBarPolicy, /) -> None: ...
    def setViewport(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    @typing.overload
    def setViewportMargins(self, margins: PySide6.QtCore.QMargins, /) -> None: ...
    @typing.overload
    def setViewportMargins(self, left: int, top: int, right: int, bottom: int, /) -> None: ...
    def setupViewport(self, viewport: PySide6.QtWidgets.QWidget, /) -> None: ...
    def sizeAdjustPolicy(self, /) -> PySide6.QtWidgets.QAbstractScrollArea.SizeAdjustPolicy: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def verticalScrollBar(self, /) -> PySide6.QtWidgets.QScrollBar: ...
    def verticalScrollBarPolicy(self, /) -> PySide6.QtCore.Qt.ScrollBarPolicy: ...
    def viewport(self, /) -> PySide6.QtWidgets.QWidget: ...
    def viewportEvent(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    def viewportMargins(self, /) -> PySide6.QtCore.QMargins: ...
    def viewportSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def wheelEvent(self, arg__1: PySide6.QtGui.QWheelEvent, /) -> None: ...


class QAbstractSlider(PySide6.QtWidgets.QWidget):

    actionTriggered          : typing.ClassVar[Signal] = ... # actionTriggered(int)
    rangeChanged             : typing.ClassVar[Signal] = ... # rangeChanged(int,int)
    sliderMoved              : typing.ClassVar[Signal] = ... # sliderMoved(int)
    sliderPressed            : typing.ClassVar[Signal] = ... # sliderPressed()
    sliderReleased           : typing.ClassVar[Signal] = ... # sliderReleased()
    valueChanged             : typing.ClassVar[Signal] = ... # valueChanged(int)

    class SliderAction(enum.Enum):

        SliderNoAction            = ...  # 0x0
        SliderSingleStepAdd       = ...  # 0x1
        SliderSingleStepSub       = ...  # 0x2
        SliderPageStepAdd         = ...  # 0x3
        SliderPageStepSub         = ...  # 0x4
        SliderToMinimum           = ...  # 0x5
        SliderToMaximum           = ...  # 0x6
        SliderMove                = ...  # 0x7

    class SliderChange(enum.Enum):

        SliderRangeChange         = ...  # 0x0
        SliderOrientationChange   = ...  # 0x1
        SliderStepsChange         = ...  # 0x2
        SliderValueChange         = ...  # 0x3


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, minimum: int | None = ..., maximum: int | None = ..., singleStep: int | None = ..., pageStep: int | None = ..., value: int | None = ..., sliderPosition: int | None = ..., tracking: bool | None = ..., orientation: PySide6.QtCore.Qt.Orientation | None = ..., invertedAppearance: bool | None = ..., invertedControls: bool | None = ..., sliderDown: bool | None = ...) -> None: ...

    def changeEvent(self, e: PySide6.QtCore.QEvent, /) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def hasTracking(self, /) -> bool: ...
    def invertedAppearance(self, /) -> bool: ...
    def invertedControls(self, /) -> bool: ...
    def isSliderDown(self, /) -> bool: ...
    def keyPressEvent(self, ev: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def maximum(self, /) -> int: ...
    def minimum(self, /) -> int: ...
    def orientation(self, /) -> PySide6.QtCore.Qt.Orientation: ...
    def pageStep(self, /) -> int: ...
    def repeatAction(self, /) -> PySide6.QtWidgets.QAbstractSlider.SliderAction: ...
    def setInvertedAppearance(self, arg__1: bool, /) -> None: ...
    def setInvertedControls(self, arg__1: bool, /) -> None: ...
    def setMaximum(self, arg__1: int, /) -> None: ...
    def setMinimum(self, arg__1: int, /) -> None: ...
    def setOrientation(self, arg__1: PySide6.QtCore.Qt.Orientation, /) -> None: ...
    def setPageStep(self, arg__1: int, /) -> None: ...
    def setRange(self, min: int, max: int, /) -> None: ...
    def setRepeatAction(self, action: PySide6.QtWidgets.QAbstractSlider.SliderAction, /, thresholdTime: int = ..., repeatTime: int = ...) -> None: ...
    def setSingleStep(self, arg__1: int, /) -> None: ...
    def setSliderDown(self, arg__1: bool, /) -> None: ...
    def setSliderPosition(self, arg__1: int, /) -> None: ...
    def setTracking(self, enable: bool, /) -> None: ...
    def setValue(self, arg__1: int, /) -> None: ...
    def singleStep(self, /) -> int: ...
    def sliderChange(self, change: PySide6.QtWidgets.QAbstractSlider.SliderChange, /) -> None: ...
    def sliderPosition(self, /) -> int: ...
    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def triggerAction(self, action: PySide6.QtWidgets.QAbstractSlider.SliderAction, /) -> None: ...
    def value(self, /) -> int: ...
    def wheelEvent(self, e: PySide6.QtGui.QWheelEvent, /) -> None: ...


class QAbstractSpinBox(PySide6.QtWidgets.QWidget):

    editingFinished          : typing.ClassVar[Signal] = ... # editingFinished()

    class ButtonSymbols(enum.Enum):

        UpDownArrows              = ...  # 0x0
        PlusMinus                 = ...  # 0x1
        NoButtons                 = ...  # 0x2

    class CorrectionMode(enum.Enum):

        CorrectToPreviousValue    = ...  # 0x0
        CorrectToNearestValue     = ...  # 0x1

    class StepEnabledFlag(enum.Flag):

        StepNone                  = ...  # 0x0
        StepUpEnabled             = ...  # 0x1
        StepDownEnabled           = ...  # 0x2

    class StepType(enum.Enum):

        DefaultStepType           = ...  # 0x0
        AdaptiveDecimalStepType   = ...  # 0x1


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, wrapping: bool | None = ..., frame: bool | None = ..., alignment: PySide6.QtCore.Qt.AlignmentFlag | None = ..., readOnly: bool | None = ..., buttonSymbols: PySide6.QtWidgets.QAbstractSpinBox.ButtonSymbols | None = ..., specialValueText: str | None = ..., text: str | None = ..., accelerated: bool | None = ..., correctionMode: PySide6.QtWidgets.QAbstractSpinBox.CorrectionMode | None = ..., acceptableInput: bool | None = ..., keyboardTracking: bool | None = ..., showGroupSeparator: bool | None = ...) -> None: ...

    def alignment(self, /) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def buttonSymbols(self, /) -> PySide6.QtWidgets.QAbstractSpinBox.ButtonSymbols: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def clear(self, /) -> None: ...
    def closeEvent(self, event: PySide6.QtGui.QCloseEvent, /) -> None: ...
    def contextMenuEvent(self, event: PySide6.QtGui.QContextMenuEvent, /) -> None: ...
    def correctionMode(self, /) -> PySide6.QtWidgets.QAbstractSpinBox.CorrectionMode: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def fixup(self, input: str, /) -> str: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def hasAcceptableInput(self, /) -> bool: ...
    def hasFrame(self, /) -> bool: ...
    def hideEvent(self, event: PySide6.QtGui.QHideEvent, /) -> None: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionSpinBox, /) -> None: ...
    def inputMethodQuery(self, arg__1: PySide6.QtCore.Qt.InputMethodQuery, /) -> typing.Any: ...
    def interpretText(self, /) -> None: ...
    def isAccelerated(self, /) -> bool: ...
    def isGroupSeparatorShown(self, /) -> bool: ...
    def isReadOnly(self, /) -> bool: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def keyReleaseEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def keyboardTracking(self, /) -> bool: ...
    def lineEdit(self, /) -> PySide6.QtWidgets.QLineEdit: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def selectAll(self, /) -> None: ...
    def setAccelerated(self, on: bool, /) -> None: ...
    def setAlignment(self, flag: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    def setButtonSymbols(self, bs: PySide6.QtWidgets.QAbstractSpinBox.ButtonSymbols, /) -> None: ...
    def setCorrectionMode(self, cm: PySide6.QtWidgets.QAbstractSpinBox.CorrectionMode, /) -> None: ...
    def setFrame(self, arg__1: bool, /) -> None: ...
    def setGroupSeparatorShown(self, shown: bool, /) -> None: ...
    def setKeyboardTracking(self, kt: bool, /) -> None: ...
    def setLineEdit(self, edit: PySide6.QtWidgets.QLineEdit, /) -> None: ...
    def setReadOnly(self, r: bool, /) -> None: ...
    def setSpecialValueText(self, txt: str, /) -> None: ...
    def setWrapping(self, w: bool, /) -> None: ...
    def showEvent(self, event: PySide6.QtGui.QShowEvent, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def specialValueText(self, /) -> str: ...
    def stepBy(self, steps: int, /) -> None: ...
    def stepDown(self, /) -> None: ...
    def stepEnabled(self, /) -> PySide6.QtWidgets.QAbstractSpinBox.StepEnabledFlag: ...
    def stepUp(self, /) -> None: ...
    def text(self, /) -> str: ...
    def timerEvent(self, event: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def validate(self, input: str, pos: int, /) -> object: ...
    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent, /) -> None: ...
    def wrapping(self, /) -> bool: ...


class QAccessibleWidget(PySide6.QtGui.QAccessibleObject, PySide6.QtGui.QAccessibleActionInterface):

    def __init__(self, o: PySide6.QtWidgets.QWidget, /, r: PySide6.QtGui.QAccessible.Role = ..., name: str = ...) -> None: ...

    def actionNames(self, /) -> typing.List[str]: ...
    def addControllingSignal(self, signal: str, /) -> None: ...
    def backgroundColor(self, /) -> PySide6.QtGui.QColor: ...
    def child(self, index: int, /) -> PySide6.QtGui.QAccessibleInterface: ...
    def childCount(self, /) -> int: ...
    def doAction(self, actionName: str, /) -> None: ...
    def focusChild(self, /) -> PySide6.QtGui.QAccessibleInterface: ...
    def foregroundColor(self, /) -> PySide6.QtGui.QColor: ...
    def indexOfChild(self, child: PySide6.QtGui.QAccessibleInterface, /) -> int: ...
    def interface_cast(self, t: PySide6.QtGui.QAccessible.InterfaceType, /) -> int: ...
    def isValid(self, /) -> bool: ...
    def keyBindingsForAction(self, actionName: str, /) -> typing.List[str]: ...
    def parent(self, /) -> PySide6.QtGui.QAccessibleInterface: ...
    def parentObject(self, /) -> PySide6.QtCore.QObject: ...
    def rect(self, /) -> PySide6.QtCore.QRect: ...
    def relations(self, /, match: PySide6.QtGui.QAccessible.RelationFlag = ...) -> typing.List[typing.Tuple[PySide6.QtGui.QAccessibleInterface, PySide6.QtGui.QAccessible.RelationFlag]]: ...
    def role(self, /) -> PySide6.QtGui.QAccessible.Role: ...
    def state(self, /) -> PySide6.QtGui.QAccessible.State: ...
    def text(self, t: PySide6.QtGui.QAccessible.Text, /) -> str: ...
    def widget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def window(self, /) -> PySide6.QtGui.QWindow: ...


class QApplication(PySide6.QtGui.QGuiApplication):

    focusChanged             : typing.ClassVar[Signal] = ... # focusChanged(QWidget*,QWidget*)

    @typing.overload
    def __init__(self, arguments: collections.abc.Sequence[str], /, *, cursorFlashTime: int | None = ..., doubleClickInterval: int | None = ..., keyboardInputInterval: int | None = ..., wheelScrollLines: int | None = ..., startDragTime: int | None = ..., startDragDistance: int | None = ..., styleSheet: str | None = ..., autoSipEnabled: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, *, cursorFlashTime: int | None = ..., doubleClickInterval: int | None = ..., keyboardInputInterval: int | None = ..., wheelScrollLines: int | None = ..., startDragTime: int | None = ..., startDragDistance: int | None = ..., styleSheet: str | None = ..., autoSipEnabled: bool | None = ...) -> None: ...

    @staticmethod
    def aboutQt() -> None: ...
    @staticmethod
    def activeModalWidget() -> PySide6.QtWidgets.QWidget | None: ...
    @staticmethod
    def activePopupWidget() -> PySide6.QtWidgets.QWidget | None: ...
    @staticmethod
    def activeWindow() -> PySide6.QtWidgets.QWidget | None: ...
    @staticmethod
    def alert(widget: PySide6.QtWidgets.QWidget, /, duration: int | None = ...) -> None: ...
    @staticmethod
    def allWidgets() -> typing.List[PySide6.QtWidgets.QWidget]: ...
    def autoSipEnabled(self, /) -> bool: ...
    @staticmethod
    def beep() -> None: ...
    @staticmethod
    def closeAllWindows() -> None: ...
    @staticmethod
    def cursorFlashTime() -> int: ...
    @staticmethod
    def doubleClickInterval() -> int: ...
    def event(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    @staticmethod
    def exec() -> int: ...
    def exec_(self, /) -> int: ...
    @staticmethod
    def focusWidget() -> PySide6.QtWidgets.QWidget | None: ...
    @typing.overload
    @staticmethod
    def font() -> PySide6.QtGui.QFont: ...
    @typing.overload
    @staticmethod
    def font(arg__1: PySide6.QtWidgets.QWidget, /) -> PySide6.QtGui.QFont: ...
    @typing.overload
    @staticmethod
    def font(className: bytes | bytearray | memoryview, /) -> PySide6.QtGui.QFont: ...
    @staticmethod
    def fontMetrics() -> PySide6.QtGui.QFontMetrics: ...
    @staticmethod
    def isEffectEnabled(arg__1: PySide6.QtCore.Qt.UIEffect, /) -> bool: ...
    @staticmethod
    def keyboardInputInterval() -> int: ...
    def notify(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent, /) -> bool: ...
    @typing.overload
    @staticmethod
    def palette() -> PySide6.QtGui.QPalette: ...
    @typing.overload
    @staticmethod
    def palette(arg__1: PySide6.QtWidgets.QWidget, /) -> PySide6.QtGui.QPalette: ...
    @typing.overload
    @staticmethod
    def palette(className: bytes | bytearray | memoryview, /) -> PySide6.QtGui.QPalette: ...
    def resolveInterface(self, name: bytes | bytearray | memoryview, revision: int, /) -> int: ...
    @staticmethod
    def setActiveWindow(act: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setAutoSipEnabled(self, enabled: bool, /) -> None: ...
    @staticmethod
    def setCursorFlashTime(arg__1: int, /) -> None: ...
    @staticmethod
    def setDoubleClickInterval(arg__1: int, /) -> None: ...
    @staticmethod
    def setEffectEnabled(arg__1: PySide6.QtCore.Qt.UIEffect, /, enable: bool = ...) -> None: ...
    @staticmethod
    def setFont(arg__1: PySide6.QtGui.QFont | str | collections.abc.Sequence[str], /, className: bytes | bytearray | memoryview | None = ...) -> None: ...
    @staticmethod
    def setKeyboardInputInterval(arg__1: int, /) -> None: ...
    @staticmethod
    def setPalette(arg__1: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, /, className: bytes | bytearray | memoryview | None = ...) -> None: ...
    @staticmethod
    def setStartDragDistance(l: int, /) -> None: ...
    @staticmethod
    def setStartDragTime(ms: int, /) -> None: ...
    @typing.overload
    @staticmethod
    def setStyle(arg__1: PySide6.QtWidgets.QStyle, /) -> None: ...
    @typing.overload
    @staticmethod
    def setStyle(arg__1: str, /) -> PySide6.QtWidgets.QStyle | None: ...
    def setStyleSheet(self, sheet: str, /) -> None: ...
    @staticmethod
    def setWheelScrollLines(arg__1: int, /) -> None: ...
    @staticmethod
    def startDragDistance() -> int: ...
    @staticmethod
    def startDragTime() -> int: ...
    @staticmethod
    def style() -> PySide6.QtWidgets.QStyle: ...
    def styleSheet(self, /) -> str: ...
    @typing.overload
    @staticmethod
    def topLevelAt(p: PySide6.QtCore.QPoint, /) -> PySide6.QtWidgets.QWidget | None: ...
    @typing.overload
    @staticmethod
    def topLevelAt(x: int, y: int, /) -> PySide6.QtWidgets.QWidget | None: ...
    @staticmethod
    def topLevelWidgets() -> typing.List[PySide6.QtWidgets.QWidget]: ...
    @staticmethod
    def wheelScrollLines() -> int: ...
    @typing.overload
    @staticmethod
    def widgetAt(p: PySide6.QtCore.QPoint, /) -> PySide6.QtWidgets.QWidget | None: ...
    @typing.overload
    @staticmethod
    def widgetAt(x: int, y: int, /) -> PySide6.QtWidgets.QWidget | None: ...


class QBoxLayout(PySide6.QtWidgets.QLayout):

    class Direction(enum.Enum):

        LeftToRight               = ...  # 0x0
        RightToLeft               = ...  # 0x1
        Down                      = ...  # 0x2
        TopToBottom               = ...  # 0x2
        BottomToTop               = ...  # 0x3
        Up                        = ...  # 0x3


    def __init__(self, arg__1: PySide6.QtWidgets.QBoxLayout.Direction, /, parent: PySide6.QtWidgets.QWidget | None = ...) -> None: ...

    def addItem(self, arg__1: PySide6.QtWidgets.QLayoutItem, /) -> None: ...
    def addLayout(self, layout: PySide6.QtWidgets.QLayout, /, stretch: int | None = ...) -> None: ...
    def addSpacerItem(self, spacerItem: PySide6.QtWidgets.QSpacerItem, /) -> None: ...
    def addSpacing(self, size: int, /) -> None: ...
    def addStretch(self, /, stretch: int | None = ...) -> None: ...
    def addStrut(self, arg__1: int, /) -> None: ...
    def addWidget(self, arg__1: PySide6.QtWidgets.QWidget, /, stretch: int | None = ..., alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...
    def count(self, /) -> int: ...
    def direction(self, /) -> PySide6.QtWidgets.QBoxLayout.Direction: ...
    def expandingDirections(self, /) -> PySide6.QtCore.Qt.Orientation: ...
    def hasHeightForWidth(self, /) -> bool: ...
    def heightForWidth(self, arg__1: int, /) -> int: ...
    def insertItem(self, index: int, arg__2: PySide6.QtWidgets.QLayoutItem, /) -> None: ...
    def insertLayout(self, index: int, layout: PySide6.QtWidgets.QLayout, /, stretch: int | None = ...) -> None: ...
    def insertSpacerItem(self, index: int, spacerItem: PySide6.QtWidgets.QSpacerItem, /) -> None: ...
    def insertSpacing(self, index: int, size: int, /) -> None: ...
    def insertStretch(self, index: int, /, stretch: int | None = ...) -> None: ...
    def insertWidget(self, index: int, widget: PySide6.QtWidgets.QWidget, /, stretch: int | None = ..., alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...
    def invalidate(self, /) -> None: ...
    def itemAt(self, arg__1: int, /) -> PySide6.QtWidgets.QLayoutItem: ...
    def maximumSize(self, /) -> PySide6.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1: int, /) -> int: ...
    def minimumSize(self, /) -> PySide6.QtCore.QSize: ...
    def setDirection(self, arg__1: PySide6.QtWidgets.QBoxLayout.Direction, /) -> None: ...
    def setGeometry(self, arg__1: PySide6.QtCore.QRect, /) -> None: ...
    def setSpacing(self, spacing: int, /) -> None: ...
    def setStretch(self, index: int, stretch: int, /) -> None: ...
    @typing.overload
    def setStretchFactor(self, l: PySide6.QtWidgets.QLayout, stretch: int, /) -> bool: ...
    @typing.overload
    def setStretchFactor(self, w: PySide6.QtWidgets.QWidget, stretch: int, /) -> bool: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def spacing(self, /) -> int: ...
    def stretch(self, index: int, /) -> int: ...
    def takeAt(self, arg__1: int, /) -> PySide6.QtWidgets.QLayoutItem: ...


class QButtonGroup(PySide6.QtCore.QObject):

    buttonClicked            : typing.ClassVar[Signal] = ... # buttonClicked(QAbstractButton*)
    buttonPressed            : typing.ClassVar[Signal] = ... # buttonPressed(QAbstractButton*)
    buttonReleased           : typing.ClassVar[Signal] = ... # buttonReleased(QAbstractButton*)
    buttonToggled            : typing.ClassVar[Signal] = ... # buttonToggled(QAbstractButton*,bool)
    idClicked                : typing.ClassVar[Signal] = ... # idClicked(int)
    idPressed                : typing.ClassVar[Signal] = ... # idPressed(int)
    idReleased               : typing.ClassVar[Signal] = ... # idReleased(int)
    idToggled                : typing.ClassVar[Signal] = ... # idToggled(int,bool)

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, exclusive: bool | None = ...) -> None: ...

    def addButton(self, arg__1: PySide6.QtWidgets.QAbstractButton, /, id: int = ...) -> None: ...
    def button(self, id: int, /) -> PySide6.QtWidgets.QAbstractButton: ...
    def buttons(self, /) -> typing.List[PySide6.QtWidgets.QAbstractButton]: ...
    def checkedButton(self, /) -> PySide6.QtWidgets.QAbstractButton: ...
    def checkedId(self, /) -> int: ...
    def exclusive(self, /) -> bool: ...
    def id(self, button: PySide6.QtWidgets.QAbstractButton, /) -> int: ...
    def removeButton(self, arg__1: PySide6.QtWidgets.QAbstractButton, /) -> None: ...
    def setExclusive(self, arg__1: bool, /) -> None: ...
    def setId(self, button: PySide6.QtWidgets.QAbstractButton, id: int, /) -> None: ...


class QCalendarWidget(PySide6.QtWidgets.QWidget):

    activated                : typing.ClassVar[Signal] = ... # activated(QDate)
    clicked                  : typing.ClassVar[Signal] = ... # clicked(QDate)
    currentPageChanged       : typing.ClassVar[Signal] = ... # currentPageChanged(int,int)
    selectionChanged         : typing.ClassVar[Signal] = ... # selectionChanged()

    class HorizontalHeaderFormat(enum.Enum):

        NoHorizontalHeader        = ...  # 0x0
        SingleLetterDayNames      = ...  # 0x1
        ShortDayNames             = ...  # 0x2
        LongDayNames              = ...  # 0x3

    class SelectionMode(enum.Enum):

        NoSelection               = ...  # 0x0
        SingleSelection           = ...  # 0x1

    class VerticalHeaderFormat(enum.Enum):

        NoVerticalHeader          = ...  # 0x0
        ISOWeekNumbers            = ...  # 0x1


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, selectedDate: PySide6.QtCore.QDate | None = ..., minimumDate: PySide6.QtCore.QDate | None = ..., maximumDate: PySide6.QtCore.QDate | None = ..., firstDayOfWeek: PySide6.QtCore.Qt.DayOfWeek | None = ..., gridVisible: bool | None = ..., selectionMode: PySide6.QtWidgets.QCalendarWidget.SelectionMode | None = ..., horizontalHeaderFormat: PySide6.QtWidgets.QCalendarWidget.HorizontalHeaderFormat | None = ..., verticalHeaderFormat: PySide6.QtWidgets.QCalendarWidget.VerticalHeaderFormat | None = ..., navigationBarVisible: bool | None = ..., dateEditEnabled: bool | None = ..., dateEditAcceptDelay: int | None = ...) -> None: ...

    def calendar(self, /) -> PySide6.QtCore.QCalendar: ...
    def clearMaximumDate(self, /) -> None: ...
    def clearMinimumDate(self, /) -> None: ...
    def dateEditAcceptDelay(self, /) -> int: ...
    @typing.overload
    def dateTextFormat(self, /) -> typing.Dict[PySide6.QtCore.QDate, PySide6.QtGui.QTextCharFormat]: ...
    @typing.overload
    def dateTextFormat(self, date: PySide6.QtCore.QDate, /) -> PySide6.QtGui.QTextCharFormat: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def eventFilter(self, watched: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def firstDayOfWeek(self, /) -> PySide6.QtCore.Qt.DayOfWeek: ...
    def headerTextFormat(self, /) -> PySide6.QtGui.QTextCharFormat: ...
    def horizontalHeaderFormat(self, /) -> PySide6.QtWidgets.QCalendarWidget.HorizontalHeaderFormat: ...
    def isDateEditEnabled(self, /) -> bool: ...
    def isGridVisible(self, /) -> bool: ...
    def isNavigationBarVisible(self, /) -> bool: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def maximumDate(self, /) -> PySide6.QtCore.QDate: ...
    def minimumDate(self, /) -> PySide6.QtCore.QDate: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def monthShown(self, /) -> int: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def paintCell(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, date: PySide6.QtCore.QDate, /) -> None: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def selectedDate(self, /) -> PySide6.QtCore.QDate: ...
    def selectionMode(self, /) -> PySide6.QtWidgets.QCalendarWidget.SelectionMode: ...
    def setCalendar(self, calendar: PySide6.QtCore.QCalendar, /) -> None: ...
    def setCurrentPage(self, year: int, month: int, /) -> None: ...
    def setDateEditAcceptDelay(self, delay: int, /) -> None: ...
    def setDateEditEnabled(self, enable: bool, /) -> None: ...
    def setDateRange(self, min: PySide6.QtCore.QDate, max: PySide6.QtCore.QDate, /) -> None: ...
    def setDateTextFormat(self, date: PySide6.QtCore.QDate, format: PySide6.QtGui.QTextCharFormat, /) -> None: ...
    def setFirstDayOfWeek(self, dayOfWeek: PySide6.QtCore.Qt.DayOfWeek, /) -> None: ...
    def setGridVisible(self, show: bool, /) -> None: ...
    def setHeaderTextFormat(self, format: PySide6.QtGui.QTextCharFormat, /) -> None: ...
    def setHorizontalHeaderFormat(self, format: PySide6.QtWidgets.QCalendarWidget.HorizontalHeaderFormat, /) -> None: ...
    def setMaximumDate(self, date: PySide6.QtCore.QDate, /) -> None: ...
    def setMinimumDate(self, date: PySide6.QtCore.QDate, /) -> None: ...
    def setNavigationBarVisible(self, visible: bool, /) -> None: ...
    def setSelectedDate(self, date: PySide6.QtCore.QDate, /) -> None: ...
    def setSelectionMode(self, mode: PySide6.QtWidgets.QCalendarWidget.SelectionMode, /) -> None: ...
    def setVerticalHeaderFormat(self, format: PySide6.QtWidgets.QCalendarWidget.VerticalHeaderFormat, /) -> None: ...
    def setWeekdayTextFormat(self, dayOfWeek: PySide6.QtCore.Qt.DayOfWeek, format: PySide6.QtGui.QTextCharFormat, /) -> None: ...
    def showNextMonth(self, /) -> None: ...
    def showNextYear(self, /) -> None: ...
    def showPreviousMonth(self, /) -> None: ...
    def showPreviousYear(self, /) -> None: ...
    def showSelectedDate(self, /) -> None: ...
    def showToday(self, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def updateCell(self, date: PySide6.QtCore.QDate, /) -> None: ...
    def updateCells(self, /) -> None: ...
    def verticalHeaderFormat(self, /) -> PySide6.QtWidgets.QCalendarWidget.VerticalHeaderFormat: ...
    def weekdayTextFormat(self, dayOfWeek: PySide6.QtCore.Qt.DayOfWeek, /) -> PySide6.QtGui.QTextCharFormat: ...
    def yearShown(self, /) -> int: ...


class QCheckBox(PySide6.QtWidgets.QAbstractButton):

    checkStateChanged        : typing.ClassVar[Signal] = ... # checkStateChanged(Qt::CheckState)
    stateChanged             : typing.ClassVar[Signal] = ... # stateChanged(int)

    @typing.overload
    def __init__(self, text: str, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, tristate: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, tristate: bool | None = ...) -> None: ...

    def checkState(self, /) -> PySide6.QtCore.Qt.CheckState: ...
    def checkStateSet(self, /) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def hitButton(self, pos: PySide6.QtCore.QPoint, /) -> bool: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionButton, /) -> None: ...
    def isTristate(self, /) -> bool: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def nextCheckState(self, /) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def setCheckState(self, state: PySide6.QtCore.Qt.CheckState, /) -> None: ...
    def setTristate(self, /, y: bool = ...) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...


class QColorDialog(PySide6.QtWidgets.QDialog):

    colorSelected            : typing.ClassVar[Signal] = ... # colorSelected(QColor)
    currentColorChanged      : typing.ClassVar[Signal] = ... # currentColorChanged(QColor)

    class ColorDialogOption(enum.Flag):

        ShowAlphaChannel          = ...  # 0x1
        NoButtons                 = ...  # 0x2
        DontUseNativeDialog       = ...  # 0x4
        NoEyeDropperButton        = ...  # 0x8


    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, currentColor: PySide6.QtGui.QColor | None = ..., options: PySide6.QtWidgets.QColorDialog.ColorDialogOption | None = ...) -> None: ...
    @typing.overload
    def __init__(self, initial: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, currentColor: PySide6.QtGui.QColor | None = ..., options: PySide6.QtWidgets.QColorDialog.ColorDialogOption | None = ...) -> None: ...

    def changeEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def currentColor(self, /) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def customColor(index: int, /) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def customCount() -> int: ...
    def done(self, result: int, /) -> None: ...
    @staticmethod
    def getColor(initial: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int = ..., parent: PySide6.QtWidgets.QWidget | None = ..., title: str = ..., options: PySide6.QtWidgets.QColorDialog.ColorDialogOption = ...) -> PySide6.QtGui.QColor: ...
    @typing.overload
    def open(self, /) -> None: ...
    @typing.overload
    def open(self, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /) -> None: ...
    def options(self, /) -> PySide6.QtWidgets.QColorDialog.ColorDialogOption: ...
    def selectedColor(self, /) -> PySide6.QtGui.QColor: ...
    def setCurrentColor(self, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, /) -> None: ...
    @staticmethod
    def setCustomColor(index: int, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, /) -> None: ...
    def setOption(self, option: PySide6.QtWidgets.QColorDialog.ColorDialogOption, /, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide6.QtWidgets.QColorDialog.ColorDialogOption, /) -> None: ...
    @staticmethod
    def setStandardColor(index: int, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, /) -> None: ...
    def setVisible(self, visible: bool, /) -> None: ...
    @staticmethod
    def standardColor(index: int, /) -> PySide6.QtGui.QColor: ...
    def testOption(self, option: PySide6.QtWidgets.QColorDialog.ColorDialogOption, /) -> bool: ...


class QColormap(Shiboken.Object):

    class Mode(enum.Enum):

        Direct                    = ...  # 0x0
        Indexed                   = ...  # 0x1
        Gray                      = ...  # 0x2


    def __init__(self, colormap: PySide6.QtWidgets.QColormap, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    @staticmethod
    def cleanup() -> None: ...
    def colorAt(self, pixel: int, /) -> PySide6.QtGui.QColor: ...
    def colormap(self, /) -> typing.List[PySide6.QtGui.QColor]: ...
    def depth(self, /) -> int: ...
    @staticmethod
    def initialize() -> None: ...
    @staticmethod
    def instance(screen: int = ...) -> PySide6.QtWidgets.QColormap: ...
    def mode(self, /) -> PySide6.QtWidgets.QColormap.Mode: ...
    def pixel(self, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, /) -> int: ...
    def size(self, /) -> int: ...


class QColumnView(PySide6.QtWidgets.QAbstractItemView):

    updatePreviewWidget      : typing.ClassVar[Signal] = ... # updatePreviewWidget(QModelIndex)

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, resizeGripsVisible: bool | None = ...) -> None: ...

    def columnWidths(self, /) -> typing.List[int]: ...
    def createColumn(self, rootIndex: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtWidgets.QAbstractItemView: ...
    def currentChanged(self, current: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, previous: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def horizontalOffset(self, /) -> int: ...
    def indexAt(self, point: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QModelIndex: ...
    def initializeColumn(self, column: PySide6.QtWidgets.QAbstractItemView, /) -> None: ...
    def isIndexHidden(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def moveCursor(self, cursorAction: PySide6.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide6.QtCore.Qt.KeyboardModifier, /) -> PySide6.QtCore.QModelIndex: ...
    def previewWidget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def resizeGripsVisible(self, /) -> bool: ...
    def rowsInserted(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, start: int, end: int, /) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int, /) -> None: ...
    def scrollTo(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectAll(self, /) -> None: ...
    def setColumnWidths(self, list: collections.abc.Sequence[int], /) -> None: ...
    def setModel(self, model: PySide6.QtCore.QAbstractItemModel | None, /) -> None: ...
    def setPreviewWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setResizeGripsVisible(self, visible: bool, /) -> None: ...
    def setRootIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def setSelection(self, rect: PySide6.QtCore.QRect, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag, /) -> None: ...
    def setSelectionModel(self, selectionModel: PySide6.QtCore.QItemSelectionModel, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def verticalOffset(self, /) -> int: ...
    def visualRect(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide6.QtCore.QItemSelection, /) -> PySide6.QtGui.QRegion: ...


class QComboBox(PySide6.QtWidgets.QWidget):

    activated                : typing.ClassVar[Signal] = ... # activated(int)
    currentIndexChanged      : typing.ClassVar[Signal] = ... # currentIndexChanged(int)
    currentTextChanged       : typing.ClassVar[Signal] = ... # currentTextChanged(QString)
    editTextChanged          : typing.ClassVar[Signal] = ... # editTextChanged(QString)
    highlighted              : typing.ClassVar[Signal] = ... # highlighted(int)
    textActivated            : typing.ClassVar[Signal] = ... # textActivated(QString)
    textHighlighted          : typing.ClassVar[Signal] = ... # textHighlighted(QString)

    class InsertPolicy(enum.Enum):

        NoInsert                  = ...  # 0x0
        InsertAtTop               = ...  # 0x1
        InsertAtCurrent           = ...  # 0x2
        InsertAtBottom            = ...  # 0x3
        InsertAfterCurrent        = ...  # 0x4
        InsertBeforeCurrent       = ...  # 0x5
        InsertAlphabetically      = ...  # 0x6

    class LabelDrawingMode(enum.Enum):

        UseStyle                  = ...  # 0x0
        UseDelegate               = ...  # 0x1

    class SizeAdjustPolicy(enum.Enum):

        AdjustToContents          = ...  # 0x0
        AdjustToContentsOnFirstShow = ...  # 0x1
        AdjustToMinimumContentsLengthWithIcon = ...  # 0x2


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, editable: bool | None = ..., count: int | None = ..., currentText: str | None = ..., currentIndex: int | None = ..., currentData: typing.Any | None = ..., maxVisibleItems: int | None = ..., maxCount: int | None = ..., insertPolicy: PySide6.QtWidgets.QComboBox.InsertPolicy | None = ..., sizeAdjustPolicy: PySide6.QtWidgets.QComboBox.SizeAdjustPolicy | None = ..., minimumContentsLength: int | None = ..., iconSize: PySide6.QtCore.QSize | None = ..., placeholderText: str | None = ..., duplicatesEnabled: bool | None = ..., frame: bool | None = ..., modelColumn: int | None = ..., labelDrawingMode: PySide6.QtWidgets.QComboBox.LabelDrawingMode | None = ...) -> None: ...

    @typing.overload
    def addItem(self, text: str, /, userData: typing.Any = ...) -> None: ...
    @typing.overload
    def addItem(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, /, userData: typing.Any = ...) -> None: ...
    def addItems(self, texts: collections.abc.Sequence[str], /) -> None: ...
    def changeEvent(self, e: PySide6.QtCore.QEvent, /) -> None: ...
    def clear(self, /) -> None: ...
    def clearEditText(self, /) -> None: ...
    def completer(self, /) -> PySide6.QtWidgets.QCompleter | None: ...
    def contextMenuEvent(self, e: PySide6.QtGui.QContextMenuEvent, /) -> None: ...
    def count(self, /) -> int: ...
    def currentData(self, /, role: int = ...) -> typing.Any: ...
    def currentIndex(self, /) -> int: ...
    def currentText(self, /) -> str: ...
    def duplicatesEnabled(self, /) -> bool: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def findData(self, data: typing.Any, /, role: int = ..., flags: PySide6.QtCore.Qt.MatchFlag = ...) -> int: ...
    def findText(self, text: str, /, flags: PySide6.QtCore.Qt.MatchFlag = ...) -> int: ...
    def focusInEvent(self, e: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusOutEvent(self, e: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def hasFrame(self, /) -> bool: ...
    def hideEvent(self, e: PySide6.QtGui.QHideEvent, /) -> None: ...
    def hidePopup(self, /) -> None: ...
    def iconSize(self, /) -> PySide6.QtCore.QSize: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionComboBox, /) -> None: ...
    def inputMethodEvent(self, arg__1: PySide6.QtGui.QInputMethodEvent, /) -> None: ...
    @typing.overload
    def inputMethodQuery(self, arg__1: PySide6.QtCore.Qt.InputMethodQuery, /) -> typing.Any: ...
    @typing.overload
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery, argument: typing.Any, /) -> typing.Any: ...
    @typing.overload
    def insertItem(self, index: int, text: str, /, userData: typing.Any = ...) -> None: ...
    @typing.overload
    def insertItem(self, index: int, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, /, userData: typing.Any = ...) -> None: ...
    def insertItems(self, index: int, texts: collections.abc.Sequence[str], /) -> None: ...
    def insertPolicy(self, /) -> PySide6.QtWidgets.QComboBox.InsertPolicy: ...
    def insertSeparator(self, index: int, /) -> None: ...
    def isEditable(self, /) -> bool: ...
    def itemData(self, index: int, /, role: int = ...) -> typing.Any: ...
    def itemDelegate(self, /) -> PySide6.QtWidgets.QAbstractItemDelegate: ...
    def itemIcon(self, index: int, /) -> PySide6.QtGui.QIcon: ...
    def itemText(self, index: int, /) -> str: ...
    def keyPressEvent(self, e: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def keyReleaseEvent(self, e: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def labelDrawingMode(self, /) -> PySide6.QtWidgets.QComboBox.LabelDrawingMode: ...
    def lineEdit(self, /) -> PySide6.QtWidgets.QLineEdit | None: ...
    def maxCount(self, /) -> int: ...
    def maxVisibleItems(self, /) -> int: ...
    def minimumContentsLength(self, /) -> int: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def model(self, /) -> PySide6.QtCore.QAbstractItemModel: ...
    def modelColumn(self, /) -> int: ...
    def mousePressEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def placeholderText(self, /) -> str: ...
    def removeItem(self, index: int, /) -> None: ...
    def resizeEvent(self, e: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def rootModelIndex(self, /) -> PySide6.QtCore.QModelIndex: ...
    def setCompleter(self, c: PySide6.QtWidgets.QCompleter, /) -> None: ...
    def setCurrentIndex(self, index: int, /) -> None: ...
    def setCurrentText(self, text: str, /) -> None: ...
    def setDuplicatesEnabled(self, enable: bool, /) -> None: ...
    def setEditText(self, text: str, /) -> None: ...
    def setEditable(self, editable: bool, /) -> None: ...
    def setFrame(self, arg__1: bool, /) -> None: ...
    def setIconSize(self, size: PySide6.QtCore.QSize, /) -> None: ...
    def setInsertPolicy(self, policy: PySide6.QtWidgets.QComboBox.InsertPolicy, /) -> None: ...
    def setItemData(self, index: int, value: typing.Any, /, role: int = ...) -> None: ...
    def setItemDelegate(self, delegate: PySide6.QtWidgets.QAbstractItemDelegate, /) -> None: ...
    def setItemIcon(self, index: int, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, /) -> None: ...
    def setItemText(self, index: int, text: str, /) -> None: ...
    def setLabelDrawingMode(self, labelDrawing: PySide6.QtWidgets.QComboBox.LabelDrawingMode, /) -> None: ...
    def setLineEdit(self, edit: PySide6.QtWidgets.QLineEdit, /) -> None: ...
    def setMaxCount(self, max: int, /) -> None: ...
    def setMaxVisibleItems(self, maxItems: int, /) -> None: ...
    def setMinimumContentsLength(self, characters: int, /) -> None: ...
    def setModel(self, model: PySide6.QtCore.QAbstractItemModel, /) -> None: ...
    def setModelColumn(self, visibleColumn: int, /) -> None: ...
    def setPlaceholderText(self, placeholderText: str, /) -> None: ...
    def setRootModelIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def setSizeAdjustPolicy(self, policy: PySide6.QtWidgets.QComboBox.SizeAdjustPolicy, /) -> None: ...
    def setValidator(self, v: PySide6.QtGui.QValidator, /) -> None: ...
    def setView(self, itemView: PySide6.QtWidgets.QAbstractItemView, /) -> None: ...
    def showEvent(self, e: PySide6.QtGui.QShowEvent, /) -> None: ...
    def showPopup(self, /) -> None: ...
    def sizeAdjustPolicy(self, /) -> PySide6.QtWidgets.QComboBox.SizeAdjustPolicy: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def validator(self, /) -> PySide6.QtGui.QValidator | None: ...
    def view(self, /) -> PySide6.QtWidgets.QAbstractItemView: ...
    def wheelEvent(self, e: PySide6.QtGui.QWheelEvent, /) -> None: ...


class QCommandLinkButton(PySide6.QtWidgets.QPushButton):

    @typing.overload
    def __init__(self, text: str, description: str, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, flat: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, text: str, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, description: str | None = ..., flat: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, description: str | None = ..., flat: bool | None = ...) -> None: ...

    def description(self, /) -> str: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def heightForWidth(self, arg__1: int, /) -> int: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionButton, /) -> None: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def setDescription(self, description: str, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...


class QCommonStyle(PySide6.QtWidgets.QStyle):

    def __init__(self, /) -> None: ...

    def drawComplexControl(self, cc: PySide6.QtWidgets.QStyle.ComplexControl, opt: PySide6.QtWidgets.QStyleOptionComplex, p: PySide6.QtGui.QPainter, /, w: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def drawControl(self, element: PySide6.QtWidgets.QStyle.ControlElement, opt: PySide6.QtWidgets.QStyleOption, p: PySide6.QtGui.QPainter, /, w: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def drawPrimitive(self, pe: PySide6.QtWidgets.QStyle.PrimitiveElement, opt: PySide6.QtWidgets.QStyleOption, p: PySide6.QtGui.QPainter, /, w: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def generatedIconPixmap(self, iconMode: PySide6.QtGui.QIcon.Mode, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, opt: PySide6.QtWidgets.QStyleOption, /) -> PySide6.QtGui.QPixmap: ...
    def hitTestComplexControl(self, cc: PySide6.QtWidgets.QStyle.ComplexControl, opt: PySide6.QtWidgets.QStyleOptionComplex, pt: PySide6.QtCore.QPoint, /, w: PySide6.QtWidgets.QWidget | None = ...) -> PySide6.QtWidgets.QStyle.SubControl: ...
    def layoutSpacing(self, control1: PySide6.QtWidgets.QSizePolicy.ControlType, control2: PySide6.QtWidgets.QSizePolicy.ControlType, orientation: PySide6.QtCore.Qt.Orientation, /, option: PySide6.QtWidgets.QStyleOption | None = ..., widget: PySide6.QtWidgets.QWidget | None = ...) -> int: ...
    def pixelMetric(self, m: PySide6.QtWidgets.QStyle.PixelMetric, /, opt: PySide6.QtWidgets.QStyleOption | None = ..., widget: PySide6.QtWidgets.QWidget | None = ...) -> int: ...
    @typing.overload
    def polish(self, app: PySide6.QtWidgets.QApplication, /) -> None: ...
    @typing.overload
    def polish(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    @typing.overload
    def polish(self, palette: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, /) -> None: ...
    def sizeFromContents(self, ct: PySide6.QtWidgets.QStyle.ContentsType, opt: PySide6.QtWidgets.QStyleOption, contentsSize: PySide6.QtCore.QSize, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> PySide6.QtCore.QSize: ...
    def standardIcon(self, standardIcon: PySide6.QtWidgets.QStyle.StandardPixmap, /, opt: PySide6.QtWidgets.QStyleOption | None = ..., widget: PySide6.QtWidgets.QWidget | None = ...) -> PySide6.QtGui.QIcon: ...
    def standardPixmap(self, sp: PySide6.QtWidgets.QStyle.StandardPixmap, /, opt: PySide6.QtWidgets.QStyleOption | None = ..., widget: PySide6.QtWidgets.QWidget | None = ...) -> PySide6.QtGui.QPixmap: ...
    def styleHint(self, sh: PySide6.QtWidgets.QStyle.StyleHint, /, opt: PySide6.QtWidgets.QStyleOption | None = ..., w: PySide6.QtWidgets.QWidget | None = ..., shret: PySide6.QtWidgets.QStyleHintReturn | None = ...) -> int: ...
    def subControlRect(self, cc: PySide6.QtWidgets.QStyle.ComplexControl, opt: PySide6.QtWidgets.QStyleOptionComplex, sc: PySide6.QtWidgets.QStyle.SubControl, /, w: PySide6.QtWidgets.QWidget | None = ...) -> PySide6.QtCore.QRect: ...
    def subElementRect(self, r: PySide6.QtWidgets.QStyle.SubElement, opt: PySide6.QtWidgets.QStyleOption, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> PySide6.QtCore.QRect: ...
    @typing.overload
    def unpolish(self, application: PySide6.QtWidgets.QApplication, /) -> None: ...
    @typing.overload
    def unpolish(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...


class QCompleter(PySide6.QtCore.QObject):

    activated                : typing.ClassVar[Signal] = ... # activated(QString); activated(QModelIndex)
    highlighted              : typing.ClassVar[Signal] = ... # highlighted(QString); highlighted(QModelIndex)

    class CompletionMode(enum.Enum):

        PopupCompletion           = ...  # 0x0
        UnfilteredPopupCompletion = ...  # 0x1
        InlineCompletion          = ...  # 0x2

    class ModelSorting(enum.Enum):

        UnsortedModel             = ...  # 0x0
        CaseSensitivelySortedModel = ...  # 0x1
        CaseInsensitivelySortedModel = ...  # 0x2


    @typing.overload
    def __init__(self, model: PySide6.QtCore.QAbstractItemModel, /, parent: PySide6.QtCore.QObject | None = ..., *, completionPrefix: str | None = ..., modelSorting: PySide6.QtWidgets.QCompleter.ModelSorting | None = ..., filterMode: PySide6.QtCore.Qt.MatchFlag | None = ..., completionMode: PySide6.QtWidgets.QCompleter.CompletionMode | None = ..., completionColumn: int | None = ..., completionRole: int | None = ..., maxVisibleItems: int | None = ..., caseSensitivity: PySide6.QtCore.Qt.CaseSensitivity | None = ..., wrapAround: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, completions: collections.abc.Sequence[str], /, parent: PySide6.QtCore.QObject | None = ..., *, completionPrefix: str | None = ..., modelSorting: PySide6.QtWidgets.QCompleter.ModelSorting | None = ..., filterMode: PySide6.QtCore.Qt.MatchFlag | None = ..., completionMode: PySide6.QtWidgets.QCompleter.CompletionMode | None = ..., completionColumn: int | None = ..., completionRole: int | None = ..., maxVisibleItems: int | None = ..., caseSensitivity: PySide6.QtCore.Qt.CaseSensitivity | None = ..., wrapAround: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, completionPrefix: str | None = ..., modelSorting: PySide6.QtWidgets.QCompleter.ModelSorting | None = ..., filterMode: PySide6.QtCore.Qt.MatchFlag | None = ..., completionMode: PySide6.QtWidgets.QCompleter.CompletionMode | None = ..., completionColumn: int | None = ..., completionRole: int | None = ..., maxVisibleItems: int | None = ..., caseSensitivity: PySide6.QtCore.Qt.CaseSensitivity | None = ..., wrapAround: bool | None = ...) -> None: ...

    def caseSensitivity(self, /) -> PySide6.QtCore.Qt.CaseSensitivity: ...
    def complete(self, /, rect: PySide6.QtCore.QRect = ...) -> None: ...
    def completionColumn(self, /) -> int: ...
    def completionCount(self, /) -> int: ...
    def completionMode(self, /) -> PySide6.QtWidgets.QCompleter.CompletionMode: ...
    def completionModel(self, /) -> PySide6.QtCore.QAbstractItemModel: ...
    def completionPrefix(self, /) -> str: ...
    def completionRole(self, /) -> int: ...
    def currentCompletion(self, /) -> str: ...
    def currentIndex(self, /) -> PySide6.QtCore.QModelIndex: ...
    def currentRow(self, /) -> int: ...
    def event(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    def eventFilter(self, o: PySide6.QtCore.QObject, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def filterMode(self, /) -> PySide6.QtCore.Qt.MatchFlag: ...
    def maxVisibleItems(self, /) -> int: ...
    def model(self, /) -> PySide6.QtCore.QAbstractItemModel: ...
    def modelSorting(self, /) -> PySide6.QtWidgets.QCompleter.ModelSorting: ...
    def pathFromIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> str: ...
    def popup(self, /) -> PySide6.QtWidgets.QAbstractItemView: ...
    def setCaseSensitivity(self, caseSensitivity: PySide6.QtCore.Qt.CaseSensitivity, /) -> None: ...
    def setCompletionColumn(self, column: int, /) -> None: ...
    def setCompletionMode(self, mode: PySide6.QtWidgets.QCompleter.CompletionMode, /) -> None: ...
    def setCompletionPrefix(self, prefix: str, /) -> None: ...
    def setCompletionRole(self, role: int, /) -> None: ...
    def setCurrentRow(self, row: int, /) -> bool: ...
    def setFilterMode(self, filterMode: PySide6.QtCore.Qt.MatchFlag, /) -> None: ...
    def setMaxVisibleItems(self, maxItems: int, /) -> None: ...
    def setModel(self, c: PySide6.QtCore.QAbstractItemModel, /) -> None: ...
    def setModelSorting(self, sorting: PySide6.QtWidgets.QCompleter.ModelSorting, /) -> None: ...
    def setPopup(self, popup: PySide6.QtWidgets.QAbstractItemView, /) -> None: ...
    def setWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setWrapAround(self, wrap: bool, /) -> None: ...
    def splitPath(self, path: str, /) -> typing.List[str]: ...
    def widget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def wrapAround(self, /) -> bool: ...


class QDataWidgetMapper(PySide6.QtCore.QObject):

    currentIndexChanged      : typing.ClassVar[Signal] = ... # currentIndexChanged(int)

    class SubmitPolicy(enum.Enum):

        AutoSubmit                = ...  # 0x0
        ManualSubmit              = ...  # 0x1


    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, currentIndex: int | None = ..., orientation: PySide6.QtCore.Qt.Orientation | None = ..., submitPolicy: PySide6.QtWidgets.QDataWidgetMapper.SubmitPolicy | None = ...) -> None: ...

    @typing.overload
    def addMapping(self, widget: PySide6.QtWidgets.QWidget, section: int, /) -> None: ...
    @typing.overload
    def addMapping(self, widget: PySide6.QtWidgets.QWidget, section: int, propertyName: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...
    def clearMapping(self, /) -> None: ...
    def currentIndex(self, /) -> int: ...
    def itemDelegate(self, /) -> PySide6.QtWidgets.QAbstractItemDelegate: ...
    def mappedPropertyName(self, widget: PySide6.QtWidgets.QWidget, /) -> PySide6.QtCore.QByteArray: ...
    def mappedSection(self, widget: PySide6.QtWidgets.QWidget, /) -> int: ...
    def mappedWidgetAt(self, section: int, /) -> PySide6.QtWidgets.QWidget: ...
    def model(self, /) -> PySide6.QtCore.QAbstractItemModel: ...
    def orientation(self, /) -> PySide6.QtCore.Qt.Orientation: ...
    def removeMapping(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def revert(self, /) -> None: ...
    def rootIndex(self, /) -> PySide6.QtCore.QModelIndex: ...
    def setCurrentIndex(self, index: int, /) -> None: ...
    def setCurrentModelIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def setItemDelegate(self, delegate: PySide6.QtWidgets.QAbstractItemDelegate, /) -> None: ...
    def setModel(self, model: PySide6.QtCore.QAbstractItemModel, /) -> None: ...
    def setOrientation(self, aOrientation: PySide6.QtCore.Qt.Orientation, /) -> None: ...
    def setRootIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def setSubmitPolicy(self, policy: PySide6.QtWidgets.QDataWidgetMapper.SubmitPolicy, /) -> None: ...
    def submit(self, /) -> bool: ...
    def submitPolicy(self, /) -> PySide6.QtWidgets.QDataWidgetMapper.SubmitPolicy: ...
    def toFirst(self, /) -> None: ...
    def toLast(self, /) -> None: ...
    def toNext(self, /) -> None: ...
    def toPrevious(self, /) -> None: ...


class QDateEdit(PySide6.QtWidgets.QDateTimeEdit):

    userDateChanged          : typing.ClassVar[Signal] = ... # userDateChanged(QDate)

    @typing.overload
    def __init__(self, date: PySide6.QtCore.QDate, /, parent: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, date: PySide6.QtCore.QDate | None = ...) -> None: ...


class QDateTimeEdit(PySide6.QtWidgets.QAbstractSpinBox):

    dateChanged              : typing.ClassVar[Signal] = ... # dateChanged(QDate)
    dateTimeChanged          : typing.ClassVar[Signal] = ... # dateTimeChanged(QDateTime)
    timeChanged              : typing.ClassVar[Signal] = ... # timeChanged(QTime)

    class Section(enum.Flag):

        NoSection                 = ...  # 0x0
        AmPmSection               = ...  # 0x1
        MSecSection               = ...  # 0x2
        SecondSection             = ...  # 0x4
        MinuteSection             = ...  # 0x8
        HourSection               = ...  # 0x10
        TimeSections_Mask         = ...  # 0x1f
        DaySection                = ...  # 0x100
        MonthSection              = ...  # 0x200
        YearSection               = ...  # 0x400
        DateSections_Mask         = ...  # 0x700


    @typing.overload
    def __init__(self, d: PySide6.QtCore.QDate, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, dateTime: PySide6.QtCore.QDateTime | None = ..., date: PySide6.QtCore.QDate | None = ..., time: PySide6.QtCore.QTime | None = ..., maximumDateTime: PySide6.QtCore.QDateTime | None = ..., minimumDateTime: PySide6.QtCore.QDateTime | None = ..., maximumDate: PySide6.QtCore.QDate | None = ..., minimumDate: PySide6.QtCore.QDate | None = ..., maximumTime: PySide6.QtCore.QTime | None = ..., minimumTime: PySide6.QtCore.QTime | None = ..., currentSection: PySide6.QtWidgets.QDateTimeEdit.Section | None = ..., displayedSections: PySide6.QtWidgets.QDateTimeEdit.Section | None = ..., displayFormat: str | None = ..., calendarPopup: bool | None = ..., currentSectionIndex: int | None = ..., sectionCount: int | None = ..., timeSpec: PySide6.QtCore.Qt.TimeSpec | None = ..., timeZone: PySide6.QtCore.QTimeZone | None = ...) -> None: ...
    @typing.overload
    def __init__(self, dt: PySide6.QtCore.QDateTime, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, dateTime: PySide6.QtCore.QDateTime | None = ..., date: PySide6.QtCore.QDate | None = ..., time: PySide6.QtCore.QTime | None = ..., maximumDateTime: PySide6.QtCore.QDateTime | None = ..., minimumDateTime: PySide6.QtCore.QDateTime | None = ..., maximumDate: PySide6.QtCore.QDate | None = ..., minimumDate: PySide6.QtCore.QDate | None = ..., maximumTime: PySide6.QtCore.QTime | None = ..., minimumTime: PySide6.QtCore.QTime | None = ..., currentSection: PySide6.QtWidgets.QDateTimeEdit.Section | None = ..., displayedSections: PySide6.QtWidgets.QDateTimeEdit.Section | None = ..., displayFormat: str | None = ..., calendarPopup: bool | None = ..., currentSectionIndex: int | None = ..., sectionCount: int | None = ..., timeSpec: PySide6.QtCore.Qt.TimeSpec | None = ..., timeZone: PySide6.QtCore.QTimeZone | None = ...) -> None: ...
    @typing.overload
    def __init__(self, t: PySide6.QtCore.QTime, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, dateTime: PySide6.QtCore.QDateTime | None = ..., date: PySide6.QtCore.QDate | None = ..., time: PySide6.QtCore.QTime | None = ..., maximumDateTime: PySide6.QtCore.QDateTime | None = ..., minimumDateTime: PySide6.QtCore.QDateTime | None = ..., maximumDate: PySide6.QtCore.QDate | None = ..., minimumDate: PySide6.QtCore.QDate | None = ..., maximumTime: PySide6.QtCore.QTime | None = ..., minimumTime: PySide6.QtCore.QTime | None = ..., currentSection: PySide6.QtWidgets.QDateTimeEdit.Section | None = ..., displayedSections: PySide6.QtWidgets.QDateTimeEdit.Section | None = ..., displayFormat: str | None = ..., calendarPopup: bool | None = ..., currentSectionIndex: int | None = ..., sectionCount: int | None = ..., timeSpec: PySide6.QtCore.Qt.TimeSpec | None = ..., timeZone: PySide6.QtCore.QTimeZone | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, dateTime: PySide6.QtCore.QDateTime | None = ..., date: PySide6.QtCore.QDate | None = ..., time: PySide6.QtCore.QTime | None = ..., maximumDateTime: PySide6.QtCore.QDateTime | None = ..., minimumDateTime: PySide6.QtCore.QDateTime | None = ..., maximumDate: PySide6.QtCore.QDate | None = ..., minimumDate: PySide6.QtCore.QDate | None = ..., maximumTime: PySide6.QtCore.QTime | None = ..., minimumTime: PySide6.QtCore.QTime | None = ..., currentSection: PySide6.QtWidgets.QDateTimeEdit.Section | None = ..., displayedSections: PySide6.QtWidgets.QDateTimeEdit.Section | None = ..., displayFormat: str | None = ..., calendarPopup: bool | None = ..., currentSectionIndex: int | None = ..., sectionCount: int | None = ..., timeSpec: PySide6.QtCore.Qt.TimeSpec | None = ..., timeZone: PySide6.QtCore.QTimeZone | None = ...) -> None: ...
    @typing.overload
    def __init__(self, val: typing.Any, parserType: PySide6.QtCore.QMetaType.Type, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, dateTime: PySide6.QtCore.QDateTime | None = ..., date: PySide6.QtCore.QDate | None = ..., time: PySide6.QtCore.QTime | None = ..., maximumDateTime: PySide6.QtCore.QDateTime | None = ..., minimumDateTime: PySide6.QtCore.QDateTime | None = ..., maximumDate: PySide6.QtCore.QDate | None = ..., minimumDate: PySide6.QtCore.QDate | None = ..., maximumTime: PySide6.QtCore.QTime | None = ..., minimumTime: PySide6.QtCore.QTime | None = ..., currentSection: PySide6.QtWidgets.QDateTimeEdit.Section | None = ..., displayedSections: PySide6.QtWidgets.QDateTimeEdit.Section | None = ..., displayFormat: str | None = ..., calendarPopup: bool | None = ..., currentSectionIndex: int | None = ..., sectionCount: int | None = ..., timeSpec: PySide6.QtCore.Qt.TimeSpec | None = ..., timeZone: PySide6.QtCore.QTimeZone | None = ...) -> None: ...

    def calendar(self, /) -> PySide6.QtCore.QCalendar: ...
    def calendarPopup(self, /) -> bool: ...
    def calendarWidget(self, /) -> PySide6.QtWidgets.QCalendarWidget: ...
    def clear(self, /) -> None: ...
    def clearMaximumDate(self, /) -> None: ...
    def clearMaximumDateTime(self, /) -> None: ...
    def clearMaximumTime(self, /) -> None: ...
    def clearMinimumDate(self, /) -> None: ...
    def clearMinimumDateTime(self, /) -> None: ...
    def clearMinimumTime(self, /) -> None: ...
    def currentSection(self, /) -> PySide6.QtWidgets.QDateTimeEdit.Section: ...
    def currentSectionIndex(self, /) -> int: ...
    def date(self, /) -> PySide6.QtCore.QDate: ...
    def dateTime(self, /) -> PySide6.QtCore.QDateTime: ...
    def dateTimeFromText(self, text: str, /) -> PySide6.QtCore.QDateTime: ...
    def displayFormat(self, /) -> str: ...
    def displayedSections(self, /) -> PySide6.QtWidgets.QDateTimeEdit.Section: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def fixup(self, input: str, /) -> str: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusNextPrevChild(self, next: bool, /) -> bool: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionSpinBox, /) -> None: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def maximumDate(self, /) -> PySide6.QtCore.QDate: ...
    def maximumDateTime(self, /) -> PySide6.QtCore.QDateTime: ...
    def maximumTime(self, /) -> PySide6.QtCore.QTime: ...
    def minimumDate(self, /) -> PySide6.QtCore.QDate: ...
    def minimumDateTime(self, /) -> PySide6.QtCore.QDateTime: ...
    def minimumTime(self, /) -> PySide6.QtCore.QTime: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def sectionAt(self, index: int, /) -> PySide6.QtWidgets.QDateTimeEdit.Section: ...
    def sectionCount(self, /) -> int: ...
    def sectionText(self, section: PySide6.QtWidgets.QDateTimeEdit.Section, /) -> str: ...
    def setCalendar(self, calendar: PySide6.QtCore.QCalendar, /) -> None: ...
    def setCalendarPopup(self, enable: bool, /) -> None: ...
    def setCalendarWidget(self, calendarWidget: PySide6.QtWidgets.QCalendarWidget, /) -> None: ...
    def setCurrentSection(self, section: PySide6.QtWidgets.QDateTimeEdit.Section, /) -> None: ...
    def setCurrentSectionIndex(self, index: int, /) -> None: ...
    def setDate(self, date: PySide6.QtCore.QDate, /) -> None: ...
    def setDateRange(self, min: PySide6.QtCore.QDate, max: PySide6.QtCore.QDate, /) -> None: ...
    def setDateTime(self, dateTime: PySide6.QtCore.QDateTime, /) -> None: ...
    def setDateTimeRange(self, min: PySide6.QtCore.QDateTime, max: PySide6.QtCore.QDateTime, /) -> None: ...
    def setDisplayFormat(self, format: str, /) -> None: ...
    def setMaximumDate(self, max: PySide6.QtCore.QDate, /) -> None: ...
    def setMaximumDateTime(self, dt: PySide6.QtCore.QDateTime, /) -> None: ...
    def setMaximumTime(self, max: PySide6.QtCore.QTime, /) -> None: ...
    def setMinimumDate(self, min: PySide6.QtCore.QDate, /) -> None: ...
    def setMinimumDateTime(self, dt: PySide6.QtCore.QDateTime, /) -> None: ...
    def setMinimumTime(self, min: PySide6.QtCore.QTime, /) -> None: ...
    def setSelectedSection(self, section: PySide6.QtWidgets.QDateTimeEdit.Section, /) -> None: ...
    def setTime(self, time: PySide6.QtCore.QTime, /) -> None: ...
    def setTimeRange(self, min: PySide6.QtCore.QTime, max: PySide6.QtCore.QTime, /) -> None: ...
    def setTimeSpec(self, spec: PySide6.QtCore.Qt.TimeSpec, /) -> None: ...
    def setTimeZone(self, zone: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def stepBy(self, steps: int, /) -> None: ...
    def stepEnabled(self, /) -> PySide6.QtWidgets.QAbstractSpinBox.StepEnabledFlag: ...
    def textFromDateTime(self, dt: PySide6.QtCore.QDateTime, /) -> str: ...
    def time(self, /) -> PySide6.QtCore.QTime: ...
    def timeSpec(self, /) -> PySide6.QtCore.Qt.TimeSpec: ...
    def timeZone(self, /) -> PySide6.QtCore.QTimeZone: ...
    def validate(self, input: str, pos: int, /) -> object: ...
    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent, /) -> None: ...


class QDial(PySide6.QtWidgets.QAbstractSlider):

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, wrapping: bool | None = ..., notchSize: int | None = ..., notchTarget: float | None = ..., notchesVisible: bool | None = ...) -> None: ...

    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionSlider, /) -> None: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def mouseMoveEvent(self, me: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, me: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, me: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def notchSize(self, /) -> int: ...
    def notchTarget(self, /) -> float: ...
    def notchesVisible(self, /) -> bool: ...
    def paintEvent(self, pe: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def resizeEvent(self, re: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def setNotchTarget(self, target: float, /) -> None: ...
    def setNotchesVisible(self, visible: bool, /) -> None: ...
    def setWrapping(self, on: bool, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def sliderChange(self, change: PySide6.QtWidgets.QAbstractSlider.SliderChange, /) -> None: ...
    def wrapping(self, /) -> bool: ...


class QDialog(PySide6.QtWidgets.QWidget):

    accepted                 : typing.ClassVar[Signal] = ... # accepted()
    finished                 : typing.ClassVar[Signal] = ... # finished(int)
    rejected                 : typing.ClassVar[Signal] = ... # rejected()

    class DialogCode(enum.IntEnum):

        Rejected                  = ...  # 0x0
        Accepted                  = ...  # 0x1


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., f: PySide6.QtCore.Qt.WindowType = ..., *, sizeGripEnabled: bool | None = ..., modal: bool | None = ...) -> None: ...

    def accept(self, /) -> None: ...
    def adjustPosition(self, arg__1: PySide6.QtWidgets.QWidget, /) -> None: ...
    def closeEvent(self, arg__1: PySide6.QtGui.QCloseEvent, /) -> None: ...
    def contextMenuEvent(self, arg__1: PySide6.QtGui.QContextMenuEvent, /) -> None: ...
    def done(self, arg__1: int, /) -> None: ...
    def eventFilter(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent, /) -> bool: ...
    def exec(self, /) -> int: ...
    def exec_(self, /) -> int: ...
    def isSizeGripEnabled(self, /) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def open(self, /) -> None: ...
    def reject(self, /) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def result(self, /) -> int: ...
    def setModal(self, modal: bool, /) -> None: ...
    def setResult(self, r: int, /) -> None: ...
    def setSizeGripEnabled(self, arg__1: bool, /) -> None: ...
    def setVisible(self, visible: bool, /) -> None: ...
    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...


class QDialogButtonBox(PySide6.QtWidgets.QWidget):

    accepted                 : typing.ClassVar[Signal] = ... # accepted()
    clicked                  : typing.ClassVar[Signal] = ... # clicked(QAbstractButton*)
    helpRequested            : typing.ClassVar[Signal] = ... # helpRequested()
    rejected                 : typing.ClassVar[Signal] = ... # rejected()

    class ButtonLayout(enum.Enum):

        WinLayout                 = ...  # 0x0
        MacLayout                 = ...  # 0x1
        KdeLayout                 = ...  # 0x2
        GnomeLayout               = ...  # 0x3
        AndroidLayout             = ...  # 0x4

    class ButtonRole(enum.Enum):

        InvalidRole               = ...  # -1
        AcceptRole                = ...  # 0x0
        RejectRole                = ...  # 0x1
        DestructiveRole           = ...  # 0x2
        ActionRole                = ...  # 0x3
        HelpRole                  = ...  # 0x4
        YesRole                   = ...  # 0x5
        NoRole                    = ...  # 0x6
        ResetRole                 = ...  # 0x7
        ApplyRole                 = ...  # 0x8
        NRoles                    = ...  # 0x9

    class StandardButton(enum.Flag):

        NoButton                  = ...  # 0x0
        FirstButton               = ...  # 0x400
        Ok                        = ...  # 0x400
        Save                      = ...  # 0x800
        SaveAll                   = ...  # 0x1000
        Open                      = ...  # 0x2000
        Yes                       = ...  # 0x4000
        YesToAll                  = ...  # 0x8000
        No                        = ...  # 0x10000
        NoToAll                   = ...  # 0x20000
        Abort                     = ...  # 0x40000
        Retry                     = ...  # 0x80000
        Ignore                    = ...  # 0x100000
        Close                     = ...  # 0x200000
        Cancel                    = ...  # 0x400000
        Discard                   = ...  # 0x800000
        Help                      = ...  # 0x1000000
        Apply                     = ...  # 0x2000000
        Reset                     = ...  # 0x4000000
        LastButton                = ...  # 0x8000000
        RestoreDefaults           = ...  # 0x8000000


    @typing.overload
    def __init__(self, orientation: PySide6.QtCore.Qt.Orientation, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, standardButtons: PySide6.QtWidgets.QDialogButtonBox.StandardButton | None = ..., centerButtons: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, buttons: PySide6.QtWidgets.QDialogButtonBox.StandardButton, orientation: PySide6.QtCore.Qt.Orientation, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, standardButtons: PySide6.QtWidgets.QDialogButtonBox.StandardButton | None = ..., centerButtons: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, buttons: PySide6.QtWidgets.QDialogButtonBox.StandardButton, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, orientation: PySide6.QtCore.Qt.Orientation | None = ..., standardButtons: PySide6.QtWidgets.QDialogButtonBox.StandardButton | None = ..., centerButtons: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, orientation: PySide6.QtCore.Qt.Orientation | None = ..., standardButtons: PySide6.QtWidgets.QDialogButtonBox.StandardButton | None = ..., centerButtons: bool | None = ...) -> None: ...

    @typing.overload
    def addButton(self, button: PySide6.QtWidgets.QAbstractButton, role: PySide6.QtWidgets.QDialogButtonBox.ButtonRole, /) -> None: ...
    @typing.overload
    def addButton(self, button: PySide6.QtWidgets.QDialogButtonBox.StandardButton, /) -> PySide6.QtWidgets.QPushButton: ...
    @typing.overload
    def addButton(self, text: str, role: PySide6.QtWidgets.QDialogButtonBox.ButtonRole, /) -> PySide6.QtWidgets.QPushButton: ...
    def button(self, which: PySide6.QtWidgets.QDialogButtonBox.StandardButton, /) -> PySide6.QtWidgets.QPushButton: ...
    def buttonRole(self, button: PySide6.QtWidgets.QAbstractButton, /) -> PySide6.QtWidgets.QDialogButtonBox.ButtonRole: ...
    def buttons(self, /) -> typing.List[PySide6.QtWidgets.QAbstractButton]: ...
    def centerButtons(self, /) -> bool: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def clear(self, /) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def orientation(self, /) -> PySide6.QtCore.Qt.Orientation: ...
    def removeButton(self, button: PySide6.QtWidgets.QAbstractButton, /) -> None: ...
    def setCenterButtons(self, center: bool, /) -> None: ...
    def setOrientation(self, orientation: PySide6.QtCore.Qt.Orientation, /) -> None: ...
    def setStandardButtons(self, buttons: PySide6.QtWidgets.QDialogButtonBox.StandardButton, /) -> None: ...
    def standardButton(self, button: PySide6.QtWidgets.QAbstractButton, /) -> PySide6.QtWidgets.QDialogButtonBox.StandardButton: ...
    def standardButtons(self, /) -> PySide6.QtWidgets.QDialogButtonBox.StandardButton: ...


class QDockWidget(PySide6.QtWidgets.QWidget):

    allowedAreasChanged      : typing.ClassVar[Signal] = ... # allowedAreasChanged(Qt::DockWidgetAreas)
    dockLocationChanged      : typing.ClassVar[Signal] = ... # dockLocationChanged(Qt::DockWidgetArea)
    featuresChanged          : typing.ClassVar[Signal] = ... # featuresChanged(QDockWidget::DockWidgetFeatures)
    topLevelChanged          : typing.ClassVar[Signal] = ... # topLevelChanged(bool)
    visibilityChanged        : typing.ClassVar[Signal] = ... # visibilityChanged(bool)

    class DockWidgetFeature(enum.Flag):

        NoDockWidgetFeatures      = ...  # 0x0
        DockWidgetClosable        = ...  # 0x1
        DockWidgetMovable         = ...  # 0x2
        DockWidgetFloatable       = ...  # 0x4
        DockWidgetVerticalTitleBar = ...  # 0x8
        DockWidgetFeatureMask     = ...  # 0xf
        Reserved                  = ...  # 0xff


    @typing.overload
    def __init__(self, title: str, /, parent: PySide6.QtWidgets.QWidget | None = ..., flags: PySide6.QtCore.Qt.WindowType = ..., *, floating: bool | None = ..., features: PySide6.QtWidgets.QDockWidget.DockWidgetFeature | None = ..., allowedAreas: PySide6.QtCore.Qt.DockWidgetArea | None = ..., windowTitle: str | None = ..., dockLocation: PySide6.QtCore.Qt.DockWidgetArea | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., flags: PySide6.QtCore.Qt.WindowType = ..., *, floating: bool | None = ..., features: PySide6.QtWidgets.QDockWidget.DockWidgetFeature | None = ..., allowedAreas: PySide6.QtCore.Qt.DockWidgetArea | None = ..., windowTitle: str | None = ..., dockLocation: PySide6.QtCore.Qt.DockWidgetArea | None = ...) -> None: ...

    def allowedAreas(self, /) -> PySide6.QtCore.Qt.DockWidgetArea: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def closeEvent(self, event: PySide6.QtGui.QCloseEvent, /) -> None: ...
    def dockLocation(self, /) -> PySide6.QtCore.Qt.DockWidgetArea: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def features(self, /) -> PySide6.QtWidgets.QDockWidget.DockWidgetFeature: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionDockWidget, /) -> None: ...
    def isAreaAllowed(self, area: PySide6.QtCore.Qt.DockWidgetArea, /) -> bool: ...
    def isFloating(self, /) -> bool: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def setAllowedAreas(self, areas: PySide6.QtCore.Qt.DockWidgetArea, /) -> None: ...
    def setDockLocation(self, area: PySide6.QtCore.Qt.DockWidgetArea, /) -> None: ...
    def setFeatures(self, features: PySide6.QtWidgets.QDockWidget.DockWidgetFeature, /) -> None: ...
    def setFloating(self, floating: bool, /) -> None: ...
    def setTitleBarWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def titleBarWidget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def toggleViewAction(self, /) -> PySide6.QtGui.QAction: ...
    def widget(self, /) -> PySide6.QtWidgets.QWidget: ...


class QDoubleSpinBox(PySide6.QtWidgets.QAbstractSpinBox):

    textChanged              : typing.ClassVar[Signal] = ... # textChanged(QString)
    valueChanged             : typing.ClassVar[Signal] = ... # valueChanged(double)

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, prefix: str | None = ..., suffix: str | None = ..., cleanText: str | None = ..., decimals: int | None = ..., minimum: float | None = ..., maximum: float | None = ..., singleStep: float | None = ..., stepType: PySide6.QtWidgets.QAbstractSpinBox.StepType | None = ..., value: float | None = ...) -> None: ...

    def cleanText(self, /) -> str: ...
    def decimals(self, /) -> int: ...
    def fixup(self, str: str, /) -> str: ...
    def maximum(self, /) -> float: ...
    def minimum(self, /) -> float: ...
    def prefix(self, /) -> str: ...
    def setDecimals(self, prec: int, /) -> None: ...
    def setMaximum(self, max: float, /) -> None: ...
    def setMinimum(self, min: float, /) -> None: ...
    def setPrefix(self, prefix: str, /) -> None: ...
    def setRange(self, min: float, max: float, /) -> None: ...
    def setSingleStep(self, val: float, /) -> None: ...
    def setStepType(self, stepType: PySide6.QtWidgets.QAbstractSpinBox.StepType, /) -> None: ...
    def setSuffix(self, suffix: str, /) -> None: ...
    def setValue(self, val: float, /) -> None: ...
    def singleStep(self, /) -> float: ...
    def stepType(self, /) -> PySide6.QtWidgets.QAbstractSpinBox.StepType: ...
    def suffix(self, /) -> str: ...
    def textFromValue(self, val: float, /) -> str: ...
    def validate(self, input: str, pos: int, /) -> object: ...
    def value(self, /) -> float: ...
    def valueFromText(self, text: str, /) -> float: ...


class QErrorMessage(PySide6.QtWidgets.QDialog):

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ...) -> None: ...

    def changeEvent(self, e: PySide6.QtCore.QEvent, /) -> None: ...
    def done(self, arg__1: int, /) -> None: ...
    @staticmethod
    def qtHandler() -> PySide6.QtWidgets.QErrorMessage: ...
    @typing.overload
    def showMessage(self, message: str, /) -> None: ...
    @typing.overload
    def showMessage(self, message: str, type: str, /) -> None: ...


class QFileDialog(PySide6.QtWidgets.QDialog):

    currentChanged           : typing.ClassVar[Signal] = ... # currentChanged(QString)
    currentUrlChanged        : typing.ClassVar[Signal] = ... # currentUrlChanged(QUrl)
    directoryEntered         : typing.ClassVar[Signal] = ... # directoryEntered(QString)
    directoryUrlEntered      : typing.ClassVar[Signal] = ... # directoryUrlEntered(QUrl)
    fileSelected             : typing.ClassVar[Signal] = ... # fileSelected(QString)
    filesSelected            : typing.ClassVar[Signal] = ... # filesSelected(QStringList)
    filterSelected           : typing.ClassVar[Signal] = ... # filterSelected(QString)
    urlSelected              : typing.ClassVar[Signal] = ... # urlSelected(QUrl)
    urlsSelected             : typing.ClassVar[Signal] = ... # urlsSelected(QList<QUrl>)

    class AcceptMode(enum.Enum):

        AcceptOpen                = ...  # 0x0
        AcceptSave                = ...  # 0x1

    class DialogLabel(enum.Enum):

        LookIn                    = ...  # 0x0
        FileName                  = ...  # 0x1
        FileType                  = ...  # 0x2
        Accept                    = ...  # 0x3
        Reject                    = ...  # 0x4

    class FileMode(enum.Enum):

        AnyFile                   = ...  # 0x0
        ExistingFile              = ...  # 0x1
        Directory                 = ...  # 0x2
        ExistingFiles             = ...  # 0x3

    class Option(enum.Flag):

        ShowDirsOnly              = ...  # 0x1
        DontResolveSymlinks       = ...  # 0x2
        DontConfirmOverwrite      = ...  # 0x4
        DontUseNativeDialog       = ...  # 0x8
        ReadOnly                  = ...  # 0x10
        HideNameFilterDetails     = ...  # 0x20
        DontUseCustomDirectoryIcons = ...  # 0x40

    class ViewMode(enum.Enum):

        Detail                    = ...  # 0x0
        List                      = ...  # 0x1


    @typing.overload
    def __init__(self, parent: PySide6.QtWidgets.QWidget, f: PySide6.QtCore.Qt.WindowType, /, *, viewMode: PySide6.QtWidgets.QFileDialog.ViewMode | None = ..., fileMode: PySide6.QtWidgets.QFileDialog.FileMode | None = ..., acceptMode: PySide6.QtWidgets.QFileDialog.AcceptMode | None = ..., defaultSuffix: str | None = ..., options: PySide6.QtGui.QAbstractFileIconProvider.Option | None = ..., supportedSchemes: collections.abc.Sequence[str] | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., caption: str = ..., directory: str = ..., filter: str = ..., *, viewMode: PySide6.QtWidgets.QFileDialog.ViewMode | None = ..., fileMode: PySide6.QtWidgets.QFileDialog.FileMode | None = ..., acceptMode: PySide6.QtWidgets.QFileDialog.AcceptMode | None = ..., defaultSuffix: str | None = ..., options: PySide6.QtGui.QAbstractFileIconProvider.Option | None = ..., supportedSchemes: collections.abc.Sequence[str] | None = ...) -> None: ...

    def accept(self, /) -> None: ...
    def acceptMode(self, /) -> PySide6.QtWidgets.QFileDialog.AcceptMode: ...
    def changeEvent(self, e: PySide6.QtCore.QEvent, /) -> None: ...
    def defaultSuffix(self, /) -> str: ...
    def directory(self, /) -> PySide6.QtCore.QDir: ...
    def directoryUrl(self, /) -> PySide6.QtCore.QUrl: ...
    def done(self, result: int, /) -> None: ...
    def fileMode(self, /) -> PySide6.QtWidgets.QFileDialog.FileMode: ...
    def filter(self, /) -> PySide6.QtCore.QDir.Filter: ...
    @staticmethod
    def getExistingDirectory(parent: PySide6.QtWidgets.QWidget | None = ..., caption: str = ..., dir: str = ..., options: PySide6.QtWidgets.QFileDialog.Option = ...) -> str: ...
    @staticmethod
    def getExistingDirectoryUrl(parent: PySide6.QtWidgets.QWidget | None = ..., caption: str = ..., dir: PySide6.QtCore.QUrl | str = ..., options: PySide6.QtWidgets.QFileDialog.Option = ..., supportedSchemes: collections.abc.Sequence[str] = ...) -> PySide6.QtCore.QUrl: ...
    @staticmethod
    def getOpenFileName(parent: PySide6.QtWidgets.QWidget | None = ..., caption: str = ..., dir: str = ..., filter: str = ..., selectedFilter: str = ..., options: PySide6.QtWidgets.QFileDialog.Option = ...) -> typing.Tuple[str, str]: ...
    @staticmethod
    def getOpenFileNames(parent: PySide6.QtWidgets.QWidget | None = ..., caption: str = ..., dir: str = ..., filter: str = ..., selectedFilter: str = ..., options: PySide6.QtWidgets.QFileDialog.Option = ...) -> typing.Tuple[typing.List[str], str]: ...
    @staticmethod
    def getOpenFileUrl(parent: PySide6.QtWidgets.QWidget | None = ..., caption: str = ..., dir: PySide6.QtCore.QUrl | str = ..., filter: str = ..., selectedFilter: str = ..., options: PySide6.QtWidgets.QFileDialog.Option = ..., supportedSchemes: collections.abc.Sequence[str] = ...) -> typing.Tuple[PySide6.QtCore.QUrl, str]: ...
    @staticmethod
    def getOpenFileUrls(parent: PySide6.QtWidgets.QWidget | None = ..., caption: str = ..., dir: PySide6.QtCore.QUrl | str = ..., filter: str = ..., selectedFilter: str = ..., options: PySide6.QtWidgets.QFileDialog.Option = ..., supportedSchemes: collections.abc.Sequence[str] = ...) -> typing.Tuple[typing.List[PySide6.QtCore.QUrl], str]: ...
    @staticmethod
    def getSaveFileName(parent: PySide6.QtWidgets.QWidget | None = ..., caption: str = ..., dir: str = ..., filter: str = ..., selectedFilter: str = ..., options: PySide6.QtWidgets.QFileDialog.Option = ...) -> typing.Tuple[str, str]: ...
    @staticmethod
    def getSaveFileUrl(parent: PySide6.QtWidgets.QWidget | None = ..., caption: str = ..., dir: PySide6.QtCore.QUrl | str = ..., filter: str = ..., selectedFilter: str = ..., options: PySide6.QtWidgets.QFileDialog.Option = ..., supportedSchemes: collections.abc.Sequence[str] = ...) -> typing.Tuple[PySide6.QtCore.QUrl, str]: ...
    def history(self, /) -> typing.List[str]: ...
    def iconProvider(self, /) -> PySide6.QtGui.QAbstractFileIconProvider: ...
    def itemDelegate(self, /) -> PySide6.QtWidgets.QAbstractItemDelegate: ...
    def labelText(self, label: PySide6.QtWidgets.QFileDialog.DialogLabel, /) -> str: ...
    def mimeTypeFilters(self, /) -> typing.List[str]: ...
    def nameFilters(self, /) -> typing.List[str]: ...
    @typing.overload
    def open(self, /) -> None: ...
    @typing.overload
    def open(self, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /) -> None: ...
    def options(self, /) -> PySide6.QtWidgets.QFileDialog.Option: ...
    def proxyModel(self, /) -> PySide6.QtCore.QAbstractProxyModel: ...
    def restoreState(self, state: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bool: ...
    @staticmethod
    def saveFileContent(fileContent: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, fileNameHint: str, /, parent: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def saveState(self, /) -> PySide6.QtCore.QByteArray: ...
    def selectFile(self, filename: str, /) -> None: ...
    def selectMimeTypeFilter(self, filter: str, /) -> None: ...
    def selectNameFilter(self, filter: str, /) -> None: ...
    def selectUrl(self, url: PySide6.QtCore.QUrl | str, /) -> None: ...
    def selectedFiles(self, /) -> typing.List[str]: ...
    def selectedMimeTypeFilter(self, /) -> str: ...
    def selectedNameFilter(self, /) -> str: ...
    def selectedUrls(self, /) -> typing.List[PySide6.QtCore.QUrl]: ...
    def setAcceptMode(self, mode: PySide6.QtWidgets.QFileDialog.AcceptMode, /) -> None: ...
    def setDefaultSuffix(self, suffix: str, /) -> None: ...
    @typing.overload
    def setDirectory(self, directory: PySide6.QtCore.QDir, /) -> None: ...
    @typing.overload
    def setDirectory(self, directory: str, /) -> None: ...
    def setDirectoryUrl(self, directory: PySide6.QtCore.QUrl | str, /) -> None: ...
    def setFileMode(self, mode: PySide6.QtWidgets.QFileDialog.FileMode, /) -> None: ...
    def setFilter(self, filters: PySide6.QtCore.QDir.Filter, /) -> None: ...
    def setHistory(self, paths: collections.abc.Sequence[str], /) -> None: ...
    def setIconProvider(self, provider: PySide6.QtGui.QAbstractFileIconProvider, /) -> None: ...
    def setItemDelegate(self, delegate: PySide6.QtWidgets.QAbstractItemDelegate, /) -> None: ...
    def setLabelText(self, label: PySide6.QtWidgets.QFileDialog.DialogLabel, text: str, /) -> None: ...
    def setMimeTypeFilters(self, filters: collections.abc.Sequence[str], /) -> None: ...
    def setNameFilter(self, filter: str, /) -> None: ...
    def setNameFilters(self, filters: collections.abc.Sequence[str], /) -> None: ...
    def setOption(self, option: PySide6.QtWidgets.QFileDialog.Option, /, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide6.QtWidgets.QFileDialog.Option, /) -> None: ...
    def setProxyModel(self, model: PySide6.QtCore.QAbstractProxyModel, /) -> None: ...
    def setSidebarUrls(self, urls: collections.abc.Sequence[PySide6.QtCore.QUrl], /) -> None: ...
    def setSupportedSchemes(self, schemes: collections.abc.Sequence[str], /) -> None: ...
    def setViewMode(self, mode: PySide6.QtWidgets.QFileDialog.ViewMode, /) -> None: ...
    def setVisible(self, visible: bool, /) -> None: ...
    def sidebarUrls(self, /) -> typing.List[PySide6.QtCore.QUrl]: ...
    def supportedSchemes(self, /) -> typing.List[str]: ...
    def testOption(self, option: PySide6.QtWidgets.QFileDialog.Option, /) -> bool: ...
    def viewMode(self, /) -> PySide6.QtWidgets.QFileDialog.ViewMode: ...


class QFileIconProvider(PySide6.QtGui.QAbstractFileIconProvider):

    def __init__(self, /) -> None: ...

    @typing.overload
    def icon(self, type: PySide6.QtGui.QAbstractFileIconProvider.IconType, /) -> PySide6.QtGui.QIcon: ...
    @typing.overload
    def icon(self, info: PySide6.QtCore.QFileInfo, /) -> PySide6.QtGui.QIcon: ...


class QFileSystemModel(PySide6.QtCore.QAbstractItemModel):

    directoryLoaded          : typing.ClassVar[Signal] = ... # directoryLoaded(QString)
    fileRenamed              : typing.ClassVar[Signal] = ... # fileRenamed(QString,QString,QString)
    rootPathChanged          : typing.ClassVar[Signal] = ... # rootPathChanged(QString)

    class Option(enum.Flag):

        DontWatchForChanges       = ...  # 0x1
        DontResolveSymlinks       = ...  # 0x2
        DontUseCustomDirectoryIcons = ...  # 0x4

    class Roles(enum.IntEnum):

        FileIconRole              = ...  # 0x1
        FileInfoRole              = ...  # 0xfc
        FilePathRole              = ...  # 0x101
        FileNameRole              = ...  # 0x102
        FilePermissions           = ...  # 0x103


    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, resolveSymlinks: bool | None = ..., readOnly: bool | None = ..., nameFilterDisables: bool | None = ..., options: PySide6.QtGui.QAbstractFileIconProvider.Option | None = ...) -> None: ...

    def canFetchMore(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def columnCount(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex = ...) -> int: ...
    def data(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, role: int = ...) -> typing.Any: ...
    def dropMimeData(self, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, row: int, column: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def fetchMore(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def fileIcon(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtGui.QIcon: ...
    def fileInfo(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QFileInfo: ...
    def fileName(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> str: ...
    def filePath(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> str: ...
    def filter(self, /) -> PySide6.QtCore.QDir.Filter: ...
    def flags(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.Qt.ItemFlag: ...
    def hasChildren(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex = ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide6.QtCore.Qt.Orientation, /, role: int = ...) -> typing.Any: ...
    def iconProvider(self, /) -> PySide6.QtGui.QAbstractFileIconProvider: ...
    @typing.overload
    def index(self, path: str, /, column: int | None = ...) -> PySide6.QtCore.QModelIndex: ...
    @typing.overload
    def index(self, row: int, column: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex = ...) -> PySide6.QtCore.QModelIndex: ...
    def isDir(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def isReadOnly(self, /) -> bool: ...
    @typing.overload
    def lastModified(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def lastModified(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, tz: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDateTime: ...
    def mimeData(self, indexes: collections.abc.Sequence[PySide6.QtCore.QModelIndex], /) -> PySide6.QtCore.QMimeData: ...
    def mimeTypes(self, /) -> typing.List[str]: ...
    def mkdir(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, name: str, /) -> PySide6.QtCore.QModelIndex: ...
    def myComputer(self, /, role: int = ...) -> typing.Any: ...
    def nameFilterDisables(self, /) -> bool: ...
    def nameFilters(self, /) -> typing.List[str]: ...
    def options(self, /) -> PySide6.QtWidgets.QFileSystemModel.Option: ...
    @typing.overload
    def parent(self, /) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def parent(self, child: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def permissions(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QFileDevice.Permission: ...
    def remove(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def resolveSymlinks(self, /) -> bool: ...
    def rmdir(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def roleNames(self, /) -> typing.Dict[int, PySide6.QtCore.QByteArray]: ...
    def rootDirectory(self, /) -> PySide6.QtCore.QDir: ...
    def rootPath(self, /) -> str: ...
    def rowCount(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex = ...) -> int: ...
    def setData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, value: typing.Any, /, role: int = ...) -> bool: ...
    def setFilter(self, filters: PySide6.QtCore.QDir.Filter, /) -> None: ...
    def setIconProvider(self, provider: PySide6.QtGui.QAbstractFileIconProvider, /) -> None: ...
    def setNameFilterDisables(self, enable: bool, /) -> None: ...
    def setNameFilters(self, filters: collections.abc.Sequence[str], /) -> None: ...
    def setOption(self, option: PySide6.QtWidgets.QFileSystemModel.Option, /, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide6.QtWidgets.QFileSystemModel.Option, /) -> None: ...
    def setReadOnly(self, enable: bool, /) -> None: ...
    def setResolveSymlinks(self, enable: bool, /) -> None: ...
    def setRootPath(self, path: str, /) -> PySide6.QtCore.QModelIndex: ...
    def sibling(self, row: int, column: int, idx: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def size(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> int: ...
    def sort(self, column: int, /, order: PySide6.QtCore.Qt.SortOrder = ...) -> None: ...
    def supportedDropActions(self, /) -> PySide6.QtCore.Qt.DropAction: ...
    def testOption(self, option: PySide6.QtWidgets.QFileSystemModel.Option, /) -> bool: ...
    def timerEvent(self, event: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def type(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> str: ...


class QFocusFrame(PySide6.QtWidgets.QWidget):

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ...) -> None: ...

    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def eventFilter(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent, /) -> bool: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOption, /) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def setWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def widget(self, /) -> PySide6.QtWidgets.QWidget: ...


class QFontComboBox(PySide6.QtWidgets.QComboBox):

    currentFontChanged       : typing.ClassVar[Signal] = ... # currentFontChanged(QFont)

    class FontFilter(enum.Flag):

        AllFonts                  = ...  # 0x0
        ScalableFonts             = ...  # 0x1
        NonScalableFonts          = ...  # 0x2
        MonospacedFonts           = ...  # 0x4
        ProportionalFonts         = ...  # 0x8


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, writingSystem: PySide6.QtGui.QFontDatabase.WritingSystem | None = ..., fontFilters: PySide6.QtWidgets.QFontComboBox.FontFilter | None = ..., currentFont: PySide6.QtGui.QFont | None = ...) -> None: ...

    def currentFont(self, /) -> PySide6.QtGui.QFont: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def fontFilters(self, /) -> PySide6.QtWidgets.QFontComboBox.FontFilter: ...
    def sampleTextForFont(self, fontFamily: str, /) -> str: ...
    def sampleTextForSystem(self, writingSystem: PySide6.QtGui.QFontDatabase.WritingSystem, /) -> str: ...
    def setCurrentFont(self, f: PySide6.QtGui.QFont | str | collections.abc.Sequence[str], /) -> None: ...
    def setDisplayFont(self, fontFamily: str, font: PySide6.QtGui.QFont | str | collections.abc.Sequence[str], /) -> None: ...
    def setFontFilters(self, filters: PySide6.QtWidgets.QFontComboBox.FontFilter, /) -> None: ...
    def setSampleTextForFont(self, fontFamily: str, sampleText: str, /) -> None: ...
    def setSampleTextForSystem(self, writingSystem: PySide6.QtGui.QFontDatabase.WritingSystem, sampleText: str, /) -> None: ...
    def setWritingSystem(self, arg__1: PySide6.QtGui.QFontDatabase.WritingSystem, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def writingSystem(self, /) -> PySide6.QtGui.QFontDatabase.WritingSystem: ...


class QFontDialog(PySide6.QtWidgets.QDialog):

    currentFontChanged       : typing.ClassVar[Signal] = ... # currentFontChanged(QFont)
    fontSelected             : typing.ClassVar[Signal] = ... # fontSelected(QFont)

    class FontDialogOption(enum.Flag):

        NoButtons                 = ...  # 0x1
        DontUseNativeDialog       = ...  # 0x2
        ScalableFonts             = ...  # 0x4
        NonScalableFonts          = ...  # 0x8
        MonospacedFonts           = ...  # 0x10
        ProportionalFonts         = ...  # 0x20


    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, currentFont: PySide6.QtGui.QFont | None = ..., options: PySide6.QtWidgets.QFontDialog.FontDialogOption | None = ...) -> None: ...
    @typing.overload
    def __init__(self, initial: PySide6.QtGui.QFont | str | collections.abc.Sequence[str], /, parent: PySide6.QtWidgets.QWidget | None = ..., *, currentFont: PySide6.QtGui.QFont | None = ..., options: PySide6.QtWidgets.QFontDialog.FontDialogOption | None = ...) -> None: ...

    def changeEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def currentFont(self, /) -> PySide6.QtGui.QFont: ...
    def done(self, result: int, /) -> None: ...
    def eventFilter(self, object: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent, /) -> bool: ...
    @typing.overload
    @staticmethod
    def getFont(parent: PySide6.QtWidgets.QWidget | None = ...) -> typing.Tuple[bool, PySide6.QtGui.QFont]: ...
    @typing.overload
    @staticmethod
    def getFont(initial: PySide6.QtGui.QFont | str | collections.abc.Sequence[str], /, parent: PySide6.QtWidgets.QWidget | None = ..., title: str = ..., options: PySide6.QtWidgets.QFontDialog.FontDialogOption = ...) -> typing.Tuple[bool, PySide6.QtGui.QFont]: ...
    @typing.overload
    def open(self, /) -> None: ...
    @typing.overload
    def open(self, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /) -> None: ...
    def options(self, /) -> PySide6.QtWidgets.QFontDialog.FontDialogOption: ...
    def selectedFont(self, /) -> PySide6.QtGui.QFont: ...
    def setCurrentFont(self, font: PySide6.QtGui.QFont | str | collections.abc.Sequence[str], /) -> None: ...
    def setOption(self, option: PySide6.QtWidgets.QFontDialog.FontDialogOption, /, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide6.QtWidgets.QFontDialog.FontDialogOption, /) -> None: ...
    def setVisible(self, visible: bool, /) -> None: ...
    def testOption(self, option: PySide6.QtWidgets.QFontDialog.FontDialogOption, /) -> bool: ...


class QFormLayout(PySide6.QtWidgets.QLayout):

    class FieldGrowthPolicy(enum.Enum):

        FieldsStayAtSizeHint      = ...  # 0x0
        ExpandingFieldsGrow       = ...  # 0x1
        AllNonFixedFieldsGrow     = ...  # 0x2

    class ItemRole(enum.Enum):

        LabelRole                 = ...  # 0x0
        FieldRole                 = ...  # 0x1
        SpanningRole              = ...  # 0x2

    class RowWrapPolicy(enum.Enum):

        DontWrapRows              = ...  # 0x0
        WrapLongRows              = ...  # 0x1
        WrapAllRows               = ...  # 0x2

    class TakeRowResult(Shiboken.Object):

        @typing.overload
        def __init__(self, /) -> None: ...
        @typing.overload
        def __init__(self, TakeRowResult: PySide6.QtWidgets.QFormLayout.TakeRowResult, /) -> None: ...

        def __copy__(self, /) -> typing.Self: ...


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, fieldGrowthPolicy: PySide6.QtWidgets.QFormLayout.FieldGrowthPolicy | None = ..., rowWrapPolicy: PySide6.QtWidgets.QFormLayout.RowWrapPolicy | None = ..., labelAlignment: PySide6.QtCore.Qt.AlignmentFlag | None = ..., formAlignment: PySide6.QtCore.Qt.AlignmentFlag | None = ..., horizontalSpacing: int | None = ..., verticalSpacing: int | None = ...) -> None: ...

    def addItem(self, item: PySide6.QtWidgets.QLayoutItem, /) -> None: ...
    @typing.overload
    def addRow(self, layout: PySide6.QtWidgets.QLayout, /) -> None: ...
    @typing.overload
    def addRow(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    @typing.overload
    def addRow(self, label: PySide6.QtWidgets.QWidget, field: PySide6.QtWidgets.QLayout, /) -> None: ...
    @typing.overload
    def addRow(self, label: PySide6.QtWidgets.QWidget, field: PySide6.QtWidgets.QWidget, /) -> None: ...
    @typing.overload
    def addRow(self, labelText: str, field: PySide6.QtWidgets.QLayout, /) -> None: ...
    @typing.overload
    def addRow(self, labelText: str, field: PySide6.QtWidgets.QWidget, /) -> None: ...
    def count(self, /) -> int: ...
    def expandingDirections(self, /) -> PySide6.QtCore.Qt.Orientation: ...
    def fieldGrowthPolicy(self, /) -> PySide6.QtWidgets.QFormLayout.FieldGrowthPolicy: ...
    def formAlignment(self, /) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def getItemPosition(self, index: int, /) -> object: ...
    def getLayoutPosition(self, layout: PySide6.QtWidgets.QLayout, /) -> typing.Tuple[int, PySide6.QtWidgets.QFormLayout.ItemRole]: ...
    def getWidgetPosition(self, widget: PySide6.QtWidgets.QWidget, /) -> object: ...
    def hasHeightForWidth(self, /) -> bool: ...
    def heightForWidth(self, width: int, /) -> int: ...
    def horizontalSpacing(self, /) -> int: ...
    @typing.overload
    def insertRow(self, row: int, layout: PySide6.QtWidgets.QLayout, /) -> None: ...
    @typing.overload
    def insertRow(self, row: int, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    @typing.overload
    def insertRow(self, row: int, label: PySide6.QtWidgets.QWidget, field: PySide6.QtWidgets.QLayout, /) -> None: ...
    @typing.overload
    def insertRow(self, row: int, label: PySide6.QtWidgets.QWidget, field: PySide6.QtWidgets.QWidget, /) -> None: ...
    @typing.overload
    def insertRow(self, row: int, labelText: str, field: PySide6.QtWidgets.QLayout, /) -> None: ...
    @typing.overload
    def insertRow(self, row: int, labelText: str, field: PySide6.QtWidgets.QWidget, /) -> None: ...
    def invalidate(self, /) -> None: ...
    @typing.overload
    def isRowVisible(self, layout: PySide6.QtWidgets.QLayout, /) -> bool: ...
    @typing.overload
    def isRowVisible(self, widget: PySide6.QtWidgets.QWidget, /) -> bool: ...
    @typing.overload
    def isRowVisible(self, row: int, /) -> bool: ...
    @typing.overload
    def itemAt(self, index: int, /) -> PySide6.QtWidgets.QLayoutItem: ...
    @typing.overload
    def itemAt(self, row: int, role: PySide6.QtWidgets.QFormLayout.ItemRole, /) -> PySide6.QtWidgets.QLayoutItem: ...
    def labelAlignment(self, /) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    @typing.overload
    def labelForField(self, field: PySide6.QtWidgets.QLayout, /) -> PySide6.QtWidgets.QWidget: ...
    @typing.overload
    def labelForField(self, field: PySide6.QtWidgets.QWidget, /) -> PySide6.QtWidgets.QWidget: ...
    def minimumSize(self, /) -> PySide6.QtCore.QSize: ...
    @typing.overload
    def removeRow(self, layout: PySide6.QtWidgets.QLayout, /) -> None: ...
    @typing.overload
    def removeRow(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    @typing.overload
    def removeRow(self, row: int, /) -> None: ...
    def rowCount(self, /) -> int: ...
    def rowWrapPolicy(self, /) -> PySide6.QtWidgets.QFormLayout.RowWrapPolicy: ...
    def setFieldGrowthPolicy(self, policy: PySide6.QtWidgets.QFormLayout.FieldGrowthPolicy, /) -> None: ...
    def setFormAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    def setGeometry(self, rect: PySide6.QtCore.QRect, /) -> None: ...
    def setHorizontalSpacing(self, spacing: int, /) -> None: ...
    def setItem(self, row: int, role: PySide6.QtWidgets.QFormLayout.ItemRole, item: PySide6.QtWidgets.QLayoutItem, /) -> None: ...
    def setLabelAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    def setLayout(self, row: int, role: PySide6.QtWidgets.QFormLayout.ItemRole, layout: PySide6.QtWidgets.QLayout, /) -> None: ...
    @typing.overload
    def setRowVisible(self, layout: PySide6.QtWidgets.QLayout, on: bool, /) -> None: ...
    @typing.overload
    def setRowVisible(self, widget: PySide6.QtWidgets.QWidget, on: bool, /) -> None: ...
    @typing.overload
    def setRowVisible(self, row: int, on: bool, /) -> None: ...
    def setRowWrapPolicy(self, policy: PySide6.QtWidgets.QFormLayout.RowWrapPolicy, /) -> None: ...
    def setSpacing(self, arg__1: int, /) -> None: ...
    def setVerticalSpacing(self, spacing: int, /) -> None: ...
    def setWidget(self, row: int, role: PySide6.QtWidgets.QFormLayout.ItemRole, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def spacing(self, /) -> int: ...
    def takeAt(self, index: int, /) -> PySide6.QtWidgets.QLayoutItem: ...
    @typing.overload
    def takeRow(self, layout: PySide6.QtWidgets.QLayout, /) -> PySide6.QtWidgets.QFormLayout.TakeRowResult: ...
    @typing.overload
    def takeRow(self, widget: PySide6.QtWidgets.QWidget, /) -> PySide6.QtWidgets.QFormLayout.TakeRowResult: ...
    @typing.overload
    def takeRow(self, row: int, /) -> PySide6.QtWidgets.QFormLayout.TakeRowResult: ...
    def verticalSpacing(self, /) -> int: ...


class QFrame(PySide6.QtWidgets.QWidget):

    class Shadow(enum.IntEnum):

        Plain                     = ...  # 0x10
        Raised                    = ...  # 0x20
        Sunken                    = ...  # 0x30

    class Shape(enum.IntEnum):

        NoFrame                   = ...  # 0x0
        Box                       = ...  # 0x1
        Panel                     = ...  # 0x2
        WinPanel                  = ...  # 0x3
        HLine                     = ...  # 0x4
        VLine                     = ...  # 0x5
        StyledPanel               = ...  # 0x6

    class StyleMask(enum.Enum):

        Shape_Mask                = ...  # 0xf
        Shadow_Mask               = ...  # 0xf0


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., f: PySide6.QtCore.Qt.WindowType = ..., *, frameShape: PySide6.QtWidgets.QFrame.Shape | None = ..., frameShadow: PySide6.QtWidgets.QFrame.Shadow | None = ..., lineWidth: int | None = ..., midLineWidth: int | None = ..., frameWidth: int | None = ..., frameRect: PySide6.QtCore.QRect | None = ...) -> None: ...

    def changeEvent(self, arg__1: PySide6.QtCore.QEvent, /) -> None: ...
    def drawFrame(self, arg__1: PySide6.QtGui.QPainter, /) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def frameRect(self, /) -> PySide6.QtCore.QRect: ...
    def frameShadow(self, /) -> PySide6.QtWidgets.QFrame.Shadow: ...
    def frameShape(self, /) -> PySide6.QtWidgets.QFrame.Shape: ...
    def frameStyle(self, /) -> int: ...
    def frameWidth(self, /) -> int: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionFrame, /) -> None: ...
    def lineWidth(self, /) -> int: ...
    def midLineWidth(self, /) -> int: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def setFrameRect(self, arg__1: PySide6.QtCore.QRect, /) -> None: ...
    def setFrameShadow(self, arg__1: PySide6.QtWidgets.QFrame.Shadow, /) -> None: ...
    def setFrameShape(self, arg__1: PySide6.QtWidgets.QFrame.Shape, /) -> None: ...
    def setFrameStyle(self, arg__1: int, /) -> None: ...
    def setLineWidth(self, arg__1: int, /) -> None: ...
    def setMidLineWidth(self, arg__1: int, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...


class QGesture(PySide6.QtCore.QObject):

    class GestureCancelPolicy(enum.Enum):

        CancelNone                = ...  # 0x0
        CancelAllInContext        = ...  # 0x1


    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, state: PySide6.QtCore.Qt.GestureState | None = ..., gestureType: PySide6.QtCore.Qt.GestureType | None = ..., gestureCancelPolicy: PySide6.QtWidgets.QGesture.GestureCancelPolicy | None = ..., hotSpot: PySide6.QtCore.QPointF | None = ..., hasHotSpot: bool | None = ...) -> None: ...

    def __repr__(self, /) -> str: ...
    def gestureCancelPolicy(self, /) -> PySide6.QtWidgets.QGesture.GestureCancelPolicy: ...
    def gestureType(self, /) -> PySide6.QtCore.Qt.GestureType: ...
    def hasHotSpot(self, /) -> bool: ...
    def hotSpot(self, /) -> PySide6.QtCore.QPointF: ...
    def setGestureCancelPolicy(self, policy: PySide6.QtWidgets.QGesture.GestureCancelPolicy, /) -> None: ...
    def setHotSpot(self, value: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def state(self, /) -> PySide6.QtCore.Qt.GestureState: ...
    def unsetHotSpot(self, /) -> None: ...


class QGestureEvent(PySide6.QtCore.QEvent):

    def __init__(self, gestures: collections.abc.Sequence[PySide6.QtWidgets.QGesture], /) -> None: ...

    def __repr__(self, /) -> str: ...
    @typing.overload
    def accept(self, /) -> None: ...
    @typing.overload
    def accept(self, arg__1: PySide6.QtCore.Qt.GestureType, /) -> None: ...
    @typing.overload
    def accept(self, arg__1: PySide6.QtWidgets.QGesture, /) -> None: ...
    def activeGestures(self, /) -> typing.List[PySide6.QtWidgets.QGesture]: ...
    def canceledGestures(self, /) -> typing.List[PySide6.QtWidgets.QGesture]: ...
    def gesture(self, type: PySide6.QtCore.Qt.GestureType, /) -> PySide6.QtWidgets.QGesture: ...
    def gestures(self, /) -> typing.List[PySide6.QtWidgets.QGesture]: ...
    @typing.overload
    def ignore(self, /) -> None: ...
    @typing.overload
    def ignore(self, arg__1: PySide6.QtCore.Qt.GestureType, /) -> None: ...
    @typing.overload
    def ignore(self, arg__1: PySide6.QtWidgets.QGesture, /) -> None: ...
    @typing.overload
    def isAccepted(self, /) -> bool: ...
    @typing.overload
    def isAccepted(self, arg__1: PySide6.QtCore.Qt.GestureType, /) -> bool: ...
    @typing.overload
    def isAccepted(self, arg__1: PySide6.QtWidgets.QGesture, /) -> bool: ...
    def mapToGraphicsScene(self, gesturePoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def setAccepted(self, arg__1: PySide6.QtCore.Qt.GestureType, arg__2: bool, /) -> None: ...
    @typing.overload
    def setAccepted(self, arg__1: PySide6.QtWidgets.QGesture, arg__2: bool, /) -> None: ...
    @typing.overload
    def setAccepted(self, accepted: bool, /) -> None: ...
    def setWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def widget(self, /) -> PySide6.QtWidgets.QWidget: ...


class QGestureRecognizer(Shiboken.Object):

    class ResultFlag(enum.Flag):

        Ignore                    = ...  # 0x1
        MayBeGesture              = ...  # 0x2
        TriggerGesture            = ...  # 0x4
        FinishGesture             = ...  # 0x8
        CancelGesture             = ...  # 0x10
        ResultState_Mask          = ...  # 0xff
        ConsumeEventHint          = ...  # 0x100
        ResultHint_Mask           = ...  # 0xff00


    def __init__(self, /) -> None: ...

    def create(self, target: PySide6.QtCore.QObject, /) -> PySide6.QtWidgets.QGesture: ...
    def recognize(self, state: PySide6.QtWidgets.QGesture, watched: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent, /) -> PySide6.QtWidgets.QGestureRecognizer.ResultFlag: ...
    @staticmethod
    def registerRecognizer(recognizer: PySide6.QtWidgets.QGestureRecognizer, /) -> PySide6.QtCore.Qt.GestureType: ...
    def reset(self, state: PySide6.QtWidgets.QGesture, /) -> None: ...
    @staticmethod
    def unregisterRecognizer(type: PySide6.QtCore.Qt.GestureType, /) -> None: ...


class QGraphicsAnchor(PySide6.QtCore.QObject):
    def setSizePolicy(self, policy: PySide6.QtWidgets.QSizePolicy.Policy, /) -> None: ...
    def setSpacing(self, spacing: float, /) -> None: ...
    def sizePolicy(self, /) -> PySide6.QtWidgets.QSizePolicy.Policy: ...
    def spacing(self, /) -> float: ...
    def unsetSpacing(self, /) -> None: ...


class QGraphicsAnchorLayout(PySide6.QtWidgets.QGraphicsLayout):

    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsLayoutItem | None = ...) -> None: ...

    def addAnchor(self, firstItem: PySide6.QtWidgets.QGraphicsLayoutItem, firstEdge: PySide6.QtCore.Qt.AnchorPoint, secondItem: PySide6.QtWidgets.QGraphicsLayoutItem, secondEdge: PySide6.QtCore.Qt.AnchorPoint, /) -> PySide6.QtWidgets.QGraphicsAnchor: ...
    def addAnchors(self, firstItem: PySide6.QtWidgets.QGraphicsLayoutItem, secondItem: PySide6.QtWidgets.QGraphicsLayoutItem, /, orientations: PySide6.QtCore.Qt.Orientation = ...) -> None: ...
    def addCornerAnchors(self, firstItem: PySide6.QtWidgets.QGraphicsLayoutItem, firstCorner: PySide6.QtCore.Qt.Corner, secondItem: PySide6.QtWidgets.QGraphicsLayoutItem, secondCorner: PySide6.QtCore.Qt.Corner, /) -> None: ...
    def anchor(self, firstItem: PySide6.QtWidgets.QGraphicsLayoutItem, firstEdge: PySide6.QtCore.Qt.AnchorPoint, secondItem: PySide6.QtWidgets.QGraphicsLayoutItem, secondEdge: PySide6.QtCore.Qt.AnchorPoint, /) -> PySide6.QtWidgets.QGraphicsAnchor: ...
    def count(self, /) -> int: ...
    def horizontalSpacing(self, /) -> float: ...
    def invalidate(self, /) -> None: ...
    def itemAt(self, index: int, /) -> PySide6.QtWidgets.QGraphicsLayoutItem: ...
    def removeAt(self, index: int, /) -> None: ...
    def setGeometry(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> None: ...
    def setHorizontalSpacing(self, spacing: float, /) -> None: ...
    def setSpacing(self, spacing: float, /) -> None: ...
    def setVerticalSpacing(self, spacing: float, /) -> None: ...
    def sizeHint(self, which: PySide6.QtCore.Qt.SizeHint, /, constraint: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize = ...) -> PySide6.QtCore.QSizeF: ...
    def verticalSpacing(self, /) -> float: ...


class QGraphicsBlurEffect(PySide6.QtWidgets.QGraphicsEffect):

    blurHintsChanged         : typing.ClassVar[Signal] = ... # blurHintsChanged(BlurHints)
    blurRadiusChanged        : typing.ClassVar[Signal] = ... # blurRadiusChanged(double)

    class BlurHint(enum.Flag):

        PerformanceHint           = ...  # 0x0
        QualityHint               = ...  # 0x1
        AnimationHint             = ...  # 0x2


    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, blurRadius: float | None = ..., blurHints: PySide6.QtWidgets.QGraphicsBlurEffect.BlurHint | None = ...) -> None: ...

    def blurHints(self, /) -> PySide6.QtWidgets.QGraphicsBlurEffect.BlurHint: ...
    def blurRadius(self, /) -> float: ...
    def boundingRectFor(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRectF: ...
    def draw(self, painter: PySide6.QtGui.QPainter, /) -> None: ...
    def setBlurHints(self, hints: PySide6.QtWidgets.QGraphicsBlurEffect.BlurHint, /) -> None: ...
    def setBlurRadius(self, blurRadius: float, /) -> None: ...


class QGraphicsColorizeEffect(PySide6.QtWidgets.QGraphicsEffect):

    colorChanged             : typing.ClassVar[Signal] = ... # colorChanged(QColor)
    strengthChanged          : typing.ClassVar[Signal] = ... # strengthChanged(double)

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, color: PySide6.QtGui.QColor | None = ..., strength: float | None = ...) -> None: ...

    def color(self, /) -> PySide6.QtGui.QColor: ...
    def draw(self, painter: PySide6.QtGui.QPainter, /) -> None: ...
    def setColor(self, c: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, /) -> None: ...
    def setStrength(self, strength: float, /) -> None: ...
    def strength(self, /) -> float: ...


class QGraphicsDropShadowEffect(PySide6.QtWidgets.QGraphicsEffect):

    blurRadiusChanged        : typing.ClassVar[Signal] = ... # blurRadiusChanged(double)
    colorChanged             : typing.ClassVar[Signal] = ... # colorChanged(QColor)
    offsetChanged            : typing.ClassVar[Signal] = ... # offsetChanged(QPointF)

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, offset: PySide6.QtCore.QPointF | None = ..., xOffset: float | None = ..., yOffset: float | None = ..., blurRadius: float | None = ..., color: PySide6.QtGui.QColor | None = ...) -> None: ...

    def blurRadius(self, /) -> float: ...
    def boundingRectFor(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRectF: ...
    def color(self, /) -> PySide6.QtGui.QColor: ...
    def draw(self, painter: PySide6.QtGui.QPainter, /) -> None: ...
    def offset(self, /) -> PySide6.QtCore.QPointF: ...
    def setBlurRadius(self, blurRadius: float, /) -> None: ...
    def setColor(self, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, /) -> None: ...
    @typing.overload
    def setOffset(self, ofs: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    @typing.overload
    def setOffset(self, d: float, /) -> None: ...
    @typing.overload
    def setOffset(self, dx: float, dy: float, /) -> None: ...
    def setXOffset(self, dx: float, /) -> None: ...
    def setYOffset(self, dy: float, /) -> None: ...
    def xOffset(self, /) -> float: ...
    def yOffset(self, /) -> float: ...


class QGraphicsEffect(PySide6.QtCore.QObject):

    enabledChanged           : typing.ClassVar[Signal] = ... # enabledChanged(bool)

    class ChangeFlag(enum.Flag):

        SourceAttached            = ...  # 0x1
        SourceDetached            = ...  # 0x2
        SourceBoundingRectChanged = ...  # 0x4
        SourceInvalidated         = ...  # 0x8

    class PixmapPadMode(enum.Enum):

        NoPad                     = ...  # 0x0
        PadToTransparentBorder    = ...  # 0x1
        PadToEffectiveBoundingRect = ...  # 0x2


    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, enabled: bool | None = ...) -> None: ...

    def boundingRect(self, /) -> PySide6.QtCore.QRectF: ...
    def boundingRectFor(self, sourceRect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRectF: ...
    def draw(self, painter: PySide6.QtGui.QPainter, /) -> None: ...
    def drawSource(self, painter: PySide6.QtGui.QPainter, /) -> None: ...
    def isEnabled(self, /) -> bool: ...
    def setEnabled(self, enable: bool, /) -> None: ...
    def sourceBoundingRect(self, /, system: PySide6.QtCore.Qt.CoordinateSystem = ...) -> PySide6.QtCore.QRectF: ...
    def sourceChanged(self, flags: PySide6.QtWidgets.QGraphicsEffect.ChangeFlag, /) -> None: ...
    def sourceIsPixmap(self, /) -> bool: ...
    def sourcePixmap(self, /, system: PySide6.QtCore.Qt.CoordinateSystem = ..., offset: PySide6.QtCore.QPoint | None = ..., mode: PySide6.QtWidgets.QGraphicsEffect.PixmapPadMode = ...) -> PySide6.QtGui.QPixmap: ...
    def update(self, /) -> None: ...
    def updateBoundingRect(self, /) -> None: ...


class QGraphicsEllipseItem(PySide6.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float, w: float, h: float, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...

    def boundingRect(self, /) -> PySide6.QtCore.QRectF: ...
    def contains(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> bool: ...
    def extension(self, variant: typing.Any, /) -> typing.Any: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> bool: ...
    def opaqueArea(self, /) -> PySide6.QtGui.QPainterPath: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def rect(self, /) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def setRect(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> None: ...
    @typing.overload
    def setRect(self, x: float, y: float, w: float, h: float, /) -> None: ...
    def setSpanAngle(self, angle: int, /) -> None: ...
    def setStartAngle(self, angle: int, /) -> None: ...
    def shape(self, /) -> PySide6.QtGui.QPainterPath: ...
    def spanAngle(self, /) -> int: ...
    def startAngle(self, /) -> int: ...
    def type(self, /) -> int: ...


class QGraphicsGridLayout(PySide6.QtWidgets.QGraphicsLayout):

    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsLayoutItem | None = ...) -> None: ...

    @typing.overload
    def addItem(self, item: PySide6.QtWidgets.QGraphicsLayoutItem, row: int, column: int, /, alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...
    @typing.overload
    def addItem(self, item: PySide6.QtWidgets.QGraphicsLayoutItem, row: int, column: int, rowSpan: int, columnSpan: int, /, alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...
    def alignment(self, item: PySide6.QtWidgets.QGraphicsLayoutItem, /) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def columnAlignment(self, column: int, /) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def columnCount(self, /) -> int: ...
    def columnMaximumWidth(self, column: int, /) -> float: ...
    def columnMinimumWidth(self, column: int, /) -> float: ...
    def columnPreferredWidth(self, column: int, /) -> float: ...
    def columnSpacing(self, column: int, /) -> float: ...
    def columnStretchFactor(self, column: int, /) -> int: ...
    def count(self, /) -> int: ...
    def horizontalSpacing(self, /) -> float: ...
    def invalidate(self, /) -> None: ...
    @typing.overload
    def itemAt(self, index: int, /) -> PySide6.QtWidgets.QGraphicsLayoutItem: ...
    @typing.overload
    def itemAt(self, row: int, column: int, /) -> PySide6.QtWidgets.QGraphicsLayoutItem: ...
    def removeAt(self, index: int, /) -> None: ...
    def removeItem(self, item: PySide6.QtWidgets.QGraphicsLayoutItem, /) -> None: ...
    def rowAlignment(self, row: int, /) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def rowCount(self, /) -> int: ...
    def rowMaximumHeight(self, row: int, /) -> float: ...
    def rowMinimumHeight(self, row: int, /) -> float: ...
    def rowPreferredHeight(self, row: int, /) -> float: ...
    def rowSpacing(self, row: int, /) -> float: ...
    def rowStretchFactor(self, row: int, /) -> int: ...
    def setAlignment(self, item: PySide6.QtWidgets.QGraphicsLayoutItem, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    def setColumnAlignment(self, column: int, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    def setColumnFixedWidth(self, column: int, width: float, /) -> None: ...
    def setColumnMaximumWidth(self, column: int, width: float, /) -> None: ...
    def setColumnMinimumWidth(self, column: int, width: float, /) -> None: ...
    def setColumnPreferredWidth(self, column: int, width: float, /) -> None: ...
    def setColumnSpacing(self, column: int, spacing: float, /) -> None: ...
    def setColumnStretchFactor(self, column: int, stretch: int, /) -> None: ...
    def setGeometry(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> None: ...
    def setHorizontalSpacing(self, spacing: float, /) -> None: ...
    def setRowAlignment(self, row: int, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    def setRowFixedHeight(self, row: int, height: float, /) -> None: ...
    def setRowMaximumHeight(self, row: int, height: float, /) -> None: ...
    def setRowMinimumHeight(self, row: int, height: float, /) -> None: ...
    def setRowPreferredHeight(self, row: int, height: float, /) -> None: ...
    def setRowSpacing(self, row: int, spacing: float, /) -> None: ...
    def setRowStretchFactor(self, row: int, stretch: int, /) -> None: ...
    def setSpacing(self, spacing: float, /) -> None: ...
    def setVerticalSpacing(self, spacing: float, /) -> None: ...
    def sizeHint(self, which: PySide6.QtCore.Qt.SizeHint, /, constraint: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize = ...) -> PySide6.QtCore.QSizeF: ...
    def verticalSpacing(self, /) -> float: ...


class QGraphicsItem(Shiboken.Object):

    class CacheMode(enum.Enum):

        NoCache                   = ...  # 0x0
        ItemCoordinateCache       = ...  # 0x1
        DeviceCoordinateCache     = ...  # 0x2

    class Extension(enum.Enum):

        UserExtension             = ...  # -2147483648

    class GraphicsItemChange(enum.Enum):

        ItemPositionChange        = ...  # 0x0
        ItemVisibleChange         = ...  # 0x2
        ItemEnabledChange         = ...  # 0x3
        ItemSelectedChange        = ...  # 0x4
        ItemParentChange          = ...  # 0x5
        ItemChildAddedChange      = ...  # 0x6
        ItemChildRemovedChange    = ...  # 0x7
        ItemTransformChange       = ...  # 0x8
        ItemPositionHasChanged    = ...  # 0x9
        ItemTransformHasChanged   = ...  # 0xa
        ItemSceneChange           = ...  # 0xb
        ItemVisibleHasChanged     = ...  # 0xc
        ItemEnabledHasChanged     = ...  # 0xd
        ItemSelectedHasChanged    = ...  # 0xe
        ItemParentHasChanged      = ...  # 0xf
        ItemSceneHasChanged       = ...  # 0x10
        ItemCursorChange          = ...  # 0x11
        ItemCursorHasChanged      = ...  # 0x12
        ItemToolTipChange         = ...  # 0x13
        ItemToolTipHasChanged     = ...  # 0x14
        ItemFlagsChange           = ...  # 0x15
        ItemFlagsHaveChanged      = ...  # 0x16
        ItemZValueChange          = ...  # 0x17
        ItemZValueHasChanged      = ...  # 0x18
        ItemOpacityChange         = ...  # 0x19
        ItemOpacityHasChanged     = ...  # 0x1a
        ItemScenePositionHasChanged = ...  # 0x1b
        ItemRotationChange        = ...  # 0x1c
        ItemRotationHasChanged    = ...  # 0x1d
        ItemScaleChange           = ...  # 0x1e
        ItemScaleHasChanged       = ...  # 0x1f
        ItemTransformOriginPointChange = ...  # 0x20
        ItemTransformOriginPointHasChanged = ...  # 0x21

    class GraphicsItemFlag(enum.Flag):

        ItemIsMovable             = ...  # 0x1
        ItemIsSelectable          = ...  # 0x2
        ItemIsFocusable           = ...  # 0x4
        ItemClipsToShape          = ...  # 0x8
        ItemClipsChildrenToShape  = ...  # 0x10
        ItemIgnoresTransformations = ...  # 0x20
        ItemIgnoresParentOpacity  = ...  # 0x40
        ItemDoesntPropagateOpacityToChildren = ...  # 0x80
        ItemStacksBehindParent    = ...  # 0x100
        ItemUsesExtendedStyleOption = ...  # 0x200
        ItemHasNoContents         = ...  # 0x400
        ItemSendsGeometryChanges  = ...  # 0x800
        ItemAcceptsInputMethod    = ...  # 0x1000
        ItemNegativeZStacksBehindParent = ...  # 0x2000
        ItemIsPanel               = ...  # 0x4000
        ItemIsFocusScope          = ...  # 0x8000
        ItemSendsScenePositionChanges = ...  # 0x10000
        ItemStopsClickFocusPropagation = ...  # 0x20000
        ItemStopsFocusHandling    = ...  # 0x40000
        ItemContainsChildrenInShape = ...  # 0x80000

    class PanelModality(enum.Enum):

        NonModal                  = ...  # 0x0
        PanelModal                = ...  # 0x1
        SceneModal                = ...  # 0x2


    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...

    def __repr__(self, /) -> str: ...
    def acceptDrops(self, /) -> bool: ...
    def acceptHoverEvents(self, /) -> bool: ...
    def acceptTouchEvents(self, /) -> bool: ...
    def acceptedMouseButtons(self, /) -> PySide6.QtCore.Qt.MouseButton: ...
    def addToIndex(self, /) -> None: ...
    def advance(self, phase: int, /) -> None: ...
    def boundingRect(self, /) -> PySide6.QtCore.QRectF: ...
    def boundingRegion(self, itemToDeviceTransform: PySide6.QtGui.QTransform, /) -> PySide6.QtGui.QRegion: ...
    def boundingRegionGranularity(self, /) -> float: ...
    def cacheMode(self, /) -> PySide6.QtWidgets.QGraphicsItem.CacheMode: ...
    def childItems(self, /) -> typing.List[PySide6.QtWidgets.QGraphicsItem]: ...
    def childrenBoundingRect(self, /) -> PySide6.QtCore.QRectF: ...
    def clearFocus(self, /) -> None: ...
    def clipPath(self, /) -> PySide6.QtGui.QPainterPath: ...
    def collidesWithItem(self, other: PySide6.QtWidgets.QGraphicsItem, /, mode: PySide6.QtCore.Qt.ItemSelectionMode = ...) -> bool: ...
    def collidesWithPath(self, path: PySide6.QtGui.QPainterPath, /, mode: PySide6.QtCore.Qt.ItemSelectionMode = ...) -> bool: ...
    def collidingItems(self, /, mode: PySide6.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[PySide6.QtWidgets.QGraphicsItem]: ...
    def commonAncestorItem(self, other: PySide6.QtWidgets.QGraphicsItem, /) -> PySide6.QtWidgets.QGraphicsItem: ...
    def contains(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> bool: ...
    def contextMenuEvent(self, event: PySide6.QtWidgets.QGraphicsSceneContextMenuEvent, /) -> None: ...
    def cursor(self, /) -> PySide6.QtGui.QCursor: ...
    def data(self, key: int, /) -> typing.Any: ...
    def deviceTransform(self, viewportTransform: PySide6.QtGui.QTransform, /) -> PySide6.QtGui.QTransform: ...
    def dragEnterEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent, /) -> None: ...
    def dragLeaveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent, /) -> None: ...
    def dragMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent, /) -> None: ...
    def dropEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent, /) -> None: ...
    def effectiveOpacity(self, /) -> float: ...
    @typing.overload
    def ensureVisible(self, /, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect = ..., xmargin: int = ..., ymargin: int = ...) -> None: ...
    @typing.overload
    def ensureVisible(self, x: float, y: float, w: float, h: float, /, xmargin: int = ..., ymargin: int = ...) -> None: ...
    def extension(self, variant: typing.Any, /) -> typing.Any: ...
    def filtersChildEvents(self, /) -> bool: ...
    def flags(self, /) -> PySide6.QtWidgets.QGraphicsItem.GraphicsItemFlag: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusItem(self, /) -> PySide6.QtWidgets.QGraphicsItem: ...
    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusProxy(self, /) -> PySide6.QtWidgets.QGraphicsItem: ...
    def focusScopeItem(self, /) -> PySide6.QtWidgets.QGraphicsItem: ...
    def grabKeyboard(self, /) -> None: ...
    def grabMouse(self, /) -> None: ...
    def graphicsEffect(self, /) -> PySide6.QtWidgets.QGraphicsEffect: ...
    def group(self, /) -> PySide6.QtWidgets.QGraphicsItemGroup: ...
    def handlesChildEvents(self, /) -> bool: ...
    def hasCursor(self, /) -> bool: ...
    def hasFocus(self, /) -> bool: ...
    def hide(self, /) -> None: ...
    def hoverEnterEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent, /) -> None: ...
    def hoverLeaveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent, /) -> None: ...
    def hoverMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent, /) -> None: ...
    def inputMethodEvent(self, event: PySide6.QtGui.QInputMethodEvent, /) -> None: ...
    def inputMethodHints(self, /) -> PySide6.QtCore.Qt.InputMethodHint: ...
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery, /) -> typing.Any: ...
    def installSceneEventFilter(self, filterItem: PySide6.QtWidgets.QGraphicsItem, /) -> None: ...
    def isActive(self, /) -> bool: ...
    def isAncestorOf(self, child: PySide6.QtWidgets.QGraphicsItem, /) -> bool: ...
    def isBlockedByModalPanel(self, /) -> typing.Tuple[bool, PySide6.QtWidgets.QGraphicsItem]: ...
    def isClipped(self, /) -> bool: ...
    def isEnabled(self, /) -> bool: ...
    @typing.overload
    def isObscured(self, /, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect = ...) -> bool: ...
    @typing.overload
    def isObscured(self, x: float, y: float, w: float, h: float, /) -> bool: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> bool: ...
    def isPanel(self, /) -> bool: ...
    def isSelected(self, /) -> bool: ...
    def isUnderMouse(self, /) -> bool: ...
    def isVisible(self, /) -> bool: ...
    def isVisibleTo(self, parent: PySide6.QtWidgets.QGraphicsItem, /) -> bool: ...
    def isWidget(self, /) -> bool: ...
    def isWindow(self, /) -> bool: ...
    def itemChange(self, change: PySide6.QtWidgets.QGraphicsItem.GraphicsItemChange, value: typing.Any, /) -> typing.Any: ...
    def itemTransform(self, other: PySide6.QtWidgets.QGraphicsItem, /) -> typing.Tuple[PySide6.QtGui.QTransform, bool]: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def keyReleaseEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    @typing.overload
    def mapFromItem(self, item: PySide6.QtWidgets.QGraphicsItem, path: PySide6.QtGui.QPainterPath, /) -> PySide6.QtGui.QPainterPath: ...
    @typing.overload
    def mapFromItem(self, item: PySide6.QtWidgets.QGraphicsItem, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromItem(self, item: PySide6.QtWidgets.QGraphicsItem, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapFromItem(self, item: PySide6.QtWidgets.QGraphicsItem, polygon: PySide6.QtGui.QPolygonF | collections.abc.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromItem(self, item: PySide6.QtWidgets.QGraphicsItem, x: float, y: float, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapFromItem(self, item: PySide6.QtWidgets.QGraphicsItem, x: float, y: float, w: float, h: float, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromParent(self, path: PySide6.QtGui.QPainterPath, /) -> PySide6.QtGui.QPainterPath: ...
    @typing.overload
    def mapFromParent(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromParent(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapFromParent(self, polygon: PySide6.QtGui.QPolygonF | collections.abc.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromParent(self, x: float, y: float, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapFromParent(self, x: float, y: float, w: float, h: float, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromScene(self, path: PySide6.QtGui.QPainterPath, /) -> PySide6.QtGui.QPainterPath: ...
    @typing.overload
    def mapFromScene(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromScene(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapFromScene(self, polygon: PySide6.QtGui.QPolygonF | collections.abc.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapFromScene(self, x: float, y: float, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapFromScene(self, x: float, y: float, w: float, h: float, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapRectFromItem(self, item: PySide6.QtWidgets.QGraphicsItem, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromItem(self, item: PySide6.QtWidgets.QGraphicsItem, x: float, y: float, w: float, h: float, /) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromParent(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromParent(self, x: float, y: float, w: float, h: float, /) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromScene(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def mapRectFromScene(self, x: float, y: float, w: float, h: float, /) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def mapRectToItem(self, item: PySide6.QtWidgets.QGraphicsItem, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def mapRectToItem(self, item: PySide6.QtWidgets.QGraphicsItem, x: float, y: float, w: float, h: float, /) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def mapRectToParent(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def mapRectToParent(self, x: float, y: float, w: float, h: float, /) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def mapRectToScene(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def mapRectToScene(self, x: float, y: float, w: float, h: float, /) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def mapToItem(self, item: PySide6.QtWidgets.QGraphicsItem, path: PySide6.QtGui.QPainterPath, /) -> PySide6.QtGui.QPainterPath: ...
    @typing.overload
    def mapToItem(self, item: PySide6.QtWidgets.QGraphicsItem, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapToItem(self, item: PySide6.QtWidgets.QGraphicsItem, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapToItem(self, item: PySide6.QtWidgets.QGraphicsItem, polygon: PySide6.QtGui.QPolygonF | collections.abc.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapToItem(self, item: PySide6.QtWidgets.QGraphicsItem, x: float, y: float, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapToItem(self, item: PySide6.QtWidgets.QGraphicsItem, x: float, y: float, w: float, h: float, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapToParent(self, path: PySide6.QtGui.QPainterPath, /) -> PySide6.QtGui.QPainterPath: ...
    @typing.overload
    def mapToParent(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapToParent(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapToParent(self, polygon: PySide6.QtGui.QPolygonF | collections.abc.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapToParent(self, x: float, y: float, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapToParent(self, x: float, y: float, w: float, h: float, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, path: PySide6.QtGui.QPainterPath, /) -> PySide6.QtGui.QPainterPath: ...
    @typing.overload
    def mapToScene(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, polygon: PySide6.QtGui.QPolygonF | collections.abc.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, x: float, y: float, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, x: float, y: float, w: float, h: float, /) -> PySide6.QtGui.QPolygonF: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent, /) -> None: ...
    def mouseMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent, /) -> None: ...
    def mousePressEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent, /) -> None: ...
    def moveBy(self, dx: float, dy: float, /) -> None: ...
    def opacity(self, /) -> float: ...
    def opaqueArea(self, /) -> PySide6.QtGui.QPainterPath: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def panel(self, /) -> PySide6.QtWidgets.QGraphicsItem: ...
    def panelModality(self, /) -> PySide6.QtWidgets.QGraphicsItem.PanelModality: ...
    def parentItem(self, /) -> PySide6.QtWidgets.QGraphicsItem: ...
    def parentObject(self, /) -> PySide6.QtWidgets.QGraphicsObject: ...
    def parentWidget(self, /) -> PySide6.QtWidgets.QGraphicsWidget: ...
    def pos(self, /) -> PySide6.QtCore.QPointF: ...
    def prepareGeometryChange(self, /) -> None: ...
    def removeFromIndex(self, /) -> None: ...
    def removeSceneEventFilter(self, filterItem: PySide6.QtWidgets.QGraphicsItem, /) -> None: ...
    def resetTransform(self, /) -> None: ...
    def rotation(self, /) -> float: ...
    def scale(self, /) -> float: ...
    def scene(self, /) -> PySide6.QtWidgets.QGraphicsScene: ...
    def sceneBoundingRect(self, /) -> PySide6.QtCore.QRectF: ...
    def sceneEvent(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def sceneEventFilter(self, watched: PySide6.QtWidgets.QGraphicsItem, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def scenePos(self, /) -> PySide6.QtCore.QPointF: ...
    def sceneTransform(self, /) -> PySide6.QtGui.QTransform: ...
    def scroll(self, dx: float, dy: float, /, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect = ...) -> None: ...
    def setAcceptDrops(self, on: bool, /) -> None: ...
    def setAcceptHoverEvents(self, enabled: bool, /) -> None: ...
    def setAcceptTouchEvents(self, enabled: bool, /) -> None: ...
    def setAcceptedMouseButtons(self, buttons: PySide6.QtCore.Qt.MouseButton, /) -> None: ...
    def setActive(self, active: bool, /) -> None: ...
    def setBoundingRegionGranularity(self, granularity: float, /) -> None: ...
    def setCacheMode(self, mode: PySide6.QtWidgets.QGraphicsItem.CacheMode, /, cacheSize: PySide6.QtCore.QSize = ...) -> None: ...
    def setCursor(self, cursor: PySide6.QtGui.QCursor | PySide6.QtCore.Qt.CursorShape | PySide6.QtGui.QPixmap, /) -> None: ...
    def setData(self, key: int, value: typing.Any, /) -> None: ...
    def setEnabled(self, enabled: bool, /) -> None: ...
    def setFiltersChildEvents(self, enabled: bool, /) -> None: ...
    def setFlag(self, flag: PySide6.QtWidgets.QGraphicsItem.GraphicsItemFlag, /, enabled: bool = ...) -> None: ...
    def setFlags(self, flags: PySide6.QtWidgets.QGraphicsItem.GraphicsItemFlag, /) -> None: ...
    def setFocus(self, /, focusReason: PySide6.QtCore.Qt.FocusReason = ...) -> None: ...
    def setFocusProxy(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> None: ...
    def setGraphicsEffect(self, effect: PySide6.QtWidgets.QGraphicsEffect, /) -> None: ...
    def setGroup(self, group: PySide6.QtWidgets.QGraphicsItemGroup, /) -> None: ...
    def setHandlesChildEvents(self, enabled: bool, /) -> None: ...
    def setInputMethodHints(self, hints: PySide6.QtCore.Qt.InputMethodHint, /) -> None: ...
    def setOpacity(self, opacity: float, /) -> None: ...
    def setPanelModality(self, panelModality: PySide6.QtWidgets.QGraphicsItem.PanelModality, /) -> None: ...
    def setParentItem(self, parent: PySide6.QtWidgets.QGraphicsItem, /) -> None: ...
    @typing.overload
    def setPos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    @typing.overload
    def setPos(self, x: float, y: float, /) -> None: ...
    def setRotation(self, angle: float, /) -> None: ...
    def setScale(self, scale: float, /) -> None: ...
    def setSelected(self, selected: bool, /) -> None: ...
    def setToolTip(self, toolTip: str, /) -> None: ...
    def setTransform(self, matrix: PySide6.QtGui.QTransform, /, combine: bool = ...) -> None: ...
    @typing.overload
    def setTransformOriginPoint(self, origin: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    @typing.overload
    def setTransformOriginPoint(self, ax: float, ay: float, /) -> None: ...
    def setTransformations(self, transformations: collections.abc.Sequence[PySide6.QtWidgets.QGraphicsTransform], /) -> None: ...
    def setVisible(self, visible: bool, /) -> None: ...
    def setX(self, x: float, /) -> None: ...
    def setY(self, y: float, /) -> None: ...
    def setZValue(self, z: float, /) -> None: ...
    def shape(self, /) -> PySide6.QtGui.QPainterPath: ...
    def show(self, /) -> None: ...
    def stackBefore(self, sibling: PySide6.QtWidgets.QGraphicsItem, /) -> None: ...
    def toGraphicsObject(self, /) -> PySide6.QtWidgets.QGraphicsObject: ...
    def toolTip(self, /) -> str: ...
    def topLevelItem(self, /) -> PySide6.QtWidgets.QGraphicsItem: ...
    def topLevelWidget(self, /) -> PySide6.QtWidgets.QGraphicsWidget: ...
    def transform(self, /) -> PySide6.QtGui.QTransform: ...
    def transformOriginPoint(self, /) -> PySide6.QtCore.QPointF: ...
    def transformations(self, /) -> typing.List[PySide6.QtWidgets.QGraphicsTransform]: ...
    def type(self, /) -> int: ...
    def ungrabKeyboard(self, /) -> None: ...
    def ungrabMouse(self, /) -> None: ...
    def unsetCursor(self, /) -> None: ...
    @typing.overload
    def update(self, /, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect = ...) -> None: ...
    @typing.overload
    def update(self, x: float, y: float, width: float, height: float, /) -> None: ...
    def updateMicroFocus(self, /) -> None: ...
    def wheelEvent(self, event: PySide6.QtWidgets.QGraphicsSceneWheelEvent, /) -> None: ...
    def window(self, /) -> PySide6.QtWidgets.QGraphicsWidget: ...
    def x(self, /) -> float: ...
    def y(self, /) -> float: ...
    def zValue(self, /) -> float: ...


class QGraphicsItemAnimation(PySide6.QtCore.QObject):

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def afterAnimationStep(self, step: float, /) -> None: ...
    def beforeAnimationStep(self, step: float, /) -> None: ...
    def clear(self, /) -> None: ...
    def horizontalScaleAt(self, step: float, /) -> float: ...
    def horizontalShearAt(self, step: float, /) -> float: ...
    def item(self, /) -> PySide6.QtWidgets.QGraphicsItem: ...
    def posAt(self, step: float, /) -> PySide6.QtCore.QPointF: ...
    def posList(self, /) -> typing.List[typing.Tuple[float, PySide6.QtCore.QPointF]]: ...
    def rotationAt(self, step: float, /) -> float: ...
    def rotationList(self, /) -> typing.List[typing.Tuple[float, float]]: ...
    def scaleList(self, /) -> typing.List[typing.Tuple[float, PySide6.QtCore.QPointF]]: ...
    def setItem(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> None: ...
    def setPosAt(self, step: float, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setRotationAt(self, step: float, angle: float, /) -> None: ...
    def setScaleAt(self, step: float, sx: float, sy: float, /) -> None: ...
    def setShearAt(self, step: float, sh: float, sv: float, /) -> None: ...
    def setStep(self, x: float, /) -> None: ...
    def setTimeLine(self, timeLine: PySide6.QtCore.QTimeLine, /) -> None: ...
    def setTranslationAt(self, step: float, dx: float, dy: float, /) -> None: ...
    def shearList(self, /) -> typing.List[typing.Tuple[float, PySide6.QtCore.QPointF]]: ...
    def timeLine(self, /) -> PySide6.QtCore.QTimeLine: ...
    def transformAt(self, step: float, /) -> PySide6.QtGui.QTransform: ...
    def translationList(self, /) -> typing.List[typing.Tuple[float, PySide6.QtCore.QPointF]]: ...
    def verticalScaleAt(self, step: float, /) -> float: ...
    def verticalShearAt(self, step: float, /) -> float: ...
    def xTranslationAt(self, step: float, /) -> float: ...
    def yTranslationAt(self, step: float, /) -> float: ...


class QGraphicsItemGroup(PySide6.QtWidgets.QGraphicsItem):

    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...

    def addToGroup(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> None: ...
    def boundingRect(self, /) -> PySide6.QtCore.QRectF: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> bool: ...
    def opaqueArea(self, /) -> PySide6.QtGui.QPainterPath: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def removeFromGroup(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> None: ...
    def type(self, /) -> int: ...


class QGraphicsLayout(PySide6.QtWidgets.QGraphicsLayoutItem):

    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsLayoutItem | None = ...) -> None: ...

    def activate(self, /) -> None: ...
    def addChildLayoutItem(self, layoutItem: PySide6.QtWidgets.QGraphicsLayoutItem, /) -> None: ...
    def count(self, /) -> int: ...
    def getContentsMargins(self, /) -> object: ...
    @staticmethod
    def instantInvalidatePropagation() -> bool: ...
    def invalidate(self, /) -> None: ...
    def isActivated(self, /) -> bool: ...
    def itemAt(self, i: int, /) -> PySide6.QtWidgets.QGraphicsLayoutItem: ...
    def removeAt(self, index: int, /) -> None: ...
    def setContentsMargins(self, left: float, top: float, right: float, bottom: float, /) -> None: ...
    @staticmethod
    def setInstantInvalidatePropagation(enable: bool, /) -> None: ...
    def updateGeometry(self, /) -> None: ...
    def widgetEvent(self, e: PySide6.QtCore.QEvent, /) -> None: ...


class QGraphicsLayoutItem(Shiboken.Object):

    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsLayoutItem | None = ..., isLayout: bool = ...) -> None: ...

    def contentsRect(self, /) -> PySide6.QtCore.QRectF: ...
    def effectiveSizeHint(self, which: PySide6.QtCore.Qt.SizeHint, /, constraint: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize = ...) -> PySide6.QtCore.QSizeF: ...
    def geometry(self, /) -> PySide6.QtCore.QRectF: ...
    def getContentsMargins(self, /) -> object: ...
    def graphicsItem(self, /) -> PySide6.QtWidgets.QGraphicsItem: ...
    def isEmpty(self, /) -> bool: ...
    def isLayout(self, /) -> bool: ...
    def maximumHeight(self, /) -> float: ...
    def maximumSize(self, /) -> PySide6.QtCore.QSizeF: ...
    def maximumWidth(self, /) -> float: ...
    def minimumHeight(self, /) -> float: ...
    def minimumSize(self, /) -> PySide6.QtCore.QSizeF: ...
    def minimumWidth(self, /) -> float: ...
    def ownedByLayout(self, /) -> bool: ...
    def parentLayoutItem(self, /) -> PySide6.QtWidgets.QGraphicsLayoutItem: ...
    def preferredHeight(self, /) -> float: ...
    def preferredSize(self, /) -> PySide6.QtCore.QSizeF: ...
    def preferredWidth(self, /) -> float: ...
    def setGeometry(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> None: ...
    def setGraphicsItem(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> None: ...
    def setMaximumHeight(self, height: float, /) -> None: ...
    @typing.overload
    def setMaximumSize(self, size: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> None: ...
    @typing.overload
    def setMaximumSize(self, w: float, h: float, /) -> None: ...
    def setMaximumWidth(self, width: float, /) -> None: ...
    def setMinimumHeight(self, height: float, /) -> None: ...
    @typing.overload
    def setMinimumSize(self, size: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> None: ...
    @typing.overload
    def setMinimumSize(self, w: float, h: float, /) -> None: ...
    def setMinimumWidth(self, width: float, /) -> None: ...
    def setOwnedByLayout(self, ownedByLayout: bool, /) -> None: ...
    def setParentLayoutItem(self, parent: PySide6.QtWidgets.QGraphicsLayoutItem, /) -> None: ...
    def setPreferredHeight(self, height: float, /) -> None: ...
    @typing.overload
    def setPreferredSize(self, size: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> None: ...
    @typing.overload
    def setPreferredSize(self, w: float, h: float, /) -> None: ...
    def setPreferredWidth(self, width: float, /) -> None: ...
    @typing.overload
    def setSizePolicy(self, hPolicy: PySide6.QtWidgets.QSizePolicy.Policy, vPolicy: PySide6.QtWidgets.QSizePolicy.Policy, /, controlType: PySide6.QtWidgets.QSizePolicy.ControlType = ...) -> None: ...
    @typing.overload
    def setSizePolicy(self, policy: PySide6.QtWidgets.QSizePolicy, /) -> None: ...
    def sizeHint(self, which: PySide6.QtCore.Qt.SizeHint, /, constraint: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize = ...) -> PySide6.QtCore.QSizeF: ...
    def sizePolicy(self, /) -> PySide6.QtWidgets.QSizePolicy: ...
    def updateGeometry(self, /) -> None: ...


class QGraphicsLineItem(PySide6.QtWidgets.QGraphicsItem):

    @typing.overload
    def __init__(self, line: PySide6.QtCore.QLineF | PySide6.QtCore.QLine, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...
    @typing.overload
    def __init__(self, x1: float, y1: float, x2: float, y2: float, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...

    def boundingRect(self, /) -> PySide6.QtCore.QRectF: ...
    def contains(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> bool: ...
    def extension(self, variant: typing.Any, /) -> typing.Any: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> bool: ...
    def line(self, /) -> PySide6.QtCore.QLineF: ...
    def opaqueArea(self, /) -> PySide6.QtGui.QPainterPath: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def pen(self, /) -> PySide6.QtGui.QPen: ...
    @typing.overload
    def setLine(self, line: PySide6.QtCore.QLineF | PySide6.QtCore.QLine, /) -> None: ...
    @typing.overload
    def setLine(self, x1: float, y1: float, x2: float, y2: float, /) -> None: ...
    def setPen(self, pen: PySide6.QtGui.QPen | PySide6.QtCore.Qt.PenStyle | PySide6.QtGui.QColor, /) -> None: ...
    def shape(self, /) -> PySide6.QtGui.QPainterPath: ...
    def type(self, /) -> int: ...


class QGraphicsLinearLayout(PySide6.QtWidgets.QGraphicsLayout):

    @typing.overload
    def __init__(self, orientation: PySide6.QtCore.Qt.Orientation, /, parent: PySide6.QtWidgets.QGraphicsLayoutItem | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsLayoutItem | None = ...) -> None: ...

    def addItem(self, item: PySide6.QtWidgets.QGraphicsLayoutItem, /) -> None: ...
    def addStretch(self, /, stretch: int = ...) -> None: ...
    def alignment(self, item: PySide6.QtWidgets.QGraphicsLayoutItem, /) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def count(self, /) -> int: ...
    def dump(self, /, indent: int | None = ...) -> None: ...
    def insertItem(self, index: int, item: PySide6.QtWidgets.QGraphicsLayoutItem, /) -> None: ...
    def insertStretch(self, index: int, /, stretch: int = ...) -> None: ...
    def invalidate(self, /) -> None: ...
    def itemAt(self, index: int, /) -> PySide6.QtWidgets.QGraphicsLayoutItem: ...
    def itemSpacing(self, index: int, /) -> float: ...
    def orientation(self, /) -> PySide6.QtCore.Qt.Orientation: ...
    def removeAt(self, index: int, /) -> None: ...
    def removeItem(self, item: PySide6.QtWidgets.QGraphicsLayoutItem, /) -> None: ...
    def setAlignment(self, item: PySide6.QtWidgets.QGraphicsLayoutItem, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    def setGeometry(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> None: ...
    def setItemSpacing(self, index: int, spacing: float, /) -> None: ...
    def setOrientation(self, orientation: PySide6.QtCore.Qt.Orientation, /) -> None: ...
    def setSpacing(self, spacing: float, /) -> None: ...
    def setStretchFactor(self, item: PySide6.QtWidgets.QGraphicsLayoutItem, stretch: int, /) -> None: ...
    def sizeHint(self, which: PySide6.QtCore.Qt.SizeHint, /, constraint: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize = ...) -> PySide6.QtCore.QSizeF: ...
    def spacing(self, /) -> float: ...
    def stretchFactor(self, item: PySide6.QtWidgets.QGraphicsLayoutItem, /) -> int: ...


class QGraphicsObject(PySide6.QtWidgets.QGraphicsItem, PySide6.QtCore.QObject):

    childrenChanged          : typing.ClassVar[Signal] = ... # childrenChanged()
    enabledChanged           : typing.ClassVar[Signal] = ... # enabledChanged()
    heightChanged            : typing.ClassVar[Signal] = ... # heightChanged()
    opacityChanged           : typing.ClassVar[Signal] = ... # opacityChanged()
    parentChanged            : typing.ClassVar[Signal] = ... # parentChanged()
    rotationChanged          : typing.ClassVar[Signal] = ... # rotationChanged()
    scaleChanged             : typing.ClassVar[Signal] = ... # scaleChanged()
    visibleChanged           : typing.ClassVar[Signal] = ... # visibleChanged()
    widthChanged             : typing.ClassVar[Signal] = ... # widthChanged()
    xChanged                 : typing.ClassVar[Signal] = ... # xChanged()
    yChanged                 : typing.ClassVar[Signal] = ... # yChanged()
    zChanged                 : typing.ClassVar[Signal] = ... # zChanged()

    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsObject | None = ..., *, opacity: float | None = ..., enabled: bool | None = ..., visible: bool | None = ..., pos: PySide6.QtCore.QPointF | None = ..., x: float | None = ..., y: float | None = ..., z: float | None = ..., rotation: float | None = ..., scale: float | None = ..., transformOriginPoint: PySide6.QtCore.QPointF | None = ..., effect: PySide6.QtWidgets.QGraphicsEffect | None = ...) -> None: ...

    def __repr__(self, /) -> str: ...
    def event(self, ev: PySide6.QtCore.QEvent, /) -> bool: ...
    def grabGesture(self, type: PySide6.QtCore.Qt.GestureType, /, flags: PySide6.QtCore.Qt.GestureFlag = ...) -> None: ...
    def ungrabGesture(self, type: PySide6.QtCore.Qt.GestureType, /) -> None: ...
    def updateMicroFocus(self, /) -> None: ...


class QGraphicsOpacityEffect(PySide6.QtWidgets.QGraphicsEffect):

    opacityChanged           : typing.ClassVar[Signal] = ... # opacityChanged(double)
    opacityMaskChanged       : typing.ClassVar[Signal] = ... # opacityMaskChanged(QBrush)

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, opacity: float | None = ..., opacityMask: PySide6.QtGui.QBrush | None = ...) -> None: ...

    def draw(self, painter: PySide6.QtGui.QPainter, /) -> None: ...
    def opacity(self, /) -> float: ...
    def opacityMask(self, /) -> PySide6.QtGui.QBrush: ...
    def setOpacity(self, opacity: float, /) -> None: ...
    def setOpacityMask(self, mask: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, /) -> None: ...


class QGraphicsPathItem(PySide6.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, path: PySide6.QtGui.QPainterPath, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...

    def boundingRect(self, /) -> PySide6.QtCore.QRectF: ...
    def contains(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> bool: ...
    def extension(self, variant: typing.Any, /) -> typing.Any: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> bool: ...
    def opaqueArea(self, /) -> PySide6.QtGui.QPainterPath: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def path(self, /) -> PySide6.QtGui.QPainterPath: ...
    def setPath(self, path: PySide6.QtGui.QPainterPath, /) -> None: ...
    def shape(self, /) -> PySide6.QtGui.QPainterPath: ...
    def type(self, /) -> int: ...


class QGraphicsPixmapItem(PySide6.QtWidgets.QGraphicsItem):

    class ShapeMode(enum.Enum):

        MaskShape                 = ...  # 0x0
        BoundingRectShape         = ...  # 0x1
        HeuristicMaskShape        = ...  # 0x2


    @typing.overload
    def __init__(self, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...

    def boundingRect(self, /) -> PySide6.QtCore.QRectF: ...
    def contains(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> bool: ...
    def extension(self, variant: typing.Any, /) -> typing.Any: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> bool: ...
    def offset(self, /) -> PySide6.QtCore.QPointF: ...
    def opaqueArea(self, /) -> PySide6.QtGui.QPainterPath: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def pixmap(self, /) -> PySide6.QtGui.QPixmap: ...
    @typing.overload
    def setOffset(self, offset: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    @typing.overload
    def setOffset(self, x: float, y: float, /) -> None: ...
    def setPixmap(self, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, /) -> None: ...
    def setShapeMode(self, mode: PySide6.QtWidgets.QGraphicsPixmapItem.ShapeMode, /) -> None: ...
    def setTransformationMode(self, mode: PySide6.QtCore.Qt.TransformationMode, /) -> None: ...
    def shape(self, /) -> PySide6.QtGui.QPainterPath: ...
    def shapeMode(self, /) -> PySide6.QtWidgets.QGraphicsPixmapItem.ShapeMode: ...
    def transformationMode(self, /) -> PySide6.QtCore.Qt.TransformationMode: ...
    def type(self, /) -> int: ...


class QGraphicsPolygonItem(PySide6.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, polygon: PySide6.QtGui.QPolygonF | collections.abc.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...

    def boundingRect(self, /) -> PySide6.QtCore.QRectF: ...
    def contains(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> bool: ...
    def extension(self, variant: typing.Any, /) -> typing.Any: ...
    def fillRule(self, /) -> PySide6.QtCore.Qt.FillRule: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> bool: ...
    def opaqueArea(self, /) -> PySide6.QtGui.QPainterPath: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def polygon(self, /) -> PySide6.QtGui.QPolygonF: ...
    def setFillRule(self, rule: PySide6.QtCore.Qt.FillRule, /) -> None: ...
    def setPolygon(self, polygon: PySide6.QtGui.QPolygonF | collections.abc.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF, /) -> None: ...
    def shape(self, /) -> PySide6.QtGui.QPainterPath: ...
    def type(self, /) -> int: ...


class QGraphicsProxyWidget(PySide6.QtWidgets.QGraphicsWidget):

    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ..., wFlags: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    def contextMenuEvent(self, event: PySide6.QtWidgets.QGraphicsSceneContextMenuEvent, /) -> None: ...
    def createProxyForChildWidget(self, child: PySide6.QtWidgets.QWidget, /) -> PySide6.QtWidgets.QGraphicsProxyWidget: ...
    def dragEnterEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent, /) -> None: ...
    def dragLeaveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent, /) -> None: ...
    def dragMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent, /) -> None: ...
    def dropEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent, /) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def eventFilter(self, object: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusNextPrevChild(self, next: bool, /) -> bool: ...
    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def grabMouseEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def hideEvent(self, event: PySide6.QtGui.QHideEvent, /) -> None: ...
    def hoverEnterEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent, /) -> None: ...
    def hoverLeaveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent, /) -> None: ...
    def hoverMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent, /) -> None: ...
    def inputMethodEvent(self, event: PySide6.QtGui.QInputMethodEvent, /) -> None: ...
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery, /) -> typing.Any: ...
    def itemChange(self, change: PySide6.QtWidgets.QGraphicsItem.GraphicsItemChange, value: typing.Any, /) -> typing.Any: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def keyReleaseEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent, /) -> None: ...
    def mouseMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent, /) -> None: ...
    def mousePressEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent, /) -> None: ...
    def newProxyWidget(self, arg__1: PySide6.QtWidgets.QWidget, /) -> PySide6.QtWidgets.QGraphicsProxyWidget: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def resizeEvent(self, event: PySide6.QtWidgets.QGraphicsSceneResizeEvent, /) -> None: ...
    @typing.overload
    def setGeometry(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> None: ...
    @typing.overload
    def setGeometry(self, x: float, y: float, w: float, h: float, /) -> None: ...
    def setWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def showEvent(self, event: PySide6.QtGui.QShowEvent, /) -> None: ...
    def sizeHint(self, which: PySide6.QtCore.Qt.SizeHint, /, constraint: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize = ...) -> PySide6.QtCore.QSizeF: ...
    def subWidgetRect(self, widget: PySide6.QtWidgets.QWidget, /) -> PySide6.QtCore.QRectF: ...
    def type(self, /) -> int: ...
    def ungrabMouseEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def wheelEvent(self, event: PySide6.QtWidgets.QGraphicsSceneWheelEvent, /) -> None: ...
    def widget(self, /) -> PySide6.QtWidgets.QWidget: ...


class QGraphicsRectItem(PySide6.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float, w: float, h: float, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...

    def boundingRect(self, /) -> PySide6.QtCore.QRectF: ...
    def contains(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> bool: ...
    def extension(self, variant: typing.Any, /) -> typing.Any: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> bool: ...
    def opaqueArea(self, /) -> PySide6.QtGui.QPainterPath: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def rect(self, /) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def setRect(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> None: ...
    @typing.overload
    def setRect(self, x: float, y: float, w: float, h: float, /) -> None: ...
    def shape(self, /) -> PySide6.QtGui.QPainterPath: ...
    def type(self, /) -> int: ...


class QGraphicsRotation(PySide6.QtWidgets.QGraphicsTransform):

    angleChanged             : typing.ClassVar[Signal] = ... # angleChanged()
    axisChanged              : typing.ClassVar[Signal] = ... # axisChanged()
    originChanged            : typing.ClassVar[Signal] = ... # originChanged()

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, origin: PySide6.QtGui.QVector3D | None = ..., angle: float | None = ..., axis: PySide6.QtGui.QVector3D | None = ...) -> None: ...

    def angle(self, /) -> float: ...
    def applyTo(self, matrix: PySide6.QtGui.QMatrix4x4 | PySide6.QtGui.QTransform, /) -> None: ...
    def axis(self, /) -> PySide6.QtGui.QVector3D: ...
    def origin(self, /) -> PySide6.QtGui.QVector3D: ...
    def setAngle(self, arg__1: float, /) -> None: ...
    @typing.overload
    def setAxis(self, axis: PySide6.QtCore.Qt.Axis, /) -> None: ...
    @typing.overload
    def setAxis(self, axis: PySide6.QtGui.QVector3D, /) -> None: ...
    def setOrigin(self, point: PySide6.QtGui.QVector3D, /) -> None: ...


class QGraphicsScale(PySide6.QtWidgets.QGraphicsTransform):

    originChanged            : typing.ClassVar[Signal] = ... # originChanged()
    scaleChanged             : typing.ClassVar[Signal] = ... # scaleChanged()
    xScaleChanged            : typing.ClassVar[Signal] = ... # xScaleChanged()
    yScaleChanged            : typing.ClassVar[Signal] = ... # yScaleChanged()
    zScaleChanged            : typing.ClassVar[Signal] = ... # zScaleChanged()

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, origin: PySide6.QtGui.QVector3D | None = ..., xScale: float | None = ..., yScale: float | None = ..., zScale: float | None = ...) -> None: ...

    def applyTo(self, matrix: PySide6.QtGui.QMatrix4x4 | PySide6.QtGui.QTransform, /) -> None: ...
    def origin(self, /) -> PySide6.QtGui.QVector3D: ...
    def setOrigin(self, point: PySide6.QtGui.QVector3D, /) -> None: ...
    def setXScale(self, arg__1: float, /) -> None: ...
    def setYScale(self, arg__1: float, /) -> None: ...
    def setZScale(self, arg__1: float, /) -> None: ...
    def xScale(self, /) -> float: ...
    def yScale(self, /) -> float: ...
    def zScale(self, /) -> float: ...


class QGraphicsScene(PySide6.QtCore.QObject):

    changed                  : typing.ClassVar[Signal] = ... # changed(QList<QRectF>)
    focusItemChanged         : typing.ClassVar[Signal] = ... # focusItemChanged(QGraphicsItem*,QGraphicsItem*,Qt::FocusReason)
    sceneRectChanged         : typing.ClassVar[Signal] = ... # sceneRectChanged(QRectF)
    selectionChanged         : typing.ClassVar[Signal] = ... # selectionChanged()

    class ItemIndexMethod(enum.Enum):

        NoIndex                   = ...  # -1
        BspTreeIndex              = ...  # 0x0

    class SceneLayer(enum.Flag):

        ItemLayer                 = ...  # 0x1
        BackgroundLayer           = ...  # 0x2
        ForegroundLayer           = ...  # 0x4
        AllLayers                 = ...  # 0xffff


    @typing.overload
    def __init__(self, sceneRect: PySide6.QtCore.QRectF, /, parent: PySide6.QtCore.QObject | None = ..., *, backgroundBrush: PySide6.QtGui.QBrush | None = ..., foregroundBrush: PySide6.QtGui.QBrush | None = ..., itemIndexMethod: PySide6.QtWidgets.QGraphicsScene.ItemIndexMethod | None = ..., bspTreeDepth: int | None = ..., palette: PySide6.QtGui.QPalette | None = ..., font: PySide6.QtGui.QFont | None = ..., stickyFocus: bool | None = ..., minimumRenderSize: float | None = ..., focusOnTouch: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, backgroundBrush: PySide6.QtGui.QBrush | None = ..., foregroundBrush: PySide6.QtGui.QBrush | None = ..., itemIndexMethod: PySide6.QtWidgets.QGraphicsScene.ItemIndexMethod | None = ..., sceneRect: PySide6.QtCore.QRectF | None = ..., bspTreeDepth: int | None = ..., palette: PySide6.QtGui.QPalette | None = ..., font: PySide6.QtGui.QFont | None = ..., stickyFocus: bool | None = ..., minimumRenderSize: float | None = ..., focusOnTouch: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, x: float, y: float, width: float, height: float, /, parent: PySide6.QtCore.QObject | None = ..., *, backgroundBrush: PySide6.QtGui.QBrush | None = ..., foregroundBrush: PySide6.QtGui.QBrush | None = ..., itemIndexMethod: PySide6.QtWidgets.QGraphicsScene.ItemIndexMethod | None = ..., sceneRect: PySide6.QtCore.QRectF | None = ..., bspTreeDepth: int | None = ..., palette: PySide6.QtGui.QPalette | None = ..., font: PySide6.QtGui.QFont | None = ..., stickyFocus: bool | None = ..., minimumRenderSize: float | None = ..., focusOnTouch: bool | None = ...) -> None: ...

    def activePanel(self, /) -> PySide6.QtWidgets.QGraphicsItem: ...
    def activeWindow(self, /) -> PySide6.QtWidgets.QGraphicsWidget: ...
    @typing.overload
    def addEllipse(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /, pen: PySide6.QtGui.QPen | PySide6.QtCore.Qt.PenStyle | PySide6.QtGui.QColor = ..., brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap = ...) -> PySide6.QtWidgets.QGraphicsEllipseItem: ...
    @typing.overload
    def addEllipse(self, x: float, y: float, w: float, h: float, /, pen: PySide6.QtGui.QPen | PySide6.QtCore.Qt.PenStyle | PySide6.QtGui.QColor = ..., brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap = ...) -> PySide6.QtWidgets.QGraphicsEllipseItem: ...
    def addItem(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> None: ...
    @typing.overload
    def addLine(self, line: PySide6.QtCore.QLineF | PySide6.QtCore.QLine, /, pen: PySide6.QtGui.QPen | PySide6.QtCore.Qt.PenStyle | PySide6.QtGui.QColor = ...) -> PySide6.QtWidgets.QGraphicsLineItem: ...
    @typing.overload
    def addLine(self, x1: float, y1: float, x2: float, y2: float, /, pen: PySide6.QtGui.QPen | PySide6.QtCore.Qt.PenStyle | PySide6.QtGui.QColor = ...) -> PySide6.QtWidgets.QGraphicsLineItem: ...
    def addPath(self, path: PySide6.QtGui.QPainterPath, /, pen: PySide6.QtGui.QPen | PySide6.QtCore.Qt.PenStyle | PySide6.QtGui.QColor = ..., brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap = ...) -> PySide6.QtWidgets.QGraphicsPathItem: ...
    def addPixmap(self, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, /) -> PySide6.QtWidgets.QGraphicsPixmapItem: ...
    def addPolygon(self, polygon: PySide6.QtGui.QPolygonF | collections.abc.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF, /, pen: PySide6.QtGui.QPen | PySide6.QtCore.Qt.PenStyle | PySide6.QtGui.QColor = ..., brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap = ...) -> PySide6.QtWidgets.QGraphicsPolygonItem: ...
    @typing.overload
    def addRect(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /, pen: PySide6.QtGui.QPen | PySide6.QtCore.Qt.PenStyle | PySide6.QtGui.QColor = ..., brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap = ...) -> PySide6.QtWidgets.QGraphicsRectItem: ...
    @typing.overload
    def addRect(self, x: float, y: float, w: float, h: float, /, pen: PySide6.QtGui.QPen | PySide6.QtCore.Qt.PenStyle | PySide6.QtGui.QColor = ..., brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap = ...) -> PySide6.QtWidgets.QGraphicsRectItem: ...
    def addSimpleText(self, text: str, /, font: PySide6.QtGui.QFont | str | collections.abc.Sequence[str] = ...) -> PySide6.QtWidgets.QGraphicsSimpleTextItem: ...
    def addText(self, text: str, /, font: PySide6.QtGui.QFont | str | collections.abc.Sequence[str] = ...) -> PySide6.QtWidgets.QGraphicsTextItem: ...
    def addWidget(self, widget: PySide6.QtWidgets.QWidget, /, wFlags: PySide6.QtCore.Qt.WindowType = ...) -> PySide6.QtWidgets.QGraphicsProxyWidget: ...
    def advance(self, /) -> None: ...
    def backgroundBrush(self, /) -> PySide6.QtGui.QBrush: ...
    def bspTreeDepth(self, /) -> int: ...
    def clear(self, /) -> None: ...
    def clearFocus(self, /) -> None: ...
    def clearSelection(self, /) -> None: ...
    def collidingItems(self, item: PySide6.QtWidgets.QGraphicsItem, /, mode: PySide6.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[PySide6.QtWidgets.QGraphicsItem]: ...
    def contextMenuEvent(self, event: PySide6.QtWidgets.QGraphicsSceneContextMenuEvent, /) -> None: ...
    def createItemGroup(self, items: collections.abc.Sequence[PySide6.QtWidgets.QGraphicsItem], /) -> PySide6.QtWidgets.QGraphicsItemGroup: ...
    def destroyItemGroup(self, group: PySide6.QtWidgets.QGraphicsItemGroup, /) -> None: ...
    def dragEnterEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent, /) -> None: ...
    def dragLeaveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent, /) -> None: ...
    def dragMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent, /) -> None: ...
    def drawBackground(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> None: ...
    def drawForeground(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> None: ...
    def dropEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent, /) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def eventFilter(self, watched: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusItem(self, /) -> PySide6.QtWidgets.QGraphicsItem: ...
    def focusNextPrevChild(self, next: bool, /) -> bool: ...
    def focusOnTouch(self, /) -> bool: ...
    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def font(self, /) -> PySide6.QtGui.QFont: ...
    def foregroundBrush(self, /) -> PySide6.QtGui.QBrush: ...
    def hasFocus(self, /) -> bool: ...
    def height(self, /) -> float: ...
    def helpEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHelpEvent, /) -> None: ...
    def inputMethodEvent(self, event: PySide6.QtGui.QInputMethodEvent, /) -> None: ...
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery, /) -> typing.Any: ...
    @typing.overload
    def invalidate(self, /, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect = ..., layers: PySide6.QtWidgets.QGraphicsScene.SceneLayer = ...) -> None: ...
    @typing.overload
    def invalidate(self, x: float, y: float, w: float, h: float, /, layers: PySide6.QtWidgets.QGraphicsScene.SceneLayer = ...) -> None: ...
    def isActive(self, /) -> bool: ...
    @typing.overload
    def itemAt(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, deviceTransform: PySide6.QtGui.QTransform, /) -> PySide6.QtWidgets.QGraphicsItem: ...
    @typing.overload
    def itemAt(self, x: float, y: float, deviceTransform: PySide6.QtGui.QTransform, /) -> PySide6.QtWidgets.QGraphicsItem: ...
    def itemIndexMethod(self, /) -> PySide6.QtWidgets.QGraphicsScene.ItemIndexMethod: ...
    @typing.overload
    def items(self, path: PySide6.QtGui.QPainterPath, /, mode: PySide6.QtCore.Qt.ItemSelectionMode = ..., order: PySide6.QtCore.Qt.SortOrder = ..., deviceTransform: PySide6.QtGui.QTransform = ...) -> typing.List[PySide6.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, /, order: PySide6.QtCore.Qt.SortOrder = ...) -> typing.List[PySide6.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /, mode: PySide6.QtCore.Qt.ItemSelectionMode = ..., order: PySide6.QtCore.Qt.SortOrder = ..., deviceTransform: PySide6.QtGui.QTransform = ...) -> typing.List[PySide6.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /, mode: PySide6.QtCore.Qt.ItemSelectionMode = ..., order: PySide6.QtCore.Qt.SortOrder = ..., deviceTransform: PySide6.QtGui.QTransform = ...) -> typing.List[PySide6.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, polygon: PySide6.QtGui.QPolygonF | collections.abc.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF, /, mode: PySide6.QtCore.Qt.ItemSelectionMode = ..., order: PySide6.QtCore.Qt.SortOrder = ..., deviceTransform: PySide6.QtGui.QTransform = ...) -> typing.List[PySide6.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, x: float, y: float, w: float, h: float, mode: PySide6.QtCore.Qt.ItemSelectionMode, order: PySide6.QtCore.Qt.SortOrder, /, deviceTransform: PySide6.QtGui.QTransform = ...) -> typing.List[PySide6.QtWidgets.QGraphicsItem]: ...
    def itemsBoundingRect(self, /) -> PySide6.QtCore.QRectF: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def keyReleaseEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def minimumRenderSize(self, /) -> float: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent, /) -> None: ...
    def mouseGrabberItem(self, /) -> PySide6.QtWidgets.QGraphicsItem: ...
    def mouseMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent, /) -> None: ...
    def mousePressEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent, /) -> None: ...
    def palette(self, /) -> PySide6.QtGui.QPalette: ...
    def removeItem(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> None: ...
    def render(self, painter: PySide6.QtGui.QPainter, /, target: PySide6.QtCore.QRectF | PySide6.QtCore.QRect = ..., source: PySide6.QtCore.QRectF | PySide6.QtCore.QRect = ..., aspectRatioMode: PySide6.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    def sceneRect(self, /) -> PySide6.QtCore.QRectF: ...
    def selectedItems(self, /) -> typing.List[PySide6.QtWidgets.QGraphicsItem]: ...
    def selectionArea(self, /) -> PySide6.QtGui.QPainterPath: ...
    def sendEvent(self, item: PySide6.QtWidgets.QGraphicsItem, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def setActivePanel(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> None: ...
    def setActiveWindow(self, widget: PySide6.QtWidgets.QGraphicsWidget, /) -> None: ...
    def setBackgroundBrush(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, /) -> None: ...
    def setBspTreeDepth(self, depth: int, /) -> None: ...
    def setFocus(self, /, focusReason: PySide6.QtCore.Qt.FocusReason = ...) -> None: ...
    def setFocusItem(self, item: PySide6.QtWidgets.QGraphicsItem, /, focusReason: PySide6.QtCore.Qt.FocusReason = ...) -> None: ...
    def setFocusOnTouch(self, enabled: bool, /) -> None: ...
    def setFont(self, font: PySide6.QtGui.QFont | str | collections.abc.Sequence[str], /) -> None: ...
    def setForegroundBrush(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, /) -> None: ...
    def setItemIndexMethod(self, method: PySide6.QtWidgets.QGraphicsScene.ItemIndexMethod, /) -> None: ...
    def setMinimumRenderSize(self, minSize: float, /) -> None: ...
    def setPalette(self, palette: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, /) -> None: ...
    @typing.overload
    def setSceneRect(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> None: ...
    @typing.overload
    def setSceneRect(self, x: float, y: float, w: float, h: float, /) -> None: ...
    @typing.overload
    def setSelectionArea(self, path: PySide6.QtGui.QPainterPath, /, selectionOperation: PySide6.QtCore.Qt.ItemSelectionOperation = ..., mode: PySide6.QtCore.Qt.ItemSelectionMode = ..., deviceTransform: PySide6.QtGui.QTransform = ...) -> None: ...
    @typing.overload
    def setSelectionArea(self, path: PySide6.QtGui.QPainterPath, deviceTransform: PySide6.QtGui.QTransform, /) -> None: ...
    def setStickyFocus(self, enabled: bool, /) -> None: ...
    def setStyle(self, style: PySide6.QtWidgets.QStyle, /) -> None: ...
    def stickyFocus(self, /) -> bool: ...
    def style(self, /) -> PySide6.QtWidgets.QStyle: ...
    @typing.overload
    def update(self, /, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect = ...) -> None: ...
    @typing.overload
    def update(self, x: float, y: float, w: float, h: float, /) -> None: ...
    def views(self, /) -> typing.List[PySide6.QtWidgets.QGraphicsView]: ...
    def wheelEvent(self, event: PySide6.QtWidgets.QGraphicsSceneWheelEvent, /) -> None: ...
    def width(self, /) -> float: ...


class QGraphicsSceneContextMenuEvent(PySide6.QtWidgets.QGraphicsSceneEvent):

    class Reason(enum.Enum):

        Mouse                     = ...  # 0x0
        Keyboard                  = ...  # 0x1
        Other                     = ...  # 0x2


    def __init__(self, /, type: PySide6.QtCore.QEvent.Type | None = ...) -> None: ...

    def modifiers(self, /) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def pos(self, /) -> PySide6.QtCore.QPointF: ...
    def reason(self, /) -> PySide6.QtWidgets.QGraphicsSceneContextMenuEvent.Reason: ...
    def scenePos(self, /) -> PySide6.QtCore.QPointF: ...
    def screenPos(self, /) -> PySide6.QtCore.QPoint: ...
    def setModifiers(self, modifiers: PySide6.QtCore.Qt.KeyboardModifier, /) -> None: ...
    def setPos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setReason(self, reason: PySide6.QtWidgets.QGraphicsSceneContextMenuEvent.Reason, /) -> None: ...
    def setScenePos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setScreenPos(self, pos: PySide6.QtCore.QPoint, /) -> None: ...


class QGraphicsSceneDragDropEvent(PySide6.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, /, type: PySide6.QtCore.QEvent.Type | None = ...) -> None: ...

    def acceptProposedAction(self, /) -> None: ...
    def buttons(self, /) -> PySide6.QtCore.Qt.MouseButton: ...
    def dropAction(self, /) -> PySide6.QtCore.Qt.DropAction: ...
    def mimeData(self, /) -> PySide6.QtCore.QMimeData: ...
    def modifiers(self, /) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def pos(self, /) -> PySide6.QtCore.QPointF: ...
    def possibleActions(self, /) -> PySide6.QtCore.Qt.DropAction: ...
    def proposedAction(self, /) -> PySide6.QtCore.Qt.DropAction: ...
    def scenePos(self, /) -> PySide6.QtCore.QPointF: ...
    def screenPos(self, /) -> PySide6.QtCore.QPoint: ...
    def setButtons(self, buttons: PySide6.QtCore.Qt.MouseButton, /) -> None: ...
    def setDropAction(self, action: PySide6.QtCore.Qt.DropAction, /) -> None: ...
    def setModifiers(self, modifiers: PySide6.QtCore.Qt.KeyboardModifier, /) -> None: ...
    def setPos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setPossibleActions(self, actions: PySide6.QtCore.Qt.DropAction, /) -> None: ...
    def setProposedAction(self, action: PySide6.QtCore.Qt.DropAction, /) -> None: ...
    def setScenePos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setScreenPos(self, pos: PySide6.QtCore.QPoint, /) -> None: ...
    def source(self, /) -> PySide6.QtWidgets.QWidget: ...


class QGraphicsSceneEvent(PySide6.QtCore.QEvent):

    def __init__(self, type: PySide6.QtCore.QEvent.Type, /) -> None: ...

    def __repr__(self, /) -> str: ...
    def setTimestamp(self, ts: int, /) -> None: ...
    def timestamp(self, /) -> int: ...
    def widget(self, /) -> PySide6.QtWidgets.QWidget: ...


class QGraphicsSceneHelpEvent(PySide6.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, /, type: PySide6.QtCore.QEvent.Type | None = ...) -> None: ...

    def scenePos(self, /) -> PySide6.QtCore.QPointF: ...
    def screenPos(self, /) -> PySide6.QtCore.QPoint: ...
    def setScenePos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setScreenPos(self, pos: PySide6.QtCore.QPoint, /) -> None: ...


class QGraphicsSceneHoverEvent(PySide6.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, /, type: PySide6.QtCore.QEvent.Type | None = ...) -> None: ...

    def lastPos(self, /) -> PySide6.QtCore.QPointF: ...
    def lastScenePos(self, /) -> PySide6.QtCore.QPointF: ...
    def lastScreenPos(self, /) -> PySide6.QtCore.QPoint: ...
    def modifiers(self, /) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def pos(self, /) -> PySide6.QtCore.QPointF: ...
    def scenePos(self, /) -> PySide6.QtCore.QPointF: ...
    def screenPos(self, /) -> PySide6.QtCore.QPoint: ...
    def setLastPos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setLastScenePos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setLastScreenPos(self, pos: PySide6.QtCore.QPoint, /) -> None: ...
    def setModifiers(self, modifiers: PySide6.QtCore.Qt.KeyboardModifier, /) -> None: ...
    def setPos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setScenePos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setScreenPos(self, pos: PySide6.QtCore.QPoint, /) -> None: ...


class QGraphicsSceneMouseEvent(PySide6.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, /, type: PySide6.QtCore.QEvent.Type | None = ...) -> None: ...

    def button(self, /) -> PySide6.QtCore.Qt.MouseButton: ...
    def buttonDownPos(self, button: PySide6.QtCore.Qt.MouseButton, /) -> PySide6.QtCore.QPointF: ...
    def buttonDownScenePos(self, button: PySide6.QtCore.Qt.MouseButton, /) -> PySide6.QtCore.QPointF: ...
    def buttonDownScreenPos(self, button: PySide6.QtCore.Qt.MouseButton, /) -> PySide6.QtCore.QPoint: ...
    def buttons(self, /) -> PySide6.QtCore.Qt.MouseButton: ...
    def flags(self, /) -> PySide6.QtCore.Qt.MouseEventFlag: ...
    def lastPos(self, /) -> PySide6.QtCore.QPointF: ...
    def lastScenePos(self, /) -> PySide6.QtCore.QPointF: ...
    def lastScreenPos(self, /) -> PySide6.QtCore.QPoint: ...
    def modifiers(self, /) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def pos(self, /) -> PySide6.QtCore.QPointF: ...
    def scenePos(self, /) -> PySide6.QtCore.QPointF: ...
    def screenPos(self, /) -> PySide6.QtCore.QPoint: ...
    def setButton(self, button: PySide6.QtCore.Qt.MouseButton, /) -> None: ...
    def setButtonDownPos(self, button: PySide6.QtCore.Qt.MouseButton, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setButtonDownScenePos(self, button: PySide6.QtCore.Qt.MouseButton, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setButtonDownScreenPos(self, button: PySide6.QtCore.Qt.MouseButton, pos: PySide6.QtCore.QPoint, /) -> None: ...
    def setButtons(self, buttons: PySide6.QtCore.Qt.MouseButton, /) -> None: ...
    def setFlags(self, arg__1: PySide6.QtCore.Qt.MouseEventFlag, /) -> None: ...
    def setLastPos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setLastScenePos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setLastScreenPos(self, pos: PySide6.QtCore.QPoint, /) -> None: ...
    def setModifiers(self, modifiers: PySide6.QtCore.Qt.KeyboardModifier, /) -> None: ...
    def setPos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setScenePos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setScreenPos(self, pos: PySide6.QtCore.QPoint, /) -> None: ...
    def setSource(self, source: PySide6.QtCore.Qt.MouseEventSource, /) -> None: ...
    def source(self, /) -> PySide6.QtCore.Qt.MouseEventSource: ...


class QGraphicsSceneMoveEvent(PySide6.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, /) -> None: ...

    def newPos(self, /) -> PySide6.QtCore.QPointF: ...
    def oldPos(self, /) -> PySide6.QtCore.QPointF: ...
    def setNewPos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setOldPos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...


class QGraphicsSceneResizeEvent(PySide6.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, /) -> None: ...

    def newSize(self, /) -> PySide6.QtCore.QSizeF: ...
    def oldSize(self, /) -> PySide6.QtCore.QSizeF: ...
    def setNewSize(self, size: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> None: ...
    def setOldSize(self, size: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> None: ...


class QGraphicsSceneWheelEvent(PySide6.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, /, type: PySide6.QtCore.QEvent.Type | None = ...) -> None: ...

    def buttons(self, /) -> PySide6.QtCore.Qt.MouseButton: ...
    def delta(self, /) -> int: ...
    def isInverted(self, /) -> bool: ...
    def modifiers(self, /) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def orientation(self, /) -> PySide6.QtCore.Qt.Orientation: ...
    def phase(self, /) -> PySide6.QtCore.Qt.ScrollPhase: ...
    def pixelDelta(self, /) -> PySide6.QtCore.QPoint: ...
    def pos(self, /) -> PySide6.QtCore.QPointF: ...
    def scenePos(self, /) -> PySide6.QtCore.QPointF: ...
    def screenPos(self, /) -> PySide6.QtCore.QPoint: ...
    def setButtons(self, buttons: PySide6.QtCore.Qt.MouseButton, /) -> None: ...
    def setDelta(self, delta: int, /) -> None: ...
    def setInverted(self, inverted: bool, /) -> None: ...
    def setModifiers(self, modifiers: PySide6.QtCore.Qt.KeyboardModifier, /) -> None: ...
    def setOrientation(self, orientation: PySide6.QtCore.Qt.Orientation, /) -> None: ...
    def setPhase(self, scrollPhase: PySide6.QtCore.Qt.ScrollPhase, /) -> None: ...
    def setPixelDelta(self, delta: PySide6.QtCore.QPoint, /) -> None: ...
    def setPos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setScenePos(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setScreenPos(self, pos: PySide6.QtCore.QPoint, /) -> None: ...


class QGraphicsSimpleTextItem(PySide6.QtWidgets.QAbstractGraphicsShapeItem):

    @typing.overload
    def __init__(self, text: str, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...

    def boundingRect(self, /) -> PySide6.QtCore.QRectF: ...
    def contains(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> bool: ...
    def extension(self, variant: typing.Any, /) -> typing.Any: ...
    def font(self, /) -> PySide6.QtGui.QFont: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> bool: ...
    def opaqueArea(self, /) -> PySide6.QtGui.QPainterPath: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setFont(self, font: PySide6.QtGui.QFont | str | collections.abc.Sequence[str], /) -> None: ...
    def setText(self, text: str, /) -> None: ...
    def shape(self, /) -> PySide6.QtGui.QPainterPath: ...
    def text(self, /) -> str: ...
    def type(self, /) -> int: ...


class QGraphicsTextItem(PySide6.QtWidgets.QGraphicsObject):

    linkActivated            : typing.ClassVar[Signal] = ... # linkActivated(QString)
    linkHovered              : typing.ClassVar[Signal] = ... # linkHovered(QString)

    @typing.overload
    def __init__(self, text: str, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ...) -> None: ...

    def adjustSize(self, /) -> None: ...
    def boundingRect(self, /) -> PySide6.QtCore.QRectF: ...
    def contains(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> bool: ...
    def contextMenuEvent(self, event: PySide6.QtWidgets.QGraphicsSceneContextMenuEvent, /) -> None: ...
    def defaultTextColor(self, /) -> PySide6.QtGui.QColor: ...
    def document(self, /) -> PySide6.QtGui.QTextDocument: ...
    def dragEnterEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent, /) -> None: ...
    def dragLeaveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent, /) -> None: ...
    def dragMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent, /) -> None: ...
    def dropEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent, /) -> None: ...
    def extension(self, variant: typing.Any, /) -> typing.Any: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def font(self, /) -> PySide6.QtGui.QFont: ...
    def hoverEnterEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent, /) -> None: ...
    def hoverLeaveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent, /) -> None: ...
    def hoverMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent, /) -> None: ...
    def inputMethodEvent(self, event: PySide6.QtGui.QInputMethodEvent, /) -> None: ...
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery, /) -> typing.Any: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> bool: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def keyReleaseEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent, /) -> None: ...
    def mouseMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent, /) -> None: ...
    def mousePressEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent, /) -> None: ...
    def opaqueArea(self, /) -> PySide6.QtGui.QPainterPath: ...
    def openExternalLinks(self, /) -> bool: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def sceneEvent(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def setDefaultTextColor(self, c: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, /) -> None: ...
    def setDocument(self, document: PySide6.QtGui.QTextDocument, /) -> None: ...
    def setFont(self, font: PySide6.QtGui.QFont | str | collections.abc.Sequence[str], /) -> None: ...
    def setHtml(self, html: str, /) -> None: ...
    def setOpenExternalLinks(self, open: bool, /) -> None: ...
    def setPlainText(self, text: str, /) -> None: ...
    def setTabChangesFocus(self, b: bool, /) -> None: ...
    def setTextCursor(self, cursor: PySide6.QtGui.QTextCursor, /) -> None: ...
    def setTextInteractionFlags(self, flags: PySide6.QtCore.Qt.TextInteractionFlag, /) -> None: ...
    def setTextWidth(self, width: float, /) -> None: ...
    def shape(self, /) -> PySide6.QtGui.QPainterPath: ...
    def tabChangesFocus(self, /) -> bool: ...
    def textCursor(self, /) -> PySide6.QtGui.QTextCursor: ...
    def textInteractionFlags(self, /) -> PySide6.QtCore.Qt.TextInteractionFlag: ...
    def textWidth(self, /) -> float: ...
    def toHtml(self, /) -> str: ...
    def toPlainText(self, /) -> str: ...
    def type(self, /) -> int: ...


class QGraphicsTransform(PySide6.QtCore.QObject):

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def applyTo(self, matrix: PySide6.QtGui.QMatrix4x4 | PySide6.QtGui.QTransform, /) -> None: ...
    def update(self, /) -> None: ...


class QGraphicsView(PySide6.QtWidgets.QAbstractScrollArea):

    rubberBandChanged        : typing.ClassVar[Signal] = ... # rubberBandChanged(QRect,QPointF,QPointF)

    class CacheModeFlag(enum.Flag):

        CacheNone                 = ...  # 0x0
        CacheBackground           = ...  # 0x1

    class DragMode(enum.Enum):

        NoDrag                    = ...  # 0x0
        ScrollHandDrag            = ...  # 0x1
        RubberBandDrag            = ...  # 0x2

    class OptimizationFlag(enum.Flag):

        DontSavePainterState      = ...  # 0x1
        DontAdjustForAntialiasing = ...  # 0x2
        IndirectPainting          = ...  # 0x4

    class ViewportAnchor(enum.Enum):

        NoAnchor                  = ...  # 0x0
        AnchorViewCenter          = ...  # 0x1
        AnchorUnderMouse          = ...  # 0x2

    class ViewportUpdateMode(enum.Enum):

        FullViewportUpdate        = ...  # 0x0
        MinimalViewportUpdate     = ...  # 0x1
        SmartViewportUpdate       = ...  # 0x2
        NoViewportUpdate          = ...  # 0x3
        BoundingRectViewportUpdate = ...  # 0x4


    @typing.overload
    def __init__(self, scene: PySide6.QtWidgets.QGraphicsScene, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, backgroundBrush: PySide6.QtGui.QBrush | None = ..., foregroundBrush: PySide6.QtGui.QBrush | None = ..., interactive: bool | None = ..., sceneRect: PySide6.QtCore.QRectF | None = ..., alignment: PySide6.QtCore.Qt.AlignmentFlag | None = ..., renderHints: PySide6.QtGui.QPainter.RenderHint | None = ..., dragMode: PySide6.QtWidgets.QGraphicsView.DragMode | None = ..., cacheMode: PySide6.QtWidgets.QGraphicsView.CacheModeFlag | None = ..., transformationAnchor: PySide6.QtWidgets.QGraphicsView.ViewportAnchor | None = ..., resizeAnchor: PySide6.QtWidgets.QGraphicsView.ViewportAnchor | None = ..., viewportUpdateMode: PySide6.QtWidgets.QGraphicsView.ViewportUpdateMode | None = ..., rubberBandSelectionMode: PySide6.QtCore.Qt.ItemSelectionMode | None = ..., optimizationFlags: PySide6.QtWidgets.QGraphicsView.OptimizationFlag | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, backgroundBrush: PySide6.QtGui.QBrush | None = ..., foregroundBrush: PySide6.QtGui.QBrush | None = ..., interactive: bool | None = ..., sceneRect: PySide6.QtCore.QRectF | None = ..., alignment: PySide6.QtCore.Qt.AlignmentFlag | None = ..., renderHints: PySide6.QtGui.QPainter.RenderHint | None = ..., dragMode: PySide6.QtWidgets.QGraphicsView.DragMode | None = ..., cacheMode: PySide6.QtWidgets.QGraphicsView.CacheModeFlag | None = ..., transformationAnchor: PySide6.QtWidgets.QGraphicsView.ViewportAnchor | None = ..., resizeAnchor: PySide6.QtWidgets.QGraphicsView.ViewportAnchor | None = ..., viewportUpdateMode: PySide6.QtWidgets.QGraphicsView.ViewportUpdateMode | None = ..., rubberBandSelectionMode: PySide6.QtCore.Qt.ItemSelectionMode | None = ..., optimizationFlags: PySide6.QtWidgets.QGraphicsView.OptimizationFlag | None = ...) -> None: ...

    def alignment(self, /) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def backgroundBrush(self, /) -> PySide6.QtGui.QBrush: ...
    def cacheMode(self, /) -> PySide6.QtWidgets.QGraphicsView.CacheModeFlag: ...
    @typing.overload
    def centerOn(self, item: PySide6.QtWidgets.QGraphicsItem, /) -> None: ...
    @typing.overload
    def centerOn(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    @typing.overload
    def centerOn(self, x: float, y: float, /) -> None: ...
    def contextMenuEvent(self, event: PySide6.QtGui.QContextMenuEvent, /) -> None: ...
    def dragEnterEvent(self, event: PySide6.QtGui.QDragEnterEvent, /) -> None: ...
    def dragLeaveEvent(self, event: PySide6.QtGui.QDragLeaveEvent, /) -> None: ...
    def dragMode(self, /) -> PySide6.QtWidgets.QGraphicsView.DragMode: ...
    def dragMoveEvent(self, event: PySide6.QtGui.QDragMoveEvent, /) -> None: ...
    def drawBackground(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> None: ...
    def drawForeground(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> None: ...
    def drawItems(self, painter: PySide6.QtGui.QPainter, items: collections.abc.Iterable, options: collections.abc.Iterable, /) -> None: ...
    def dropEvent(self, event: PySide6.QtGui.QDropEvent, /) -> None: ...
    @typing.overload
    def ensureVisible(self, item: PySide6.QtWidgets.QGraphicsItem, /, xmargin: int = ..., ymargin: int = ...) -> None: ...
    @typing.overload
    def ensureVisible(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /, xmargin: int = ..., ymargin: int = ...) -> None: ...
    @typing.overload
    def ensureVisible(self, x: float, y: float, w: float, h: float, /, xmargin: int = ..., ymargin: int = ...) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    @typing.overload
    def fitInView(self, item: PySide6.QtWidgets.QGraphicsItem, /, aspectRadioMode: PySide6.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    @typing.overload
    def fitInView(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /, aspectRadioMode: PySide6.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    @typing.overload
    def fitInView(self, x: float, y: float, w: float, h: float, /, aspectRadioMode: PySide6.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusNextPrevChild(self, next: bool, /) -> bool: ...
    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def foregroundBrush(self, /) -> PySide6.QtGui.QBrush: ...
    def inputMethodEvent(self, event: PySide6.QtGui.QInputMethodEvent, /) -> None: ...
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery, /) -> typing.Any: ...
    def invalidateScene(self, /, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect = ..., layers: PySide6.QtWidgets.QGraphicsScene.SceneLayer = ...) -> None: ...
    def isInteractive(self, /) -> bool: ...
    def isTransformed(self, /) -> bool: ...
    @typing.overload
    def itemAt(self, pos: PySide6.QtCore.QPoint, /) -> PySide6.QtWidgets.QGraphicsItem: ...
    @typing.overload
    def itemAt(self, x: int, y: int, /) -> PySide6.QtWidgets.QGraphicsItem: ...
    @typing.overload
    def items(self, /) -> typing.List[PySide6.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, path: PySide6.QtGui.QPainterPath, /, mode: PySide6.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[PySide6.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, pos: PySide6.QtCore.QPoint, /) -> typing.List[PySide6.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, rect: PySide6.QtCore.QRect, /, mode: PySide6.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[PySide6.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, polygon: PySide6.QtGui.QPolygon | collections.abc.Sequence[PySide6.QtCore.QPoint] | PySide6.QtCore.QRect, /, mode: PySide6.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[PySide6.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, x: int, y: int, /) -> typing.List[PySide6.QtWidgets.QGraphicsItem]: ...
    @typing.overload
    def items(self, x: int, y: int, w: int, h: int, /, mode: PySide6.QtCore.Qt.ItemSelectionMode = ...) -> typing.List[PySide6.QtWidgets.QGraphicsItem]: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def keyReleaseEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    @typing.overload
    def mapFromScene(self, path: PySide6.QtGui.QPainterPath, /) -> PySide6.QtGui.QPainterPath: ...
    @typing.overload
    def mapFromScene(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtGui.QPolygon: ...
    @typing.overload
    def mapFromScene(self, point: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def mapFromScene(self, polygon: PySide6.QtGui.QPolygonF | collections.abc.Sequence[PySide6.QtCore.QPointF] | PySide6.QtGui.QPolygon | PySide6.QtCore.QRectF, /) -> PySide6.QtGui.QPolygon: ...
    @typing.overload
    def mapFromScene(self, x: float, y: float, /) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def mapFromScene(self, x: float, y: float, w: float, h: float, /) -> PySide6.QtGui.QPolygon: ...
    @typing.overload
    def mapToScene(self, path: PySide6.QtGui.QPainterPath, /) -> PySide6.QtGui.QPainterPath: ...
    @typing.overload
    def mapToScene(self, point: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, rect: PySide6.QtCore.QRect, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, polygon: PySide6.QtGui.QPolygon | collections.abc.Sequence[PySide6.QtCore.QPoint] | PySide6.QtCore.QRect, /) -> PySide6.QtGui.QPolygonF: ...
    @typing.overload
    def mapToScene(self, x: int, y: int, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, x: int, y: int, w: int, h: int, /) -> PySide6.QtGui.QPolygonF: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def optimizationFlags(self, /) -> PySide6.QtWidgets.QGraphicsView.OptimizationFlag: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def render(self, painter: PySide6.QtGui.QPainter, /, target: PySide6.QtCore.QRectF | PySide6.QtCore.QRect = ..., source: PySide6.QtCore.QRect = ..., aspectRatioMode: PySide6.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    def renderHints(self, /) -> PySide6.QtGui.QPainter.RenderHint: ...
    def resetCachedContent(self, /) -> None: ...
    def resetTransform(self, /) -> None: ...
    def resizeAnchor(self, /) -> PySide6.QtWidgets.QGraphicsView.ViewportAnchor: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def rotate(self, angle: float, /) -> None: ...
    def rubberBandRect(self, /) -> PySide6.QtCore.QRect: ...
    def rubberBandSelectionMode(self, /) -> PySide6.QtCore.Qt.ItemSelectionMode: ...
    def scale(self, sx: float, sy: float, /) -> None: ...
    def scene(self, /) -> PySide6.QtWidgets.QGraphicsScene: ...
    def sceneRect(self, /) -> PySide6.QtCore.QRectF: ...
    def scrollContentsBy(self, dx: int, dy: int, /) -> None: ...
    def setAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    def setBackgroundBrush(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, /) -> None: ...
    def setCacheMode(self, mode: PySide6.QtWidgets.QGraphicsView.CacheModeFlag, /) -> None: ...
    def setDragMode(self, mode: PySide6.QtWidgets.QGraphicsView.DragMode, /) -> None: ...
    def setForegroundBrush(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, /) -> None: ...
    def setInteractive(self, allowed: bool, /) -> None: ...
    def setOptimizationFlag(self, flag: PySide6.QtWidgets.QGraphicsView.OptimizationFlag, /, enabled: bool = ...) -> None: ...
    def setOptimizationFlags(self, flags: PySide6.QtWidgets.QGraphicsView.OptimizationFlag, /) -> None: ...
    def setRenderHint(self, hint: PySide6.QtGui.QPainter.RenderHint, /, enabled: bool = ...) -> None: ...
    def setRenderHints(self, hints: PySide6.QtGui.QPainter.RenderHint, /) -> None: ...
    def setResizeAnchor(self, anchor: PySide6.QtWidgets.QGraphicsView.ViewportAnchor, /) -> None: ...
    def setRubberBandSelectionMode(self, mode: PySide6.QtCore.Qt.ItemSelectionMode, /) -> None: ...
    def setScene(self, scene: PySide6.QtWidgets.QGraphicsScene | None, /) -> None: ...
    @typing.overload
    def setSceneRect(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> None: ...
    @typing.overload
    def setSceneRect(self, x: float, y: float, w: float, h: float, /) -> None: ...
    def setTransform(self, matrix: PySide6.QtGui.QTransform, /, combine: bool = ...) -> None: ...
    def setTransformationAnchor(self, anchor: PySide6.QtWidgets.QGraphicsView.ViewportAnchor, /) -> None: ...
    def setViewportUpdateMode(self, mode: PySide6.QtWidgets.QGraphicsView.ViewportUpdateMode, /) -> None: ...
    def setupViewport(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def shear(self, sh: float, sv: float, /) -> None: ...
    def showEvent(self, event: PySide6.QtGui.QShowEvent, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def transform(self, /) -> PySide6.QtGui.QTransform: ...
    def transformationAnchor(self, /) -> PySide6.QtWidgets.QGraphicsView.ViewportAnchor: ...
    def translate(self, dx: float, dy: float, /) -> None: ...
    def updateScene(self, rects: collections.abc.Sequence[PySide6.QtCore.QRectF], /) -> None: ...
    def updateSceneRect(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> None: ...
    def viewportEvent(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def viewportTransform(self, /) -> PySide6.QtGui.QTransform: ...
    def viewportUpdateMode(self, /) -> PySide6.QtWidgets.QGraphicsView.ViewportUpdateMode: ...
    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent, /) -> None: ...


class QGraphicsWidget(PySide6.QtWidgets.QGraphicsObject, PySide6.QtWidgets.QGraphicsLayoutItem):

    geometryChanged          : typing.ClassVar[Signal] = ... # geometryChanged()
    layoutChanged            : typing.ClassVar[Signal] = ... # layoutChanged()

    def __init__(self, /, parent: PySide6.QtWidgets.QGraphicsItem | None = ..., wFlags: PySide6.QtCore.Qt.WindowType = ..., *, palette: PySide6.QtGui.QPalette | None = ..., font: PySide6.QtGui.QFont | None = ..., layoutDirection: PySide6.QtCore.Qt.LayoutDirection | None = ..., size: PySide6.QtCore.QSizeF | None = ..., minimumSize: PySide6.QtCore.QSizeF | None = ..., preferredSize: PySide6.QtCore.QSizeF | None = ..., maximumSize: PySide6.QtCore.QSizeF | None = ..., sizePolicy: PySide6.QtWidgets.QSizePolicy | None = ..., focusPolicy: PySide6.QtCore.Qt.FocusPolicy | None = ..., windowFlags: PySide6.QtCore.Qt.WindowType | None = ..., windowTitle: str | None = ..., geometry: PySide6.QtCore.QRectF | None = ..., autoFillBackground: bool | None = ..., layout: PySide6.QtWidgets.QGraphicsLayout | None = ...) -> None: ...

    def actions(self, /) -> typing.List[PySide6.QtGui.QAction]: ...
    def addAction(self, action: PySide6.QtGui.QAction, /) -> None: ...
    def addActions(self, actions: collections.abc.Sequence[PySide6.QtGui.QAction], /) -> None: ...
    def adjustSize(self, /) -> None: ...
    def autoFillBackground(self, /) -> bool: ...
    def boundingRect(self, /) -> PySide6.QtCore.QRectF: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def close(self, /) -> bool: ...
    def closeEvent(self, event: PySide6.QtGui.QCloseEvent, /) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusNextPrevChild(self, next: bool, /) -> bool: ...
    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusPolicy(self, /) -> PySide6.QtCore.Qt.FocusPolicy: ...
    def focusWidget(self, /) -> PySide6.QtWidgets.QGraphicsWidget: ...
    def font(self, /) -> PySide6.QtGui.QFont: ...
    def getContentsMargins(self, /) -> object: ...
    def getWindowFrameMargins(self, /) -> object: ...
    def grabKeyboardEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def grabMouseEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def grabShortcut(self, sequence: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, /, context: PySide6.QtCore.Qt.ShortcutContext = ...) -> int: ...
    def hideEvent(self, event: PySide6.QtGui.QHideEvent, /) -> None: ...
    def hoverLeaveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent, /) -> None: ...
    def hoverMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent, /) -> None: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOption, /) -> None: ...
    def insertAction(self, before: PySide6.QtGui.QAction, action: PySide6.QtGui.QAction, /) -> None: ...
    def insertActions(self, before: PySide6.QtGui.QAction, actions: collections.abc.Sequence[PySide6.QtGui.QAction], /) -> None: ...
    def isActiveWindow(self, /) -> bool: ...
    def itemChange(self, change: PySide6.QtWidgets.QGraphicsItem.GraphicsItemChange, value: typing.Any, /) -> typing.Any: ...
    def layout(self, /) -> PySide6.QtWidgets.QGraphicsLayout: ...
    def layoutDirection(self, /) -> PySide6.QtCore.Qt.LayoutDirection: ...
    def moveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMoveEvent, /) -> None: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def paintWindowFrame(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def palette(self, /) -> PySide6.QtGui.QPalette: ...
    def polishEvent(self, /) -> None: ...
    def propertyChange(self, propertyName: str, value: typing.Any, /) -> typing.Any: ...
    def rect(self, /) -> PySide6.QtCore.QRectF: ...
    def releaseShortcut(self, id: int, /) -> None: ...
    def removeAction(self, action: PySide6.QtGui.QAction, /) -> None: ...
    @typing.overload
    def resize(self, size: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> None: ...
    @typing.overload
    def resize(self, w: float, h: float, /) -> None: ...
    def resizeEvent(self, event: PySide6.QtWidgets.QGraphicsSceneResizeEvent, /) -> None: ...
    def sceneEvent(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def setAttribute(self, attribute: PySide6.QtCore.Qt.WidgetAttribute, /, on: bool = ...) -> None: ...
    def setAutoFillBackground(self, enabled: bool, /) -> None: ...
    @typing.overload
    def setContentsMargins(self, margins: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> None: ...
    @typing.overload
    def setContentsMargins(self, left: float, top: float, right: float, bottom: float, /) -> None: ...
    def setFocusPolicy(self, policy: PySide6.QtCore.Qt.FocusPolicy, /) -> None: ...
    def setFont(self, font: PySide6.QtGui.QFont | str | collections.abc.Sequence[str], /) -> None: ...
    @typing.overload
    def setGeometry(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> None: ...
    @typing.overload
    def setGeometry(self, x: float, y: float, w: float, h: float, /) -> None: ...
    def setLayout(self, layout: PySide6.QtWidgets.QGraphicsLayout, /) -> None: ...
    def setLayoutDirection(self, direction: PySide6.QtCore.Qt.LayoutDirection, /) -> None: ...
    def setPalette(self, palette: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, /) -> None: ...
    def setShortcutAutoRepeat(self, id: int, /, enabled: bool = ...) -> None: ...
    def setShortcutEnabled(self, id: int, /, enabled: bool = ...) -> None: ...
    def setStyle(self, style: PySide6.QtWidgets.QStyle, /) -> None: ...
    @staticmethod
    def setTabOrder(first: PySide6.QtWidgets.QGraphicsWidget, second: PySide6.QtWidgets.QGraphicsWidget, /) -> None: ...
    def setWindowFlags(self, wFlags: PySide6.QtCore.Qt.WindowType, /) -> None: ...
    @typing.overload
    def setWindowFrameMargins(self, margins: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> None: ...
    @typing.overload
    def setWindowFrameMargins(self, left: float, top: float, right: float, bottom: float, /) -> None: ...
    def setWindowTitle(self, title: str, /) -> None: ...
    def shape(self, /) -> PySide6.QtGui.QPainterPath: ...
    def showEvent(self, event: PySide6.QtGui.QShowEvent, /) -> None: ...
    def size(self, /) -> PySide6.QtCore.QSizeF: ...
    def sizeHint(self, which: PySide6.QtCore.Qt.SizeHint, /, constraint: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize = ...) -> PySide6.QtCore.QSizeF: ...
    def style(self, /) -> PySide6.QtWidgets.QStyle: ...
    def testAttribute(self, attribute: PySide6.QtCore.Qt.WidgetAttribute, /) -> bool: ...
    def type(self, /) -> int: ...
    def ungrabKeyboardEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def ungrabMouseEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def unsetLayoutDirection(self, /) -> None: ...
    def unsetWindowFrameMargins(self, /) -> None: ...
    def updateGeometry(self, /) -> None: ...
    def windowFlags(self, /) -> PySide6.QtCore.Qt.WindowType: ...
    def windowFrameEvent(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def windowFrameGeometry(self, /) -> PySide6.QtCore.QRectF: ...
    def windowFrameRect(self, /) -> PySide6.QtCore.QRectF: ...
    def windowFrameSectionAt(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> PySide6.QtCore.Qt.WindowFrameSection: ...
    def windowTitle(self, /) -> str: ...
    def windowType(self, /) -> PySide6.QtCore.Qt.WindowType: ...


class QGridLayout(PySide6.QtWidgets.QLayout):

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ...) -> None: ...

    @typing.overload
    def addItem(self, arg__1: PySide6.QtWidgets.QLayoutItem, /) -> None: ...
    @typing.overload
    def addItem(self, item: PySide6.QtWidgets.QLayoutItem, row: int, column: int, /, rowSpan: int = ..., columnSpan: int = ..., alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...
    @typing.overload
    def addLayout(self, arg__1: PySide6.QtWidgets.QLayout, row: int, column: int, /, alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...
    @typing.overload
    def addLayout(self, arg__1: PySide6.QtWidgets.QLayout, row: int, column: int, rowSpan: int, columnSpan: int, /, alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...
    @typing.overload
    def addWidget(self, w: PySide6.QtWidgets.QWidget, /) -> None: ...
    @typing.overload
    def addWidget(self, arg__1: PySide6.QtWidgets.QWidget, row: int, column: int, /, alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...
    @typing.overload
    def addWidget(self, arg__1: PySide6.QtWidgets.QWidget, row: int, column: int, rowSpan: int, columnSpan: int, /, alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...
    def cellRect(self, row: int, column: int, /) -> PySide6.QtCore.QRect: ...
    def columnCount(self, /) -> int: ...
    def columnMinimumWidth(self, column: int, /) -> int: ...
    def columnStretch(self, column: int, /) -> int: ...
    def count(self, /) -> int: ...
    def expandingDirections(self, /) -> PySide6.QtCore.Qt.Orientation: ...
    def getItemPosition(self, idx: int, /) -> object: ...
    def hasHeightForWidth(self, /) -> bool: ...
    def heightForWidth(self, arg__1: int, /) -> int: ...
    def horizontalSpacing(self, /) -> int: ...
    def invalidate(self, /) -> None: ...
    def itemAt(self, index: int, /) -> PySide6.QtWidgets.QLayoutItem | None: ...
    def itemAtPosition(self, row: int, column: int, /) -> PySide6.QtWidgets.QLayoutItem | None: ...
    def maximumSize(self, /) -> PySide6.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1: int, /) -> int: ...
    def minimumSize(self, /) -> PySide6.QtCore.QSize: ...
    def originCorner(self, /) -> PySide6.QtCore.Qt.Corner: ...
    def rowCount(self, /) -> int: ...
    def rowMinimumHeight(self, row: int, /) -> int: ...
    def rowStretch(self, row: int, /) -> int: ...
    def setColumnMinimumWidth(self, column: int, minSize: int, /) -> None: ...
    def setColumnStretch(self, column: int, stretch: int, /) -> None: ...
    def setDefaultPositioning(self, n: int, orient: PySide6.QtCore.Qt.Orientation, /) -> None: ...
    def setGeometry(self, arg__1: PySide6.QtCore.QRect, /) -> None: ...
    def setHorizontalSpacing(self, spacing: int, /) -> None: ...
    def setOriginCorner(self, arg__1: PySide6.QtCore.Qt.Corner, /) -> None: ...
    def setRowMinimumHeight(self, row: int, minSize: int, /) -> None: ...
    def setRowStretch(self, row: int, stretch: int, /) -> None: ...
    def setSpacing(self, spacing: int, /) -> None: ...
    def setVerticalSpacing(self, spacing: int, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def spacing(self, /) -> int: ...
    def takeAt(self, index: int, /) -> PySide6.QtWidgets.QLayoutItem: ...
    def verticalSpacing(self, /) -> int: ...


class QGroupBox(PySide6.QtWidgets.QWidget):

    clicked                  : typing.ClassVar[Signal] = ... # clicked(); clicked(bool)
    toggled                  : typing.ClassVar[Signal] = ... # toggled(bool)

    @typing.overload
    def __init__(self, title: str, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, alignment: PySide6.QtCore.Qt.AlignmentFlag | None = ..., flat: bool | None = ..., checkable: bool | None = ..., checked: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, title: str | None = ..., alignment: PySide6.QtCore.Qt.AlignmentFlag | None = ..., flat: bool | None = ..., checkable: bool | None = ..., checked: bool | None = ...) -> None: ...

    def alignment(self, /) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def childEvent(self, event: PySide6.QtCore.QChildEvent, /) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionGroupBox, /) -> None: ...
    def isCheckable(self, /) -> bool: ...
    def isChecked(self, /) -> bool: ...
    def isFlat(self, /) -> bool: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def setAlignment(self, alignment: int, /) -> None: ...
    def setCheckable(self, checkable: bool, /) -> None: ...
    def setChecked(self, checked: bool, /) -> None: ...
    def setFlat(self, flat: bool, /) -> None: ...
    def setTitle(self, title: str, /) -> None: ...
    def title(self, /) -> str: ...


class QHBoxLayout(PySide6.QtWidgets.QBoxLayout):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtWidgets.QWidget, /) -> None: ...


class QHeaderView(PySide6.QtWidgets.QAbstractItemView):

    geometriesChanged        : typing.ClassVar[Signal] = ... # geometriesChanged()
    sectionClicked           : typing.ClassVar[Signal] = ... # sectionClicked(int)
    sectionCountChanged      : typing.ClassVar[Signal] = ... # sectionCountChanged(int,int)
    sectionDoubleClicked     : typing.ClassVar[Signal] = ... # sectionDoubleClicked(int)
    sectionEntered           : typing.ClassVar[Signal] = ... # sectionEntered(int)
    sectionHandleDoubleClicked: typing.ClassVar[Signal] = ... # sectionHandleDoubleClicked(int)
    sectionMoved             : typing.ClassVar[Signal] = ... # sectionMoved(int,int,int)
    sectionPressed           : typing.ClassVar[Signal] = ... # sectionPressed(int)
    sectionResized           : typing.ClassVar[Signal] = ... # sectionResized(int,int,int)
    sortIndicatorChanged     : typing.ClassVar[Signal] = ... # sortIndicatorChanged(int,Qt::SortOrder)
    sortIndicatorClearableChanged: typing.ClassVar[Signal] = ... # sortIndicatorClearableChanged(bool)

    class ResizeMode(enum.Enum):

        Interactive               = ...  # 0x0
        Stretch                   = ...  # 0x1
        Custom                    = ...  # 0x2
        Fixed                     = ...  # 0x2
        ResizeToContents          = ...  # 0x3


    def __init__(self, orientation: PySide6.QtCore.Qt.Orientation, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, firstSectionMovable: bool | None = ..., showSortIndicator: bool | None = ..., sectionsMovable: bool | None = ..., sectionsClickable: bool | None = ..., highlightSections: bool | None = ..., stretchLastSection: bool | None = ..., cascadingSectionResizes: bool | None = ..., defaultSectionSize: int | None = ..., minimumSectionSize: int | None = ..., maximumSectionSize: int | None = ..., defaultAlignment: PySide6.QtCore.Qt.AlignmentFlag | None = ..., sortIndicatorClearable: bool | None = ...) -> None: ...

    def cascadingSectionResizes(self, /) -> bool: ...
    def count(self, /) -> int: ...
    def currentChanged(self, current: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, old: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def dataChanged(self, topLeft: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, bottomRight: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, roles: collections.abc.Sequence[int] = ...) -> None: ...
    def defaultAlignment(self, /) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def defaultSectionSize(self, /) -> int: ...
    def doItemsLayout(self, /) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def headerDataChanged(self, orientation: PySide6.QtCore.Qt.Orientation, logicalFirst: int, logicalLast: int, /) -> None: ...
    def hiddenSectionCount(self, /) -> int: ...
    def hideSection(self, logicalIndex: int, /) -> None: ...
    def highlightSections(self, /) -> bool: ...
    def horizontalOffset(self, /) -> int: ...
    def indexAt(self, p: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QModelIndex: ...
    @typing.overload
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionFrame, /) -> None: ...
    @typing.overload
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionHeader, /) -> None: ...
    def initStyleOptionForIndex(self, option: PySide6.QtWidgets.QStyleOptionHeader, logicalIndex: int, /) -> None: ...
    def initialize(self, /) -> None: ...
    @typing.overload
    def initializeSections(self, /) -> None: ...
    @typing.overload
    def initializeSections(self, start: int, end: int, /) -> None: ...
    def isFirstSectionMovable(self, /) -> bool: ...
    def isIndexHidden(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def isSectionHidden(self, logicalIndex: int, /) -> bool: ...
    def isSortIndicatorClearable(self, /) -> bool: ...
    def isSortIndicatorShown(self, /) -> bool: ...
    def length(self, /) -> int: ...
    def logicalIndex(self, visualIndex: int, /) -> int: ...
    @typing.overload
    def logicalIndexAt(self, pos: PySide6.QtCore.QPoint, /) -> int: ...
    @typing.overload
    def logicalIndexAt(self, position: int, /) -> int: ...
    @typing.overload
    def logicalIndexAt(self, x: int, y: int, /) -> int: ...
    def maximumSectionSize(self, /) -> int: ...
    def minimumSectionSize(self, /) -> int: ...
    def mouseDoubleClickEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseMoveEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def moveCursor(self, arg__1: PySide6.QtWidgets.QAbstractItemView.CursorAction, arg__2: PySide6.QtCore.Qt.KeyboardModifier, /) -> PySide6.QtCore.QModelIndex: ...
    def moveSection(self, from_: int, to: int, /) -> None: ...
    def offset(self, /) -> int: ...
    def orientation(self, /) -> PySide6.QtCore.Qt.Orientation: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def paintSection(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, logicalIndex: int, /) -> None: ...
    def reset(self, /) -> None: ...
    def resetDefaultSectionSize(self, /) -> None: ...
    def resizeContentsPrecision(self, /) -> int: ...
    def resizeSection(self, logicalIndex: int, size: int, /) -> None: ...
    @typing.overload
    def resizeSections(self, /) -> None: ...
    @typing.overload
    def resizeSections(self, mode: PySide6.QtWidgets.QHeaderView.ResizeMode, /) -> None: ...
    def restoreState(self, state: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bool: ...
    def rowsInserted(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, start: int, end: int, /) -> None: ...
    def saveState(self, /) -> PySide6.QtCore.QByteArray: ...
    def scrollContentsBy(self, dx: int, dy: int, /) -> None: ...
    def scrollTo(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint, /) -> None: ...
    def sectionPosition(self, logicalIndex: int, /) -> int: ...
    def sectionResizeMode(self, logicalIndex: int, /) -> PySide6.QtWidgets.QHeaderView.ResizeMode: ...
    def sectionSize(self, logicalIndex: int, /) -> int: ...
    def sectionSizeFromContents(self, logicalIndex: int, /) -> PySide6.QtCore.QSize: ...
    def sectionSizeHint(self, logicalIndex: int, /) -> int: ...
    def sectionViewportPosition(self, logicalIndex: int, /) -> int: ...
    def sectionsAboutToBeRemoved(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, logicalFirst: int, logicalLast: int, /) -> None: ...
    def sectionsClickable(self, /) -> bool: ...
    def sectionsHidden(self, /) -> bool: ...
    def sectionsInserted(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, logicalFirst: int, logicalLast: int, /) -> None: ...
    def sectionsMovable(self, /) -> bool: ...
    def sectionsMoved(self, /) -> bool: ...
    def setCascadingSectionResizes(self, enable: bool, /) -> None: ...
    def setDefaultAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    def setDefaultSectionSize(self, size: int, /) -> None: ...
    def setFirstSectionMovable(self, movable: bool, /) -> None: ...
    def setHighlightSections(self, highlight: bool, /) -> None: ...
    def setMaximumSectionSize(self, size: int, /) -> None: ...
    def setMinimumSectionSize(self, size: int, /) -> None: ...
    def setModel(self, model: PySide6.QtCore.QAbstractItemModel | None, /) -> None: ...
    def setOffset(self, offset: int, /) -> None: ...
    def setOffsetToLastSection(self, /) -> None: ...
    def setOffsetToSectionPosition(self, visualIndex: int, /) -> None: ...
    def setResizeContentsPrecision(self, precision: int, /) -> None: ...
    def setSectionHidden(self, logicalIndex: int, hide: bool, /) -> None: ...
    @typing.overload
    def setSectionResizeMode(self, mode: PySide6.QtWidgets.QHeaderView.ResizeMode, /) -> None: ...
    @typing.overload
    def setSectionResizeMode(self, logicalIndex: int, mode: PySide6.QtWidgets.QHeaderView.ResizeMode, /) -> None: ...
    def setSectionsClickable(self, clickable: bool, /) -> None: ...
    def setSectionsMovable(self, movable: bool, /) -> None: ...
    def setSelection(self, rect: PySide6.QtCore.QRect, flags: PySide6.QtCore.QItemSelectionModel.SelectionFlag, /) -> None: ...
    def setSortIndicator(self, logicalIndex: int, order: PySide6.QtCore.Qt.SortOrder, /) -> None: ...
    def setSortIndicatorClearable(self, clearable: bool, /) -> None: ...
    def setSortIndicatorShown(self, show: bool, /) -> None: ...
    def setStretchLastSection(self, stretch: bool, /) -> None: ...
    def setVisible(self, v: bool, /) -> None: ...
    def showSection(self, logicalIndex: int, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def sortIndicatorOrder(self, /) -> PySide6.QtCore.Qt.SortOrder: ...
    def sortIndicatorSection(self, /) -> int: ...
    def stretchLastSection(self, /) -> bool: ...
    def stretchSectionCount(self, /) -> int: ...
    def swapSections(self, first: int, second: int, /) -> None: ...
    def updateGeometries(self, /) -> None: ...
    def updateSection(self, logicalIndex: int, /) -> None: ...
    def verticalOffset(self, /) -> int: ...
    def viewportEvent(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def visualIndex(self, logicalIndex: int, /) -> int: ...
    def visualIndexAt(self, position: int, /) -> int: ...
    def visualRect(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide6.QtCore.QItemSelection, /) -> PySide6.QtGui.QRegion: ...


class QInputDialog(PySide6.QtWidgets.QDialog):

    doubleValueChanged       : typing.ClassVar[Signal] = ... # doubleValueChanged(double)
    doubleValueSelected      : typing.ClassVar[Signal] = ... # doubleValueSelected(double)
    intValueChanged          : typing.ClassVar[Signal] = ... # intValueChanged(int)
    intValueSelected         : typing.ClassVar[Signal] = ... # intValueSelected(int)
    textValueChanged         : typing.ClassVar[Signal] = ... # textValueChanged(QString)
    textValueSelected        : typing.ClassVar[Signal] = ... # textValueSelected(QString)

    class InputDialogOption(enum.Enum):

        NoButtons                 = ...  # 0x1
        UseListViewForComboBoxItems = ...  # 0x2
        UsePlainTextEditForTextInput = ...  # 0x4

    class InputMode(enum.Enum):

        TextInput                 = ...  # 0x0
        IntInput                  = ...  # 0x1
        DoubleInput               = ...  # 0x2


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., flags: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    def cancelButtonText(self, /) -> str: ...
    def comboBoxItems(self, /) -> typing.List[str]: ...
    def done(self, result: int, /) -> None: ...
    def doubleDecimals(self, /) -> int: ...
    def doubleMaximum(self, /) -> float: ...
    def doubleMinimum(self, /) -> float: ...
    def doubleStep(self, /) -> float: ...
    def doubleValue(self, /) -> float: ...
    @staticmethod
    def getDouble(parent: PySide6.QtWidgets.QWidget, title: str, label: str, /, value: float | None = ..., minValue: float = ..., maxValue: float = ..., decimals: int = ..., flags: PySide6.QtCore.Qt.WindowType = ..., step: float = ...) -> typing.Tuple[float, bool]: ...
    @staticmethod
    def getInt(parent: PySide6.QtWidgets.QWidget, title: str, label: str, /, value: int | None = ..., minValue: int = ..., maxValue: int = ..., step: int = ..., flags: PySide6.QtCore.Qt.WindowType = ...) -> typing.Tuple[int, bool]: ...
    @staticmethod
    def getItem(parent: PySide6.QtWidgets.QWidget, title: str, label: str, items: collections.abc.Sequence[str], /, current: int | None = ..., editable: bool = ..., flags: PySide6.QtCore.Qt.WindowType = ..., inputMethodHints: PySide6.QtCore.Qt.InputMethodHint = ...) -> typing.Tuple[str, bool]: ...
    @staticmethod
    def getMultiLineText(parent: PySide6.QtWidgets.QWidget, title: str, label: str, /, text: str = ..., flags: PySide6.QtCore.Qt.WindowType = ..., inputMethodHints: PySide6.QtCore.Qt.InputMethodHint = ...) -> typing.Tuple[str, bool]: ...
    @staticmethod
    def getText(parent: PySide6.QtWidgets.QWidget, title: str, label: str, /, echo: PySide6.QtWidgets.QLineEdit.EchoMode = ..., text: str = ..., flags: PySide6.QtCore.Qt.WindowType = ..., inputMethodHints: PySide6.QtCore.Qt.InputMethodHint = ...) -> typing.Tuple[str, bool]: ...
    def inputMode(self, /) -> PySide6.QtWidgets.QInputDialog.InputMode: ...
    def intMaximum(self, /) -> int: ...
    def intMinimum(self, /) -> int: ...
    def intStep(self, /) -> int: ...
    def intValue(self, /) -> int: ...
    def isComboBoxEditable(self, /) -> bool: ...
    def labelText(self, /) -> str: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def okButtonText(self, /) -> str: ...
    @typing.overload
    def open(self, /) -> None: ...
    @typing.overload
    def open(self, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /) -> None: ...
    def setCancelButtonText(self, text: str, /) -> None: ...
    def setComboBoxEditable(self, editable: bool, /) -> None: ...
    def setComboBoxItems(self, items: collections.abc.Sequence[str], /) -> None: ...
    def setDoubleDecimals(self, decimals: int, /) -> None: ...
    def setDoubleMaximum(self, max: float, /) -> None: ...
    def setDoubleMinimum(self, min: float, /) -> None: ...
    def setDoubleRange(self, min: float, max: float, /) -> None: ...
    def setDoubleStep(self, step: float, /) -> None: ...
    def setDoubleValue(self, value: float, /) -> None: ...
    def setInputMode(self, mode: PySide6.QtWidgets.QInputDialog.InputMode, /) -> None: ...
    def setIntMaximum(self, max: int, /) -> None: ...
    def setIntMinimum(self, min: int, /) -> None: ...
    def setIntRange(self, min: int, max: int, /) -> None: ...
    def setIntStep(self, step: int, /) -> None: ...
    def setIntValue(self, value: int, /) -> None: ...
    def setLabelText(self, text: str, /) -> None: ...
    def setOkButtonText(self, text: str, /) -> None: ...
    def setOption(self, option: PySide6.QtWidgets.QInputDialog.InputDialogOption, /, on: bool = ...) -> None: ...
    def setTextEchoMode(self, mode: PySide6.QtWidgets.QLineEdit.EchoMode, /) -> None: ...
    def setTextValue(self, text: str, /) -> None: ...
    def setVisible(self, visible: bool, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def testOption(self, option: PySide6.QtWidgets.QInputDialog.InputDialogOption, /) -> bool: ...
    def textEchoMode(self, /) -> PySide6.QtWidgets.QLineEdit.EchoMode: ...
    def textValue(self, /) -> str: ...


class QIntList: ...


class QItemDelegate(PySide6.QtWidgets.QAbstractItemDelegate):

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, clipping: bool | None = ...) -> None: ...

    def createEditor(self, parent: PySide6.QtWidgets.QWidget, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtWidgets.QWidget: ...
    def decoration(self, option: PySide6.QtWidgets.QStyleOptionViewItem, variant: typing.Any, /) -> PySide6.QtGui.QPixmap: ...
    def doCheck(self, option: PySide6.QtWidgets.QStyleOptionViewItem, bounding: PySide6.QtCore.QRect, variant: typing.Any, /) -> PySide6.QtCore.QRect: ...
    def drawBackground(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def drawCheck(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionViewItem, rect: PySide6.QtCore.QRect, state: PySide6.QtCore.Qt.CheckState, /) -> None: ...
    def drawDecoration(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionViewItem, rect: PySide6.QtCore.QRect, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, /) -> None: ...
    def drawDisplay(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionViewItem, rect: PySide6.QtCore.QRect, text: str, /) -> None: ...
    def drawFocus(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionViewItem, rect: PySide6.QtCore.QRect, /) -> None: ...
    def editorEvent(self, event: PySide6.QtCore.QEvent, model: PySide6.QtCore.QAbstractItemModel, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def eventFilter(self, object: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def hasClipping(self, /) -> bool: ...
    def itemEditorFactory(self, /) -> PySide6.QtWidgets.QItemEditorFactory: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def rect(self, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, role: int, /) -> PySide6.QtCore.QRect: ...
    @staticmethod
    def selectedPixmap(pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, palette: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, enabled: bool, /) -> PySide6.QtGui.QPixmap: ...
    def setClipping(self, clip: bool, /) -> None: ...
    def setEditorData(self, editor: PySide6.QtWidgets.QWidget, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def setItemEditorFactory(self, factory: PySide6.QtWidgets.QItemEditorFactory, /) -> None: ...
    def setModelData(self, editor: PySide6.QtWidgets.QWidget, model: PySide6.QtCore.QAbstractItemModel, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def setOptions(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, option: PySide6.QtWidgets.QStyleOptionViewItem, /) -> PySide6.QtWidgets.QStyleOptionViewItem: ...
    def sizeHint(self, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QSize: ...
    def textRectangle(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, font: PySide6.QtGui.QFont | str | collections.abc.Sequence[str], text: str, /) -> PySide6.QtCore.QRect: ...
    def updateEditorGeometry(self, editor: PySide6.QtWidgets.QWidget, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...


class QItemEditorCreatorBase(Shiboken.Object):

    def __init__(self, /) -> None: ...

    def createWidget(self, parent: PySide6.QtWidgets.QWidget, /) -> PySide6.QtWidgets.QWidget: ...
    def valuePropertyName(self, /) -> PySide6.QtCore.QByteArray: ...


class QItemEditorFactory(Shiboken.Object):

    def __init__(self, /) -> None: ...

    def createEditor(self, userType: int, parent: PySide6.QtWidgets.QWidget, /) -> PySide6.QtWidgets.QWidget: ...
    @staticmethod
    def defaultFactory() -> PySide6.QtWidgets.QItemEditorFactory: ...
    def registerEditor(self, userType: int, creator: PySide6.QtWidgets.QItemEditorCreatorBase, /) -> None: ...
    @staticmethod
    def setDefaultFactory(factory: PySide6.QtWidgets.QItemEditorFactory, /) -> None: ...
    def valuePropertyName(self, userType: int, /) -> PySide6.QtCore.QByteArray: ...


class QKeySequenceEdit(PySide6.QtWidgets.QWidget):

    editingFinished          : typing.ClassVar[Signal] = ... # editingFinished()
    keySequenceChanged       : typing.ClassVar[Signal] = ... # keySequenceChanged(QKeySequence)

    @typing.overload
    def __init__(self, keySequence: PySide6.QtGui.QKeySequence, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, clearButtonEnabled: bool | None = ..., maximumSequenceLength: int | None = ..., finishingKeyCombinations: collections.abc.Sequence[PySide6.QtCore.QKeyCombination] | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, keySequence: PySide6.QtGui.QKeySequence | None = ..., clearButtonEnabled: bool | None = ..., maximumSequenceLength: int | None = ..., finishingKeyCombinations: collections.abc.Sequence[PySide6.QtCore.QKeyCombination] | None = ...) -> None: ...

    def clear(self, /) -> None: ...
    def event(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    def finishingKeyCombinations(self, /) -> typing.List[PySide6.QtCore.QKeyCombination]: ...
    def focusOutEvent(self, arg__1: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def isClearButtonEnabled(self, /) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def keyReleaseEvent(self, arg__1: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def keySequence(self, /) -> PySide6.QtGui.QKeySequence: ...
    def maximumSequenceLength(self, /) -> int: ...
    def setClearButtonEnabled(self, enable: bool, /) -> None: ...
    def setFinishingKeyCombinations(self, finishingKeyCombinations: collections.abc.Sequence[PySide6.QtCore.QKeyCombination], /) -> None: ...
    def setKeySequence(self, keySequence: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, /) -> None: ...
    def setMaximumSequenceLength(self, count: int, /) -> None: ...
    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent, /) -> None: ...


class QLCDNumber(PySide6.QtWidgets.QFrame):

    overflow                 : typing.ClassVar[Signal] = ... # overflow()

    class Mode(enum.Enum):

        Hex                       = ...  # 0x0
        Dec                       = ...  # 0x1
        Oct                       = ...  # 0x2
        Bin                       = ...  # 0x3

    class SegmentStyle(enum.Enum):

        Outline                   = ...  # 0x0
        Filled                    = ...  # 0x1
        Flat                      = ...  # 0x2


    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, smallDecimalPoint: bool | None = ..., digitCount: int | None = ..., mode: PySide6.QtWidgets.QLCDNumber.Mode | None = ..., segmentStyle: PySide6.QtWidgets.QLCDNumber.SegmentStyle | None = ..., value: float | None = ..., intValue: int | None = ...) -> None: ...
    @typing.overload
    def __init__(self, numDigits: int, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, smallDecimalPoint: bool | None = ..., digitCount: int | None = ..., mode: PySide6.QtWidgets.QLCDNumber.Mode | None = ..., segmentStyle: PySide6.QtWidgets.QLCDNumber.SegmentStyle | None = ..., value: float | None = ..., intValue: int | None = ...) -> None: ...

    @typing.overload
    def checkOverflow(self, num: int, /) -> bool: ...
    @typing.overload
    def checkOverflow(self, num: float, /) -> bool: ...
    def digitCount(self, /) -> int: ...
    @typing.overload
    def display(self, str: str, /) -> None: ...
    @typing.overload
    def display(self, num: int, /) -> None: ...
    @typing.overload
    def display(self, num: float, /) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def intValue(self, /) -> int: ...
    def mode(self, /) -> PySide6.QtWidgets.QLCDNumber.Mode: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def segmentStyle(self, /) -> PySide6.QtWidgets.QLCDNumber.SegmentStyle: ...
    def setBinMode(self, /) -> None: ...
    def setDecMode(self, /) -> None: ...
    def setDigitCount(self, nDigits: int, /) -> None: ...
    def setHexMode(self, /) -> None: ...
    def setMode(self, arg__1: PySide6.QtWidgets.QLCDNumber.Mode, /) -> None: ...
    def setOctMode(self, /) -> None: ...
    def setSegmentStyle(self, arg__1: PySide6.QtWidgets.QLCDNumber.SegmentStyle, /) -> None: ...
    def setSmallDecimalPoint(self, arg__1: bool, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def smallDecimalPoint(self, /) -> bool: ...
    def value(self, /) -> float: ...


class QLabel(PySide6.QtWidgets.QFrame):

    linkActivated            : typing.ClassVar[Signal] = ... # linkActivated(QString)
    linkHovered              : typing.ClassVar[Signal] = ... # linkHovered(QString)

    @typing.overload
    def __init__(self, text: str, /, parent: PySide6.QtWidgets.QWidget | None = ..., f: PySide6.QtCore.Qt.WindowType = ..., *, textFormat: PySide6.QtCore.Qt.TextFormat | None = ..., pixmap: PySide6.QtGui.QPixmap | None = ..., scaledContents: bool | None = ..., alignment: PySide6.QtCore.Qt.AlignmentFlag | None = ..., wordWrap: bool | None = ..., margin: int | None = ..., indent: int | None = ..., openExternalLinks: bool | None = ..., textInteractionFlags: PySide6.QtCore.Qt.TextInteractionFlag | None = ..., hasSelectedText: bool | None = ..., selectedText: str | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., f: PySide6.QtCore.Qt.WindowType = ..., *, text: str | None = ..., textFormat: PySide6.QtCore.Qt.TextFormat | None = ..., pixmap: PySide6.QtGui.QPixmap | None = ..., scaledContents: bool | None = ..., alignment: PySide6.QtCore.Qt.AlignmentFlag | None = ..., wordWrap: bool | None = ..., margin: int | None = ..., indent: int | None = ..., openExternalLinks: bool | None = ..., textInteractionFlags: PySide6.QtCore.Qt.TextInteractionFlag | None = ..., hasSelectedText: bool | None = ..., selectedText: str | None = ...) -> None: ...

    def alignment(self, /) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def buddy(self, /) -> PySide6.QtWidgets.QWidget: ...
    def changeEvent(self, arg__1: PySide6.QtCore.QEvent, /) -> None: ...
    def clear(self, /) -> None: ...
    def contextMenuEvent(self, ev: PySide6.QtGui.QContextMenuEvent, /) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def focusInEvent(self, ev: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusNextPrevChild(self, next: bool, /) -> bool: ...
    def focusOutEvent(self, ev: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def hasScaledContents(self, /) -> bool: ...
    def hasSelectedText(self, /) -> bool: ...
    def heightForWidth(self, arg__1: int, /) -> int: ...
    def indent(self, /) -> int: ...
    def keyPressEvent(self, ev: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def margin(self, /) -> int: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def mouseMoveEvent(self, ev: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, ev: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, ev: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def movie(self, /) -> PySide6.QtGui.QMovie: ...
    def openExternalLinks(self, /) -> bool: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def picture(self, /) -> PySide6.QtGui.QPicture: ...
    def pixmap(self, /) -> PySide6.QtGui.QPixmap: ...
    def selectedText(self, /) -> str: ...
    def selectionStart(self, /) -> int: ...
    def setAlignment(self, arg__1: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    def setBuddy(self, arg__1: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setIndent(self, arg__1: int, /) -> None: ...
    def setMargin(self, arg__1: int, /) -> None: ...
    def setMovie(self, movie: PySide6.QtGui.QMovie, /) -> None: ...
    @typing.overload
    def setNum(self, arg__1: int, /) -> None: ...
    @typing.overload
    def setNum(self, arg__1: float, /) -> None: ...
    def setOpenExternalLinks(self, open: bool, /) -> None: ...
    def setPicture(self, arg__1: PySide6.QtGui.QPicture | int, /) -> None: ...
    def setPixmap(self, arg__1: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, /) -> None: ...
    def setScaledContents(self, arg__1: bool, /) -> None: ...
    def setSelection(self, arg__1: int, arg__2: int, /) -> None: ...
    def setText(self, arg__1: str, /) -> None: ...
    def setTextFormat(self, arg__1: PySide6.QtCore.Qt.TextFormat, /) -> None: ...
    def setTextInteractionFlags(self, flags: PySide6.QtCore.Qt.TextInteractionFlag, /) -> None: ...
    def setWordWrap(self, on: bool, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def text(self, /) -> str: ...
    def textFormat(self, /) -> PySide6.QtCore.Qt.TextFormat: ...
    def textInteractionFlags(self, /) -> PySide6.QtCore.Qt.TextInteractionFlag: ...
    def wordWrap(self, /) -> bool: ...


class QLayout(PySide6.QtCore.QObject, PySide6.QtWidgets.QLayoutItem):

    class SizeConstraint(enum.Enum):

        SetDefaultConstraint      = ...  # 0x0
        SetNoConstraint           = ...  # 0x1
        SetMinimumSize            = ...  # 0x2
        SetFixedSize              = ...  # 0x3
        SetMaximumSize            = ...  # 0x4
        SetMinAndMaxSize          = ...  # 0x5


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, spacing: int | None = ..., contentsMargins: PySide6.QtCore.QMargins | None = ..., sizeConstraint: PySide6.QtWidgets.QLayout.SizeConstraint | None = ...) -> None: ...

    def activate(self, /) -> bool: ...
    def addChildLayout(self, l: PySide6.QtWidgets.QLayout, /) -> None: ...
    def addChildWidget(self, w: PySide6.QtWidgets.QWidget, /) -> None: ...
    def addItem(self, arg__1: PySide6.QtWidgets.QLayoutItem, /) -> None: ...
    def addWidget(self, w: PySide6.QtWidgets.QWidget, /) -> None: ...
    def adoptLayout(self, layout: PySide6.QtWidgets.QLayout, /) -> bool: ...
    def alignmentRect(self, arg__1: PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRect: ...
    def childEvent(self, e: PySide6.QtCore.QChildEvent, /) -> None: ...
    @staticmethod
    def closestAcceptableSize(w: PySide6.QtWidgets.QWidget, s: PySide6.QtCore.QSize, /) -> PySide6.QtCore.QSize: ...
    def contentsMargins(self, /) -> PySide6.QtCore.QMargins: ...
    def contentsRect(self, /) -> PySide6.QtCore.QRect: ...
    def controlTypes(self, /) -> PySide6.QtWidgets.QSizePolicy.ControlType: ...
    def count(self, /) -> int: ...
    def expandingDirections(self, /) -> PySide6.QtCore.Qt.Orientation: ...
    def geometry(self, /) -> PySide6.QtCore.QRect: ...
    def getContentsMargins(self, /) -> object: ...
    @typing.overload
    def indexOf(self, arg__1: PySide6.QtWidgets.QWidget, /) -> int: ...
    @typing.overload
    def indexOf(self, arg__1: PySide6.QtWidgets.QLayoutItem, /) -> int: ...
    def invalidate(self, /) -> None: ...
    def isEmpty(self, /) -> bool: ...
    def isEnabled(self, /) -> bool: ...
    def itemAt(self, index: int, /) -> PySide6.QtWidgets.QLayoutItem | None: ...
    def layout(self, /) -> PySide6.QtWidgets.QLayout: ...
    def maximumSize(self, /) -> PySide6.QtCore.QSize: ...
    def menuBar(self, /) -> PySide6.QtWidgets.QWidget: ...
    def minimumSize(self, /) -> PySide6.QtCore.QSize: ...
    def parentWidget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def removeItem(self, arg__1: PySide6.QtWidgets.QLayoutItem, /) -> None: ...
    def removeWidget(self, w: PySide6.QtWidgets.QWidget, /) -> None: ...
    def replaceWidget(self, from_: PySide6.QtWidgets.QWidget, to: PySide6.QtWidgets.QWidget, /, options: PySide6.QtCore.Qt.FindChildOption = ...) -> PySide6.QtWidgets.QLayoutItem: ...
    @typing.overload
    def setAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    @typing.overload
    def setAlignment(self, l: PySide6.QtWidgets.QLayout, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> bool: ...
    @typing.overload
    def setAlignment(self, w: PySide6.QtWidgets.QWidget, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> bool: ...
    @typing.overload
    def setContentsMargins(self, margins: PySide6.QtCore.QMargins, /) -> None: ...
    @typing.overload
    def setContentsMargins(self, left: int, top: int, right: int, bottom: int, /) -> None: ...
    def setEnabled(self, arg__1: bool, /) -> None: ...
    def setGeometry(self, arg__1: PySide6.QtCore.QRect, /) -> None: ...
    def setMenuBar(self, w: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setSizeConstraint(self, arg__1: PySide6.QtWidgets.QLayout.SizeConstraint, /) -> None: ...
    def setSpacing(self, arg__1: int, /) -> None: ...
    def sizeConstraint(self, /) -> PySide6.QtWidgets.QLayout.SizeConstraint: ...
    def spacing(self, /) -> int: ...
    def takeAt(self, index: int, /) -> PySide6.QtWidgets.QLayoutItem: ...
    def totalHeightForWidth(self, w: int, /) -> int: ...
    def totalMaximumSize(self, /) -> PySide6.QtCore.QSize: ...
    def totalMinimumHeightForWidth(self, w: int, /) -> int: ...
    def totalMinimumSize(self, /) -> PySide6.QtCore.QSize: ...
    def totalSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def unsetContentsMargins(self, /) -> None: ...
    def update(self, /) -> None: ...
    def widgetEvent(self, arg__1: PySide6.QtCore.QEvent, /) -> None: ...


class QLayoutItem(Shiboken.Object):

    def __init__(self, /, alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...

    def alignment(self, /) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def controlTypes(self, /) -> PySide6.QtWidgets.QSizePolicy.ControlType: ...
    def expandingDirections(self, /) -> PySide6.QtCore.Qt.Orientation: ...
    def geometry(self, /) -> PySide6.QtCore.QRect: ...
    def hasHeightForWidth(self, /) -> bool: ...
    def heightForWidth(self, arg__1: int, /) -> int: ...
    def invalidate(self, /) -> None: ...
    def isEmpty(self, /) -> bool: ...
    def layout(self, /) -> PySide6.QtWidgets.QLayout: ...
    def maximumSize(self, /) -> PySide6.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1: int, /) -> int: ...
    def minimumSize(self, /) -> PySide6.QtCore.QSize: ...
    def setAlignment(self, a: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    def setGeometry(self, arg__1: PySide6.QtCore.QRect, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def spacerItem(self, /) -> PySide6.QtWidgets.QSpacerItem: ...
    def widget(self, /) -> PySide6.QtWidgets.QWidget: ...


class QLineEdit(PySide6.QtWidgets.QWidget):

    cursorPositionChanged    : typing.ClassVar[Signal] = ... # cursorPositionChanged(int,int)
    editingFinished          : typing.ClassVar[Signal] = ... # editingFinished()
    inputRejected            : typing.ClassVar[Signal] = ... # inputRejected()
    returnPressed            : typing.ClassVar[Signal] = ... # returnPressed()
    selectionChanged         : typing.ClassVar[Signal] = ... # selectionChanged()
    textChanged              : typing.ClassVar[Signal] = ... # textChanged(QString)
    textEdited               : typing.ClassVar[Signal] = ... # textEdited(QString)

    class ActionPosition(enum.Enum):

        LeadingPosition           = ...  # 0x0
        TrailingPosition          = ...  # 0x1

    class EchoMode(enum.Enum):

        Normal                    = ...  # 0x0
        NoEcho                    = ...  # 0x1
        Password                  = ...  # 0x2
        PasswordEchoOnEdit        = ...  # 0x3


    @typing.overload
    def __init__(self, arg__1: str, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, inputMask: str | None = ..., text: str | None = ..., maxLength: int | None = ..., frame: bool | None = ..., echoMode: PySide6.QtWidgets.QLineEdit.EchoMode | None = ..., displayText: str | None = ..., cursorPosition: int | None = ..., alignment: PySide6.QtCore.Qt.AlignmentFlag | None = ..., modified: bool | None = ..., hasSelectedText: bool | None = ..., selectedText: str | None = ..., dragEnabled: bool | None = ..., readOnly: bool | None = ..., undoAvailable: bool | None = ..., redoAvailable: bool | None = ..., acceptableInput: bool | None = ..., placeholderText: str | None = ..., cursorMoveStyle: PySide6.QtCore.Qt.CursorMoveStyle | None = ..., clearButtonEnabled: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, inputMask: str | None = ..., text: str | None = ..., maxLength: int | None = ..., frame: bool | None = ..., echoMode: PySide6.QtWidgets.QLineEdit.EchoMode | None = ..., displayText: str | None = ..., cursorPosition: int | None = ..., alignment: PySide6.QtCore.Qt.AlignmentFlag | None = ..., modified: bool | None = ..., hasSelectedText: bool | None = ..., selectedText: str | None = ..., dragEnabled: bool | None = ..., readOnly: bool | None = ..., undoAvailable: bool | None = ..., redoAvailable: bool | None = ..., acceptableInput: bool | None = ..., placeholderText: str | None = ..., cursorMoveStyle: PySide6.QtCore.Qt.CursorMoveStyle | None = ..., clearButtonEnabled: bool | None = ...) -> None: ...

    @typing.overload
    def addAction(self, action: PySide6.QtGui.QAction, /) -> None: ...
    @typing.overload
    def addAction(self, action: PySide6.QtGui.QAction, position: PySide6.QtWidgets.QLineEdit.ActionPosition, /) -> None: ...
    @typing.overload
    def addAction(self, text: str, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, text: str, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, text: str, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, text: str, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, text: str, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, callable: object, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, text: str, callable: object, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, position: PySide6.QtWidgets.QLineEdit.ActionPosition, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, callable: object, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, callable: object, /) -> PySide6.QtGui.QAction: ...
    def alignment(self, /) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def backspace(self, /) -> None: ...
    def changeEvent(self, arg__1: PySide6.QtCore.QEvent, /) -> None: ...
    def clear(self, /) -> None: ...
    def completer(self, /) -> PySide6.QtWidgets.QCompleter: ...
    def contextMenuEvent(self, arg__1: PySide6.QtGui.QContextMenuEvent, /) -> None: ...
    def copy(self, /) -> None: ...
    def createStandardContextMenu(self, /) -> PySide6.QtWidgets.QMenu: ...
    def cursorBackward(self, mark: bool, /, steps: int = ...) -> None: ...
    def cursorForward(self, mark: bool, /, steps: int = ...) -> None: ...
    def cursorMoveStyle(self, /) -> PySide6.QtCore.Qt.CursorMoveStyle: ...
    def cursorPosition(self, /) -> int: ...
    def cursorPositionAt(self, pos: PySide6.QtCore.QPoint, /) -> int: ...
    def cursorRect(self, /) -> PySide6.QtCore.QRect: ...
    def cursorWordBackward(self, mark: bool, /) -> None: ...
    def cursorWordForward(self, mark: bool, /) -> None: ...
    def cut(self, /) -> None: ...
    def del_(self, /) -> None: ...
    def deselect(self, /) -> None: ...
    def displayText(self, /) -> str: ...
    def dragEnabled(self, /) -> bool: ...
    def dragEnterEvent(self, arg__1: PySide6.QtGui.QDragEnterEvent, /) -> None: ...
    def dragLeaveEvent(self, e: PySide6.QtGui.QDragLeaveEvent, /) -> None: ...
    def dragMoveEvent(self, e: PySide6.QtGui.QDragMoveEvent, /) -> None: ...
    def dropEvent(self, arg__1: PySide6.QtGui.QDropEvent, /) -> None: ...
    def echoMode(self, /) -> PySide6.QtWidgets.QLineEdit.EchoMode: ...
    def end(self, mark: bool, /) -> None: ...
    def event(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    def focusInEvent(self, arg__1: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusOutEvent(self, arg__1: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def hasAcceptableInput(self, /) -> bool: ...
    def hasFrame(self, /) -> bool: ...
    def hasSelectedText(self, /) -> bool: ...
    def home(self, mark: bool, /) -> None: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionFrame, /) -> None: ...
    def inputMask(self, /) -> str: ...
    def inputMethodEvent(self, arg__1: PySide6.QtGui.QInputMethodEvent, /) -> None: ...
    @typing.overload
    def inputMethodQuery(self, arg__1: PySide6.QtCore.Qt.InputMethodQuery, /) -> typing.Any: ...
    @typing.overload
    def inputMethodQuery(self, property: PySide6.QtCore.Qt.InputMethodQuery, argument: typing.Any, /) -> typing.Any: ...
    def insert(self, arg__1: str, /) -> None: ...
    def isClearButtonEnabled(self, /) -> bool: ...
    def isModified(self, /) -> bool: ...
    def isReadOnly(self, /) -> bool: ...
    def isRedoAvailable(self, /) -> bool: ...
    def isUndoAvailable(self, /) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def keyReleaseEvent(self, arg__1: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def maxLength(self, /) -> int: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def paste(self, /) -> None: ...
    def placeholderText(self, /) -> str: ...
    def redo(self, /) -> None: ...
    def selectAll(self, /) -> None: ...
    def selectedText(self, /) -> str: ...
    def selectionEnd(self, /) -> int: ...
    def selectionLength(self, /) -> int: ...
    def selectionStart(self, /) -> int: ...
    def setAlignment(self, flag: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    def setClearButtonEnabled(self, enable: bool, /) -> None: ...
    def setCompleter(self, completer: PySide6.QtWidgets.QCompleter, /) -> None: ...
    def setCursorMoveStyle(self, style: PySide6.QtCore.Qt.CursorMoveStyle, /) -> None: ...
    def setCursorPosition(self, arg__1: int, /) -> None: ...
    def setDragEnabled(self, b: bool, /) -> None: ...
    def setEchoMode(self, arg__1: PySide6.QtWidgets.QLineEdit.EchoMode, /) -> None: ...
    def setFrame(self, arg__1: bool, /) -> None: ...
    def setInputMask(self, inputMask: str, /) -> None: ...
    def setMaxLength(self, arg__1: int, /) -> None: ...
    def setModified(self, arg__1: bool, /) -> None: ...
    def setPlaceholderText(self, arg__1: str, /) -> None: ...
    def setReadOnly(self, arg__1: bool, /) -> None: ...
    def setSelection(self, arg__1: int, arg__2: int, /) -> None: ...
    def setText(self, arg__1: str, /) -> None: ...
    @typing.overload
    def setTextMargins(self, margins: PySide6.QtCore.QMargins, /) -> None: ...
    @typing.overload
    def setTextMargins(self, left: int, top: int, right: int, bottom: int, /) -> None: ...
    def setValidator(self, arg__1: PySide6.QtGui.QValidator, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def text(self, /) -> str: ...
    def textMargins(self, /) -> PySide6.QtCore.QMargins: ...
    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def undo(self, /) -> None: ...
    def validator(self, /) -> PySide6.QtGui.QValidator: ...


class QListView(PySide6.QtWidgets.QAbstractItemView):

    indexesMoved             : typing.ClassVar[Signal] = ... # indexesMoved(QModelIndexList)

    class Flow(enum.Enum):

        LeftToRight               = ...  # 0x0
        TopToBottom               = ...  # 0x1

    class LayoutMode(enum.Enum):

        SinglePass                = ...  # 0x0
        Batched                   = ...  # 0x1

    class Movement(enum.Enum):

        Static                    = ...  # 0x0
        Free                      = ...  # 0x1
        Snap                      = ...  # 0x2

    class ResizeMode(enum.Enum):

        Fixed                     = ...  # 0x0
        Adjust                    = ...  # 0x1

    class ViewMode(enum.Enum):

        ListMode                  = ...  # 0x0
        IconMode                  = ...  # 0x1


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, movement: PySide6.QtWidgets.QListView.Movement | None = ..., flow: PySide6.QtWidgets.QListView.Flow | None = ..., isWrapping: bool | None = ..., resizeMode: PySide6.QtWidgets.QListView.ResizeMode | None = ..., layoutMode: PySide6.QtWidgets.QListView.LayoutMode | None = ..., spacing: int | None = ..., gridSize: PySide6.QtCore.QSize | None = ..., viewMode: PySide6.QtWidgets.QListView.ViewMode | None = ..., modelColumn: int | None = ..., uniformItemSizes: bool | None = ..., batchSize: int | None = ..., wordWrap: bool | None = ..., selectionRectVisible: bool | None = ..., itemAlignment: PySide6.QtCore.Qt.AlignmentFlag | None = ...) -> None: ...

    def batchSize(self, /) -> int: ...
    def clearPropertyFlags(self, /) -> None: ...
    def contentsSize(self, /) -> PySide6.QtCore.QSize: ...
    def currentChanged(self, current: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, previous: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def dataChanged(self, topLeft: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, bottomRight: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, roles: collections.abc.Sequence[int] = ...) -> None: ...
    def doItemsLayout(self, /) -> None: ...
    def dragLeaveEvent(self, e: PySide6.QtGui.QDragLeaveEvent, /) -> None: ...
    def dragMoveEvent(self, e: PySide6.QtGui.QDragMoveEvent, /) -> None: ...
    def dropEvent(self, e: PySide6.QtGui.QDropEvent, /) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def flow(self, /) -> PySide6.QtWidgets.QListView.Flow: ...
    def gridSize(self, /) -> PySide6.QtCore.QSize: ...
    def horizontalOffset(self, /) -> int: ...
    def indexAt(self, p: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QModelIndex: ...
    def initViewItemOption(self, option: PySide6.QtWidgets.QStyleOptionViewItem, /) -> None: ...
    def isIndexHidden(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def isRowHidden(self, row: int, /) -> bool: ...
    def isSelectionRectVisible(self, /) -> bool: ...
    def isWrapping(self, /) -> bool: ...
    def itemAlignment(self, /) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def layoutMode(self, /) -> PySide6.QtWidgets.QListView.LayoutMode: ...
    def modelColumn(self, /) -> int: ...
    def mouseMoveEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def moveCursor(self, cursorAction: PySide6.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide6.QtCore.Qt.KeyboardModifier, /) -> PySide6.QtCore.QModelIndex: ...
    def movement(self, /) -> PySide6.QtWidgets.QListView.Movement: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def rectForIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QRect: ...
    def reset(self, /) -> None: ...
    def resizeContents(self, width: int, height: int, /) -> None: ...
    def resizeEvent(self, e: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def resizeMode(self, /) -> PySide6.QtWidgets.QListView.ResizeMode: ...
    def rowsAboutToBeRemoved(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, start: int, end: int, /) -> None: ...
    def rowsInserted(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, start: int, end: int, /) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int, /) -> None: ...
    def scrollTo(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectedIndexes(self, /) -> typing.List[PySide6.QtCore.QModelIndex]: ...
    def selectionChanged(self, selected: PySide6.QtCore.QItemSelection, deselected: PySide6.QtCore.QItemSelection, /) -> None: ...
    def setBatchSize(self, batchSize: int, /) -> None: ...
    def setFlow(self, flow: PySide6.QtWidgets.QListView.Flow, /) -> None: ...
    def setGridSize(self, size: PySide6.QtCore.QSize, /) -> None: ...
    def setItemAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    def setLayoutMode(self, mode: PySide6.QtWidgets.QListView.LayoutMode, /) -> None: ...
    def setModelColumn(self, column: int, /) -> None: ...
    def setMovement(self, movement: PySide6.QtWidgets.QListView.Movement, /) -> None: ...
    def setPositionForIndex(self, position: PySide6.QtCore.QPoint, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def setResizeMode(self, mode: PySide6.QtWidgets.QListView.ResizeMode, /) -> None: ...
    def setRootIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def setRowHidden(self, row: int, hide: bool, /) -> None: ...
    def setSelection(self, rect: PySide6.QtCore.QRect, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag, /) -> None: ...
    def setSelectionRectVisible(self, show: bool, /) -> None: ...
    def setSpacing(self, space: int, /) -> None: ...
    def setUniformItemSizes(self, enable: bool, /) -> None: ...
    def setViewMode(self, mode: PySide6.QtWidgets.QListView.ViewMode, /) -> None: ...
    def setWordWrap(self, on: bool, /) -> None: ...
    def setWrapping(self, enable: bool, /) -> None: ...
    def spacing(self, /) -> int: ...
    def startDrag(self, supportedActions: PySide6.QtCore.Qt.DropAction, /) -> None: ...
    def timerEvent(self, e: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def uniformItemSizes(self, /) -> bool: ...
    def updateGeometries(self, /) -> None: ...
    def verticalOffset(self, /) -> int: ...
    def viewMode(self, /) -> PySide6.QtWidgets.QListView.ViewMode: ...
    def viewportSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def visualRect(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide6.QtCore.QItemSelection, /) -> PySide6.QtGui.QRegion: ...
    def wheelEvent(self, e: PySide6.QtGui.QWheelEvent, /) -> None: ...
    def wordWrap(self, /) -> bool: ...


class QListWidget(PySide6.QtWidgets.QListView):

    currentItemChanged       : typing.ClassVar[Signal] = ... # currentItemChanged(QListWidgetItem*,QListWidgetItem*)
    currentRowChanged        : typing.ClassVar[Signal] = ... # currentRowChanged(int)
    currentTextChanged       : typing.ClassVar[Signal] = ... # currentTextChanged(QString)
    itemActivated            : typing.ClassVar[Signal] = ... # itemActivated(QListWidgetItem*)
    itemChanged              : typing.ClassVar[Signal] = ... # itemChanged(QListWidgetItem*)
    itemClicked              : typing.ClassVar[Signal] = ... # itemClicked(QListWidgetItem*)
    itemDoubleClicked        : typing.ClassVar[Signal] = ... # itemDoubleClicked(QListWidgetItem*)
    itemEntered              : typing.ClassVar[Signal] = ... # itemEntered(QListWidgetItem*)
    itemPressed              : typing.ClassVar[Signal] = ... # itemPressed(QListWidgetItem*)
    itemSelectionChanged     : typing.ClassVar[Signal] = ... # itemSelectionChanged()

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, count: int | None = ..., currentRow: int | None = ..., sortingEnabled: bool | None = ...) -> None: ...

    @typing.overload
    def addItem(self, item: PySide6.QtWidgets.QListWidgetItem, /) -> None: ...
    @typing.overload
    def addItem(self, label: str, /) -> None: ...
    def addItems(self, labels: collections.abc.Sequence[str], /) -> None: ...
    def clear(self, /) -> None: ...
    def closePersistentEditor(self, item: PySide6.QtWidgets.QListWidgetItem, /) -> None: ...
    def count(self, /) -> int: ...
    def currentItem(self, /) -> PySide6.QtWidgets.QListWidgetItem: ...
    def currentRow(self, /) -> int: ...
    def dropEvent(self, event: PySide6.QtGui.QDropEvent, /) -> None: ...
    def dropMimeData(self, index: int, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, /) -> bool: ...
    def editItem(self, item: PySide6.QtWidgets.QListWidgetItem, /) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def findItems(self, text: str, flags: PySide6.QtCore.Qt.MatchFlag, /) -> typing.List[PySide6.QtWidgets.QListWidgetItem]: ...
    def indexFromItem(self, item: PySide6.QtWidgets.QListWidgetItem, /) -> PySide6.QtCore.QModelIndex: ...
    @typing.overload
    def insertItem(self, row: int, item: PySide6.QtWidgets.QListWidgetItem, /) -> None: ...
    @typing.overload
    def insertItem(self, row: int, label: str, /) -> None: ...
    def insertItems(self, row: int, labels: collections.abc.Sequence[str], /) -> None: ...
    @typing.overload
    def isPersistentEditorOpen(self, item: PySide6.QtWidgets.QListWidgetItem, /) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def isSortingEnabled(self, /) -> bool: ...
    def item(self, row: int, /) -> PySide6.QtWidgets.QListWidgetItem: ...
    @typing.overload
    def itemAt(self, p: PySide6.QtCore.QPoint, /) -> PySide6.QtWidgets.QListWidgetItem: ...
    @typing.overload
    def itemAt(self, x: int, y: int, /) -> PySide6.QtWidgets.QListWidgetItem: ...
    def itemFromIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtWidgets.QListWidgetItem: ...
    def itemWidget(self, item: PySide6.QtWidgets.QListWidgetItem, /) -> PySide6.QtWidgets.QWidget: ...
    def items(self, data: PySide6.QtCore.QMimeData, /) -> typing.List[PySide6.QtWidgets.QListWidgetItem]: ...
    def mimeData(self, items: collections.abc.Sequence[PySide6.QtWidgets.QListWidgetItem], /) -> PySide6.QtCore.QMimeData: ...
    def mimeTypes(self, /) -> typing.List[str]: ...
    def openPersistentEditor(self, item: PySide6.QtWidgets.QListWidgetItem, /) -> None: ...
    def removeItemWidget(self, item: PySide6.QtWidgets.QListWidgetItem, /) -> None: ...
    def row(self, item: PySide6.QtWidgets.QListWidgetItem, /) -> int: ...
    def scrollToItem(self, item: PySide6.QtWidgets.QListWidgetItem, /, hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectedItems(self, /) -> typing.List[PySide6.QtWidgets.QListWidgetItem]: ...
    @typing.overload
    def setCurrentItem(self, item: PySide6.QtWidgets.QListWidgetItem, /) -> None: ...
    @typing.overload
    def setCurrentItem(self, item: PySide6.QtWidgets.QListWidgetItem, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag, /) -> None: ...
    @typing.overload
    def setCurrentRow(self, row: int, /) -> None: ...
    @typing.overload
    def setCurrentRow(self, row: int, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag, /) -> None: ...
    def setItemWidget(self, item: PySide6.QtWidgets.QListWidgetItem, widget: PySide6.QtWidgets.QWidget | None, /) -> None: ...
    def setModel(self, model: PySide6.QtCore.QAbstractItemModel | None, /) -> None: ...
    def setSelectionModel(self, selectionModel: PySide6.QtCore.QItemSelectionModel, /) -> None: ...
    def setSortingEnabled(self, enable: bool, /) -> None: ...
    def sortItems(self, /, order: PySide6.QtCore.Qt.SortOrder = ...) -> None: ...
    def supportedDropActions(self, /) -> PySide6.QtCore.Qt.DropAction: ...
    def takeItem(self, row: int, /) -> PySide6.QtWidgets.QListWidgetItem: ...
    def visualItemRect(self, item: PySide6.QtWidgets.QListWidgetItem, /) -> PySide6.QtCore.QRect: ...


class QListWidgetItem(Shiboken.Object):

    class ItemType(enum.IntEnum):

        Type                      = ...  # 0x0
        UserType                  = ...  # 0x3e8


    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QListWidgetItem, /) -> None: ...
    @typing.overload
    def __init__(self, text: str, /, listview: PySide6.QtWidgets.QListWidget | None = ..., type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, /, listview: PySide6.QtWidgets.QListWidget | None = ..., type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, /, listview: PySide6.QtWidgets.QListWidget | None = ..., type: int = ...) -> None: ...

    def __lshift__(self, out: PySide6.QtCore.QDataStream, /) -> PySide6.QtCore.QDataStream: ...
    def __lt__(self, other: PySide6.QtWidgets.QListWidgetItem, /) -> bool: ...
    def __rshift__(self, in_: PySide6.QtCore.QDataStream, /) -> PySide6.QtCore.QDataStream: ...
    def background(self, /) -> PySide6.QtGui.QBrush: ...
    def checkState(self, /) -> PySide6.QtCore.Qt.CheckState: ...
    def clone(self, /) -> PySide6.QtWidgets.QListWidgetItem: ...
    def data(self, role: int, /) -> typing.Any: ...
    def flags(self, /) -> PySide6.QtCore.Qt.ItemFlag: ...
    def font(self, /) -> PySide6.QtGui.QFont: ...
    def foreground(self, /) -> PySide6.QtGui.QBrush: ...
    def icon(self, /) -> PySide6.QtGui.QIcon: ...
    def isHidden(self, /) -> bool: ...
    def isSelected(self, /) -> bool: ...
    def listWidget(self, /) -> PySide6.QtWidgets.QListWidget: ...
    def read(self, in_: PySide6.QtCore.QDataStream, /) -> None: ...
    def setBackground(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, /) -> None: ...
    def setCheckState(self, state: PySide6.QtCore.Qt.CheckState, /) -> None: ...
    def setData(self, role: int, value: typing.Any, /) -> None: ...
    def setFlags(self, flags: PySide6.QtCore.Qt.ItemFlag, /) -> None: ...
    def setFont(self, font: PySide6.QtGui.QFont | str | collections.abc.Sequence[str], /) -> None: ...
    def setForeground(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, /) -> None: ...
    def setHidden(self, hide: bool, /) -> None: ...
    def setIcon(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, /) -> None: ...
    def setSelected(self, select: bool, /) -> None: ...
    def setSizeHint(self, size: PySide6.QtCore.QSize, /) -> None: ...
    def setStatusTip(self, statusTip: str, /) -> None: ...
    def setText(self, text: str, /) -> None: ...
    @typing.overload
    def setTextAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    @typing.overload
    def setTextAlignment(self, alignment: int, /) -> None: ...
    def setToolTip(self, toolTip: str, /) -> None: ...
    def setWhatsThis(self, whatsThis: str, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def statusTip(self, /) -> str: ...
    def text(self, /) -> str: ...
    def textAlignment(self, /) -> int: ...
    def toolTip(self, /) -> str: ...
    def type(self, /) -> int: ...
    def whatsThis(self, /) -> str: ...
    def write(self, out: PySide6.QtCore.QDataStream, /) -> None: ...


class QMainWindow(PySide6.QtWidgets.QWidget):

    iconSizeChanged          : typing.ClassVar[Signal] = ... # iconSizeChanged(QSize)
    tabifiedDockWidgetActivated: typing.ClassVar[Signal] = ... # tabifiedDockWidgetActivated(QDockWidget*)
    toolButtonStyleChanged   : typing.ClassVar[Signal] = ... # toolButtonStyleChanged(Qt::ToolButtonStyle)

    class DockOption(enum.Flag):

        AnimatedDocks             = ...  # 0x1
        AllowNestedDocks          = ...  # 0x2
        AllowTabbedDocks          = ...  # 0x4
        ForceTabbedDocks          = ...  # 0x8
        VerticalTabs              = ...  # 0x10
        GroupedDragging           = ...  # 0x20


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., flags: PySide6.QtCore.Qt.WindowType = ..., *, iconSize: PySide6.QtCore.QSize | None = ..., toolButtonStyle: PySide6.QtCore.Qt.ToolButtonStyle | None = ..., animated: bool | None = ..., documentMode: bool | None = ..., tabShape: PySide6.QtWidgets.QTabWidget.TabShape | None = ..., dockNestingEnabled: bool | None = ..., dockOptions: PySide6.QtWidgets.QMainWindow.DockOption | None = ..., unifiedTitleAndToolBarOnMac: bool | None = ...) -> None: ...

    @typing.overload
    def addDockWidget(self, area: PySide6.QtCore.Qt.DockWidgetArea, dockwidget: PySide6.QtWidgets.QDockWidget, /) -> None: ...
    @typing.overload
    def addDockWidget(self, area: PySide6.QtCore.Qt.DockWidgetArea, dockwidget: PySide6.QtWidgets.QDockWidget, orientation: PySide6.QtCore.Qt.Orientation, /) -> None: ...
    @typing.overload
    def addToolBar(self, toolbar: PySide6.QtWidgets.QToolBar, /) -> None: ...
    @typing.overload
    def addToolBar(self, area: PySide6.QtCore.Qt.ToolBarArea, toolbar: PySide6.QtWidgets.QToolBar, /) -> None: ...
    @typing.overload
    def addToolBar(self, title: str, /) -> PySide6.QtWidgets.QToolBar: ...
    def addToolBarBreak(self, /, area: PySide6.QtCore.Qt.ToolBarArea = ...) -> None: ...
    def centralWidget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def contextMenuEvent(self, event: PySide6.QtGui.QContextMenuEvent, /) -> None: ...
    def corner(self, corner: PySide6.QtCore.Qt.Corner, /) -> PySide6.QtCore.Qt.DockWidgetArea: ...
    def createPopupMenu(self, /) -> PySide6.QtWidgets.QMenu: ...
    def dockOptions(self, /) -> PySide6.QtWidgets.QMainWindow.DockOption: ...
    def dockWidgetArea(self, dockwidget: PySide6.QtWidgets.QDockWidget, /) -> PySide6.QtCore.Qt.DockWidgetArea: ...
    def documentMode(self, /) -> bool: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def iconSize(self, /) -> PySide6.QtCore.QSize: ...
    def insertToolBar(self, before: PySide6.QtWidgets.QToolBar, toolbar: PySide6.QtWidgets.QToolBar, /) -> None: ...
    def insertToolBarBreak(self, before: PySide6.QtWidgets.QToolBar, /) -> None: ...
    def isAnimated(self, /) -> bool: ...
    def isDockNestingEnabled(self, /) -> bool: ...
    def isSeparator(self, pos: PySide6.QtCore.QPoint, /) -> bool: ...
    def menuBar(self, /) -> PySide6.QtWidgets.QMenuBar: ...
    def menuWidget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def removeDockWidget(self, dockwidget: PySide6.QtWidgets.QDockWidget, /) -> None: ...
    def removeToolBar(self, toolbar: PySide6.QtWidgets.QToolBar, /) -> None: ...
    def removeToolBarBreak(self, before: PySide6.QtWidgets.QToolBar, /) -> None: ...
    def resizeDocks(self, docks: collections.abc.Sequence[PySide6.QtWidgets.QDockWidget], sizes: collections.abc.Sequence[int], orientation: PySide6.QtCore.Qt.Orientation, /) -> None: ...
    def restoreDockWidget(self, dockwidget: PySide6.QtWidgets.QDockWidget, /) -> bool: ...
    def restoreState(self, state: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /, version: int | None = ...) -> bool: ...
    def saveState(self, /, version: int | None = ...) -> PySide6.QtCore.QByteArray: ...
    def setAnimated(self, enabled: bool, /) -> None: ...
    def setCentralWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setCorner(self, corner: PySide6.QtCore.Qt.Corner, area: PySide6.QtCore.Qt.DockWidgetArea, /) -> None: ...
    def setDockNestingEnabled(self, enabled: bool, /) -> None: ...
    def setDockOptions(self, options: PySide6.QtWidgets.QMainWindow.DockOption, /) -> None: ...
    def setDocumentMode(self, enabled: bool, /) -> None: ...
    def setIconSize(self, iconSize: PySide6.QtCore.QSize, /) -> None: ...
    def setMenuBar(self, menubar: PySide6.QtWidgets.QMenuBar, /) -> None: ...
    def setMenuWidget(self, menubar: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setStatusBar(self, statusbar: PySide6.QtWidgets.QStatusBar, /) -> None: ...
    def setTabPosition(self, areas: PySide6.QtCore.Qt.DockWidgetArea, tabPosition: PySide6.QtWidgets.QTabWidget.TabPosition, /) -> None: ...
    def setTabShape(self, tabShape: PySide6.QtWidgets.QTabWidget.TabShape, /) -> None: ...
    def setToolButtonStyle(self, toolButtonStyle: PySide6.QtCore.Qt.ToolButtonStyle, /) -> None: ...
    def setUnifiedTitleAndToolBarOnMac(self, set: bool, /) -> None: ...
    def splitDockWidget(self, after: PySide6.QtWidgets.QDockWidget, dockwidget: PySide6.QtWidgets.QDockWidget, orientation: PySide6.QtCore.Qt.Orientation, /) -> None: ...
    def statusBar(self, /) -> PySide6.QtWidgets.QStatusBar: ...
    def tabPosition(self, area: PySide6.QtCore.Qt.DockWidgetArea, /) -> PySide6.QtWidgets.QTabWidget.TabPosition: ...
    def tabShape(self, /) -> PySide6.QtWidgets.QTabWidget.TabShape: ...
    def tabifiedDockWidgets(self, dockwidget: PySide6.QtWidgets.QDockWidget, /) -> typing.List[PySide6.QtWidgets.QDockWidget]: ...
    def tabifyDockWidget(self, first: PySide6.QtWidgets.QDockWidget, second: PySide6.QtWidgets.QDockWidget, /) -> None: ...
    def takeCentralWidget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def toolBarArea(self, toolbar: PySide6.QtWidgets.QToolBar, /) -> PySide6.QtCore.Qt.ToolBarArea: ...
    def toolBarBreak(self, toolbar: PySide6.QtWidgets.QToolBar, /) -> bool: ...
    def toolButtonStyle(self, /) -> PySide6.QtCore.Qt.ToolButtonStyle: ...
    def unifiedTitleAndToolBarOnMac(self, /) -> bool: ...


class QMdiArea(PySide6.QtWidgets.QAbstractScrollArea):

    subWindowActivated       : typing.ClassVar[Signal] = ... # subWindowActivated(QMdiSubWindow*)

    class AreaOption(enum.Flag):

        DontMaximizeSubWindowOnActivation = ...  # 0x1

    class ViewMode(enum.Enum):

        SubWindowView             = ...  # 0x0
        TabbedView                = ...  # 0x1

    class WindowOrder(enum.Enum):

        CreationOrder             = ...  # 0x0
        StackingOrder             = ...  # 0x1
        ActivationHistoryOrder    = ...  # 0x2


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, background: PySide6.QtGui.QBrush | None = ..., activationOrder: PySide6.QtWidgets.QMdiArea.WindowOrder | None = ..., viewMode: PySide6.QtWidgets.QMdiArea.ViewMode | None = ..., documentMode: bool | None = ..., tabsClosable: bool | None = ..., tabsMovable: bool | None = ..., tabShape: PySide6.QtWidgets.QTabWidget.TabShape | None = ..., tabPosition: PySide6.QtWidgets.QTabWidget.TabPosition | None = ...) -> None: ...

    def activateNextSubWindow(self, /) -> None: ...
    def activatePreviousSubWindow(self, /) -> None: ...
    def activationOrder(self, /) -> PySide6.QtWidgets.QMdiArea.WindowOrder: ...
    def activeSubWindow(self, /) -> PySide6.QtWidgets.QMdiSubWindow: ...
    def addSubWindow(self, widget: PySide6.QtWidgets.QWidget, /, flags: PySide6.QtCore.Qt.WindowType = ...) -> PySide6.QtWidgets.QMdiSubWindow: ...
    def background(self, /) -> PySide6.QtGui.QBrush: ...
    def cascadeSubWindows(self, /) -> None: ...
    def childEvent(self, childEvent: PySide6.QtCore.QChildEvent, /) -> None: ...
    def closeActiveSubWindow(self, /) -> None: ...
    def closeAllSubWindows(self, /) -> None: ...
    def currentSubWindow(self, /) -> PySide6.QtWidgets.QMdiSubWindow: ...
    def documentMode(self, /) -> bool: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def eventFilter(self, object: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def paintEvent(self, paintEvent: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def removeSubWindow(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def resizeEvent(self, resizeEvent: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int, /) -> None: ...
    def setActivationOrder(self, order: PySide6.QtWidgets.QMdiArea.WindowOrder, /) -> None: ...
    def setActiveSubWindow(self, window: PySide6.QtWidgets.QMdiSubWindow, /) -> None: ...
    def setBackground(self, background: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, /) -> None: ...
    def setDocumentMode(self, enabled: bool, /) -> None: ...
    def setOption(self, option: PySide6.QtWidgets.QMdiArea.AreaOption, /, on: bool = ...) -> None: ...
    def setTabPosition(self, position: PySide6.QtWidgets.QTabWidget.TabPosition, /) -> None: ...
    def setTabShape(self, shape: PySide6.QtWidgets.QTabWidget.TabShape, /) -> None: ...
    def setTabsClosable(self, closable: bool, /) -> None: ...
    def setTabsMovable(self, movable: bool, /) -> None: ...
    def setViewMode(self, mode: PySide6.QtWidgets.QMdiArea.ViewMode, /) -> None: ...
    def setupViewport(self, viewport: PySide6.QtWidgets.QWidget, /) -> None: ...
    def showEvent(self, showEvent: PySide6.QtGui.QShowEvent, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def subWindowList(self, /, order: PySide6.QtWidgets.QMdiArea.WindowOrder = ...) -> typing.List[PySide6.QtWidgets.QMdiSubWindow]: ...
    def tabPosition(self, /) -> PySide6.QtWidgets.QTabWidget.TabPosition: ...
    def tabShape(self, /) -> PySide6.QtWidgets.QTabWidget.TabShape: ...
    def tabsClosable(self, /) -> bool: ...
    def tabsMovable(self, /) -> bool: ...
    def testOption(self, opton: PySide6.QtWidgets.QMdiArea.AreaOption, /) -> bool: ...
    def tileSubWindows(self, /) -> None: ...
    def timerEvent(self, timerEvent: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def viewMode(self, /) -> PySide6.QtWidgets.QMdiArea.ViewMode: ...
    def viewportEvent(self, event: PySide6.QtCore.QEvent, /) -> bool: ...


class QMdiSubWindow(PySide6.QtWidgets.QWidget):

    aboutToActivate          : typing.ClassVar[Signal] = ... # aboutToActivate()
    windowStateChanged       : typing.ClassVar[Signal] = ... # windowStateChanged(Qt::WindowStates,Qt::WindowStates)

    class SubWindowOption(enum.Flag):

        AllowOutsideAreaHorizontally = ...  # 0x1
        AllowOutsideAreaVertically = ...  # 0x2
        RubberBandResize          = ...  # 0x4
        RubberBandMove            = ...  # 0x8


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., flags: PySide6.QtCore.Qt.WindowType = ..., *, keyboardSingleStep: int | None = ..., keyboardPageStep: int | None = ...) -> None: ...

    def changeEvent(self, changeEvent: PySide6.QtCore.QEvent, /) -> None: ...
    def childEvent(self, childEvent: PySide6.QtCore.QChildEvent, /) -> None: ...
    def closeEvent(self, closeEvent: PySide6.QtGui.QCloseEvent, /) -> None: ...
    def contextMenuEvent(self, contextMenuEvent: PySide6.QtGui.QContextMenuEvent, /) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def eventFilter(self, object: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def focusInEvent(self, focusInEvent: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusOutEvent(self, focusOutEvent: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def hideEvent(self, hideEvent: PySide6.QtGui.QHideEvent, /) -> None: ...
    def isShaded(self, /) -> bool: ...
    def keyPressEvent(self, keyEvent: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def keyboardPageStep(self, /) -> int: ...
    def keyboardSingleStep(self, /) -> int: ...
    def leaveEvent(self, leaveEvent: PySide6.QtCore.QEvent, /) -> None: ...
    def maximizedButtonsWidget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def maximizedSystemMenuIconWidget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def mdiArea(self, /) -> PySide6.QtWidgets.QMdiArea: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, mouseEvent: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseMoveEvent(self, mouseEvent: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, mouseEvent: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, mouseEvent: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def moveEvent(self, moveEvent: PySide6.QtGui.QMoveEvent, /) -> None: ...
    def paintEvent(self, paintEvent: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def resizeEvent(self, resizeEvent: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def setKeyboardPageStep(self, step: int, /) -> None: ...
    def setKeyboardSingleStep(self, step: int, /) -> None: ...
    def setOption(self, option: PySide6.QtWidgets.QMdiSubWindow.SubWindowOption, /, on: bool = ...) -> None: ...
    def setSystemMenu(self, systemMenu: PySide6.QtWidgets.QMenu, /) -> None: ...
    def setWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def showEvent(self, showEvent: PySide6.QtGui.QShowEvent, /) -> None: ...
    def showShaded(self, /) -> None: ...
    def showSystemMenu(self, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def systemMenu(self, /) -> PySide6.QtWidgets.QMenu: ...
    def testOption(self, arg__1: PySide6.QtWidgets.QMdiSubWindow.SubWindowOption, /) -> bool: ...
    def timerEvent(self, timerEvent: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def widget(self, /) -> PySide6.QtWidgets.QWidget: ...


class QMenu(PySide6.QtWidgets.QWidget):

    aboutToHide              : typing.ClassVar[Signal] = ... # aboutToHide()
    aboutToShow              : typing.ClassVar[Signal] = ... # aboutToShow()
    hovered                  : typing.ClassVar[Signal] = ... # hovered(QAction*)
    triggered                : typing.ClassVar[Signal] = ... # triggered(QAction*)

    @typing.overload
    def __init__(self, title: str, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, tearOffEnabled: bool | None = ..., icon: PySide6.QtGui.QIcon | None = ..., separatorsCollapsible: bool | None = ..., toolTipsVisible: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, tearOffEnabled: bool | None = ..., title: str | None = ..., icon: PySide6.QtGui.QIcon | None = ..., separatorsCollapsible: bool | None = ..., toolTipsVisible: bool | None = ...) -> None: ...

    def actionAt(self, arg__1: PySide6.QtCore.QPoint, /) -> PySide6.QtGui.QAction: ...
    def actionEvent(self, arg__1: PySide6.QtGui.QActionEvent, /) -> None: ...
    def actionGeometry(self, arg__1: PySide6.QtGui.QAction, /) -> PySide6.QtCore.QRect: ...
    def activeAction(self, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, action: PySide6.QtGui.QAction, /) -> None: ...
    @typing.overload
    def addAction(self, text: str, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, text: str, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, text: str, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, text: str, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, text: str, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, text: str, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, callable: object, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, text: str, callable: object, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, text: str, arg__2: object, /, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int | None = ...) -> None: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, callable: object, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, callable: object, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, arg__1: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, arg__3: object, /, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int | None = ...) -> None: ...
    @typing.overload
    def addMenu(self, menu: PySide6.QtWidgets.QMenu, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addMenu(self, title: str, /) -> PySide6.QtWidgets.QMenu: ...
    @typing.overload
    def addMenu(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, title: str, /) -> PySide6.QtWidgets.QMenu: ...
    @typing.overload
    def addSection(self, text: str, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addSection(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, /) -> PySide6.QtGui.QAction: ...
    def addSeparator(self, /) -> PySide6.QtGui.QAction: ...
    def changeEvent(self, arg__1: PySide6.QtCore.QEvent, /) -> None: ...
    def clear(self, /) -> None: ...
    def columnCount(self, /) -> int: ...
    def defaultAction(self, /) -> PySide6.QtGui.QAction: ...
    def enterEvent(self, arg__1: PySide6.QtGui.QEnterEvent, /) -> None: ...
    def event(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def exec(self, /) -> PySide6.QtGui.QAction: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def exec(self, pos: PySide6.QtCore.QPoint, /, at: PySide6.QtGui.QAction | None = ...) -> PySide6.QtGui.QAction: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def exec(actions: collections.abc.Sequence[PySide6.QtGui.QAction], pos: PySide6.QtCore.QPoint, /, at: PySide6.QtGui.QAction | None = ..., parent: PySide6.QtWidgets.QWidget | None = ...) -> PySide6.QtGui.QAction: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload
    def exec_(self, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def exec_(self, arg__1: PySide6.QtCore.QPoint, /, action: PySide6.QtGui.QAction | None = ...) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def exec_(self, arg__1: collections.abc.Sequence[PySide6.QtGui.QAction], arg__2: PySide6.QtCore.QPoint, /, at: PySide6.QtGui.QAction | None = ..., parent: PySide6.QtWidgets.QWidget | None = ...) -> PySide6.QtGui.QAction: ...
    def focusNextPrevChild(self, next: bool, /) -> bool: ...
    def hideEvent(self, arg__1: PySide6.QtGui.QHideEvent, /) -> None: ...
    def hideTearOffMenu(self, /) -> None: ...
    def icon(self, /) -> PySide6.QtGui.QIcon: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionMenuItem, action: PySide6.QtGui.QAction, /) -> None: ...
    def insertMenu(self, before: PySide6.QtGui.QAction, menu: PySide6.QtWidgets.QMenu, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def insertSection(self, before: PySide6.QtGui.QAction, text: str, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def insertSection(self, before: PySide6.QtGui.QAction, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, /) -> PySide6.QtGui.QAction: ...
    def insertSeparator(self, before: PySide6.QtGui.QAction, /) -> PySide6.QtGui.QAction: ...
    def isEmpty(self, /) -> bool: ...
    def isTearOffEnabled(self, /) -> bool: ...
    def isTearOffMenuVisible(self, /) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def leaveEvent(self, arg__1: PySide6.QtCore.QEvent, /) -> None: ...
    def menuAction(self, /) -> PySide6.QtGui.QAction: ...
    @staticmethod
    def menuInAction(action: PySide6.QtGui.QAction, /) -> PySide6.QtWidgets.QMenu: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def popup(self, pos: PySide6.QtCore.QPoint, /, at: PySide6.QtGui.QAction | None = ...) -> None: ...
    def separatorsCollapsible(self, /) -> bool: ...
    def setActiveAction(self, act: PySide6.QtGui.QAction, /) -> None: ...
    def setDefaultAction(self, arg__1: PySide6.QtGui.QAction, /) -> None: ...
    def setIcon(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, /) -> None: ...
    def setSeparatorsCollapsible(self, collapse: bool, /) -> None: ...
    def setTearOffEnabled(self, arg__1: bool, /) -> None: ...
    def setTitle(self, title: str, /) -> None: ...
    def setToolTipsVisible(self, visible: bool, /) -> None: ...
    @typing.overload
    def showTearOffMenu(self, /) -> None: ...
    @typing.overload
    def showTearOffMenu(self, pos: PySide6.QtCore.QPoint, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def title(self, /) -> str: ...
    def toolTipsVisible(self, /) -> bool: ...
    def wheelEvent(self, arg__1: PySide6.QtGui.QWheelEvent, /) -> None: ...


class QMenuBar(PySide6.QtWidgets.QWidget):

    hovered                  : typing.ClassVar[Signal] = ... # hovered(QAction*)
    triggered                : typing.ClassVar[Signal] = ... # triggered(QAction*)

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, defaultUp: bool | None = ..., nativeMenuBar: bool | None = ...) -> None: ...

    def actionAt(self, arg__1: PySide6.QtCore.QPoint, /) -> PySide6.QtGui.QAction: ...
    def actionEvent(self, arg__1: PySide6.QtGui.QActionEvent, /) -> None: ...
    def actionGeometry(self, arg__1: PySide6.QtGui.QAction, /) -> PySide6.QtCore.QRect: ...
    def activeAction(self, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addMenu(self, menu: PySide6.QtWidgets.QMenu, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addMenu(self, title: str, /) -> PySide6.QtWidgets.QMenu: ...
    @typing.overload
    def addMenu(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, title: str, /) -> PySide6.QtWidgets.QMenu: ...
    def addSeparator(self, /) -> PySide6.QtGui.QAction: ...
    def changeEvent(self, arg__1: PySide6.QtCore.QEvent, /) -> None: ...
    def clear(self, /) -> None: ...
    def cornerWidget(self, /, corner: PySide6.QtCore.Qt.Corner = ...) -> PySide6.QtWidgets.QWidget: ...
    def event(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    def eventFilter(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent, /) -> bool: ...
    def focusInEvent(self, arg__1: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusOutEvent(self, arg__1: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def heightForWidth(self, arg__1: int, /) -> int: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionMenuItem, action: PySide6.QtGui.QAction, /) -> None: ...
    def insertMenu(self, before: PySide6.QtGui.QAction, menu: PySide6.QtWidgets.QMenu, /) -> PySide6.QtGui.QAction: ...
    def insertSeparator(self, before: PySide6.QtGui.QAction, /) -> PySide6.QtGui.QAction: ...
    def isDefaultUp(self, /) -> bool: ...
    def isNativeMenuBar(self, /) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def leaveEvent(self, arg__1: PySide6.QtCore.QEvent, /) -> None: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def setActiveAction(self, action: PySide6.QtGui.QAction, /) -> None: ...
    def setCornerWidget(self, w: PySide6.QtWidgets.QWidget, /, corner: PySide6.QtCore.Qt.Corner = ...) -> None: ...
    def setDefaultUp(self, arg__1: bool, /) -> None: ...
    def setNativeMenuBar(self, nativeMenuBar: bool, /) -> None: ...
    def setVisible(self, visible: bool, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent, /) -> None: ...


class QMessageBox(PySide6.QtWidgets.QDialog):

    buttonClicked            : typing.ClassVar[Signal] = ... # buttonClicked(QAbstractButton*)

    class ButtonRole(enum.Enum):

        InvalidRole               = ...  # -1
        AcceptRole                = ...  # 0x0
        RejectRole                = ...  # 0x1
        DestructiveRole           = ...  # 0x2
        ActionRole                = ...  # 0x3
        HelpRole                  = ...  # 0x4
        YesRole                   = ...  # 0x5
        NoRole                    = ...  # 0x6
        ResetRole                 = ...  # 0x7
        ApplyRole                 = ...  # 0x8
        NRoles                    = ...  # 0x9

    class Icon(enum.Enum):

        NoIcon                    = ...  # 0x0
        Information               = ...  # 0x1
        Warning                   = ...  # 0x2
        Critical                  = ...  # 0x3
        Question                  = ...  # 0x4

    class Option(enum.Flag):

        DontUseNativeDialog       = ...  # 0x1

    class StandardButton(enum.IntFlag):

        ButtonMask                = ...  # -769
        NoButton                  = ...  # 0x0
        Default                   = ...  # 0x100
        Escape                    = ...  # 0x200
        FlagMask                  = ...  # 0x300
        FirstButton               = ...  # 0x400
        Ok                        = ...  # 0x400
        Save                      = ...  # 0x800
        SaveAll                   = ...  # 0x1000
        Open                      = ...  # 0x2000
        Yes                       = ...  # 0x4000
        YesAll                    = ...  # 0x8000
        YesToAll                  = ...  # 0x8000
        No                        = ...  # 0x10000
        NoAll                     = ...  # 0x20000
        NoToAll                   = ...  # 0x20000
        Abort                     = ...  # 0x40000
        Retry                     = ...  # 0x80000
        Ignore                    = ...  # 0x100000
        Close                     = ...  # 0x200000
        Cancel                    = ...  # 0x400000
        Discard                   = ...  # 0x800000
        Help                      = ...  # 0x1000000
        Apply                     = ...  # 0x2000000
        Reset                     = ...  # 0x4000000
        LastButton                = ...  # 0x8000000
        RestoreDefaults           = ...  # 0x8000000


    @typing.overload
    def __init__(self, icon: PySide6.QtWidgets.QMessageBox.Icon, title: str, text: str, /, buttons: PySide6.QtWidgets.QMessageBox.StandardButton = ..., parent: PySide6.QtWidgets.QWidget | None = ..., flags: PySide6.QtCore.Qt.WindowType = ..., *, iconPixmap: PySide6.QtGui.QPixmap | None = ..., textFormat: PySide6.QtCore.Qt.TextFormat | None = ..., standardButtons: PySide6.QtWidgets.QDialogButtonBox.StandardButton | None = ..., detailedText: str | None = ..., informativeText: str | None = ..., textInteractionFlags: PySide6.QtCore.Qt.TextInteractionFlag | None = ..., options: PySide6.QtGui.QAbstractFileIconProvider.Option | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, text: str | None = ..., icon: PySide6.QtWidgets.QMessageBox.Icon | None = ..., iconPixmap: PySide6.QtGui.QPixmap | None = ..., textFormat: PySide6.QtCore.Qt.TextFormat | None = ..., standardButtons: PySide6.QtWidgets.QDialogButtonBox.StandardButton | None = ..., detailedText: str | None = ..., informativeText: str | None = ..., textInteractionFlags: PySide6.QtCore.Qt.TextInteractionFlag | None = ..., options: PySide6.QtGui.QAbstractFileIconProvider.Option | None = ...) -> None: ...

    @staticmethod
    def about(parent: PySide6.QtWidgets.QWidget, title: str, text: str, /) -> None: ...
    @staticmethod
    def aboutQt(parent: PySide6.QtWidgets.QWidget, /, title: str = ...) -> None: ...
    @typing.overload
    def addButton(self, button: PySide6.QtWidgets.QMessageBox.StandardButton, /) -> PySide6.QtWidgets.QPushButton: ...
    @typing.overload
    def addButton(self, button: PySide6.QtWidgets.QAbstractButton, role: PySide6.QtWidgets.QMessageBox.ButtonRole, /) -> None: ...
    @typing.overload
    def addButton(self, text: str, role: PySide6.QtWidgets.QMessageBox.ButtonRole, /) -> PySide6.QtWidgets.QPushButton: ...
    def button(self, which: PySide6.QtWidgets.QMessageBox.StandardButton, /) -> PySide6.QtWidgets.QAbstractButton: ...
    def buttonRole(self, button: PySide6.QtWidgets.QAbstractButton, /) -> PySide6.QtWidgets.QMessageBox.ButtonRole: ...
    def buttonText(self, button: int, /) -> str: ...
    def buttons(self, /) -> typing.List[PySide6.QtWidgets.QAbstractButton]: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def checkBox(self, /) -> PySide6.QtWidgets.QCheckBox: ...
    def clickedButton(self, /) -> PySide6.QtWidgets.QAbstractButton: ...
    def closeEvent(self, event: PySide6.QtGui.QCloseEvent, /) -> None: ...
    @staticmethod
    def critical(parent: PySide6.QtWidgets.QWidget, title: str, text: str, /, buttons: PySide6.QtWidgets.QMessageBox.StandardButton = ..., defaultButton: PySide6.QtWidgets.QMessageBox.StandardButton = ...) -> PySide6.QtWidgets.QMessageBox.StandardButton: ...
    def defaultButton(self, /) -> PySide6.QtWidgets.QPushButton: ...
    def detailedText(self, /) -> str: ...
    def escapeButton(self, /) -> PySide6.QtWidgets.QAbstractButton: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def icon(self, /) -> PySide6.QtWidgets.QMessageBox.Icon: ...
    def iconPixmap(self, /) -> PySide6.QtGui.QPixmap: ...
    @staticmethod
    def information(parent: PySide6.QtWidgets.QWidget, title: str, text: str, /, buttons: PySide6.QtWidgets.QMessageBox.StandardButton = ..., defaultButton: PySide6.QtWidgets.QMessageBox.StandardButton = ...) -> PySide6.QtWidgets.QMessageBox.StandardButton: ...
    def informativeText(self, /) -> str: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    @typing.overload
    def open(self, /) -> None: ...
    @typing.overload
    def open(self, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /) -> None: ...
    @typing.overload
    def open(self, functor: collections.abc.Callable[..., typing.Any], /) -> None: ...
    def options(self, /) -> PySide6.QtWidgets.QMessageBox.Option: ...
    @staticmethod
    def question(parent: PySide6.QtWidgets.QWidget, title: str, text: str, /, buttons: PySide6.QtWidgets.QMessageBox.StandardButton = ..., defaultButton: PySide6.QtWidgets.QMessageBox.StandardButton = ...) -> PySide6.QtWidgets.QMessageBox.StandardButton: ...
    def removeButton(self, button: PySide6.QtWidgets.QAbstractButton, /) -> None: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def setButtonText(self, button: int, text: str, /) -> None: ...
    def setCheckBox(self, cb: PySide6.QtWidgets.QCheckBox, /) -> None: ...
    @typing.overload
    def setDefaultButton(self, button: PySide6.QtWidgets.QPushButton, /) -> None: ...
    @typing.overload
    def setDefaultButton(self, button: PySide6.QtWidgets.QMessageBox.StandardButton, /) -> None: ...
    def setDetailedText(self, text: str, /) -> None: ...
    @typing.overload
    def setEscapeButton(self, button: PySide6.QtWidgets.QMessageBox.StandardButton, /) -> None: ...
    @typing.overload
    def setEscapeButton(self, button: PySide6.QtWidgets.QAbstractButton, /) -> None: ...
    def setIcon(self, arg__1: PySide6.QtWidgets.QMessageBox.Icon, /) -> None: ...
    def setIconPixmap(self, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, /) -> None: ...
    def setInformativeText(self, text: str, /) -> None: ...
    def setOption(self, option: PySide6.QtWidgets.QMessageBox.Option, /, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide6.QtWidgets.QMessageBox.Option, /) -> None: ...
    def setStandardButtons(self, buttons: PySide6.QtWidgets.QMessageBox.StandardButton, /) -> None: ...
    def setText(self, text: str, /) -> None: ...
    def setTextFormat(self, format: PySide6.QtCore.Qt.TextFormat, /) -> None: ...
    def setTextInteractionFlags(self, flags: PySide6.QtCore.Qt.TextInteractionFlag, /) -> None: ...
    def setWindowModality(self, windowModality: PySide6.QtCore.Qt.WindowModality, /) -> None: ...
    def setWindowTitle(self, title: str, /) -> None: ...
    def showEvent(self, event: PySide6.QtGui.QShowEvent, /) -> None: ...
    def standardButton(self, button: PySide6.QtWidgets.QAbstractButton, /) -> PySide6.QtWidgets.QMessageBox.StandardButton: ...
    def standardButtons(self, /) -> PySide6.QtWidgets.QMessageBox.StandardButton: ...
    @staticmethod
    def standardIcon(icon: PySide6.QtWidgets.QMessageBox.Icon, /) -> PySide6.QtGui.QPixmap: ...
    def testOption(self, option: PySide6.QtWidgets.QMessageBox.Option, /) -> bool: ...
    def text(self, /) -> str: ...
    def textFormat(self, /) -> PySide6.QtCore.Qt.TextFormat: ...
    def textInteractionFlags(self, /) -> PySide6.QtCore.Qt.TextInteractionFlag: ...
    @staticmethod
    def warning(parent: PySide6.QtWidgets.QWidget, title: str, text: str, /, buttons: PySide6.QtWidgets.QMessageBox.StandardButton = ..., defaultButton: PySide6.QtWidgets.QMessageBox.StandardButton = ...) -> PySide6.QtWidgets.QMessageBox.StandardButton: ...


class QPanGesture(PySide6.QtWidgets.QGesture):

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, lastOffset: PySide6.QtCore.QPointF | None = ..., offset: PySide6.QtCore.QPointF | None = ..., delta: PySide6.QtCore.QPointF | None = ..., acceleration: float | None = ...) -> None: ...

    def acceleration(self, /) -> float: ...
    def delta(self, /) -> PySide6.QtCore.QPointF: ...
    def lastOffset(self, /) -> PySide6.QtCore.QPointF: ...
    def offset(self, /) -> PySide6.QtCore.QPointF: ...
    def setAcceleration(self, value: float, /) -> None: ...
    def setLastOffset(self, value: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setOffset(self, value: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...


class QPinchGesture(PySide6.QtWidgets.QGesture):

    class ChangeFlag(enum.Flag):

        ScaleFactorChanged        = ...  # 0x1
        RotationAngleChanged      = ...  # 0x2
        CenterPointChanged        = ...  # 0x4


    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, totalChangeFlags: PySide6.QtWidgets.QGraphicsEffect.ChangeFlag | None = ..., changeFlags: PySide6.QtWidgets.QGraphicsEffect.ChangeFlag | None = ..., totalScaleFactor: float | None = ..., lastScaleFactor: float | None = ..., scaleFactor: float | None = ..., totalRotationAngle: float | None = ..., lastRotationAngle: float | None = ..., rotationAngle: float | None = ..., startCenterPoint: PySide6.QtCore.QPointF | None = ..., lastCenterPoint: PySide6.QtCore.QPointF | None = ..., centerPoint: PySide6.QtCore.QPointF | None = ...) -> None: ...

    def centerPoint(self, /) -> PySide6.QtCore.QPointF: ...
    def changeFlags(self, /) -> PySide6.QtWidgets.QPinchGesture.ChangeFlag: ...
    def lastCenterPoint(self, /) -> PySide6.QtCore.QPointF: ...
    def lastRotationAngle(self, /) -> float: ...
    def lastScaleFactor(self, /) -> float: ...
    def rotationAngle(self, /) -> float: ...
    def scaleFactor(self, /) -> float: ...
    def setCenterPoint(self, value: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setChangeFlags(self, value: PySide6.QtWidgets.QPinchGesture.ChangeFlag, /) -> None: ...
    def setLastCenterPoint(self, value: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setLastRotationAngle(self, value: float, /) -> None: ...
    def setLastScaleFactor(self, value: float, /) -> None: ...
    def setRotationAngle(self, value: float, /) -> None: ...
    def setScaleFactor(self, value: float, /) -> None: ...
    def setStartCenterPoint(self, value: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    def setTotalChangeFlags(self, value: PySide6.QtWidgets.QPinchGesture.ChangeFlag, /) -> None: ...
    def setTotalRotationAngle(self, value: float, /) -> None: ...
    def setTotalScaleFactor(self, value: float, /) -> None: ...
    def startCenterPoint(self, /) -> PySide6.QtCore.QPointF: ...
    def totalChangeFlags(self, /) -> PySide6.QtWidgets.QPinchGesture.ChangeFlag: ...
    def totalRotationAngle(self, /) -> float: ...
    def totalScaleFactor(self, /) -> float: ...


class QPlainTextDocumentLayout(PySide6.QtGui.QAbstractTextDocumentLayout):

    def __init__(self, document: PySide6.QtGui.QTextDocument, /, *, cursorWidth: int | None = ...) -> None: ...

    def blockBoundingRect(self, block: PySide6.QtGui.QTextBlock, /) -> PySide6.QtCore.QRectF: ...
    def cursorWidth(self, /) -> int: ...
    def documentChanged(self, from_: int, arg__2: int, charsAdded: int, /) -> None: ...
    def documentSize(self, /) -> PySide6.QtCore.QSizeF: ...
    def draw(self, arg__1: PySide6.QtGui.QPainter, arg__2: PySide6.QtGui.QAbstractTextDocumentLayout.PaintContext, /) -> None: ...
    def ensureBlockLayout(self, block: PySide6.QtGui.QTextBlock, /) -> None: ...
    def frameBoundingRect(self, arg__1: PySide6.QtGui.QTextFrame, /) -> PySide6.QtCore.QRectF: ...
    def hitTest(self, arg__1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, arg__2: PySide6.QtCore.Qt.HitTestAccuracy, /) -> int: ...
    def pageCount(self, /) -> int: ...
    def requestUpdate(self, /) -> None: ...
    def setCursorWidth(self, width: int, /) -> None: ...


class QPlainTextEdit(PySide6.QtWidgets.QAbstractScrollArea):

    blockCountChanged        : typing.ClassVar[Signal] = ... # blockCountChanged(int)
    copyAvailable            : typing.ClassVar[Signal] = ... # copyAvailable(bool)
    cursorPositionChanged    : typing.ClassVar[Signal] = ... # cursorPositionChanged()
    modificationChanged      : typing.ClassVar[Signal] = ... # modificationChanged(bool)
    redoAvailable            : typing.ClassVar[Signal] = ... # redoAvailable(bool)
    selectionChanged         : typing.ClassVar[Signal] = ... # selectionChanged()
    textChanged              : typing.ClassVar[Signal] = ... # textChanged()
    undoAvailable            : typing.ClassVar[Signal] = ... # undoAvailable(bool)
    updateRequest            : typing.ClassVar[Signal] = ... # updateRequest(QRect,int)

    class LineWrapMode(enum.Enum):

        NoWrap                    = ...  # 0x0
        WidgetWidth               = ...  # 0x1


    @typing.overload
    def __init__(self, text: str, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, tabChangesFocus: bool | None = ..., documentTitle: str | None = ..., undoRedoEnabled: bool | None = ..., lineWrapMode: PySide6.QtWidgets.QPlainTextEdit.LineWrapMode | None = ..., readOnly: bool | None = ..., plainText: str | None = ..., overwriteMode: bool | None = ..., tabStopDistance: float | None = ..., cursorWidth: int | None = ..., textInteractionFlags: PySide6.QtCore.Qt.TextInteractionFlag | None = ..., blockCount: int | None = ..., maximumBlockCount: int | None = ..., backgroundVisible: bool | None = ..., centerOnScroll: bool | None = ..., placeholderText: str | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, tabChangesFocus: bool | None = ..., documentTitle: str | None = ..., undoRedoEnabled: bool | None = ..., lineWrapMode: PySide6.QtWidgets.QPlainTextEdit.LineWrapMode | None = ..., readOnly: bool | None = ..., plainText: str | None = ..., overwriteMode: bool | None = ..., tabStopDistance: float | None = ..., cursorWidth: int | None = ..., textInteractionFlags: PySide6.QtCore.Qt.TextInteractionFlag | None = ..., blockCount: int | None = ..., maximumBlockCount: int | None = ..., backgroundVisible: bool | None = ..., centerOnScroll: bool | None = ..., placeholderText: str | None = ...) -> None: ...

    def anchorAt(self, pos: PySide6.QtCore.QPoint, /) -> str: ...
    def appendHtml(self, html: str, /) -> None: ...
    def appendPlainText(self, text: str, /) -> None: ...
    def backgroundVisible(self, /) -> bool: ...
    def blockBoundingGeometry(self, block: PySide6.QtGui.QTextBlock, /) -> PySide6.QtCore.QRectF: ...
    def blockBoundingRect(self, block: PySide6.QtGui.QTextBlock, /) -> PySide6.QtCore.QRectF: ...
    def blockCount(self, /) -> int: ...
    def canInsertFromMimeData(self, source: PySide6.QtCore.QMimeData, /) -> bool: ...
    def canPaste(self, /) -> bool: ...
    def centerCursor(self, /) -> None: ...
    def centerOnScroll(self, /) -> bool: ...
    def changeEvent(self, e: PySide6.QtCore.QEvent, /) -> None: ...
    def clear(self, /) -> None: ...
    def contentOffset(self, /) -> PySide6.QtCore.QPointF: ...
    def contextMenuEvent(self, e: PySide6.QtGui.QContextMenuEvent, /) -> None: ...
    def copy(self, /) -> None: ...
    def createMimeDataFromSelection(self, /) -> PySide6.QtCore.QMimeData: ...
    @typing.overload
    def createStandardContextMenu(self, /) -> PySide6.QtWidgets.QMenu: ...
    @typing.overload
    def createStandardContextMenu(self, position: PySide6.QtCore.QPoint, /) -> PySide6.QtWidgets.QMenu: ...
    def currentCharFormat(self, /) -> PySide6.QtGui.QTextCharFormat: ...
    def cursorForPosition(self, pos: PySide6.QtCore.QPoint, /) -> PySide6.QtGui.QTextCursor: ...
    @typing.overload
    def cursorRect(self, /) -> PySide6.QtCore.QRect: ...
    @typing.overload
    def cursorRect(self, cursor: PySide6.QtGui.QTextCursor, /) -> PySide6.QtCore.QRect: ...
    def cursorWidth(self, /) -> int: ...
    def cut(self, /) -> None: ...
    def doSetTextCursor(self, cursor: PySide6.QtGui.QTextCursor, /) -> None: ...
    def document(self, /) -> PySide6.QtGui.QTextDocument: ...
    def documentTitle(self, /) -> str: ...
    def dragEnterEvent(self, e: PySide6.QtGui.QDragEnterEvent, /) -> None: ...
    def dragLeaveEvent(self, e: PySide6.QtGui.QDragLeaveEvent, /) -> None: ...
    def dragMoveEvent(self, e: PySide6.QtGui.QDragMoveEvent, /) -> None: ...
    def dropEvent(self, e: PySide6.QtGui.QDropEvent, /) -> None: ...
    def ensureCursorVisible(self, /) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def extraSelections(self, /) -> typing.List[PySide6.QtWidgets.QTextEdit.ExtraSelection]: ...
    @typing.overload
    def find(self, exp: str, /, options: PySide6.QtGui.QTextDocument.FindFlag = ...) -> bool: ...
    @typing.overload
    def find(self, exp: PySide6.QtCore.QRegularExpression | str, /, options: PySide6.QtGui.QTextDocument.FindFlag = ...) -> bool: ...
    def firstVisibleBlock(self, /) -> PySide6.QtGui.QTextBlock: ...
    def focusInEvent(self, e: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusNextPrevChild(self, next: bool, /) -> bool: ...
    def focusOutEvent(self, e: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def getPaintContext(self, /) -> PySide6.QtGui.QAbstractTextDocumentLayout.PaintContext: ...
    def inputMethodEvent(self, arg__1: PySide6.QtGui.QInputMethodEvent, /) -> None: ...
    @typing.overload
    def inputMethodQuery(self, property: PySide6.QtCore.Qt.InputMethodQuery, /) -> typing.Any: ...
    @typing.overload
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery, argument: typing.Any, /) -> typing.Any: ...
    def insertFromMimeData(self, source: PySide6.QtCore.QMimeData, /) -> None: ...
    def insertPlainText(self, text: str, /) -> None: ...
    def isReadOnly(self, /) -> bool: ...
    def isUndoRedoEnabled(self, /) -> bool: ...
    def keyPressEvent(self, e: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def keyReleaseEvent(self, e: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def lineWrapMode(self, /) -> PySide6.QtWidgets.QPlainTextEdit.LineWrapMode: ...
    def loadResource(self, type: int, name: PySide6.QtCore.QUrl | str, /) -> typing.Any: ...
    def maximumBlockCount(self, /) -> int: ...
    def mergeCurrentCharFormat(self, modifier: PySide6.QtGui.QTextCharFormat, /) -> None: ...
    def mouseDoubleClickEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseMoveEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def moveCursor(self, operation: PySide6.QtGui.QTextCursor.MoveOperation, /, mode: PySide6.QtGui.QTextCursor.MoveMode = ...) -> None: ...
    def overwriteMode(self, /) -> bool: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def paste(self, /) -> None: ...
    def placeholderText(self, /) -> str: ...
    def print_(self, printer: PySide6.QtGui.QPagedPaintDevice, /) -> None: ...
    def redo(self, /) -> None: ...
    def resizeEvent(self, e: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int, /) -> None: ...
    def selectAll(self, /) -> None: ...
    def setBackgroundVisible(self, visible: bool, /) -> None: ...
    def setCenterOnScroll(self, enabled: bool, /) -> None: ...
    def setCurrentCharFormat(self, format: PySide6.QtGui.QTextCharFormat, /) -> None: ...
    def setCursorWidth(self, width: int, /) -> None: ...
    def setDocument(self, document: PySide6.QtGui.QTextDocument, /) -> None: ...
    def setDocumentTitle(self, title: str, /) -> None: ...
    def setExtraSelections(self, selections: collections.abc.Sequence[PySide6.QtWidgets.QTextEdit.ExtraSelection], /) -> None: ...
    def setLineWrapMode(self, mode: PySide6.QtWidgets.QPlainTextEdit.LineWrapMode, /) -> None: ...
    def setMaximumBlockCount(self, maximum: int, /) -> None: ...
    def setOverwriteMode(self, overwrite: bool, /) -> None: ...
    def setPlaceholderText(self, placeholderText: str, /) -> None: ...
    def setPlainText(self, text: str, /) -> None: ...
    def setReadOnly(self, ro: bool, /) -> None: ...
    def setTabChangesFocus(self, b: bool, /) -> None: ...
    def setTabStopDistance(self, distance: float, /) -> None: ...
    def setTextCursor(self, cursor: PySide6.QtGui.QTextCursor, /) -> None: ...
    def setTextInteractionFlags(self, flags: PySide6.QtCore.Qt.TextInteractionFlag, /) -> None: ...
    def setUndoRedoEnabled(self, enable: bool, /) -> None: ...
    def setWordWrapMode(self, policy: PySide6.QtGui.QTextOption.WrapMode, /) -> None: ...
    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent, /) -> None: ...
    def tabChangesFocus(self, /) -> bool: ...
    def tabStopDistance(self, /) -> float: ...
    def textCursor(self, /) -> PySide6.QtGui.QTextCursor: ...
    def textInteractionFlags(self, /) -> PySide6.QtCore.Qt.TextInteractionFlag: ...
    def timerEvent(self, e: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def toPlainText(self, /) -> str: ...
    def undo(self, /) -> None: ...
    def wheelEvent(self, e: PySide6.QtGui.QWheelEvent, /) -> None: ...
    def wordWrapMode(self, /) -> PySide6.QtGui.QTextOption.WrapMode: ...
    def zoomIn(self, /, range: int = ...) -> None: ...
    def zoomInF(self, range: float, /) -> None: ...
    def zoomOut(self, /, range: int = ...) -> None: ...


class QProgressBar(PySide6.QtWidgets.QWidget):

    valueChanged             : typing.ClassVar[Signal] = ... # valueChanged(int)

    class Direction(enum.Enum):

        TopToBottom               = ...  # 0x0
        BottomToTop               = ...  # 0x1


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, minimum: int | None = ..., maximum: int | None = ..., text: str | None = ..., value: int | None = ..., alignment: PySide6.QtCore.Qt.AlignmentFlag | None = ..., textVisible: bool | None = ..., orientation: PySide6.QtCore.Qt.Orientation | None = ..., invertedAppearance: bool | None = ..., textDirection: PySide6.QtWidgets.QProgressBar.Direction | None = ..., format: str | None = ...) -> None: ...

    def alignment(self, /) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def format(self, /) -> str: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionProgressBar, /) -> None: ...
    def invertedAppearance(self, /) -> bool: ...
    def isTextVisible(self, /) -> bool: ...
    def maximum(self, /) -> int: ...
    def minimum(self, /) -> int: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def orientation(self, /) -> PySide6.QtCore.Qt.Orientation: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def reset(self, /) -> None: ...
    def resetFormat(self, /) -> None: ...
    def setAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    def setFormat(self, format: str, /) -> None: ...
    def setInvertedAppearance(self, invert: bool, /) -> None: ...
    def setMaximum(self, maximum: int, /) -> None: ...
    def setMinimum(self, minimum: int, /) -> None: ...
    def setOrientation(self, arg__1: PySide6.QtCore.Qt.Orientation, /) -> None: ...
    def setRange(self, minimum: int, maximum: int, /) -> None: ...
    def setTextDirection(self, textDirection: PySide6.QtWidgets.QProgressBar.Direction, /) -> None: ...
    def setTextVisible(self, visible: bool, /) -> None: ...
    def setValue(self, value: int, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def text(self, /) -> str: ...
    def textDirection(self, /) -> PySide6.QtWidgets.QProgressBar.Direction: ...
    def value(self, /) -> int: ...


class QProgressDialog(PySide6.QtWidgets.QDialog):

    canceled                 : typing.ClassVar[Signal] = ... # canceled()

    @typing.overload
    def __init__(self, labelText: str, cancelButtonText: str, minimum: int, maximum: int, /, parent: PySide6.QtWidgets.QWidget | None = ..., flags: PySide6.QtCore.Qt.WindowType = ..., *, wasCanceled: bool | None = ..., value: int | None = ..., autoReset: bool | None = ..., autoClose: bool | None = ..., minimumDuration: int | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., flags: PySide6.QtCore.Qt.WindowType = ..., *, wasCanceled: bool | None = ..., minimum: int | None = ..., maximum: int | None = ..., value: int | None = ..., autoReset: bool | None = ..., autoClose: bool | None = ..., minimumDuration: int | None = ..., labelText: str | None = ...) -> None: ...

    def autoClose(self, /) -> bool: ...
    def autoReset(self, /) -> bool: ...
    def cancel(self, /) -> None: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def closeEvent(self, event: PySide6.QtGui.QCloseEvent, /) -> None: ...
    def forceShow(self, /) -> None: ...
    def labelText(self, /) -> str: ...
    def maximum(self, /) -> int: ...
    def minimum(self, /) -> int: ...
    def minimumDuration(self, /) -> int: ...
    @typing.overload
    def open(self, /) -> None: ...
    @typing.overload
    def open(self, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /) -> None: ...
    def reset(self, /) -> None: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def setAutoClose(self, close: bool, /) -> None: ...
    def setAutoReset(self, reset: bool, /) -> None: ...
    def setBar(self, bar: PySide6.QtWidgets.QProgressBar, /) -> None: ...
    def setCancelButton(self, button: PySide6.QtWidgets.QPushButton | None, /) -> None: ...
    def setCancelButtonText(self, text: str, /) -> None: ...
    def setLabel(self, label: PySide6.QtWidgets.QLabel, /) -> None: ...
    def setLabelText(self, text: str, /) -> None: ...
    def setMaximum(self, maximum: int, /) -> None: ...
    def setMinimum(self, minimum: int, /) -> None: ...
    def setMinimumDuration(self, ms: int, /) -> None: ...
    def setRange(self, minimum: int, maximum: int, /) -> None: ...
    def setValue(self, progress: int, /) -> None: ...
    def showEvent(self, event: PySide6.QtGui.QShowEvent, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def value(self, /) -> int: ...
    def wasCanceled(self, /) -> bool: ...


class QProxyStyle(PySide6.QtWidgets.QCommonStyle):

    @typing.overload
    def __init__(self, key: str, /) -> None: ...
    @typing.overload
    def __init__(self, /, style: PySide6.QtWidgets.QStyle | None = ...) -> None: ...

    def baseStyle(self, /) -> PySide6.QtWidgets.QStyle: ...
    def drawComplexControl(self, control: PySide6.QtWidgets.QStyle.ComplexControl, option: PySide6.QtWidgets.QStyleOptionComplex, painter: PySide6.QtGui.QPainter, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def drawControl(self, element: PySide6.QtWidgets.QStyle.ControlElement, option: PySide6.QtWidgets.QStyleOption, painter: PySide6.QtGui.QPainter, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def drawItemPixmap(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, alignment: int, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, /) -> None: ...
    def drawItemText(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, flags: int, pal: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, enabled: bool, text: str, /, textRole: PySide6.QtGui.QPalette.ColorRole = ...) -> None: ...
    def drawPrimitive(self, element: PySide6.QtWidgets.QStyle.PrimitiveElement, option: PySide6.QtWidgets.QStyleOption, painter: PySide6.QtGui.QPainter, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def generatedIconPixmap(self, iconMode: PySide6.QtGui.QIcon.Mode, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, opt: PySide6.QtWidgets.QStyleOption, /) -> PySide6.QtGui.QPixmap: ...
    def hitTestComplexControl(self, control: PySide6.QtWidgets.QStyle.ComplexControl, option: PySide6.QtWidgets.QStyleOptionComplex, pos: PySide6.QtCore.QPoint, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> PySide6.QtWidgets.QStyle.SubControl: ...
    def itemPixmapRect(self, r: PySide6.QtCore.QRect, flags: int, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, /) -> PySide6.QtCore.QRect: ...
    def itemTextRect(self, fm: PySide6.QtGui.QFontMetrics, r: PySide6.QtCore.QRect, flags: int, enabled: bool, text: str, /) -> PySide6.QtCore.QRect: ...
    def layoutSpacing(self, control1: PySide6.QtWidgets.QSizePolicy.ControlType, control2: PySide6.QtWidgets.QSizePolicy.ControlType, orientation: PySide6.QtCore.Qt.Orientation, /, option: PySide6.QtWidgets.QStyleOption | None = ..., widget: PySide6.QtWidgets.QWidget | None = ...) -> int: ...
    def pixelMetric(self, metric: PySide6.QtWidgets.QStyle.PixelMetric, /, option: PySide6.QtWidgets.QStyleOption | None = ..., widget: PySide6.QtWidgets.QWidget | None = ...) -> int: ...
    @typing.overload
    def polish(self, app: PySide6.QtWidgets.QApplication, /) -> None: ...
    @typing.overload
    def polish(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    @typing.overload
    def polish(self, arg__1: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, /) -> None: ...
    def setBaseStyle(self, style: PySide6.QtWidgets.QStyle, /) -> None: ...
    def sizeFromContents(self, type: PySide6.QtWidgets.QStyle.ContentsType, option: PySide6.QtWidgets.QStyleOption, size: PySide6.QtCore.QSize, widget: PySide6.QtWidgets.QWidget, /) -> PySide6.QtCore.QSize: ...
    def standardIcon(self, standardIcon: PySide6.QtWidgets.QStyle.StandardPixmap, /, option: PySide6.QtWidgets.QStyleOption | None = ..., widget: PySide6.QtWidgets.QWidget | None = ...) -> PySide6.QtGui.QIcon: ...
    def standardPalette(self, /) -> PySide6.QtGui.QPalette: ...
    def standardPixmap(self, standardPixmap: PySide6.QtWidgets.QStyle.StandardPixmap, opt: PySide6.QtWidgets.QStyleOption, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> PySide6.QtGui.QPixmap: ...
    def styleHint(self, hint: PySide6.QtWidgets.QStyle.StyleHint, /, option: PySide6.QtWidgets.QStyleOption | None = ..., widget: PySide6.QtWidgets.QWidget | None = ..., returnData: PySide6.QtWidgets.QStyleHintReturn | None = ...) -> int: ...
    def subControlRect(self, cc: PySide6.QtWidgets.QStyle.ComplexControl, opt: PySide6.QtWidgets.QStyleOptionComplex, sc: PySide6.QtWidgets.QStyle.SubControl, widget: PySide6.QtWidgets.QWidget, /) -> PySide6.QtCore.QRect: ...
    def subElementRect(self, element: PySide6.QtWidgets.QStyle.SubElement, option: PySide6.QtWidgets.QStyleOption, widget: PySide6.QtWidgets.QWidget, /) -> PySide6.QtCore.QRect: ...
    @typing.overload
    def unpolish(self, app: PySide6.QtWidgets.QApplication, /) -> None: ...
    @typing.overload
    def unpolish(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...


class QPushButton(PySide6.QtWidgets.QAbstractButton):

    @typing.overload
    def __init__(self, text: str, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, autoDefault: bool | None = ..., default: bool | None = ..., flat: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, autoDefault: bool | None = ..., default: bool | None = ..., flat: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, autoDefault: bool | None = ..., default: bool | None = ..., flat: bool | None = ...) -> None: ...

    def autoDefault(self, /) -> bool: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def focusInEvent(self, arg__1: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusOutEvent(self, arg__1: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def hitButton(self, pos: PySide6.QtCore.QPoint, /) -> bool: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionButton, /) -> None: ...
    def isDefault(self, /) -> bool: ...
    def isFlat(self, /) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def menu(self, /) -> PySide6.QtWidgets.QMenu: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def setAutoDefault(self, arg__1: bool, /) -> None: ...
    def setDefault(self, arg__1: bool, /) -> None: ...
    def setFlat(self, arg__1: bool, /) -> None: ...
    def setMenu(self, menu: PySide6.QtWidgets.QMenu, /) -> None: ...
    def showMenu(self, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...


class QRadioButton(PySide6.QtWidgets.QAbstractButton):

    @typing.overload
    def __init__(self, text: str, /, parent: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ...) -> None: ...

    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def hitButton(self, arg__1: PySide6.QtCore.QPoint, /) -> bool: ...
    def initStyleOption(self, button: PySide6.QtWidgets.QStyleOptionButton, /) -> None: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...


class QRhiWidget(PySide6.QtWidgets.QWidget):

    colorBufferFormatChanged : typing.ClassVar[Signal] = ... # colorBufferFormatChanged(TextureFormat)
    fixedColorBufferSizeChanged: typing.ClassVar[Signal] = ... # fixedColorBufferSizeChanged(QSize)
    frameSubmitted           : typing.ClassVar[Signal] = ... # frameSubmitted()
    mirrorVerticallyChanged  : typing.ClassVar[Signal] = ... # mirrorVerticallyChanged(bool)
    renderFailed             : typing.ClassVar[Signal] = ... # renderFailed()
    sampleCountChanged       : typing.ClassVar[Signal] = ... # sampleCountChanged(int)

    class Api(enum.Enum):

        Null                      = ...  # 0x0
        OpenGL                    = ...  # 0x1
        Metal                     = ...  # 0x2
        Vulkan                    = ...  # 0x3
        Direct3D11                = ...  # 0x4
        Direct3D12                = ...  # 0x5

    class TextureFormat(enum.Enum):

        RGBA8                     = ...  # 0x0
        RGBA16F                   = ...  # 0x1
        RGBA32F                   = ...  # 0x2
        RGB10A2                   = ...  # 0x3


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., f: PySide6.QtCore.Qt.WindowType = ..., *, sampleCount: int | None = ..., colorBufferFormat: PySide6.QtWidgets.QRhiWidget.TextureFormat | None = ..., fixedColorBufferSize: PySide6.QtCore.QSize | None = ..., mirrorVertically: bool | None = ...) -> None: ...

    def api(self, /) -> PySide6.QtWidgets.QRhiWidget.Api: ...
    def colorBufferFormat(self, /) -> PySide6.QtWidgets.QRhiWidget.TextureFormat: ...
    def colorTexture(self, /) -> PySide6.QtGui.QRhiTexture: ...
    def depthStencilBuffer(self, /) -> PySide6.QtGui.QRhiRenderBuffer: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def fixedColorBufferSize(self, /) -> PySide6.QtCore.QSize: ...
    def grabFramebuffer(self, /) -> PySide6.QtGui.QImage: ...
    def initialize(self, cb: PySide6.QtGui.QRhiCommandBuffer, /) -> None: ...
    def isAutoRenderTargetEnabled(self, /) -> bool: ...
    def isDebugLayerEnabled(self, /) -> bool: ...
    def isMirrorVerticallyEnabled(self, /) -> bool: ...
    def msaaColorBuffer(self, /) -> PySide6.QtGui.QRhiRenderBuffer: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def releaseResources(self, /) -> None: ...
    def render(self, cb: PySide6.QtGui.QRhiCommandBuffer, /) -> None: ...
    def renderTarget(self, /) -> PySide6.QtGui.QRhiRenderTarget: ...
    def resizeEvent(self, e: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def resolveTexture(self, /) -> PySide6.QtGui.QRhiTexture: ...
    def rhi(self, /) -> PySide6.QtGui.QRhi: ...
    def sampleCount(self, /) -> int: ...
    def setApi(self, api: PySide6.QtWidgets.QRhiWidget.Api, /) -> None: ...
    def setAutoRenderTarget(self, enabled: bool, /) -> None: ...
    def setColorBufferFormat(self, format: PySide6.QtWidgets.QRhiWidget.TextureFormat, /) -> None: ...
    def setDebugLayerEnabled(self, enable: bool, /) -> None: ...
    @typing.overload
    def setFixedColorBufferSize(self, pixelSize: PySide6.QtCore.QSize, /) -> None: ...
    @typing.overload
    def setFixedColorBufferSize(self, w: int, h: int, /) -> None: ...
    def setMirrorVertically(self, enabled: bool, /) -> None: ...
    def setSampleCount(self, samples: int, /) -> None: ...


class QRubberBand(PySide6.QtWidgets.QWidget):

    class Shape(enum.Enum):

        Line                      = ...  # 0x0
        Rectangle                 = ...  # 0x1


    def __init__(self, arg__1: PySide6.QtWidgets.QRubberBand.Shape, /, parent: PySide6.QtWidgets.QWidget | None = ...) -> None: ...

    def changeEvent(self, arg__1: PySide6.QtCore.QEvent, /) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionRubberBand, /) -> None: ...
    @typing.overload
    def move(self, p: PySide6.QtCore.QPoint, /) -> None: ...
    @typing.overload
    def move(self, x: int, y: int, /) -> None: ...
    def moveEvent(self, arg__1: PySide6.QtGui.QMoveEvent, /) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    @typing.overload
    def resize(self, s: PySide6.QtCore.QSize, /) -> None: ...
    @typing.overload
    def resize(self, w: int, h: int, /) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent, /) -> None: ...
    @typing.overload
    def setGeometry(self, r: PySide6.QtCore.QRect, /) -> None: ...
    @typing.overload
    def setGeometry(self, x: int, y: int, w: int, h: int, /) -> None: ...
    def shape(self, /) -> PySide6.QtWidgets.QRubberBand.Shape: ...
    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent, /) -> None: ...


class QScrollArea(PySide6.QtWidgets.QAbstractScrollArea):

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, widgetResizable: bool | None = ..., alignment: PySide6.QtCore.Qt.AlignmentFlag | None = ...) -> None: ...

    def alignment(self, /) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def ensureVisible(self, x: int, y: int, /, xmargin: int = ..., ymargin: int = ...) -> None: ...
    def ensureWidgetVisible(self, childWidget: PySide6.QtWidgets.QWidget, /, xmargin: int = ..., ymargin: int = ...) -> None: ...
    def event(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    def eventFilter(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent, /) -> bool: ...
    def focusNextPrevChild(self, next: bool, /) -> bool: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int, /) -> None: ...
    def setAlignment(self, arg__1: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    def setWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setWidgetResizable(self, resizable: bool, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def takeWidget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def viewportSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def widget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def widgetResizable(self, /) -> bool: ...


class QScrollBar(PySide6.QtWidgets.QAbstractSlider):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.Qt.Orientation, /, parent: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ...) -> None: ...

    def contextMenuEvent(self, arg__1: PySide6.QtGui.QContextMenuEvent, /) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def hideEvent(self, arg__1: PySide6.QtGui.QHideEvent, /) -> None: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionSlider, /) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def sliderChange(self, change: PySide6.QtWidgets.QAbstractSlider.SliderChange, /) -> None: ...
    def wheelEvent(self, arg__1: PySide6.QtGui.QWheelEvent, /) -> None: ...


class QScroller(PySide6.QtCore.QObject):

    scrollerPropertiesChanged: typing.ClassVar[Signal] = ... # scrollerPropertiesChanged(QScrollerProperties)
    stateChanged             : typing.ClassVar[Signal] = ... # stateChanged(QScroller::State)

    class Input(enum.Enum):

        InputPress                = ...  # 0x1
        InputMove                 = ...  # 0x2
        InputRelease              = ...  # 0x3

    class ScrollerGestureType(enum.Enum):

        TouchGesture              = ...  # 0x0
        LeftMouseButtonGesture    = ...  # 0x1
        RightMouseButtonGesture   = ...  # 0x2
        MiddleMouseButtonGesture  = ...  # 0x3

    class State(enum.Enum):

        Inactive                  = ...  # 0x0
        Pressed                   = ...  # 0x1
        Dragging                  = ...  # 0x2
        Scrolling                 = ...  # 0x3


    @staticmethod
    def activeScrollers() -> typing.List[PySide6.QtWidgets.QScroller]: ...
    @typing.overload
    def ensureVisible(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, xmargin: float, ymargin: float, /) -> None: ...
    @typing.overload
    def ensureVisible(self, rect: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, xmargin: float, ymargin: float, scrollTime: int, /) -> None: ...
    def finalPosition(self, /) -> PySide6.QtCore.QPointF: ...
    @staticmethod
    def grabGesture(target: PySide6.QtCore.QObject, /, gestureType: PySide6.QtWidgets.QScroller.ScrollerGestureType = ...) -> PySide6.QtCore.Qt.GestureType: ...
    @staticmethod
    def grabbedGesture(target: PySide6.QtCore.QObject, /) -> PySide6.QtCore.Qt.GestureType: ...
    def handleInput(self, input: PySide6.QtWidgets.QScroller.Input, position: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /, timestamp: int | None = ...) -> bool: ...
    @staticmethod
    def hasScroller(target: PySide6.QtCore.QObject, /) -> bool: ...
    def pixelPerMeter(self, /) -> PySide6.QtCore.QPointF: ...
    def resendPrepareEvent(self, /) -> None: ...
    @typing.overload
    def scrollTo(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    @typing.overload
    def scrollTo(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, scrollTime: int, /) -> None: ...
    @staticmethod
    def scroller(target: PySide6.QtCore.QObject, /) -> PySide6.QtWidgets.QScroller: ...
    def scrollerProperties(self, /) -> PySide6.QtWidgets.QScrollerProperties: ...
    def setScrollerProperties(self, prop: PySide6.QtWidgets.QScrollerProperties, /) -> None: ...
    @typing.overload
    def setSnapPositionsX(self, positions: collections.abc.Sequence[float], /) -> None: ...
    @typing.overload
    def setSnapPositionsX(self, first: float, interval: float, /) -> None: ...
    @typing.overload
    def setSnapPositionsY(self, positions: collections.abc.Sequence[float], /) -> None: ...
    @typing.overload
    def setSnapPositionsY(self, first: float, interval: float, /) -> None: ...
    def state(self, /) -> PySide6.QtWidgets.QScroller.State: ...
    def stop(self, /) -> None: ...
    def target(self, /) -> PySide6.QtCore.QObject: ...
    @staticmethod
    def ungrabGesture(target: PySide6.QtCore.QObject, /) -> None: ...
    def velocity(self, /) -> PySide6.QtCore.QPointF: ...


class QScrollerProperties(Shiboken.Object):

    class FrameRates(enum.Enum):

        Standard                  = ...  # 0x0
        Fps60                     = ...  # 0x1
        Fps30                     = ...  # 0x2
        Fps20                     = ...  # 0x3

    class OvershootPolicy(enum.Enum):

        OvershootWhenScrollable   = ...  # 0x0
        OvershootAlwaysOff        = ...  # 0x1
        OvershootAlwaysOn         = ...  # 0x2

    class ScrollMetric(enum.Enum):

        MousePressEventDelay      = ...  # 0x0
        DragStartDistance         = ...  # 0x1
        DragVelocitySmoothingFactor = ...  # 0x2
        AxisLockThreshold         = ...  # 0x3
        ScrollingCurve            = ...  # 0x4
        DecelerationFactor        = ...  # 0x5
        MinimumVelocity           = ...  # 0x6
        MaximumVelocity           = ...  # 0x7
        MaximumClickThroughVelocity = ...  # 0x8
        AcceleratingFlickMaximumTime = ...  # 0x9
        AcceleratingFlickSpeedupFactor = ...  # 0xa
        SnapPositionRatio         = ...  # 0xb
        SnapTime                  = ...  # 0xc
        OvershootDragResistanceFactor = ...  # 0xd
        OvershootDragDistanceFactor = ...  # 0xe
        OvershootScrollDistanceFactor = ...  # 0xf
        OvershootScrollTime       = ...  # 0x10
        HorizontalOvershootPolicy = ...  # 0x11
        VerticalOvershootPolicy   = ...  # 0x12
        FrameRate                 = ...  # 0x13
        ScrollMetricCount         = ...  # 0x14


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, sp: PySide6.QtWidgets.QScrollerProperties, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, sp: PySide6.QtWidgets.QScrollerProperties, /) -> bool: ...
    def __ne__(self, sp: PySide6.QtWidgets.QScrollerProperties, /) -> bool: ...
    def scrollMetric(self, metric: PySide6.QtWidgets.QScrollerProperties.ScrollMetric, /) -> typing.Any: ...
    @staticmethod
    def setDefaultScrollerProperties(sp: PySide6.QtWidgets.QScrollerProperties, /) -> None: ...
    def setScrollMetric(self, metric: PySide6.QtWidgets.QScrollerProperties.ScrollMetric, value: typing.Any, /) -> None: ...
    @staticmethod
    def unsetDefaultScrollerProperties() -> None: ...


class QSizeGrip(PySide6.QtWidgets.QWidget):

    def __init__(self, parent: PySide6.QtWidgets.QWidget, /) -> None: ...

    def event(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    def eventFilter(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent, /) -> bool: ...
    def hideEvent(self, hideEvent: PySide6.QtGui.QHideEvent, /) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, mouseEvent: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def moveEvent(self, moveEvent: PySide6.QtGui.QMoveEvent, /) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def setVisible(self, arg__1: bool, /) -> None: ...
    def showEvent(self, showEvent: PySide6.QtGui.QShowEvent, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...


class QSizePolicy(Shiboken.Object):

    class ControlType(enum.Flag):

        DefaultType               = ...  # 0x1
        ButtonBox                 = ...  # 0x2
        CheckBox                  = ...  # 0x4
        ComboBox                  = ...  # 0x8
        Frame                     = ...  # 0x10
        GroupBox                  = ...  # 0x20
        Label                     = ...  # 0x40
        Line                      = ...  # 0x80
        LineEdit                  = ...  # 0x100
        PushButton                = ...  # 0x200
        RadioButton               = ...  # 0x400
        Slider                    = ...  # 0x800
        SpinBox                   = ...  # 0x1000
        TabWidget                 = ...  # 0x2000
        ToolButton                = ...  # 0x4000

    class Policy(enum.Enum):

        Fixed                     = ...  # 0x0
        Minimum                   = ...  # 0x1
        MinimumExpanding          = ...  # 0x3
        Maximum                   = ...  # 0x4
        Preferred                 = ...  # 0x5
        Expanding                 = ...  # 0x7
        Ignored                   = ...  # 0xd

    class PolicyFlag(enum.IntFlag):

        GrowFlag                  = ...  # 0x1
        ExpandFlag                = ...  # 0x2
        ShrinkFlag                = ...  # 0x4
        IgnoreFlag                = ...  # 0x8


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, horizontal: PySide6.QtWidgets.QSizePolicy.Policy, vertical: PySide6.QtWidgets.QSizePolicy.Policy, /, type: PySide6.QtWidgets.QSizePolicy.ControlType = ...) -> None: ...
    @typing.overload
    def __init__(self, QSizePolicy: PySide6.QtWidgets.QSizePolicy, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, s: PySide6.QtWidgets.QSizePolicy, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream, /) -> PySide6.QtCore.QDataStream: ...
    def __ne__(self, s: PySide6.QtWidgets.QSizePolicy, /) -> bool: ...
    def __repr__(self, /) -> str: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream, /) -> PySide6.QtCore.QDataStream: ...
    def controlType(self, /) -> PySide6.QtWidgets.QSizePolicy.ControlType: ...
    def expandingDirections(self, /) -> PySide6.QtCore.Qt.Orientation: ...
    def hasHeightForWidth(self, /) -> bool: ...
    def hasWidthForHeight(self, /) -> bool: ...
    def horizontalPolicy(self, /) -> PySide6.QtWidgets.QSizePolicy.Policy: ...
    def horizontalStretch(self, /) -> int: ...
    def retainSizeWhenHidden(self, /) -> bool: ...
    def setControlType(self, type: PySide6.QtWidgets.QSizePolicy.ControlType, /) -> None: ...
    def setHeightForWidth(self, b: bool, /) -> None: ...
    def setHorizontalPolicy(self, d: PySide6.QtWidgets.QSizePolicy.Policy, /) -> None: ...
    def setHorizontalStretch(self, stretchFactor: int, /) -> None: ...
    def setRetainSizeWhenHidden(self, retainSize: bool, /) -> None: ...
    def setVerticalPolicy(self, d: PySide6.QtWidgets.QSizePolicy.Policy, /) -> None: ...
    def setVerticalStretch(self, stretchFactor: int, /) -> None: ...
    def setWidthForHeight(self, b: bool, /) -> None: ...
    def transpose(self, /) -> None: ...
    def transposed(self, /) -> PySide6.QtWidgets.QSizePolicy: ...
    def verticalPolicy(self, /) -> PySide6.QtWidgets.QSizePolicy.Policy: ...
    def verticalStretch(self, /) -> int: ...


class QSlider(PySide6.QtWidgets.QAbstractSlider):

    class TickPosition(enum.Enum):

        NoTicks                   = ...  # 0x0
        TicksAbove                = ...  # 0x1
        TicksLeft                 = ...  # 0x1
        TicksBelow                = ...  # 0x2
        TicksRight                = ...  # 0x2
        TicksBothSides            = ...  # 0x3


    @typing.overload
    def __init__(self, orientation: PySide6.QtCore.Qt.Orientation, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, tickPosition: PySide6.QtWidgets.QSlider.TickPosition | None = ..., tickInterval: int | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, tickPosition: PySide6.QtWidgets.QSlider.TickPosition | None = ..., tickInterval: int | None = ...) -> None: ...

    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionSlider, /) -> None: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def mouseMoveEvent(self, ev: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, ev: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, ev: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def paintEvent(self, ev: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def setTickInterval(self, ti: int, /) -> None: ...
    def setTickPosition(self, position: PySide6.QtWidgets.QSlider.TickPosition, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def tickInterval(self, /) -> int: ...
    def tickPosition(self, /) -> PySide6.QtWidgets.QSlider.TickPosition: ...


class QSpacerItem(PySide6.QtWidgets.QLayoutItem):

    def __init__(self, w: int, h: int, /, hData: PySide6.QtWidgets.QSizePolicy.Policy = ..., vData: PySide6.QtWidgets.QSizePolicy.Policy = ...) -> None: ...

    def changeSize(self, w: int, h: int, /, hData: PySide6.QtWidgets.QSizePolicy.Policy = ..., vData: PySide6.QtWidgets.QSizePolicy.Policy = ...) -> None: ...
    def expandingDirections(self, /) -> PySide6.QtCore.Qt.Orientation: ...
    def geometry(self, /) -> PySide6.QtCore.QRect: ...
    def isEmpty(self, /) -> bool: ...
    def maximumSize(self, /) -> PySide6.QtCore.QSize: ...
    def minimumSize(self, /) -> PySide6.QtCore.QSize: ...
    def setGeometry(self, arg__1: PySide6.QtCore.QRect, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def sizePolicy(self, /) -> PySide6.QtWidgets.QSizePolicy: ...
    def spacerItem(self, /) -> PySide6.QtWidgets.QSpacerItem: ...


class QSpinBox(PySide6.QtWidgets.QAbstractSpinBox):

    textChanged              : typing.ClassVar[Signal] = ... # textChanged(QString)
    valueChanged             : typing.ClassVar[Signal] = ... # valueChanged(int)

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, suffix: str | None = ..., prefix: str | None = ..., cleanText: str | None = ..., minimum: int | None = ..., maximum: int | None = ..., singleStep: int | None = ..., stepType: PySide6.QtWidgets.QAbstractSpinBox.StepType | None = ..., value: int | None = ..., displayIntegerBase: int | None = ...) -> None: ...

    def cleanText(self, /) -> str: ...
    def displayIntegerBase(self, /) -> int: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def fixup(self, str: str, /) -> str: ...
    def maximum(self, /) -> int: ...
    def minimum(self, /) -> int: ...
    def prefix(self, /) -> str: ...
    def setDisplayIntegerBase(self, base: int, /) -> None: ...
    def setMaximum(self, max: int, /) -> None: ...
    def setMinimum(self, min: int, /) -> None: ...
    def setPrefix(self, prefix: str, /) -> None: ...
    def setRange(self, min: int, max: int, /) -> None: ...
    def setSingleStep(self, val: int, /) -> None: ...
    def setStepType(self, stepType: PySide6.QtWidgets.QAbstractSpinBox.StepType, /) -> None: ...
    def setSuffix(self, suffix: str, /) -> None: ...
    def setValue(self, val: int, /) -> None: ...
    def singleStep(self, /) -> int: ...
    def stepType(self, /) -> PySide6.QtWidgets.QAbstractSpinBox.StepType: ...
    def suffix(self, /) -> str: ...
    def textFromValue(self, val: int, /) -> str: ...
    def validate(self, input: str, pos: int, /) -> object: ...
    def value(self, /) -> int: ...
    def valueFromText(self, text: str, /) -> int: ...


class QSplashScreen(PySide6.QtWidgets.QWidget):

    messageChanged           : typing.ClassVar[Signal] = ... # messageChanged(QString)

    @typing.overload
    def __init__(self, screen: PySide6.QtGui.QScreen, /, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage = ..., f: PySide6.QtCore.Qt.WindowType = ...) -> None: ...
    @typing.overload
    def __init__(self, /, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage = ..., f: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    def clearMessage(self, /) -> None: ...
    def drawContents(self, painter: PySide6.QtGui.QPainter, /) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def finish(self, w: PySide6.QtWidgets.QWidget, /) -> None: ...
    def message(self, /) -> str: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def pixmap(self, /) -> PySide6.QtGui.QPixmap: ...
    def setPixmap(self, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, /) -> None: ...
    def showMessage(self, message: str, /, alignment: int = ..., color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int = ...) -> None: ...


class QSplitter(PySide6.QtWidgets.QFrame):

    splitterMoved            : typing.ClassVar[Signal] = ... # splitterMoved(int,int)

    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.Qt.Orientation, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, orientation: PySide6.QtCore.Qt.Orientation | None = ..., opaqueResize: bool | None = ..., handleWidth: int | None = ..., childrenCollapsible: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, orientation: PySide6.QtCore.Qt.Orientation | None = ..., opaqueResize: bool | None = ..., handleWidth: int | None = ..., childrenCollapsible: bool | None = ...) -> None: ...

    def addWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def changeEvent(self, arg__1: PySide6.QtCore.QEvent, /) -> None: ...
    def childEvent(self, arg__1: PySide6.QtCore.QChildEvent, /) -> None: ...
    def childrenCollapsible(self, /) -> bool: ...
    def closestLegalPosition(self, arg__1: int, arg__2: int, /) -> int: ...
    def count(self, /) -> int: ...
    def createHandle(self, /) -> PySide6.QtWidgets.QSplitterHandle: ...
    def event(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    def getRange(self, index: int, /) -> object: ...
    def handle(self, index: int, /) -> PySide6.QtWidgets.QSplitterHandle: ...
    def handleWidth(self, /) -> int: ...
    def indexOf(self, w: PySide6.QtWidgets.QWidget, /) -> int: ...
    def insertWidget(self, index: int, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def isCollapsible(self, index: int, /) -> bool: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def moveSplitter(self, pos: int, index: int, /) -> None: ...
    def opaqueResize(self, /) -> bool: ...
    def orientation(self, /) -> PySide6.QtCore.Qt.Orientation: ...
    def refresh(self, /) -> None: ...
    def replaceWidget(self, index: int, widget: PySide6.QtWidgets.QWidget, /) -> PySide6.QtWidgets.QWidget: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def restoreState(self, state: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bool: ...
    def saveState(self, /) -> PySide6.QtCore.QByteArray: ...
    def setChildrenCollapsible(self, arg__1: bool, /) -> None: ...
    def setCollapsible(self, index: int, arg__2: bool, /) -> None: ...
    def setHandleWidth(self, arg__1: int, /) -> None: ...
    def setOpaqueResize(self, /, opaque: bool = ...) -> None: ...
    def setOrientation(self, arg__1: PySide6.QtCore.Qt.Orientation, /) -> None: ...
    def setRubberBand(self, position: int, /) -> None: ...
    def setSizes(self, list: collections.abc.Sequence[int], /) -> None: ...
    def setStretchFactor(self, index: int, stretch: int, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def sizes(self, /) -> typing.List[int]: ...
    def widget(self, index: int, /) -> PySide6.QtWidgets.QWidget: ...


class QSplitterHandle(PySide6.QtWidgets.QWidget):

    def __init__(self, o: PySide6.QtCore.Qt.Orientation, parent: PySide6.QtWidgets.QSplitter, /) -> None: ...

    def closestLegalPosition(self, p: int, /) -> int: ...
    def event(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def moveSplitter(self, p: int, /) -> None: ...
    def opaqueResize(self, /) -> bool: ...
    def orientation(self, /) -> PySide6.QtCore.Qt.Orientation: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def setOrientation(self, o: PySide6.QtCore.Qt.Orientation, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def splitter(self, /) -> PySide6.QtWidgets.QSplitter: ...


class QStackedLayout(PySide6.QtWidgets.QLayout):

    currentChanged           : typing.ClassVar[Signal] = ... # currentChanged(int)
    widgetAdded              : typing.ClassVar[Signal] = ... # widgetAdded(int)
    widgetRemoved            : typing.ClassVar[Signal] = ... # widgetRemoved(int)

    class StackingMode(enum.Enum):

        StackOne                  = ...  # 0x0
        StackAll                  = ...  # 0x1


    @typing.overload
    def __init__(self, parentLayout: PySide6.QtWidgets.QLayout, /, *, currentIndex: int | None = ..., stackingMode: PySide6.QtWidgets.QStackedLayout.StackingMode | None = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtWidgets.QWidget, /, *, currentIndex: int | None = ..., stackingMode: PySide6.QtWidgets.QStackedLayout.StackingMode | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, *, currentIndex: int | None = ..., stackingMode: PySide6.QtWidgets.QStackedLayout.StackingMode | None = ...) -> None: ...

    def addItem(self, item: PySide6.QtWidgets.QLayoutItem, /) -> None: ...
    def addWidget(self, w: PySide6.QtWidgets.QWidget, /) -> int: ...
    def count(self, /) -> int: ...
    def currentIndex(self, /) -> int: ...
    def currentWidget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def hasHeightForWidth(self, /) -> bool: ...
    def heightForWidth(self, width: int, /) -> int: ...
    def insertWidget(self, index: int, w: PySide6.QtWidgets.QWidget, /) -> int: ...
    def itemAt(self, arg__1: int, /) -> PySide6.QtWidgets.QLayoutItem: ...
    def minimumSize(self, /) -> PySide6.QtCore.QSize: ...
    def setCurrentIndex(self, index: int, /) -> None: ...
    def setCurrentWidget(self, w: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setGeometry(self, rect: PySide6.QtCore.QRect, /) -> None: ...
    def setStackingMode(self, stackingMode: PySide6.QtWidgets.QStackedLayout.StackingMode, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def stackingMode(self, /) -> PySide6.QtWidgets.QStackedLayout.StackingMode: ...
    def takeAt(self, arg__1: int, /) -> PySide6.QtWidgets.QLayoutItem: ...
    @typing.overload
    def widget(self, /) -> PySide6.QtWidgets.QWidget: ...
    @typing.overload
    def widget(self, arg__1: int, /) -> PySide6.QtWidgets.QWidget: ...


class QStackedWidget(PySide6.QtWidgets.QFrame):

    currentChanged           : typing.ClassVar[Signal] = ... # currentChanged(int)
    widgetAdded              : typing.ClassVar[Signal] = ... # widgetAdded(int)
    widgetRemoved            : typing.ClassVar[Signal] = ... # widgetRemoved(int)

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, currentIndex: int | None = ..., count: int | None = ...) -> None: ...

    def addWidget(self, w: PySide6.QtWidgets.QWidget, /) -> int: ...
    def count(self, /) -> int: ...
    def currentIndex(self, /) -> int: ...
    def currentWidget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def indexOf(self, arg__1: PySide6.QtWidgets.QWidget, /) -> int: ...
    def insertWidget(self, index: int, w: PySide6.QtWidgets.QWidget, /) -> int: ...
    def removeWidget(self, w: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setCurrentIndex(self, index: int, /) -> None: ...
    def setCurrentWidget(self, w: PySide6.QtWidgets.QWidget, /) -> None: ...
    def widget(self, arg__1: int, /) -> PySide6.QtWidgets.QWidget: ...


class QStatusBar(PySide6.QtWidgets.QWidget):

    messageChanged           : typing.ClassVar[Signal] = ... # messageChanged(QString)

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, sizeGripEnabled: bool | None = ...) -> None: ...

    def addPermanentWidget(self, widget: PySide6.QtWidgets.QWidget, /, stretch: int | None = ...) -> None: ...
    def addWidget(self, widget: PySide6.QtWidgets.QWidget, /, stretch: int | None = ...) -> None: ...
    def clearMessage(self, /) -> None: ...
    def currentMessage(self, /) -> str: ...
    def event(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    def hideOrShow(self, /) -> None: ...
    def insertPermanentWidget(self, index: int, widget: PySide6.QtWidgets.QWidget, /, stretch: int | None = ...) -> int: ...
    def insertWidget(self, index: int, widget: PySide6.QtWidgets.QWidget, /, stretch: int | None = ...) -> int: ...
    def isSizeGripEnabled(self, /) -> bool: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def reformat(self, /) -> None: ...
    def removeWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def setSizeGripEnabled(self, arg__1: bool, /) -> None: ...
    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent, /) -> None: ...
    def showMessage(self, text: str, /, timeout: int | None = ...) -> None: ...


class QStyle(PySide6.QtCore.QObject):

    class ComplexControl(enum.IntEnum):

        CC_CustomBase             = ...  # -268435456
        CC_SpinBox                = ...  # 0x0
        CC_ComboBox               = ...  # 0x1
        CC_ScrollBar              = ...  # 0x2
        CC_Slider                 = ...  # 0x3
        CC_ToolButton             = ...  # 0x4
        CC_TitleBar               = ...  # 0x5
        CC_Dial                   = ...  # 0x6
        CC_GroupBox               = ...  # 0x7
        CC_MdiControls            = ...  # 0x8

    class ContentsType(enum.IntEnum):

        CT_CustomBase             = ...  # -268435456
        CT_PushButton             = ...  # 0x0
        CT_CheckBox               = ...  # 0x1
        CT_RadioButton            = ...  # 0x2
        CT_ToolButton             = ...  # 0x3
        CT_ComboBox               = ...  # 0x4
        CT_Splitter               = ...  # 0x5
        CT_ProgressBar            = ...  # 0x6
        CT_MenuItem               = ...  # 0x7
        CT_MenuBarItem            = ...  # 0x8
        CT_MenuBar                = ...  # 0x9
        CT_Menu                   = ...  # 0xa
        CT_TabBarTab              = ...  # 0xb
        CT_Slider                 = ...  # 0xc
        CT_ScrollBar              = ...  # 0xd
        CT_LineEdit               = ...  # 0xe
        CT_SpinBox                = ...  # 0xf
        CT_SizeGrip               = ...  # 0x10
        CT_TabWidget              = ...  # 0x11
        CT_DialogButtons          = ...  # 0x12
        CT_HeaderSection          = ...  # 0x13
        CT_GroupBox               = ...  # 0x14
        CT_MdiControls            = ...  # 0x15
        CT_ItemViewItem           = ...  # 0x16

    class ControlElement(enum.IntEnum):

        CE_CustomBase             = ...  # -268435456
        CE_PushButton             = ...  # 0x0
        CE_PushButtonBevel        = ...  # 0x1
        CE_PushButtonLabel        = ...  # 0x2
        CE_CheckBox               = ...  # 0x3
        CE_CheckBoxLabel          = ...  # 0x4
        CE_RadioButton            = ...  # 0x5
        CE_RadioButtonLabel       = ...  # 0x6
        CE_TabBarTab              = ...  # 0x7
        CE_TabBarTabShape         = ...  # 0x8
        CE_TabBarTabLabel         = ...  # 0x9
        CE_ProgressBar            = ...  # 0xa
        CE_ProgressBarGroove      = ...  # 0xb
        CE_ProgressBarContents    = ...  # 0xc
        CE_ProgressBarLabel       = ...  # 0xd
        CE_MenuItem               = ...  # 0xe
        CE_MenuScroller           = ...  # 0xf
        CE_MenuVMargin            = ...  # 0x10
        CE_MenuHMargin            = ...  # 0x11
        CE_MenuTearoff            = ...  # 0x12
        CE_MenuEmptyArea          = ...  # 0x13
        CE_MenuBarItem            = ...  # 0x14
        CE_MenuBarEmptyArea       = ...  # 0x15
        CE_ToolButtonLabel        = ...  # 0x16
        CE_Header                 = ...  # 0x17
        CE_HeaderSection          = ...  # 0x18
        CE_HeaderLabel            = ...  # 0x19
        CE_ToolBoxTab             = ...  # 0x1a
        CE_SizeGrip               = ...  # 0x1b
        CE_Splitter               = ...  # 0x1c
        CE_RubberBand             = ...  # 0x1d
        CE_DockWidgetTitle        = ...  # 0x1e
        CE_ScrollBarAddLine       = ...  # 0x1f
        CE_ScrollBarSubLine       = ...  # 0x20
        CE_ScrollBarAddPage       = ...  # 0x21
        CE_ScrollBarSubPage       = ...  # 0x22
        CE_ScrollBarSlider        = ...  # 0x23
        CE_ScrollBarFirst         = ...  # 0x24
        CE_ScrollBarLast          = ...  # 0x25
        CE_FocusFrame             = ...  # 0x26
        CE_ComboBoxLabel          = ...  # 0x27
        CE_ToolBar                = ...  # 0x28
        CE_ToolBoxTabShape        = ...  # 0x29
        CE_ToolBoxTabLabel        = ...  # 0x2a
        CE_HeaderEmptyArea        = ...  # 0x2b
        CE_ColumnViewGrip         = ...  # 0x2c
        CE_ItemViewItem           = ...  # 0x2d
        CE_ShapedFrame            = ...  # 0x2e

    class PixelMetric(enum.IntEnum):

        PM_CustomBase             = ...  # -268435456
        PM_ButtonMargin           = ...  # 0x0
        PM_ButtonDefaultIndicator = ...  # 0x1
        PM_MenuButtonIndicator    = ...  # 0x2
        PM_ButtonShiftHorizontal  = ...  # 0x3
        PM_ButtonShiftVertical    = ...  # 0x4
        PM_DefaultFrameWidth      = ...  # 0x5
        PM_SpinBoxFrameWidth      = ...  # 0x6
        PM_ComboBoxFrameWidth     = ...  # 0x7
        PM_MaximumDragDistance    = ...  # 0x8
        PM_ScrollBarExtent        = ...  # 0x9
        PM_ScrollBarSliderMin     = ...  # 0xa
        PM_SliderThickness        = ...  # 0xb
        PM_SliderControlThickness = ...  # 0xc
        PM_SliderLength           = ...  # 0xd
        PM_SliderTickmarkOffset   = ...  # 0xe
        PM_SliderSpaceAvailable   = ...  # 0xf
        PM_DockWidgetSeparatorExtent = ...  # 0x10
        PM_DockWidgetHandleExtent = ...  # 0x11
        PM_DockWidgetFrameWidth   = ...  # 0x12
        PM_TabBarTabOverlap       = ...  # 0x13
        PM_TabBarTabHSpace        = ...  # 0x14
        PM_TabBarTabVSpace        = ...  # 0x15
        PM_TabBarBaseHeight       = ...  # 0x16
        PM_TabBarBaseOverlap      = ...  # 0x17
        PM_ProgressBarChunkWidth  = ...  # 0x18
        PM_SplitterWidth          = ...  # 0x19
        PM_TitleBarHeight         = ...  # 0x1a
        PM_MenuScrollerHeight     = ...  # 0x1b
        PM_MenuHMargin            = ...  # 0x1c
        PM_MenuVMargin            = ...  # 0x1d
        PM_MenuPanelWidth         = ...  # 0x1e
        PM_MenuTearoffHeight      = ...  # 0x1f
        PM_MenuDesktopFrameWidth  = ...  # 0x20
        PM_MenuBarPanelWidth      = ...  # 0x21
        PM_MenuBarItemSpacing     = ...  # 0x22
        PM_MenuBarVMargin         = ...  # 0x23
        PM_MenuBarHMargin         = ...  # 0x24
        PM_IndicatorWidth         = ...  # 0x25
        PM_IndicatorHeight        = ...  # 0x26
        PM_ExclusiveIndicatorWidth = ...  # 0x27
        PM_ExclusiveIndicatorHeight = ...  # 0x28
        PM_DialogButtonsSeparator = ...  # 0x29
        PM_DialogButtonsButtonWidth = ...  # 0x2a
        PM_DialogButtonsButtonHeight = ...  # 0x2b
        PM_MdiSubWindowFrameWidth = ...  # 0x2c
        PM_MdiSubWindowMinimizedWidth = ...  # 0x2d
        PM_HeaderMargin           = ...  # 0x2e
        PM_HeaderMarkSize         = ...  # 0x2f
        PM_HeaderGripMargin       = ...  # 0x30
        PM_TabBarTabShiftHorizontal = ...  # 0x31
        PM_TabBarTabShiftVertical = ...  # 0x32
        PM_TabBarScrollButtonWidth = ...  # 0x33
        PM_ToolBarFrameWidth      = ...  # 0x34
        PM_ToolBarHandleExtent    = ...  # 0x35
        PM_ToolBarItemSpacing     = ...  # 0x36
        PM_ToolBarItemMargin      = ...  # 0x37
        PM_ToolBarSeparatorExtent = ...  # 0x38
        PM_ToolBarExtensionExtent = ...  # 0x39
        PM_SpinBoxSliderHeight    = ...  # 0x3a
        PM_ToolBarIconSize        = ...  # 0x3b
        PM_ListViewIconSize       = ...  # 0x3c
        PM_IconViewIconSize       = ...  # 0x3d
        PM_SmallIconSize          = ...  # 0x3e
        PM_LargeIconSize          = ...  # 0x3f
        PM_FocusFrameVMargin      = ...  # 0x40
        PM_FocusFrameHMargin      = ...  # 0x41
        PM_ToolTipLabelFrameWidth = ...  # 0x42
        PM_CheckBoxLabelSpacing   = ...  # 0x43
        PM_TabBarIconSize         = ...  # 0x44
        PM_SizeGripSize           = ...  # 0x45
        PM_DockWidgetTitleMargin  = ...  # 0x46
        PM_MessageBoxIconSize     = ...  # 0x47
        PM_ButtonIconSize         = ...  # 0x48
        PM_DockWidgetTitleBarButtonMargin = ...  # 0x49
        PM_RadioButtonLabelSpacing = ...  # 0x4a
        PM_LayoutLeftMargin       = ...  # 0x4b
        PM_LayoutTopMargin        = ...  # 0x4c
        PM_LayoutRightMargin      = ...  # 0x4d
        PM_LayoutBottomMargin     = ...  # 0x4e
        PM_LayoutHorizontalSpacing = ...  # 0x4f
        PM_LayoutVerticalSpacing  = ...  # 0x50
        PM_TabBar_ScrollButtonOverlap = ...  # 0x51
        PM_TextCursorWidth        = ...  # 0x52
        PM_TabCloseIndicatorWidth = ...  # 0x53
        PM_TabCloseIndicatorHeight = ...  # 0x54
        PM_ScrollView_ScrollBarSpacing = ...  # 0x55
        PM_ScrollView_ScrollBarOverlap = ...  # 0x56
        PM_SubMenuOverlap         = ...  # 0x57
        PM_TreeViewIndentation    = ...  # 0x58
        PM_HeaderDefaultSectionSizeHorizontal = ...  # 0x59
        PM_HeaderDefaultSectionSizeVertical = ...  # 0x5a
        PM_TitleBarButtonIconSize = ...  # 0x5b
        PM_TitleBarButtonSize     = ...  # 0x5c
        PM_LineEditIconSize       = ...  # 0x5d
        PM_LineEditIconMargin     = ...  # 0x5e

    class PrimitiveElement(enum.IntEnum):

        PE_Frame                  = ...  # 0x0
        PE_FrameDefaultButton     = ...  # 0x1
        PE_FrameDockWidget        = ...  # 0x2
        PE_FrameFocusRect         = ...  # 0x3
        PE_FrameGroupBox          = ...  # 0x4
        PE_FrameLineEdit          = ...  # 0x5
        PE_FrameMenu              = ...  # 0x6
        PE_FrameStatusBarItem     = ...  # 0x7
        PE_FrameTabWidget         = ...  # 0x8
        PE_FrameWindow            = ...  # 0x9
        PE_FrameButtonBevel       = ...  # 0xa
        PE_FrameButtonTool        = ...  # 0xb
        PE_FrameTabBarBase        = ...  # 0xc
        PE_PanelButtonCommand     = ...  # 0xd
        PE_PanelButtonBevel       = ...  # 0xe
        PE_PanelButtonTool        = ...  # 0xf
        PE_PanelMenuBar           = ...  # 0x10
        PE_PanelToolBar           = ...  # 0x11
        PE_PanelLineEdit          = ...  # 0x12
        PE_IndicatorArrowDown     = ...  # 0x13
        PE_IndicatorArrowLeft     = ...  # 0x14
        PE_IndicatorArrowRight    = ...  # 0x15
        PE_IndicatorArrowUp       = ...  # 0x16
        PE_IndicatorBranch        = ...  # 0x17
        PE_IndicatorButtonDropDown = ...  # 0x18
        PE_IndicatorItemViewItemCheck = ...  # 0x19
        PE_IndicatorCheckBox      = ...  # 0x1a
        PE_IndicatorDockWidgetResizeHandle = ...  # 0x1b
        PE_IndicatorHeaderArrow   = ...  # 0x1c
        PE_IndicatorMenuCheckMark = ...  # 0x1d
        PE_IndicatorProgressChunk = ...  # 0x1e
        PE_IndicatorRadioButton   = ...  # 0x1f
        PE_IndicatorSpinDown      = ...  # 0x20
        PE_IndicatorSpinMinus     = ...  # 0x21
        PE_IndicatorSpinPlus      = ...  # 0x22
        PE_IndicatorSpinUp        = ...  # 0x23
        PE_IndicatorToolBarHandle = ...  # 0x24
        PE_IndicatorToolBarSeparator = ...  # 0x25
        PE_PanelTipLabel          = ...  # 0x26
        PE_IndicatorTabTear       = ...  # 0x27
        PE_IndicatorTabTearLeft   = ...  # 0x27
        PE_PanelScrollAreaCorner  = ...  # 0x28
        PE_Widget                 = ...  # 0x29
        PE_IndicatorColumnViewArrow = ...  # 0x2a
        PE_IndicatorItemViewItemDrop = ...  # 0x2b
        PE_PanelItemViewItem      = ...  # 0x2c
        PE_PanelItemViewRow       = ...  # 0x2d
        PE_PanelStatusBar         = ...  # 0x2e
        PE_IndicatorTabClose      = ...  # 0x2f
        PE_PanelMenu              = ...  # 0x30
        PE_IndicatorTabTearRight  = ...  # 0x31
        PE_CustomBase             = ...  # 0xf000000

    class RequestSoftwareInputPanel(enum.Enum):

        RSIP_OnMouseClickAndAlreadyFocused = ...  # 0x0
        RSIP_OnMouseClick         = ...  # 0x1

    class StandardPixmap(enum.IntEnum):

        SP_CustomBase             = ...  # -268435456
        SP_TitleBarMenuButton     = ...  # 0x0
        SP_TitleBarMinButton      = ...  # 0x1
        SP_TitleBarMaxButton      = ...  # 0x2
        SP_TitleBarCloseButton    = ...  # 0x3
        SP_TitleBarNormalButton   = ...  # 0x4
        SP_TitleBarShadeButton    = ...  # 0x5
        SP_TitleBarUnshadeButton  = ...  # 0x6
        SP_TitleBarContextHelpButton = ...  # 0x7
        SP_DockWidgetCloseButton  = ...  # 0x8
        SP_MessageBoxInformation  = ...  # 0x9
        SP_MessageBoxWarning      = ...  # 0xa
        SP_MessageBoxCritical     = ...  # 0xb
        SP_MessageBoxQuestion     = ...  # 0xc
        SP_DesktopIcon            = ...  # 0xd
        SP_TrashIcon              = ...  # 0xe
        SP_ComputerIcon           = ...  # 0xf
        SP_DriveFDIcon            = ...  # 0x10
        SP_DriveHDIcon            = ...  # 0x11
        SP_DriveCDIcon            = ...  # 0x12
        SP_DriveDVDIcon           = ...  # 0x13
        SP_DriveNetIcon           = ...  # 0x14
        SP_DirOpenIcon            = ...  # 0x15
        SP_DirClosedIcon          = ...  # 0x16
        SP_DirLinkIcon            = ...  # 0x17
        SP_DirLinkOpenIcon        = ...  # 0x18
        SP_FileIcon               = ...  # 0x19
        SP_FileLinkIcon           = ...  # 0x1a
        SP_ToolBarHorizontalExtensionButton = ...  # 0x1b
        SP_ToolBarVerticalExtensionButton = ...  # 0x1c
        SP_FileDialogStart        = ...  # 0x1d
        SP_FileDialogEnd          = ...  # 0x1e
        SP_FileDialogToParent     = ...  # 0x1f
        SP_FileDialogNewFolder    = ...  # 0x20
        SP_FileDialogDetailedView = ...  # 0x21
        SP_FileDialogInfoView     = ...  # 0x22
        SP_FileDialogContentsView = ...  # 0x23
        SP_FileDialogListView     = ...  # 0x24
        SP_FileDialogBack         = ...  # 0x25
        SP_DirIcon                = ...  # 0x26
        SP_DialogOkButton         = ...  # 0x27
        SP_DialogCancelButton     = ...  # 0x28
        SP_DialogHelpButton       = ...  # 0x29
        SP_DialogOpenButton       = ...  # 0x2a
        SP_DialogSaveButton       = ...  # 0x2b
        SP_DialogCloseButton      = ...  # 0x2c
        SP_DialogApplyButton      = ...  # 0x2d
        SP_DialogResetButton      = ...  # 0x2e
        SP_DialogDiscardButton    = ...  # 0x2f
        SP_DialogYesButton        = ...  # 0x30
        SP_DialogNoButton         = ...  # 0x31
        SP_ArrowUp                = ...  # 0x32
        SP_ArrowDown              = ...  # 0x33
        SP_ArrowLeft              = ...  # 0x34
        SP_ArrowRight             = ...  # 0x35
        SP_ArrowBack              = ...  # 0x36
        SP_ArrowForward           = ...  # 0x37
        SP_DirHomeIcon            = ...  # 0x38
        SP_CommandLink            = ...  # 0x39
        SP_VistaShield            = ...  # 0x3a
        SP_BrowserReload          = ...  # 0x3b
        SP_BrowserStop            = ...  # 0x3c
        SP_MediaPlay              = ...  # 0x3d
        SP_MediaStop              = ...  # 0x3e
        SP_MediaPause             = ...  # 0x3f
        SP_MediaSkipForward       = ...  # 0x40
        SP_MediaSkipBackward      = ...  # 0x41
        SP_MediaSeekForward       = ...  # 0x42
        SP_MediaSeekBackward      = ...  # 0x43
        SP_MediaVolume            = ...  # 0x44
        SP_MediaVolumeMuted       = ...  # 0x45
        SP_LineEditClearButton    = ...  # 0x46
        SP_DialogYesToAllButton   = ...  # 0x47
        SP_DialogNoToAllButton    = ...  # 0x48
        SP_DialogSaveAllButton    = ...  # 0x49
        SP_DialogAbortButton      = ...  # 0x4a
        SP_DialogRetryButton      = ...  # 0x4b
        SP_DialogIgnoreButton     = ...  # 0x4c
        SP_RestoreDefaultsButton  = ...  # 0x4d
        SP_TabCloseButton         = ...  # 0x4e
        NStandardPixmap           = ...  # 0x4f

    class StateFlag(enum.Flag):

        State_None                = ...  # 0x0
        State_Enabled             = ...  # 0x1
        State_Raised              = ...  # 0x2
        State_Sunken              = ...  # 0x4
        State_Off                 = ...  # 0x8
        State_NoChange            = ...  # 0x10
        State_On                  = ...  # 0x20
        State_DownArrow           = ...  # 0x40
        State_Horizontal          = ...  # 0x80
        State_HasFocus            = ...  # 0x100
        State_Top                 = ...  # 0x200
        State_Bottom              = ...  # 0x400
        State_FocusAtBorder       = ...  # 0x800
        State_AutoRaise           = ...  # 0x1000
        State_MouseOver           = ...  # 0x2000
        State_UpArrow             = ...  # 0x4000
        State_Selected            = ...  # 0x8000
        State_Active              = ...  # 0x10000
        State_Window              = ...  # 0x20000
        State_Open                = ...  # 0x40000
        State_Children            = ...  # 0x80000
        State_Item                = ...  # 0x100000
        State_Sibling             = ...  # 0x200000
        State_Editing             = ...  # 0x400000
        State_KeyboardFocusChange = ...  # 0x800000
        State_ReadOnly            = ...  # 0x2000000
        State_Small               = ...  # 0x4000000
        State_Mini                = ...  # 0x8000000

    class StyleHint(enum.IntEnum):

        SH_CustomBase             = ...  # -268435456
        SH_EtchDisabledText       = ...  # 0x0
        SH_DitherDisabledText     = ...  # 0x1
        SH_ScrollBar_MiddleClickAbsolutePosition = ...  # 0x2
        SH_ScrollBar_ScrollWhenPointerLeavesControl = ...  # 0x3
        SH_TabBar_SelectMouseType = ...  # 0x4
        SH_TabBar_Alignment       = ...  # 0x5
        SH_Header_ArrowAlignment  = ...  # 0x6
        SH_Slider_SnapToValue     = ...  # 0x7
        SH_Slider_SloppyKeyEvents = ...  # 0x8
        SH_ProgressDialog_CenterCancelButton = ...  # 0x9
        SH_ProgressDialog_TextLabelAlignment = ...  # 0xa
        SH_PrintDialog_RightAlignButtons = ...  # 0xb
        SH_MainWindow_SpaceBelowMenuBar = ...  # 0xc
        SH_FontDialog_SelectAssociatedText = ...  # 0xd
        SH_Menu_AllowActiveAndDisabled = ...  # 0xe
        SH_Menu_SpaceActivatesItem = ...  # 0xf
        SH_Menu_SubMenuPopupDelay = ...  # 0x10
        SH_ScrollView_FrameOnlyAroundContents = ...  # 0x11
        SH_MenuBar_AltKeyNavigation = ...  # 0x12
        SH_ComboBox_ListMouseTracking = ...  # 0x13
        SH_Menu_MouseTracking     = ...  # 0x14
        SH_MenuBar_MouseTracking  = ...  # 0x15
        SH_ItemView_ChangeHighlightOnFocus = ...  # 0x16
        SH_Widget_ShareActivation = ...  # 0x17
        SH_Workspace_FillSpaceOnMaximize = ...  # 0x18
        SH_ComboBox_Popup         = ...  # 0x19
        SH_TitleBar_NoBorder      = ...  # 0x1a
        SH_Slider_StopMouseOverSlider = ...  # 0x1b
        SH_BlinkCursorWhenTextSelected = ...  # 0x1c
        SH_RichText_FullWidthSelection = ...  # 0x1d
        SH_Menu_Scrollable        = ...  # 0x1e
        SH_GroupBox_TextLabelVerticalAlignment = ...  # 0x1f
        SH_GroupBox_TextLabelColor = ...  # 0x20
        SH_Menu_SloppySubMenus    = ...  # 0x21
        SH_Table_GridLineColor    = ...  # 0x22
        SH_LineEdit_PasswordCharacter = ...  # 0x23
        SH_DialogButtons_DefaultButton = ...  # 0x24
        SH_ToolBox_SelectedPageTitleBold = ...  # 0x25
        SH_TabBar_PreferNoArrows  = ...  # 0x26
        SH_ScrollBar_LeftClickAbsolutePosition = ...  # 0x27
        SH_ListViewExpand_SelectMouseType = ...  # 0x28
        SH_UnderlineShortcut      = ...  # 0x29
        SH_SpinBox_AnimateButton  = ...  # 0x2a
        SH_SpinBox_KeyPressAutoRepeatRate = ...  # 0x2b
        SH_SpinBox_ClickAutoRepeatRate = ...  # 0x2c
        SH_Menu_FillScreenWithScroll = ...  # 0x2d
        SH_ToolTipLabel_Opacity   = ...  # 0x2e
        SH_DrawMenuBarSeparator   = ...  # 0x2f
        SH_TitleBar_ModifyNotification = ...  # 0x30
        SH_Button_FocusPolicy     = ...  # 0x31
        SH_MessageBox_UseBorderForButtonSpacing = ...  # 0x32
        SH_TitleBar_AutoRaise     = ...  # 0x33
        SH_ToolButton_PopupDelay  = ...  # 0x34
        SH_FocusFrame_Mask        = ...  # 0x35
        SH_RubberBand_Mask        = ...  # 0x36
        SH_WindowFrame_Mask       = ...  # 0x37
        SH_SpinControls_DisableOnBounds = ...  # 0x38
        SH_Dial_BackgroundRole    = ...  # 0x39
        SH_ComboBox_LayoutDirection = ...  # 0x3a
        SH_ItemView_EllipsisLocation = ...  # 0x3b
        SH_ItemView_ShowDecorationSelected = ...  # 0x3c
        SH_ItemView_ActivateItemOnSingleClick = ...  # 0x3d
        SH_ScrollBar_ContextMenu  = ...  # 0x3e
        SH_ScrollBar_RollBetweenButtons = ...  # 0x3f
        SH_Slider_AbsoluteSetButtons = ...  # 0x40
        SH_Slider_PageSetButtons  = ...  # 0x41
        SH_Menu_KeyboardSearch    = ...  # 0x42
        SH_TabBar_ElideMode       = ...  # 0x43
        SH_DialogButtonLayout     = ...  # 0x44
        SH_ComboBox_PopupFrameStyle = ...  # 0x45
        SH_MessageBox_TextInteractionFlags = ...  # 0x46
        SH_DialogButtonBox_ButtonsHaveIcons = ...  # 0x47
        SH_MessageBox_CenterButtons = ...  # 0x48
        SH_Menu_SelectionWrap     = ...  # 0x49
        SH_ItemView_MovementWithoutUpdatingSelection = ...  # 0x4a
        SH_ToolTip_Mask           = ...  # 0x4b
        SH_FocusFrame_AboveWidget = ...  # 0x4c
        SH_TextControl_FocusIndicatorTextCharFormat = ...  # 0x4d
        SH_WizardStyle            = ...  # 0x4e
        SH_ItemView_ArrowKeysNavigateIntoChildren = ...  # 0x4f
        SH_Menu_Mask              = ...  # 0x50
        SH_Menu_FlashTriggeredItem = ...  # 0x51
        SH_Menu_FadeOutOnHide     = ...  # 0x52
        SH_SpinBox_ClickAutoRepeatThreshold = ...  # 0x53
        SH_ItemView_PaintAlternatingRowColorsForEmptyArea = ...  # 0x54
        SH_FormLayoutWrapPolicy   = ...  # 0x55
        SH_TabWidget_DefaultTabPosition = ...  # 0x56
        SH_ToolBar_Movable        = ...  # 0x57
        SH_FormLayoutFieldGrowthPolicy = ...  # 0x58
        SH_FormLayoutFormAlignment = ...  # 0x59
        SH_FormLayoutLabelAlignment = ...  # 0x5a
        SH_ItemView_DrawDelegateFrame = ...  # 0x5b
        SH_TabBar_CloseButtonPosition = ...  # 0x5c
        SH_DockWidget_ButtonsHaveFrame = ...  # 0x5d
        SH_ToolButtonStyle        = ...  # 0x5e
        SH_RequestSoftwareInputPanel = ...  # 0x5f
        SH_ScrollBar_Transient    = ...  # 0x60
        SH_Menu_SupportsSections  = ...  # 0x61
        SH_ToolTip_WakeUpDelay    = ...  # 0x62
        SH_ToolTip_FallAsleepDelay = ...  # 0x63
        SH_Widget_Animate         = ...  # 0x64
        SH_Splitter_OpaqueResize  = ...  # 0x65
        SH_ComboBox_UseNativePopup = ...  # 0x66
        SH_LineEdit_PasswordMaskDelay = ...  # 0x67
        SH_TabBar_ChangeCurrentDelay = ...  # 0x68
        SH_Menu_SubMenuUniDirection = ...  # 0x69
        SH_Menu_SubMenuUniDirectionFailCount = ...  # 0x6a
        SH_Menu_SubMenuSloppySelectOtherActions = ...  # 0x6b
        SH_Menu_SubMenuSloppyCloseTimeout = ...  # 0x6c
        SH_Menu_SubMenuResetWhenReenteringParent = ...  # 0x6d
        SH_Menu_SubMenuDontStartSloppyOnLeave = ...  # 0x6e
        SH_ItemView_ScrollMode    = ...  # 0x6f
        SH_TitleBar_ShowToolTipsOnButtons = ...  # 0x70
        SH_Widget_Animation_Duration = ...  # 0x71
        SH_ComboBox_AllowWheelScrolling = ...  # 0x72
        SH_SpinBox_ButtonsInsideFrame = ...  # 0x73
        SH_SpinBox_StepModifier   = ...  # 0x74
        SH_TabBar_AllowWheelScrolling = ...  # 0x75
        SH_Table_AlwaysDrawLeftTopGridLines = ...  # 0x76
        SH_SpinBox_SelectOnStep   = ...  # 0x77

    class SubControl(enum.Flag):

        SC_CustomBase             = ...  # -268435456
        SC_All                    = ...  # -1
        SC_None                   = ...  # 0x0
        SC_ComboBoxFrame          = ...  # 0x1
        SC_DialGroove             = ...  # 0x1
        SC_GroupBoxCheckBox       = ...  # 0x1
        SC_MdiMinButton           = ...  # 0x1
        SC_ScrollBarAddLine       = ...  # 0x1
        SC_SliderGroove           = ...  # 0x1
        SC_SpinBoxUp              = ...  # 0x1
        SC_TitleBarSysMenu        = ...  # 0x1
        SC_ToolButton             = ...  # 0x1
        SC_ComboBoxEditField      = ...  # 0x2
        SC_DialHandle             = ...  # 0x2
        SC_GroupBoxLabel          = ...  # 0x2
        SC_MdiNormalButton        = ...  # 0x2
        SC_ScrollBarSubLine       = ...  # 0x2
        SC_SliderHandle           = ...  # 0x2
        SC_SpinBoxDown            = ...  # 0x2
        SC_TitleBarMinButton      = ...  # 0x2
        SC_ToolButtonMenu         = ...  # 0x2
        SC_ComboBoxArrow          = ...  # 0x4
        SC_DialTickmarks          = ...  # 0x4
        SC_GroupBoxContents       = ...  # 0x4
        SC_MdiCloseButton         = ...  # 0x4
        SC_ScrollBarAddPage       = ...  # 0x4
        SC_SliderTickmarks        = ...  # 0x4
        SC_SpinBoxFrame           = ...  # 0x4
        SC_TitleBarMaxButton      = ...  # 0x4
        SC_ComboBoxListBoxPopup   = ...  # 0x8
        SC_GroupBoxFrame          = ...  # 0x8
        SC_ScrollBarSubPage       = ...  # 0x8
        SC_SpinBoxEditField       = ...  # 0x8
        SC_TitleBarCloseButton    = ...  # 0x8
        SC_ScrollBarFirst         = ...  # 0x10
        SC_TitleBarNormalButton   = ...  # 0x10
        SC_ScrollBarLast          = ...  # 0x20
        SC_TitleBarShadeButton    = ...  # 0x20
        SC_ScrollBarSlider        = ...  # 0x40
        SC_TitleBarUnshadeButton  = ...  # 0x40
        SC_ScrollBarGroove        = ...  # 0x80
        SC_TitleBarContextHelpButton = ...  # 0x80
        SC_TitleBarLabel          = ...  # 0x100

    class SubElement(enum.IntEnum):

        SE_CustomBase             = ...  # -268435456
        SE_PushButtonContents     = ...  # 0x0
        SE_PushButtonFocusRect    = ...  # 0x1
        SE_CheckBoxIndicator      = ...  # 0x2
        SE_CheckBoxContents       = ...  # 0x3
        SE_CheckBoxFocusRect      = ...  # 0x4
        SE_CheckBoxClickRect      = ...  # 0x5
        SE_RadioButtonIndicator   = ...  # 0x6
        SE_RadioButtonContents    = ...  # 0x7
        SE_RadioButtonFocusRect   = ...  # 0x8
        SE_RadioButtonClickRect   = ...  # 0x9
        SE_ComboBoxFocusRect      = ...  # 0xa
        SE_SliderFocusRect        = ...  # 0xb
        SE_ProgressBarGroove      = ...  # 0xc
        SE_ProgressBarContents    = ...  # 0xd
        SE_ProgressBarLabel       = ...  # 0xe
        SE_ToolBoxTabContents     = ...  # 0xf
        SE_HeaderLabel            = ...  # 0x10
        SE_HeaderArrow            = ...  # 0x11
        SE_TabWidgetTabBar        = ...  # 0x12
        SE_TabWidgetTabPane       = ...  # 0x13
        SE_TabWidgetTabContents   = ...  # 0x14
        SE_TabWidgetLeftCorner    = ...  # 0x15
        SE_TabWidgetRightCorner   = ...  # 0x16
        SE_ItemViewItemCheckIndicator = ...  # 0x17
        SE_TabBarTearIndicator    = ...  # 0x18
        SE_TabBarTearIndicatorLeft = ...  # 0x18
        SE_TreeViewDisclosureItem = ...  # 0x19
        SE_LineEditContents       = ...  # 0x1a
        SE_FrameContents          = ...  # 0x1b
        SE_DockWidgetCloseButton  = ...  # 0x1c
        SE_DockWidgetFloatButton  = ...  # 0x1d
        SE_DockWidgetTitleBarText = ...  # 0x1e
        SE_DockWidgetIcon         = ...  # 0x1f
        SE_CheckBoxLayoutItem     = ...  # 0x20
        SE_ComboBoxLayoutItem     = ...  # 0x21
        SE_DateTimeEditLayoutItem = ...  # 0x22
        SE_LabelLayoutItem        = ...  # 0x23
        SE_ProgressBarLayoutItem  = ...  # 0x24
        SE_PushButtonLayoutItem   = ...  # 0x25
        SE_RadioButtonLayoutItem  = ...  # 0x26
        SE_SliderLayoutItem       = ...  # 0x27
        SE_SpinBoxLayoutItem      = ...  # 0x28
        SE_ToolButtonLayoutItem   = ...  # 0x29
        SE_FrameLayoutItem        = ...  # 0x2a
        SE_GroupBoxLayoutItem     = ...  # 0x2b
        SE_TabWidgetLayoutItem    = ...  # 0x2c
        SE_ItemViewItemDecoration = ...  # 0x2d
        SE_ItemViewItemText       = ...  # 0x2e
        SE_ItemViewItemFocusRect  = ...  # 0x2f
        SE_TabBarTabLeftButton    = ...  # 0x30
        SE_TabBarTabRightButton   = ...  # 0x31
        SE_TabBarTabText          = ...  # 0x32
        SE_ShapedFrameContents    = ...  # 0x33
        SE_ToolBarHandle          = ...  # 0x34
        SE_TabBarScrollLeftButton = ...  # 0x35
        SE_TabBarScrollRightButton = ...  # 0x36
        SE_TabBarTearIndicatorRight = ...  # 0x37
        SE_PushButtonBevel        = ...  # 0x38


    def __init__(self, /) -> None: ...

    @staticmethod
    def alignedRect(direction: PySide6.QtCore.Qt.LayoutDirection, alignment: PySide6.QtCore.Qt.AlignmentFlag, size: PySide6.QtCore.QSize, rectangle: PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRect: ...
    def combinedLayoutSpacing(self, controls1: PySide6.QtWidgets.QSizePolicy.ControlType, controls2: PySide6.QtWidgets.QSizePolicy.ControlType, orientation: PySide6.QtCore.Qt.Orientation, /, option: PySide6.QtWidgets.QStyleOption | None = ..., widget: PySide6.QtWidgets.QWidget | None = ...) -> int: ...
    def drawComplexControl(self, cc: PySide6.QtWidgets.QStyle.ComplexControl, opt: PySide6.QtWidgets.QStyleOptionComplex, p: PySide6.QtGui.QPainter, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def drawControl(self, element: PySide6.QtWidgets.QStyle.ControlElement, opt: PySide6.QtWidgets.QStyleOption, p: PySide6.QtGui.QPainter, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def drawItemPixmap(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, alignment: int, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, /) -> None: ...
    def drawItemText(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, flags: int, pal: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, enabled: bool, text: str, /, textRole: PySide6.QtGui.QPalette.ColorRole = ...) -> None: ...
    def drawPrimitive(self, pe: PySide6.QtWidgets.QStyle.PrimitiveElement, opt: PySide6.QtWidgets.QStyleOption, p: PySide6.QtGui.QPainter, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    def generatedIconPixmap(self, iconMode: PySide6.QtGui.QIcon.Mode, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, opt: PySide6.QtWidgets.QStyleOption, /) -> PySide6.QtGui.QPixmap: ...
    def hitTestComplexControl(self, cc: PySide6.QtWidgets.QStyle.ComplexControl, opt: PySide6.QtWidgets.QStyleOptionComplex, pt: PySide6.QtCore.QPoint, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> PySide6.QtWidgets.QStyle.SubControl: ...
    def itemPixmapRect(self, r: PySide6.QtCore.QRect, flags: int, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, /) -> PySide6.QtCore.QRect: ...
    def itemTextRect(self, fm: PySide6.QtGui.QFontMetrics, r: PySide6.QtCore.QRect, flags: int, enabled: bool, text: str, /) -> PySide6.QtCore.QRect: ...
    def layoutSpacing(self, control1: PySide6.QtWidgets.QSizePolicy.ControlType, control2: PySide6.QtWidgets.QSizePolicy.ControlType, orientation: PySide6.QtCore.Qt.Orientation, /, option: PySide6.QtWidgets.QStyleOption | None = ..., widget: PySide6.QtWidgets.QWidget | None = ...) -> int: ...
    def name(self, /) -> str: ...
    def pixelMetric(self, metric: PySide6.QtWidgets.QStyle.PixelMetric, /, option: PySide6.QtWidgets.QStyleOption | None = ..., widget: PySide6.QtWidgets.QWidget | None = ...) -> int: ...
    @typing.overload
    def polish(self, application: PySide6.QtWidgets.QApplication, /) -> None: ...
    @typing.overload
    def polish(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    @typing.overload
    def polish(self, palette: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, /) -> None: ...
    def proxy(self, /) -> PySide6.QtWidgets.QStyle: ...
    def sizeFromContents(self, ct: PySide6.QtWidgets.QStyle.ContentsType, opt: PySide6.QtWidgets.QStyleOption, contentsSize: PySide6.QtCore.QSize, /, w: PySide6.QtWidgets.QWidget | None = ...) -> PySide6.QtCore.QSize: ...
    @staticmethod
    def sliderPositionFromValue(min: int, max: int, val: int, space: int, /, upsideDown: bool = ...) -> int: ...
    @staticmethod
    def sliderValueFromPosition(min: int, max: int, pos: int, space: int, /, upsideDown: bool = ...) -> int: ...
    def standardIcon(self, standardIcon: PySide6.QtWidgets.QStyle.StandardPixmap, /, option: PySide6.QtWidgets.QStyleOption | None = ..., widget: PySide6.QtWidgets.QWidget | None = ...) -> PySide6.QtGui.QIcon: ...
    def standardPalette(self, /) -> PySide6.QtGui.QPalette: ...
    def standardPixmap(self, standardPixmap: PySide6.QtWidgets.QStyle.StandardPixmap, /, opt: PySide6.QtWidgets.QStyleOption | None = ..., widget: PySide6.QtWidgets.QWidget | None = ...) -> PySide6.QtGui.QPixmap: ...
    def styleHint(self, stylehint: PySide6.QtWidgets.QStyle.StyleHint, /, opt: PySide6.QtWidgets.QStyleOption | None = ..., widget: PySide6.QtWidgets.QWidget | None = ..., returnData: PySide6.QtWidgets.QStyleHintReturn | None = ...) -> int: ...
    def subControlRect(self, cc: PySide6.QtWidgets.QStyle.ComplexControl, opt: PySide6.QtWidgets.QStyleOptionComplex, sc: PySide6.QtWidgets.QStyle.SubControl, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> PySide6.QtCore.QRect: ...
    def subElementRect(self, subElement: PySide6.QtWidgets.QStyle.SubElement, option: PySide6.QtWidgets.QStyleOption, /, widget: PySide6.QtWidgets.QWidget | None = ...) -> PySide6.QtCore.QRect: ...
    @typing.overload
    def unpolish(self, application: PySide6.QtWidgets.QApplication, /) -> None: ...
    @typing.overload
    def unpolish(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    @staticmethod
    def visualAlignment(direction: PySide6.QtCore.Qt.LayoutDirection, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    @staticmethod
    def visualPos(direction: PySide6.QtCore.Qt.LayoutDirection, boundingRect: PySide6.QtCore.QRect, logicalPos: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QPoint: ...
    @staticmethod
    def visualRect(direction: PySide6.QtCore.Qt.LayoutDirection, boundingRect: PySide6.QtCore.QRect, logicalRect: PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRect: ...


class QStyleFactory(Shiboken.Object):

    def __init__(self, /) -> None: ...

    @staticmethod
    def create(arg__1: str, /) -> PySide6.QtWidgets.QStyle: ...
    @staticmethod
    def keys() -> typing.List[str]: ...


class QStyleHintReturn(Shiboken.Object):

    class HintReturnType(enum.Enum):

        SH_Default                = ...  # 0xf000
        SH_Mask                   = ...  # 0xf001
        SH_Variant                = ...  # 0xf002

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0xf000

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    def __init__(self, /, version: int = ..., type: int = ...) -> None: ...


class QStyleHintReturnMask(PySide6.QtWidgets.QStyleHintReturn):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0xf001

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    def __init__(self, /) -> None: ...


class QStyleHintReturnVariant(PySide6.QtWidgets.QStyleHintReturn):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0xf002

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    def __init__(self, /) -> None: ...


class QStyleOption(Shiboken.Object):

    class OptionType(enum.Enum):

        SO_Default                = ...  # 0x0
        SO_FocusRect              = ...  # 0x1
        SO_Button                 = ...  # 0x2
        SO_Tab                    = ...  # 0x3
        SO_MenuItem               = ...  # 0x4
        SO_Frame                  = ...  # 0x5
        SO_ProgressBar            = ...  # 0x6
        SO_ToolBox                = ...  # 0x7
        SO_Header                 = ...  # 0x8
        SO_DockWidget             = ...  # 0x9
        SO_ViewItem               = ...  # 0xa
        SO_TabWidgetFrame         = ...  # 0xb
        SO_TabBarBase             = ...  # 0xc
        SO_RubberBand             = ...  # 0xd
        SO_ToolBar                = ...  # 0xe
        SO_GraphicsItem           = ...  # 0xf
        SO_CustomBase             = ...  # 0xf00
        SO_Complex                = ...  # 0xf0000
        SO_Slider                 = ...  # 0xf0001
        SO_SpinBox                = ...  # 0xf0002
        SO_ToolButton             = ...  # 0xf0003
        SO_ComboBox               = ...  # 0xf0004
        SO_TitleBar               = ...  # 0xf0005
        SO_GroupBox               = ...  # 0xf0006
        SO_SizeGrip               = ...  # 0xf0007
        SO_ComplexCustomBase      = ...  # 0xf000000

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0x0

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOption, /) -> None: ...
    @typing.overload
    def __init__(self, /, version: int = ..., type: int = ...) -> None: ...

    def __repr__(self, /) -> str: ...
    def initFrom(self, w: PySide6.QtWidgets.QWidget, /) -> None: ...


class QStyleOptionButton(PySide6.QtWidgets.QStyleOption):

    class ButtonFeature(enum.Flag):

        None_                     = ...  # 0x0
        Flat                      = ...  # 0x1
        HasMenu                   = ...  # 0x2
        DefaultButton             = ...  # 0x4
        AutoDefaultButton         = ...  # 0x8
        CommandLinkButton         = ...  # 0x10

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0x2

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionButton, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionComboBox(PySide6.QtWidgets.QStyleOptionComplex):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0xf0004

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionComboBox, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionComplex(PySide6.QtWidgets.QStyleOption):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0xf0000

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionComplex, /) -> None: ...
    @typing.overload
    def __init__(self, /, version: int = ..., type: int = ...) -> None: ...


class QStyleOptionDockWidget(PySide6.QtWidgets.QStyleOption):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0x9

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionDockWidget, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionFocusRect(PySide6.QtWidgets.QStyleOption):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0x1

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionFocusRect, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionFrame(PySide6.QtWidgets.QStyleOption):

    class FrameFeature(enum.Flag):

        None_                     = ...  # 0x0
        Flat                      = ...  # 0x1
        Rounded                   = ...  # 0x2

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0x5

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionFrame, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionGraphicsItem(PySide6.QtWidgets.QStyleOption):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0xf

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionGraphicsItem, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...

    @staticmethod
    def levelOfDetailFromTransform(worldTransform: PySide6.QtGui.QTransform, /) -> float: ...


class QStyleOptionGroupBox(PySide6.QtWidgets.QStyleOptionComplex):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0xf0006

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionGroupBox, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionHeader(PySide6.QtWidgets.QStyleOption):

    class SectionPosition(enum.Enum):

        Beginning                 = ...  # 0x0
        Middle                    = ...  # 0x1
        End                       = ...  # 0x2
        OnlyOneSection            = ...  # 0x3

    class SelectedPosition(enum.Enum):

        NotAdjacent               = ...  # 0x0
        NextIsSelected            = ...  # 0x1
        PreviousIsSelected        = ...  # 0x2
        NextAndPreviousAreSelected = ...  # 0x3

    class SortIndicator(enum.Enum):

        None_                     = ...  # 0x0
        SortUp                    = ...  # 0x1
        SortDown                  = ...  # 0x2

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0x8

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionHeader, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionHeaderV2(PySide6.QtWidgets.QStyleOptionHeader):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0x8

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x2


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionHeaderV2, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionMenuItem(PySide6.QtWidgets.QStyleOption):

    class CheckType(enum.Enum):

        NotCheckable              = ...  # 0x0
        Exclusive                 = ...  # 0x1
        NonExclusive              = ...  # 0x2

    class MenuItemType(enum.Enum):

        Normal                    = ...  # 0x0
        DefaultItem               = ...  # 0x1
        Separator                 = ...  # 0x2
        SubMenu                   = ...  # 0x3
        Scroller                  = ...  # 0x4
        TearOff                   = ...  # 0x5
        Margin                    = ...  # 0x6
        EmptyArea                 = ...  # 0x7

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0x4

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionMenuItem, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionProgressBar(PySide6.QtWidgets.QStyleOption):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0x6

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionProgressBar, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionRubberBand(PySide6.QtWidgets.QStyleOption):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0xd

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionRubberBand, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionSizeGrip(PySide6.QtWidgets.QStyleOptionComplex):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0xf0007

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionSizeGrip, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionSlider(PySide6.QtWidgets.QStyleOptionComplex):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0xf0001

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionSlider, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionSpinBox(PySide6.QtWidgets.QStyleOptionComplex):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0xf0002

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionSpinBox, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionTab(PySide6.QtWidgets.QStyleOption):

    class CornerWidget(enum.Flag):

        NoCornerWidgets           = ...  # 0x0
        LeftCornerWidget          = ...  # 0x1
        RightCornerWidget         = ...  # 0x2

    class SelectedPosition(enum.Enum):

        NotAdjacent               = ...  # 0x0
        NextIsSelected            = ...  # 0x1
        PreviousIsSelected        = ...  # 0x2

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0x3

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1

    class TabFeature(enum.Flag):

        None_                     = ...  # 0x0
        HasFrame                  = ...  # 0x1
        MinimumSizeHint           = ...  # 0x2

    class TabPosition(enum.Enum):

        Beginning                 = ...  # 0x0
        Middle                    = ...  # 0x1
        End                       = ...  # 0x2
        OnlyOneTab                = ...  # 0x3
        Moving                    = ...  # 0x4


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionTab, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionTabBarBase(PySide6.QtWidgets.QStyleOption):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0xc

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionTabBarBase, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionTabWidgetFrame(PySide6.QtWidgets.QStyleOption):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0xb

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionTabWidgetFrame, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionTitleBar(PySide6.QtWidgets.QStyleOptionComplex):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0xf0005

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionTitleBar, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionToolBar(PySide6.QtWidgets.QStyleOption):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0xe

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1

    class ToolBarFeature(enum.Flag):

        None_                     = ...  # 0x0
        Movable                   = ...  # 0x1

    class ToolBarPosition(enum.Enum):

        Beginning                 = ...  # 0x0
        Middle                    = ...  # 0x1
        End                       = ...  # 0x2
        OnlyOne                   = ...  # 0x3


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionToolBar, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionToolBox(PySide6.QtWidgets.QStyleOption):

    class SelectedPosition(enum.Enum):

        NotAdjacent               = ...  # 0x0
        NextIsSelected            = ...  # 0x1
        PreviousIsSelected        = ...  # 0x2

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0x7

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1

    class TabPosition(enum.Enum):

        Beginning                 = ...  # 0x0
        Middle                    = ...  # 0x1
        End                       = ...  # 0x2
        OnlyOneTab                = ...  # 0x3


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionToolBox, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionToolButton(PySide6.QtWidgets.QStyleOptionComplex):

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0xf0003

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1

    class ToolButtonFeature(enum.Flag):

        None_                     = ...  # 0x0
        Arrow                     = ...  # 0x1
        Menu                      = ...  # 0x4
        MenuButtonPopup           = ...  # 0x4
        PopupDelay                = ...  # 0x8
        HasMenu                   = ...  # 0x10


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionToolButton, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...


class QStyleOptionViewItem(PySide6.QtWidgets.QStyleOption):

    class Position(enum.Enum):

        Left                      = ...  # 0x0
        Right                     = ...  # 0x1
        Top                       = ...  # 0x2
        Bottom                    = ...  # 0x3

    class StyleOptionType(enum.Enum):

        Type                      = ...  # 0xa

    class StyleOptionVersion(enum.Enum):

        Version                   = ...  # 0x1

    class ViewItemFeature(enum.Flag):

        None_                     = ...  # 0x0
        WrapText                  = ...  # 0x1
        Alternate                 = ...  # 0x2
        HasCheckIndicator         = ...  # 0x4
        HasDisplay                = ...  # 0x8
        HasDecoration             = ...  # 0x10
        IsDecoratedRootColumn     = ...  # 0x20
        IsDecorationForRootColumn = ...  # 0x40

    class ViewItemPosition(enum.Enum):

        Invalid                   = ...  # 0x0
        Beginning                 = ...  # 0x1
        Middle                    = ...  # 0x2
        End                       = ...  # 0x3
        OnlyOne                   = ...  # 0x4


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionViewItem, /) -> None: ...
    @typing.overload
    def __init__(self, version: int, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...


class QStylePainter(PySide6.QtGui.QPainter):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, w: PySide6.QtWidgets.QWidget, /) -> None: ...
    @typing.overload
    def __init__(self, pd: PySide6.QtGui.QPaintDevice, w: PySide6.QtWidgets.QWidget, /) -> None: ...

    @typing.overload
    def begin(self, w: PySide6.QtWidgets.QWidget, /) -> bool: ...
    @typing.overload
    def begin(self, pd: PySide6.QtGui.QPaintDevice, w: PySide6.QtWidgets.QWidget, /) -> bool: ...
    def drawComplexControl(self, cc: PySide6.QtWidgets.QStyle.ComplexControl, opt: PySide6.QtWidgets.QStyleOptionComplex, /) -> None: ...
    def drawControl(self, ce: PySide6.QtWidgets.QStyle.ControlElement, opt: PySide6.QtWidgets.QStyleOption, /) -> None: ...
    def drawItemPixmap(self, r: PySide6.QtCore.QRect, flags: int, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, /) -> None: ...
    def drawItemText(self, r: PySide6.QtCore.QRect, flags: int, pal: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, enabled: bool, text: str, /, textRole: PySide6.QtGui.QPalette.ColorRole = ...) -> None: ...
    def drawPrimitive(self, pe: PySide6.QtWidgets.QStyle.PrimitiveElement, opt: PySide6.QtWidgets.QStyleOption, /) -> None: ...
    def style(self, /) -> PySide6.QtWidgets.QStyle: ...


class QStyledItemDelegate(PySide6.QtWidgets.QAbstractItemDelegate):

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def createEditor(self, parent: PySide6.QtWidgets.QWidget, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtWidgets.QWidget: ...
    def displayText(self, value: typing.Any, locale: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language, /) -> str: ...
    def editorEvent(self, event: PySide6.QtCore.QEvent, model: PySide6.QtCore.QAbstractItemModel, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def eventFilter(self, object: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def itemEditorFactory(self, /) -> PySide6.QtWidgets.QItemEditorFactory: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def setEditorData(self, editor: PySide6.QtWidgets.QWidget, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def setItemEditorFactory(self, factory: PySide6.QtWidgets.QItemEditorFactory, /) -> None: ...
    def setModelData(self, editor: PySide6.QtWidgets.QWidget, model: PySide6.QtCore.QAbstractItemModel, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def sizeHint(self, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QSize: ...
    def updateEditorGeometry(self, editor: PySide6.QtWidgets.QWidget, option: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...


class QSwipeGesture(PySide6.QtWidgets.QGesture):

    class SwipeDirection(enum.Enum):

        NoDirection               = ...  # 0x0
        Left                      = ...  # 0x1
        Right                     = ...  # 0x2
        Up                        = ...  # 0x3
        Down                      = ...  # 0x4


    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, horizontalDirection: PySide6.QtWidgets.QSwipeGesture.SwipeDirection | None = ..., verticalDirection: PySide6.QtWidgets.QSwipeGesture.SwipeDirection | None = ..., swipeAngle: float | None = ...) -> None: ...

    def horizontalDirection(self, /) -> PySide6.QtWidgets.QSwipeGesture.SwipeDirection: ...
    def setSwipeAngle(self, value: float, /) -> None: ...
    def swipeAngle(self, /) -> float: ...
    def verticalDirection(self, /) -> PySide6.QtWidgets.QSwipeGesture.SwipeDirection: ...


class QSystemTrayIcon(PySide6.QtCore.QObject):

    activated                : typing.ClassVar[Signal] = ... # activated(QSystemTrayIcon::ActivationReason)
    messageClicked           : typing.ClassVar[Signal] = ... # messageClicked()

    class ActivationReason(enum.Enum):

        Unknown                   = ...  # 0x0
        Context                   = ...  # 0x1
        DoubleClick               = ...  # 0x2
        Trigger                   = ...  # 0x3
        MiddleClick               = ...  # 0x4

    class MessageIcon(enum.Enum):

        NoIcon                    = ...  # 0x0
        Information               = ...  # 0x1
        Warning                   = ...  # 0x2
        Critical                  = ...  # 0x3


    @typing.overload
    def __init__(self, icon: PySide6.QtGui.QIcon, /, parent: PySide6.QtCore.QObject | None = ..., *, toolTip: str | None = ..., visible: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, toolTip: str | None = ..., icon: PySide6.QtGui.QIcon | None = ..., visible: bool | None = ...) -> None: ...

    def contextMenu(self, /) -> PySide6.QtWidgets.QMenu: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def geometry(self, /) -> PySide6.QtCore.QRect: ...
    def hide(self, /) -> None: ...
    def icon(self, /) -> PySide6.QtGui.QIcon: ...
    @staticmethod
    def isSystemTrayAvailable() -> bool: ...
    def isVisible(self, /) -> bool: ...
    def setContextMenu(self, menu: PySide6.QtWidgets.QMenu, /) -> None: ...
    def setIcon(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, /) -> None: ...
    def setToolTip(self, tip: str, /) -> None: ...
    def setVisible(self, visible: bool, /) -> None: ...
    def show(self, /) -> None: ...
    @typing.overload
    def showMessage(self, title: str, msg: str, /, icon: PySide6.QtWidgets.QSystemTrayIcon.MessageIcon = ..., msecs: int = ...) -> None: ...
    @typing.overload
    def showMessage(self, title: str, msg: str, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, /, msecs: int = ...) -> None: ...
    @staticmethod
    def supportsMessages() -> bool: ...
    def toolTip(self, /) -> str: ...


class QTabBar(PySide6.QtWidgets.QWidget):

    currentChanged           : typing.ClassVar[Signal] = ... # currentChanged(int)
    tabBarClicked            : typing.ClassVar[Signal] = ... # tabBarClicked(int)
    tabBarDoubleClicked      : typing.ClassVar[Signal] = ... # tabBarDoubleClicked(int)
    tabCloseRequested        : typing.ClassVar[Signal] = ... # tabCloseRequested(int)
    tabMoved                 : typing.ClassVar[Signal] = ... # tabMoved(int,int)

    class ButtonPosition(enum.Enum):

        LeftSide                  = ...  # 0x0
        RightSide                 = ...  # 0x1

    class SelectionBehavior(enum.Enum):

        SelectLeftTab             = ...  # 0x0
        SelectRightTab            = ...  # 0x1
        SelectPreviousTab         = ...  # 0x2

    class Shape(enum.Enum):

        RoundedNorth              = ...  # 0x0
        RoundedSouth              = ...  # 0x1
        RoundedWest               = ...  # 0x2
        RoundedEast               = ...  # 0x3
        TriangularNorth           = ...  # 0x4
        TriangularSouth           = ...  # 0x5
        TriangularWest            = ...  # 0x6
        TriangularEast            = ...  # 0x7


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, shape: PySide6.QtWidgets.QTabBar.Shape | None = ..., currentIndex: int | None = ..., count: int | None = ..., drawBase: bool | None = ..., iconSize: PySide6.QtCore.QSize | None = ..., elideMode: PySide6.QtCore.Qt.TextElideMode | None = ..., usesScrollButtons: bool | None = ..., tabsClosable: bool | None = ..., selectionBehaviorOnRemove: PySide6.QtWidgets.QTabBar.SelectionBehavior | None = ..., expanding: bool | None = ..., movable: bool | None = ..., documentMode: bool | None = ..., autoHide: bool | None = ..., changeCurrentOnDrag: bool | None = ...) -> None: ...

    def accessibleTabName(self, index: int, /) -> str: ...
    @typing.overload
    def addTab(self, text: str, /) -> int: ...
    @typing.overload
    def addTab(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, /) -> int: ...
    def autoHide(self, /) -> bool: ...
    def changeCurrentOnDrag(self, /) -> bool: ...
    def changeEvent(self, arg__1: PySide6.QtCore.QEvent, /) -> None: ...
    def count(self, /) -> int: ...
    def currentIndex(self, /) -> int: ...
    def documentMode(self, /) -> bool: ...
    def drawBase(self, /) -> bool: ...
    def elideMode(self, /) -> PySide6.QtCore.Qt.TextElideMode: ...
    def event(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    def expanding(self, /) -> bool: ...
    def hideEvent(self, arg__1: PySide6.QtGui.QHideEvent, /) -> None: ...
    def iconSize(self, /) -> PySide6.QtCore.QSize: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionTab, tabIndex: int, /) -> None: ...
    @typing.overload
    def insertTab(self, index: int, text: str, /) -> int: ...
    @typing.overload
    def insertTab(self, index: int, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, /) -> int: ...
    def isMovable(self, /) -> bool: ...
    def isTabEnabled(self, index: int, /) -> bool: ...
    def isTabVisible(self, index: int, /) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def minimumTabSizeHint(self, index: int, /) -> PySide6.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def moveTab(self, from_: int, to: int, /) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def removeTab(self, index: int, /) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def selectionBehaviorOnRemove(self, /) -> PySide6.QtWidgets.QTabBar.SelectionBehavior: ...
    def setAccessibleTabName(self, index: int, name: str, /) -> None: ...
    def setAutoHide(self, hide: bool, /) -> None: ...
    def setChangeCurrentOnDrag(self, change: bool, /) -> None: ...
    def setCurrentIndex(self, index: int, /) -> None: ...
    def setDocumentMode(self, set: bool, /) -> None: ...
    def setDrawBase(self, drawTheBase: bool, /) -> None: ...
    def setElideMode(self, mode: PySide6.QtCore.Qt.TextElideMode, /) -> None: ...
    def setExpanding(self, enabled: bool, /) -> None: ...
    def setIconSize(self, size: PySide6.QtCore.QSize, /) -> None: ...
    def setMovable(self, movable: bool, /) -> None: ...
    def setSelectionBehaviorOnRemove(self, behavior: PySide6.QtWidgets.QTabBar.SelectionBehavior, /) -> None: ...
    def setShape(self, shape: PySide6.QtWidgets.QTabBar.Shape, /) -> None: ...
    def setTabButton(self, index: int, position: PySide6.QtWidgets.QTabBar.ButtonPosition, widget: PySide6.QtWidgets.QWidget | None, /) -> None: ...
    def setTabData(self, index: int, data: typing.Any, /) -> None: ...
    def setTabEnabled(self, index: int, enabled: bool, /) -> None: ...
    def setTabIcon(self, index: int, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, /) -> None: ...
    def setTabText(self, index: int, text: str, /) -> None: ...
    def setTabTextColor(self, index: int, color: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, /) -> None: ...
    def setTabToolTip(self, index: int, tip: str, /) -> None: ...
    def setTabVisible(self, index: int, visible: bool, /) -> None: ...
    def setTabWhatsThis(self, index: int, text: str, /) -> None: ...
    def setTabsClosable(self, closable: bool, /) -> None: ...
    def setUsesScrollButtons(self, useButtons: bool, /) -> None: ...
    def shape(self, /) -> PySide6.QtWidgets.QTabBar.Shape: ...
    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def tabAt(self, pos: PySide6.QtCore.QPoint, /) -> int: ...
    def tabButton(self, index: int, position: PySide6.QtWidgets.QTabBar.ButtonPosition, /) -> PySide6.QtWidgets.QWidget: ...
    def tabData(self, index: int, /) -> typing.Any: ...
    def tabIcon(self, index: int, /) -> PySide6.QtGui.QIcon: ...
    def tabInserted(self, index: int, /) -> None: ...
    def tabLayoutChange(self, /) -> None: ...
    def tabRect(self, index: int, /) -> PySide6.QtCore.QRect: ...
    def tabRemoved(self, index: int, /) -> None: ...
    def tabSizeHint(self, index: int, /) -> PySide6.QtCore.QSize: ...
    def tabText(self, index: int, /) -> str: ...
    def tabTextColor(self, index: int, /) -> PySide6.QtGui.QColor: ...
    def tabToolTip(self, index: int, /) -> str: ...
    def tabWhatsThis(self, index: int, /) -> str: ...
    def tabsClosable(self, /) -> bool: ...
    def timerEvent(self, event: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def usesScrollButtons(self, /) -> bool: ...
    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent, /) -> None: ...


class QTabWidget(PySide6.QtWidgets.QWidget):

    currentChanged           : typing.ClassVar[Signal] = ... # currentChanged(int)
    tabBarClicked            : typing.ClassVar[Signal] = ... # tabBarClicked(int)
    tabBarDoubleClicked      : typing.ClassVar[Signal] = ... # tabBarDoubleClicked(int)
    tabCloseRequested        : typing.ClassVar[Signal] = ... # tabCloseRequested(int)

    class TabPosition(enum.Enum):

        North                     = ...  # 0x0
        South                     = ...  # 0x1
        West                      = ...  # 0x2
        East                      = ...  # 0x3

    class TabShape(enum.Enum):

        Rounded                   = ...  # 0x0
        Triangular                = ...  # 0x1


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, tabPosition: PySide6.QtWidgets.QTabWidget.TabPosition | None = ..., tabShape: PySide6.QtWidgets.QTabWidget.TabShape | None = ..., currentIndex: int | None = ..., count: int | None = ..., iconSize: PySide6.QtCore.QSize | None = ..., elideMode: PySide6.QtCore.Qt.TextElideMode | None = ..., usesScrollButtons: bool | None = ..., documentMode: bool | None = ..., tabsClosable: bool | None = ..., movable: bool | None = ..., tabBarAutoHide: bool | None = ...) -> None: ...

    @typing.overload
    def addTab(self, widget: PySide6.QtWidgets.QWidget, arg__2: str, /) -> int: ...
    @typing.overload
    def addTab(self, widget: PySide6.QtWidgets.QWidget, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, label: str, /) -> int: ...
    def changeEvent(self, arg__1: PySide6.QtCore.QEvent, /) -> None: ...
    def clear(self, /) -> None: ...
    def cornerWidget(self, /, corner: PySide6.QtCore.Qt.Corner = ...) -> PySide6.QtWidgets.QWidget: ...
    def count(self, /) -> int: ...
    def currentIndex(self, /) -> int: ...
    def currentWidget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def documentMode(self, /) -> bool: ...
    def elideMode(self, /) -> PySide6.QtCore.Qt.TextElideMode: ...
    def event(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    def hasHeightForWidth(self, /) -> bool: ...
    def heightForWidth(self, width: int, /) -> int: ...
    def iconSize(self, /) -> PySide6.QtCore.QSize: ...
    def indexOf(self, widget: PySide6.QtWidgets.QWidget, /) -> int: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionTabWidgetFrame, /) -> None: ...
    @typing.overload
    def insertTab(self, index: int, widget: PySide6.QtWidgets.QWidget, arg__3: str, /) -> int: ...
    @typing.overload
    def insertTab(self, index: int, widget: PySide6.QtWidgets.QWidget, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, label: str, /) -> int: ...
    def isMovable(self, /) -> bool: ...
    def isTabEnabled(self, index: int, /) -> bool: ...
    def isTabVisible(self, index: int, /) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def removeTab(self, index: int, /) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def setCornerWidget(self, w: PySide6.QtWidgets.QWidget, /, corner: PySide6.QtCore.Qt.Corner = ...) -> None: ...
    def setCurrentIndex(self, index: int, /) -> None: ...
    def setCurrentWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setDocumentMode(self, set: bool, /) -> None: ...
    def setElideMode(self, mode: PySide6.QtCore.Qt.TextElideMode, /) -> None: ...
    def setIconSize(self, size: PySide6.QtCore.QSize, /) -> None: ...
    def setMovable(self, movable: bool, /) -> None: ...
    def setTabBar(self, arg__1: PySide6.QtWidgets.QTabBar, /) -> None: ...
    def setTabBarAutoHide(self, enabled: bool, /) -> None: ...
    def setTabEnabled(self, index: int, enabled: bool, /) -> None: ...
    def setTabIcon(self, index: int, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, /) -> None: ...
    def setTabPosition(self, position: PySide6.QtWidgets.QTabWidget.TabPosition, /) -> None: ...
    def setTabShape(self, s: PySide6.QtWidgets.QTabWidget.TabShape, /) -> None: ...
    def setTabText(self, index: int, text: str, /) -> None: ...
    def setTabToolTip(self, index: int, tip: str, /) -> None: ...
    def setTabVisible(self, index: int, visible: bool, /) -> None: ...
    def setTabWhatsThis(self, index: int, text: str, /) -> None: ...
    def setTabsClosable(self, closeable: bool, /) -> None: ...
    def setUsesScrollButtons(self, useButtons: bool, /) -> None: ...
    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def tabBar(self, /) -> PySide6.QtWidgets.QTabBar: ...
    def tabBarAutoHide(self, /) -> bool: ...
    def tabIcon(self, index: int, /) -> PySide6.QtGui.QIcon: ...
    def tabInserted(self, index: int, /) -> None: ...
    def tabPosition(self, /) -> PySide6.QtWidgets.QTabWidget.TabPosition: ...
    def tabRemoved(self, index: int, /) -> None: ...
    def tabShape(self, /) -> PySide6.QtWidgets.QTabWidget.TabShape: ...
    def tabText(self, index: int, /) -> str: ...
    def tabToolTip(self, index: int, /) -> str: ...
    def tabWhatsThis(self, index: int, /) -> str: ...
    def tabsClosable(self, /) -> bool: ...
    def usesScrollButtons(self, /) -> bool: ...
    def widget(self, index: int, /) -> PySide6.QtWidgets.QWidget: ...


class QTableView(PySide6.QtWidgets.QAbstractItemView):

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, showGrid: bool | None = ..., gridStyle: PySide6.QtCore.Qt.PenStyle | None = ..., sortingEnabled: bool | None = ..., wordWrap: bool | None = ..., cornerButtonEnabled: bool | None = ...) -> None: ...

    def clearSpans(self, /) -> None: ...
    def columnAt(self, x: int, /) -> int: ...
    def columnCountChanged(self, oldCount: int, newCount: int, /) -> None: ...
    def columnMoved(self, column: int, oldIndex: int, newIndex: int, /) -> None: ...
    def columnResized(self, column: int, oldWidth: int, newWidth: int, /) -> None: ...
    def columnSpan(self, row: int, column: int, /) -> int: ...
    def columnViewportPosition(self, column: int, /) -> int: ...
    def columnWidth(self, column: int, /) -> int: ...
    def currentChanged(self, current: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, previous: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def doItemsLayout(self, /) -> None: ...
    def dropEvent(self, event: PySide6.QtGui.QDropEvent, /) -> None: ...
    def gridStyle(self, /) -> PySide6.QtCore.Qt.PenStyle: ...
    def hideColumn(self, column: int, /) -> None: ...
    def hideRow(self, row: int, /) -> None: ...
    def horizontalHeader(self, /) -> PySide6.QtWidgets.QHeaderView: ...
    def horizontalOffset(self, /) -> int: ...
    def horizontalScrollbarAction(self, action: int, /) -> None: ...
    def indexAt(self, p: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QModelIndex: ...
    def initViewItemOption(self, option: PySide6.QtWidgets.QStyleOptionViewItem, /) -> None: ...
    def isColumnHidden(self, column: int, /) -> bool: ...
    def isCornerButtonEnabled(self, /) -> bool: ...
    def isIndexHidden(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def isRowHidden(self, row: int, /) -> bool: ...
    def isSortingEnabled(self, /) -> bool: ...
    def moveCursor(self, cursorAction: PySide6.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide6.QtCore.Qt.KeyboardModifier, /) -> PySide6.QtCore.QModelIndex: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def resizeColumnToContents(self, column: int, /) -> None: ...
    def resizeColumnsToContents(self, /) -> None: ...
    def resizeRowToContents(self, row: int, /) -> None: ...
    def resizeRowsToContents(self, /) -> None: ...
    def rowAt(self, y: int, /) -> int: ...
    def rowCountChanged(self, oldCount: int, newCount: int, /) -> None: ...
    def rowHeight(self, row: int, /) -> int: ...
    def rowMoved(self, row: int, oldIndex: int, newIndex: int, /) -> None: ...
    def rowResized(self, row: int, oldHeight: int, newHeight: int, /) -> None: ...
    def rowSpan(self, row: int, column: int, /) -> int: ...
    def rowViewportPosition(self, row: int, /) -> int: ...
    def scrollContentsBy(self, dx: int, dy: int, /) -> None: ...
    def scrollTo(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectColumn(self, column: int, /) -> None: ...
    def selectRow(self, row: int, /) -> None: ...
    def selectedIndexes(self, /) -> typing.List[PySide6.QtCore.QModelIndex]: ...
    def selectionChanged(self, selected: PySide6.QtCore.QItemSelection, deselected: PySide6.QtCore.QItemSelection, /) -> None: ...
    def setColumnHidden(self, column: int, hide: bool, /) -> None: ...
    def setColumnWidth(self, column: int, width: int, /) -> None: ...
    def setCornerButtonEnabled(self, enable: bool, /) -> None: ...
    def setGridStyle(self, style: PySide6.QtCore.Qt.PenStyle, /) -> None: ...
    def setHorizontalHeader(self, header: PySide6.QtWidgets.QHeaderView, /) -> None: ...
    def setModel(self, model: PySide6.QtCore.QAbstractItemModel | None, /) -> None: ...
    def setRootIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def setRowHeight(self, row: int, height: int, /) -> None: ...
    def setRowHidden(self, row: int, hide: bool, /) -> None: ...
    def setSelection(self, rect: PySide6.QtCore.QRect, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag, /) -> None: ...
    def setSelectionModel(self, selectionModel: PySide6.QtCore.QItemSelectionModel, /) -> None: ...
    def setShowGrid(self, show: bool, /) -> None: ...
    def setSortingEnabled(self, enable: bool, /) -> None: ...
    def setSpan(self, row: int, column: int, rowSpan: int, columnSpan: int, /) -> None: ...
    def setVerticalHeader(self, header: PySide6.QtWidgets.QHeaderView, /) -> None: ...
    def setWordWrap(self, on: bool, /) -> None: ...
    def showColumn(self, column: int, /) -> None: ...
    def showGrid(self, /) -> bool: ...
    def showRow(self, row: int, /) -> None: ...
    def sizeHintForColumn(self, column: int, /) -> int: ...
    def sizeHintForRow(self, row: int, /) -> int: ...
    def sortByColumn(self, column: int, order: PySide6.QtCore.Qt.SortOrder, /) -> None: ...
    def timerEvent(self, event: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def updateGeometries(self, /) -> None: ...
    def verticalHeader(self, /) -> PySide6.QtWidgets.QHeaderView: ...
    def verticalOffset(self, /) -> int: ...
    def verticalScrollbarAction(self, action: int, /) -> None: ...
    def viewportSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def visualRect(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide6.QtCore.QItemSelection, /) -> PySide6.QtGui.QRegion: ...
    def wordWrap(self, /) -> bool: ...


class QTableWidget(PySide6.QtWidgets.QTableView):

    cellActivated            : typing.ClassVar[Signal] = ... # cellActivated(int,int)
    cellChanged              : typing.ClassVar[Signal] = ... # cellChanged(int,int)
    cellClicked              : typing.ClassVar[Signal] = ... # cellClicked(int,int)
    cellDoubleClicked        : typing.ClassVar[Signal] = ... # cellDoubleClicked(int,int)
    cellEntered              : typing.ClassVar[Signal] = ... # cellEntered(int,int)
    cellPressed              : typing.ClassVar[Signal] = ... # cellPressed(int,int)
    currentCellChanged       : typing.ClassVar[Signal] = ... # currentCellChanged(int,int,int,int)
    currentItemChanged       : typing.ClassVar[Signal] = ... # currentItemChanged(QTableWidgetItem*,QTableWidgetItem*)
    itemActivated            : typing.ClassVar[Signal] = ... # itemActivated(QTableWidgetItem*)
    itemChanged              : typing.ClassVar[Signal] = ... # itemChanged(QTableWidgetItem*)
    itemClicked              : typing.ClassVar[Signal] = ... # itemClicked(QTableWidgetItem*)
    itemDoubleClicked        : typing.ClassVar[Signal] = ... # itemDoubleClicked(QTableWidgetItem*)
    itemEntered              : typing.ClassVar[Signal] = ... # itemEntered(QTableWidgetItem*)
    itemPressed              : typing.ClassVar[Signal] = ... # itemPressed(QTableWidgetItem*)
    itemSelectionChanged     : typing.ClassVar[Signal] = ... # itemSelectionChanged()

    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, rowCount: int | None = ..., columnCount: int | None = ...) -> None: ...
    @typing.overload
    def __init__(self, rows: int, columns: int, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, rowCount: int | None = ..., columnCount: int | None = ...) -> None: ...

    def cellWidget(self, row: int, column: int, /) -> PySide6.QtWidgets.QWidget: ...
    def clear(self, /) -> None: ...
    def clearContents(self, /) -> None: ...
    def closePersistentEditor(self, item: PySide6.QtWidgets.QTableWidgetItem, /) -> None: ...
    def column(self, item: PySide6.QtWidgets.QTableWidgetItem, /) -> int: ...
    def columnCount(self, /) -> int: ...
    def currentColumn(self, /) -> int: ...
    def currentItem(self, /) -> PySide6.QtWidgets.QTableWidgetItem: ...
    def currentRow(self, /) -> int: ...
    def dropEvent(self, event: PySide6.QtGui.QDropEvent, /) -> None: ...
    def dropMimeData(self, row: int, column: int, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, /) -> bool: ...
    def editItem(self, item: PySide6.QtWidgets.QTableWidgetItem, /) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def findItems(self, text: str, flags: PySide6.QtCore.Qt.MatchFlag, /) -> typing.List[PySide6.QtWidgets.QTableWidgetItem]: ...
    def horizontalHeaderItem(self, column: int, /) -> PySide6.QtWidgets.QTableWidgetItem | None: ...
    def indexFromItem(self, item: PySide6.QtWidgets.QTableWidgetItem, /) -> PySide6.QtCore.QModelIndex: ...
    def insertColumn(self, column: int, /) -> None: ...
    def insertRow(self, row: int, /) -> None: ...
    @typing.overload
    def isPersistentEditorOpen(self, item: PySide6.QtWidgets.QTableWidgetItem, /) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def isSortingEnabled(self, /) -> bool: ...
    def item(self, row: int, column: int, /) -> PySide6.QtWidgets.QTableWidgetItem | None: ...
    @typing.overload
    def itemAt(self, p: PySide6.QtCore.QPoint, /) -> PySide6.QtWidgets.QTableWidgetItem | None: ...
    @typing.overload
    def itemAt(self, x: int, y: int, /) -> PySide6.QtWidgets.QTableWidgetItem | None: ...
    def itemFromIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtWidgets.QTableWidgetItem: ...
    def itemPrototype(self, /) -> PySide6.QtWidgets.QTableWidgetItem: ...
    def items(self, data: PySide6.QtCore.QMimeData, /) -> typing.List[PySide6.QtWidgets.QTableWidgetItem]: ...
    def mimeData(self, items: collections.abc.Sequence[PySide6.QtWidgets.QTableWidgetItem], /) -> PySide6.QtCore.QMimeData | None: ...
    def mimeTypes(self, /) -> typing.List[str]: ...
    def openPersistentEditor(self, item: PySide6.QtWidgets.QTableWidgetItem, /) -> None: ...
    def removeCellWidget(self, row: int, column: int, /) -> None: ...
    def removeColumn(self, column: int, /) -> None: ...
    def removeRow(self, row: int, /) -> None: ...
    def row(self, item: PySide6.QtWidgets.QTableWidgetItem, /) -> int: ...
    def rowCount(self, /) -> int: ...
    def scrollToItem(self, item: PySide6.QtWidgets.QTableWidgetItem, /, hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectedItems(self, /) -> typing.List[PySide6.QtWidgets.QTableWidgetItem]: ...
    def selectedRanges(self, /) -> typing.List[PySide6.QtWidgets.QTableWidgetSelectionRange]: ...
    def setCellWidget(self, row: int, column: int, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setColumnCount(self, columns: int, /) -> None: ...
    @typing.overload
    def setCurrentCell(self, row: int, column: int, /) -> None: ...
    @typing.overload
    def setCurrentCell(self, row: int, column: int, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag, /) -> None: ...
    @typing.overload
    def setCurrentItem(self, item: PySide6.QtWidgets.QTableWidgetItem, /) -> None: ...
    @typing.overload
    def setCurrentItem(self, item: PySide6.QtWidgets.QTableWidgetItem, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag, /) -> None: ...
    def setHorizontalHeaderItem(self, column: int, item: PySide6.QtWidgets.QTableWidgetItem, /) -> None: ...
    def setHorizontalHeaderLabels(self, labels: collections.abc.Sequence[str], /) -> None: ...
    def setItem(self, row: int, column: int, item: PySide6.QtWidgets.QTableWidgetItem, /) -> None: ...
    def setItemPrototype(self, item: PySide6.QtWidgets.QTableWidgetItem, /) -> None: ...
    def setModel(self, model: PySide6.QtCore.QAbstractItemModel | None, /) -> None: ...
    def setRangeSelected(self, range: PySide6.QtWidgets.QTableWidgetSelectionRange, select: bool, /) -> None: ...
    def setRowCount(self, rows: int, /) -> None: ...
    def setSortingEnabled(self, enable: bool, /) -> None: ...
    def setVerticalHeaderItem(self, row: int, item: PySide6.QtWidgets.QTableWidgetItem, /) -> None: ...
    def setVerticalHeaderLabels(self, labels: collections.abc.Sequence[str], /) -> None: ...
    def sortItems(self, column: int, /, order: PySide6.QtCore.Qt.SortOrder = ...) -> None: ...
    def supportedDropActions(self, /) -> PySide6.QtCore.Qt.DropAction: ...
    def takeHorizontalHeaderItem(self, column: int, /) -> PySide6.QtWidgets.QTableWidgetItem: ...
    def takeItem(self, row: int, column: int, /) -> PySide6.QtWidgets.QTableWidgetItem: ...
    def takeVerticalHeaderItem(self, row: int, /) -> PySide6.QtWidgets.QTableWidgetItem: ...
    def verticalHeaderItem(self, row: int, /) -> PySide6.QtWidgets.QTableWidgetItem: ...
    def visualColumn(self, logicalColumn: int, /) -> int: ...
    def visualItemRect(self, item: PySide6.QtWidgets.QTableWidgetItem, /) -> PySide6.QtCore.QRect: ...
    def visualRow(self, logicalRow: int, /) -> int: ...


class QTableWidgetItem(Shiboken.Object):

    class ItemType(enum.IntEnum):

        Type                      = ...  # 0x0
        UserType                  = ...  # 0x3e8


    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QTableWidgetItem, /) -> None: ...
    @typing.overload
    def __init__(self, text: str, /, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, /, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, /, type: int = ...) -> None: ...

    def __lshift__(self, out: PySide6.QtCore.QDataStream, /) -> PySide6.QtCore.QDataStream: ...
    def __lt__(self, other: PySide6.QtWidgets.QTableWidgetItem, /) -> bool: ...
    def __rshift__(self, in_: PySide6.QtCore.QDataStream, /) -> PySide6.QtCore.QDataStream: ...
    def background(self, /) -> PySide6.QtGui.QBrush: ...
    def checkState(self, /) -> PySide6.QtCore.Qt.CheckState: ...
    def clone(self, /) -> PySide6.QtWidgets.QTableWidgetItem: ...
    def column(self, /) -> int: ...
    def data(self, role: int, /) -> typing.Any: ...
    def flags(self, /) -> PySide6.QtCore.Qt.ItemFlag: ...
    def font(self, /) -> PySide6.QtGui.QFont: ...
    def foreground(self, /) -> PySide6.QtGui.QBrush: ...
    def icon(self, /) -> PySide6.QtGui.QIcon: ...
    def isSelected(self, /) -> bool: ...
    def read(self, in_: PySide6.QtCore.QDataStream, /) -> None: ...
    def row(self, /) -> int: ...
    def setBackground(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, /) -> None: ...
    def setCheckState(self, state: PySide6.QtCore.Qt.CheckState, /) -> None: ...
    def setData(self, role: int, value: typing.Any, /) -> None: ...
    def setFlags(self, flags: PySide6.QtCore.Qt.ItemFlag, /) -> None: ...
    def setFont(self, font: PySide6.QtGui.QFont | str | collections.abc.Sequence[str], /) -> None: ...
    def setForeground(self, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, /) -> None: ...
    def setIcon(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, /) -> None: ...
    def setSelected(self, select: bool, /) -> None: ...
    def setSizeHint(self, size: PySide6.QtCore.QSize, /) -> None: ...
    def setStatusTip(self, statusTip: str, /) -> None: ...
    def setText(self, text: str, /) -> None: ...
    @typing.overload
    def setTextAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    @typing.overload
    def setTextAlignment(self, alignment: int, /) -> None: ...
    def setToolTip(self, toolTip: str, /) -> None: ...
    def setWhatsThis(self, whatsThis: str, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def statusTip(self, /) -> str: ...
    def tableWidget(self, /) -> PySide6.QtWidgets.QTableWidget: ...
    def text(self, /) -> str: ...
    def textAlignment(self, /) -> int: ...
    def toolTip(self, /) -> str: ...
    def type(self, /) -> int: ...
    def whatsThis(self, /) -> str: ...
    def write(self, out: PySide6.QtCore.QDataStream, /) -> None: ...


class QTableWidgetSelectionRange(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QTableWidgetSelectionRange: PySide6.QtWidgets.QTableWidgetSelectionRange, /) -> None: ...
    @typing.overload
    def __init__(self, top: int, left: int, bottom: int, right: int, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtWidgets.QTableWidgetSelectionRange, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtWidgets.QTableWidgetSelectionRange, /) -> bool: ...
    def bottomRow(self, /) -> int: ...
    def columnCount(self, /) -> int: ...
    def leftColumn(self, /) -> int: ...
    def rightColumn(self, /) -> int: ...
    def rowCount(self, /) -> int: ...
    def topRow(self, /) -> int: ...


class QTapAndHoldGesture(PySide6.QtWidgets.QGesture):

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, position: PySide6.QtCore.QPointF | None = ...) -> None: ...

    def position(self, /) -> PySide6.QtCore.QPointF: ...
    def setPosition(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...
    @staticmethod
    def setTimeout(msecs: int, /) -> None: ...
    @staticmethod
    def timeout() -> int: ...


class QTapGesture(PySide6.QtWidgets.QGesture):

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, position: PySide6.QtCore.QPointF | None = ...) -> None: ...

    def position(self, /) -> PySide6.QtCore.QPointF: ...
    def setPosition(self, pos: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> None: ...


class QTextBrowser(PySide6.QtWidgets.QTextEdit):

    anchorClicked            : typing.ClassVar[Signal] = ... # anchorClicked(QUrl)
    backwardAvailable        : typing.ClassVar[Signal] = ... # backwardAvailable(bool)
    forwardAvailable         : typing.ClassVar[Signal] = ... # forwardAvailable(bool)
    highlighted              : typing.ClassVar[Signal] = ... # highlighted(QUrl)
    historyChanged           : typing.ClassVar[Signal] = ... # historyChanged()
    sourceChanged            : typing.ClassVar[Signal] = ... # sourceChanged(QUrl)

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, source: PySide6.QtCore.QUrl | None = ..., sourceType: PySide6.QtGui.QTextDocument.ResourceType | None = ..., searchPaths: collections.abc.Sequence[str] | None = ..., openExternalLinks: bool | None = ..., openLinks: bool | None = ...) -> None: ...

    def backward(self, /) -> None: ...
    def backwardHistoryCount(self, /) -> int: ...
    def clearHistory(self, /) -> None: ...
    def doSetSource(self, name: PySide6.QtCore.QUrl | str, /, type: PySide6.QtGui.QTextDocument.ResourceType = ...) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def focusNextPrevChild(self, next: bool, /) -> bool: ...
    def focusOutEvent(self, ev: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def forward(self, /) -> None: ...
    def forwardHistoryCount(self, /) -> int: ...
    def historyTitle(self, arg__1: int, /) -> str: ...
    def historyUrl(self, arg__1: int, /) -> PySide6.QtCore.QUrl: ...
    def home(self, /) -> None: ...
    def isBackwardAvailable(self, /) -> bool: ...
    def isForwardAvailable(self, /) -> bool: ...
    def keyPressEvent(self, ev: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def loadResource(self, type: int, name: PySide6.QtCore.QUrl | str, /) -> typing.Any: ...
    def mouseMoveEvent(self, ev: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, ev: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, ev: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def openExternalLinks(self, /) -> bool: ...
    def openLinks(self, /) -> bool: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def reload(self, /) -> None: ...
    def searchPaths(self, /) -> typing.List[str]: ...
    def setOpenExternalLinks(self, open: bool, /) -> None: ...
    def setOpenLinks(self, open: bool, /) -> None: ...
    def setSearchPaths(self, paths: collections.abc.Sequence[str], /) -> None: ...
    def setSource(self, name: PySide6.QtCore.QUrl | str, /, type: PySide6.QtGui.QTextDocument.ResourceType = ...) -> None: ...
    def source(self, /) -> PySide6.QtCore.QUrl: ...
    def sourceType(self, /) -> PySide6.QtGui.QTextDocument.ResourceType: ...


class QTextEdit(PySide6.QtWidgets.QAbstractScrollArea):

    copyAvailable            : typing.ClassVar[Signal] = ... # copyAvailable(bool)
    currentCharFormatChanged : typing.ClassVar[Signal] = ... # currentCharFormatChanged(QTextCharFormat)
    cursorPositionChanged    : typing.ClassVar[Signal] = ... # cursorPositionChanged()
    redoAvailable            : typing.ClassVar[Signal] = ... # redoAvailable(bool)
    selectionChanged         : typing.ClassVar[Signal] = ... # selectionChanged()
    textChanged              : typing.ClassVar[Signal] = ... # textChanged()
    undoAvailable            : typing.ClassVar[Signal] = ... # undoAvailable(bool)

    class AutoFormattingFlag(enum.Flag):

        AutoAll                   = ...  # -1
        AutoNone                  = ...  # 0x0
        AutoBulletList            = ...  # 0x1

    class ExtraSelection(Shiboken.Object):

        @typing.overload
        def __init__(self, /) -> None: ...
        @typing.overload
        def __init__(self, ExtraSelection: PySide6.QtWidgets.QTextEdit.ExtraSelection, /) -> None: ...

        def __copy__(self, /) -> typing.Self: ...

    class LineWrapMode(enum.Enum):

        NoWrap                    = ...  # 0x0
        WidgetWidth               = ...  # 0x1
        FixedPixelWidth           = ...  # 0x2
        FixedColumnWidth          = ...  # 0x3


    @typing.overload
    def __init__(self, text: str, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, autoFormatting: PySide6.QtWidgets.QTextEdit.AutoFormattingFlag | None = ..., tabChangesFocus: bool | None = ..., documentTitle: str | None = ..., undoRedoEnabled: bool | None = ..., lineWrapMode: PySide6.QtWidgets.QTextEdit.LineWrapMode | None = ..., lineWrapColumnOrWidth: int | None = ..., readOnly: bool | None = ..., markdown: str | None = ..., html: str | None = ..., plainText: str | None = ..., overwriteMode: bool | None = ..., tabStopDistance: float | None = ..., acceptRichText: bool | None = ..., cursorWidth: int | None = ..., textInteractionFlags: PySide6.QtCore.Qt.TextInteractionFlag | None = ..., document: PySide6.QtGui.QTextDocument | None = ..., placeholderText: str | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, autoFormatting: PySide6.QtWidgets.QTextEdit.AutoFormattingFlag | None = ..., tabChangesFocus: bool | None = ..., documentTitle: str | None = ..., undoRedoEnabled: bool | None = ..., lineWrapMode: PySide6.QtWidgets.QTextEdit.LineWrapMode | None = ..., lineWrapColumnOrWidth: int | None = ..., readOnly: bool | None = ..., markdown: str | None = ..., html: str | None = ..., plainText: str | None = ..., overwriteMode: bool | None = ..., tabStopDistance: float | None = ..., acceptRichText: bool | None = ..., cursorWidth: int | None = ..., textInteractionFlags: PySide6.QtCore.Qt.TextInteractionFlag | None = ..., document: PySide6.QtGui.QTextDocument | None = ..., placeholderText: str | None = ...) -> None: ...

    def acceptRichText(self, /) -> bool: ...
    def alignment(self, /) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def anchorAt(self, pos: PySide6.QtCore.QPoint, /) -> str: ...
    def append(self, text: str, /) -> None: ...
    def autoFormatting(self, /) -> PySide6.QtWidgets.QTextEdit.AutoFormattingFlag: ...
    def canInsertFromMimeData(self, source: PySide6.QtCore.QMimeData, /) -> bool: ...
    def canPaste(self, /) -> bool: ...
    def changeEvent(self, e: PySide6.QtCore.QEvent, /) -> None: ...
    def clear(self, /) -> None: ...
    def contextMenuEvent(self, e: PySide6.QtGui.QContextMenuEvent, /) -> None: ...
    def copy(self, /) -> None: ...
    def createMimeDataFromSelection(self, /) -> PySide6.QtCore.QMimeData: ...
    @typing.overload
    def createStandardContextMenu(self, /) -> PySide6.QtWidgets.QMenu: ...
    @typing.overload
    def createStandardContextMenu(self, position: PySide6.QtCore.QPoint, /) -> PySide6.QtWidgets.QMenu: ...
    def currentCharFormat(self, /) -> PySide6.QtGui.QTextCharFormat: ...
    def currentFont(self, /) -> PySide6.QtGui.QFont: ...
    def cursorForPosition(self, pos: PySide6.QtCore.QPoint, /) -> PySide6.QtGui.QTextCursor: ...
    @typing.overload
    def cursorRect(self, /) -> PySide6.QtCore.QRect: ...
    @typing.overload
    def cursorRect(self, cursor: PySide6.QtGui.QTextCursor, /) -> PySide6.QtCore.QRect: ...
    def cursorWidth(self, /) -> int: ...
    def cut(self, /) -> None: ...
    def doSetTextCursor(self, cursor: PySide6.QtGui.QTextCursor, /) -> None: ...
    def document(self, /) -> PySide6.QtGui.QTextDocument: ...
    def documentTitle(self, /) -> str: ...
    def dragEnterEvent(self, e: PySide6.QtGui.QDragEnterEvent, /) -> None: ...
    def dragLeaveEvent(self, e: PySide6.QtGui.QDragLeaveEvent, /) -> None: ...
    def dragMoveEvent(self, e: PySide6.QtGui.QDragMoveEvent, /) -> None: ...
    def dropEvent(self, e: PySide6.QtGui.QDropEvent, /) -> None: ...
    def ensureCursorVisible(self, /) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def extraSelections(self, /) -> typing.List[PySide6.QtWidgets.QTextEdit.ExtraSelection]: ...
    @typing.overload
    def find(self, exp: str, /, options: PySide6.QtGui.QTextDocument.FindFlag = ...) -> bool: ...
    @typing.overload
    def find(self, exp: PySide6.QtCore.QRegularExpression | str, /, options: PySide6.QtGui.QTextDocument.FindFlag = ...) -> bool: ...
    def focusInEvent(self, e: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusNextPrevChild(self, next: bool, /) -> bool: ...
    def focusOutEvent(self, e: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def fontFamily(self, /) -> str: ...
    def fontItalic(self, /) -> bool: ...
    def fontPointSize(self, /) -> float: ...
    def fontUnderline(self, /) -> bool: ...
    def fontWeight(self, /) -> int: ...
    def inputMethodEvent(self, arg__1: PySide6.QtGui.QInputMethodEvent, /) -> None: ...
    @typing.overload
    def inputMethodQuery(self, property: PySide6.QtCore.Qt.InputMethodQuery, /) -> typing.Any: ...
    @typing.overload
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery, argument: typing.Any, /) -> typing.Any: ...
    def insertFromMimeData(self, source: PySide6.QtCore.QMimeData, /) -> None: ...
    def insertHtml(self, text: str, /) -> None: ...
    def insertPlainText(self, text: str, /) -> None: ...
    def isReadOnly(self, /) -> bool: ...
    def isUndoRedoEnabled(self, /) -> bool: ...
    def keyPressEvent(self, e: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def keyReleaseEvent(self, e: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def lineWrapColumnOrWidth(self, /) -> int: ...
    def lineWrapMode(self, /) -> PySide6.QtWidgets.QTextEdit.LineWrapMode: ...
    def loadResource(self, type: int, name: PySide6.QtCore.QUrl | str, /) -> typing.Any: ...
    def mergeCurrentCharFormat(self, modifier: PySide6.QtGui.QTextCharFormat, /) -> None: ...
    def mouseDoubleClickEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseMoveEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, e: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def moveCursor(self, operation: PySide6.QtGui.QTextCursor.MoveOperation, /, mode: PySide6.QtGui.QTextCursor.MoveMode = ...) -> None: ...
    def overwriteMode(self, /) -> bool: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def paste(self, /) -> None: ...
    def placeholderText(self, /) -> str: ...
    def print_(self, printer: PySide6.QtGui.QPagedPaintDevice, /) -> None: ...
    def redo(self, /) -> None: ...
    def resizeEvent(self, e: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int, /) -> None: ...
    def scrollToAnchor(self, name: str, /) -> None: ...
    def selectAll(self, /) -> None: ...
    def setAcceptRichText(self, accept: bool, /) -> None: ...
    def setAlignment(self, a: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    def setAutoFormatting(self, features: PySide6.QtWidgets.QTextEdit.AutoFormattingFlag, /) -> None: ...
    def setCurrentCharFormat(self, format: PySide6.QtGui.QTextCharFormat, /) -> None: ...
    def setCurrentFont(self, f: PySide6.QtGui.QFont | str | collections.abc.Sequence[str], /) -> None: ...
    def setCursorWidth(self, width: int, /) -> None: ...
    def setDocument(self, document: PySide6.QtGui.QTextDocument, /) -> None: ...
    def setDocumentTitle(self, title: str, /) -> None: ...
    def setExtraSelections(self, selections: collections.abc.Sequence[PySide6.QtWidgets.QTextEdit.ExtraSelection], /) -> None: ...
    def setFontFamily(self, fontFamily: str, /) -> None: ...
    def setFontItalic(self, b: bool, /) -> None: ...
    def setFontPointSize(self, s: float, /) -> None: ...
    def setFontUnderline(self, b: bool, /) -> None: ...
    def setFontWeight(self, w: int, /) -> None: ...
    def setHtml(self, text: str, /) -> None: ...
    def setLineWrapColumnOrWidth(self, w: int, /) -> None: ...
    def setLineWrapMode(self, mode: PySide6.QtWidgets.QTextEdit.LineWrapMode, /) -> None: ...
    def setMarkdown(self, markdown: str, /) -> None: ...
    def setOverwriteMode(self, overwrite: bool, /) -> None: ...
    def setPlaceholderText(self, placeholderText: str, /) -> None: ...
    def setPlainText(self, text: str, /) -> None: ...
    def setReadOnly(self, ro: bool, /) -> None: ...
    def setTabChangesFocus(self, b: bool, /) -> None: ...
    def setTabStopDistance(self, distance: float, /) -> None: ...
    def setText(self, text: str, /) -> None: ...
    def setTextBackgroundColor(self, c: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, /) -> None: ...
    def setTextColor(self, c: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, /) -> None: ...
    def setTextCursor(self, cursor: PySide6.QtGui.QTextCursor, /) -> None: ...
    def setTextInteractionFlags(self, flags: PySide6.QtCore.Qt.TextInteractionFlag, /) -> None: ...
    def setUndoRedoEnabled(self, enable: bool, /) -> None: ...
    def setWordWrapMode(self, policy: PySide6.QtGui.QTextOption.WrapMode, /) -> None: ...
    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent, /) -> None: ...
    def tabChangesFocus(self, /) -> bool: ...
    def tabStopDistance(self, /) -> float: ...
    def textBackgroundColor(self, /) -> PySide6.QtGui.QColor: ...
    def textColor(self, /) -> PySide6.QtGui.QColor: ...
    def textCursor(self, /) -> PySide6.QtGui.QTextCursor: ...
    def textInteractionFlags(self, /) -> PySide6.QtCore.Qt.TextInteractionFlag: ...
    def timerEvent(self, e: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def toHtml(self, /) -> str: ...
    def toMarkdown(self, /, features: PySide6.QtGui.QTextDocument.MarkdownFeature = ...) -> str: ...
    def toPlainText(self, /) -> str: ...
    def undo(self, /) -> None: ...
    def wheelEvent(self, e: PySide6.QtGui.QWheelEvent, /) -> None: ...
    def wordWrapMode(self, /) -> PySide6.QtGui.QTextOption.WrapMode: ...
    def zoomIn(self, /, range: int = ...) -> None: ...
    def zoomInF(self, range: float, /) -> None: ...
    def zoomOut(self, /, range: int = ...) -> None: ...


class QTileRules(Shiboken.Object):

    @typing.overload
    def __init__(self, QTileRules: PySide6.QtWidgets.QTileRules, /) -> None: ...
    @typing.overload
    def __init__(self, /, rule: PySide6.QtCore.Qt.TileRule = ...) -> None: ...
    @typing.overload
    def __init__(self, horizontalRule: PySide6.QtCore.Qt.TileRule, verticalRule: PySide6.QtCore.Qt.TileRule, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...


class QTimeEdit(PySide6.QtWidgets.QDateTimeEdit):

    userTimeChanged          : typing.ClassVar[Signal] = ... # userTimeChanged(QTime)

    @typing.overload
    def __init__(self, time: PySide6.QtCore.QTime, /, parent: PySide6.QtWidgets.QWidget | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, time: PySide6.QtCore.QTime | None = ...) -> None: ...


class QToolBar(PySide6.QtWidgets.QWidget):

    actionTriggered          : typing.ClassVar[Signal] = ... # actionTriggered(QAction*)
    allowedAreasChanged      : typing.ClassVar[Signal] = ... # allowedAreasChanged(Qt::ToolBarAreas)
    iconSizeChanged          : typing.ClassVar[Signal] = ... # iconSizeChanged(QSize)
    movableChanged           : typing.ClassVar[Signal] = ... # movableChanged(bool)
    orientationChanged       : typing.ClassVar[Signal] = ... # orientationChanged(Qt::Orientation)
    toolButtonStyleChanged   : typing.ClassVar[Signal] = ... # toolButtonStyleChanged(Qt::ToolButtonStyle)
    topLevelChanged          : typing.ClassVar[Signal] = ... # topLevelChanged(bool)
    visibilityChanged        : typing.ClassVar[Signal] = ... # visibilityChanged(bool)

    @typing.overload
    def __init__(self, title: str, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, movable: bool | None = ..., allowedAreas: PySide6.QtCore.Qt.ToolBarArea | None = ..., orientation: PySide6.QtCore.Qt.Orientation | None = ..., iconSize: PySide6.QtCore.QSize | None = ..., toolButtonStyle: PySide6.QtCore.Qt.ToolButtonStyle | None = ..., floating: bool | None = ..., floatable: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, movable: bool | None = ..., allowedAreas: PySide6.QtCore.Qt.ToolBarArea | None = ..., orientation: PySide6.QtCore.Qt.Orientation | None = ..., iconSize: PySide6.QtCore.QSize | None = ..., toolButtonStyle: PySide6.QtCore.Qt.ToolButtonStyle | None = ..., floating: bool | None = ..., floatable: bool | None = ...) -> None: ...

    @typing.overload
    def actionAt(self, p: PySide6.QtCore.QPoint, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def actionAt(self, x: int, y: int, /) -> PySide6.QtGui.QAction: ...
    def actionEvent(self, event: PySide6.QtGui.QActionEvent, /) -> None: ...
    def actionGeometry(self, action: PySide6.QtGui.QAction, /) -> PySide6.QtCore.QRect: ...
    def addSeparator(self, /) -> PySide6.QtGui.QAction: ...
    def addWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> PySide6.QtGui.QAction: ...
    def allowedAreas(self, /) -> PySide6.QtCore.Qt.ToolBarArea: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def clear(self, /) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def iconSize(self, /) -> PySide6.QtCore.QSize: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionToolBar, /) -> None: ...
    def insertSeparator(self, before: PySide6.QtGui.QAction, /) -> PySide6.QtGui.QAction: ...
    def insertWidget(self, before: PySide6.QtGui.QAction, widget: PySide6.QtWidgets.QWidget, /) -> PySide6.QtGui.QAction: ...
    def isAreaAllowed(self, area: PySide6.QtCore.Qt.ToolBarArea, /) -> bool: ...
    def isFloatable(self, /) -> bool: ...
    def isFloating(self, /) -> bool: ...
    def isMovable(self, /) -> bool: ...
    def orientation(self, /) -> PySide6.QtCore.Qt.Orientation: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def setAllowedAreas(self, areas: PySide6.QtCore.Qt.ToolBarArea, /) -> None: ...
    def setFloatable(self, floatable: bool, /) -> None: ...
    def setIconSize(self, iconSize: PySide6.QtCore.QSize, /) -> None: ...
    def setMovable(self, movable: bool, /) -> None: ...
    def setOrientation(self, orientation: PySide6.QtCore.Qt.Orientation, /) -> None: ...
    def setToolButtonStyle(self, toolButtonStyle: PySide6.QtCore.Qt.ToolButtonStyle, /) -> None: ...
    def toggleViewAction(self, /) -> PySide6.QtGui.QAction: ...
    def toolButtonStyle(self, /) -> PySide6.QtCore.Qt.ToolButtonStyle: ...
    def widgetForAction(self, action: PySide6.QtGui.QAction, /) -> PySide6.QtWidgets.QWidget: ...


class QToolBox(PySide6.QtWidgets.QFrame):

    currentChanged           : typing.ClassVar[Signal] = ... # currentChanged(int)

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., f: PySide6.QtCore.Qt.WindowType = ..., *, currentIndex: int | None = ..., count: int | None = ...) -> None: ...

    @typing.overload
    def addItem(self, widget: PySide6.QtWidgets.QWidget, text: str, /) -> int: ...
    @typing.overload
    def addItem(self, widget: PySide6.QtWidgets.QWidget, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, /) -> int: ...
    def changeEvent(self, arg__1: PySide6.QtCore.QEvent, /) -> None: ...
    def count(self, /) -> int: ...
    def currentIndex(self, /) -> int: ...
    def currentWidget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def indexOf(self, widget: PySide6.QtWidgets.QWidget, /) -> int: ...
    @typing.overload
    def insertItem(self, index: int, widget: PySide6.QtWidgets.QWidget, text: str, /) -> int: ...
    @typing.overload
    def insertItem(self, index: int, widget: PySide6.QtWidgets.QWidget, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, /) -> int: ...
    def isItemEnabled(self, index: int, /) -> bool: ...
    def itemIcon(self, index: int, /) -> PySide6.QtGui.QIcon: ...
    def itemInserted(self, index: int, /) -> None: ...
    def itemRemoved(self, index: int, /) -> None: ...
    def itemText(self, index: int, /) -> str: ...
    def itemToolTip(self, index: int, /) -> str: ...
    def removeItem(self, index: int, /) -> None: ...
    def setCurrentIndex(self, index: int, /) -> None: ...
    def setCurrentWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setItemEnabled(self, index: int, enabled: bool, /) -> None: ...
    def setItemIcon(self, index: int, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, /) -> None: ...
    def setItemText(self, index: int, text: str, /) -> None: ...
    def setItemToolTip(self, index: int, toolTip: str, /) -> None: ...
    def showEvent(self, e: PySide6.QtGui.QShowEvent, /) -> None: ...
    def widget(self, index: int, /) -> PySide6.QtWidgets.QWidget: ...


class QToolButton(PySide6.QtWidgets.QAbstractButton):

    triggered                : typing.ClassVar[Signal] = ... # triggered(QAction*)

    class ToolButtonPopupMode(enum.Enum):

        DelayedPopup              = ...  # 0x0
        MenuButtonPopup           = ...  # 0x1
        InstantPopup              = ...  # 0x2


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, popupMode: PySide6.QtWidgets.QToolButton.ToolButtonPopupMode | None = ..., toolButtonStyle: PySide6.QtCore.Qt.ToolButtonStyle | None = ..., autoRaise: bool | None = ..., arrowType: PySide6.QtCore.Qt.ArrowType | None = ...) -> None: ...

    def actionEvent(self, arg__1: PySide6.QtGui.QActionEvent, /) -> None: ...
    def arrowType(self, /) -> PySide6.QtCore.Qt.ArrowType: ...
    def autoRaise(self, /) -> bool: ...
    def changeEvent(self, arg__1: PySide6.QtCore.QEvent, /) -> None: ...
    def checkStateSet(self, /) -> None: ...
    def defaultAction(self, /) -> PySide6.QtGui.QAction: ...
    def enterEvent(self, arg__1: PySide6.QtGui.QEnterEvent, /) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def hitButton(self, pos: PySide6.QtCore.QPoint, /) -> bool: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionToolButton, /) -> None: ...
    def leaveEvent(self, arg__1: PySide6.QtCore.QEvent, /) -> None: ...
    def menu(self, /) -> PySide6.QtWidgets.QMenu: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def nextCheckState(self, /) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def popupMode(self, /) -> PySide6.QtWidgets.QToolButton.ToolButtonPopupMode: ...
    def setArrowType(self, type: PySide6.QtCore.Qt.ArrowType, /) -> None: ...
    def setAutoRaise(self, enable: bool, /) -> None: ...
    def setDefaultAction(self, arg__1: PySide6.QtGui.QAction, /) -> None: ...
    def setMenu(self, menu: PySide6.QtWidgets.QMenu, /) -> None: ...
    def setPopupMode(self, mode: PySide6.QtWidgets.QToolButton.ToolButtonPopupMode, /) -> None: ...
    def setToolButtonStyle(self, style: PySide6.QtCore.Qt.ToolButtonStyle, /) -> None: ...
    def showMenu(self, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def toolButtonStyle(self, /) -> PySide6.QtCore.Qt.ToolButtonStyle: ...


class QToolTip(Shiboken.Object):
    @staticmethod
    def font() -> PySide6.QtGui.QFont: ...
    @staticmethod
    def hideText() -> None: ...
    @staticmethod
    def isVisible() -> bool: ...
    @staticmethod
    def palette() -> PySide6.QtGui.QPalette: ...
    @staticmethod
    def setFont(arg__1: PySide6.QtGui.QFont | str | collections.abc.Sequence[str], /) -> None: ...
    @staticmethod
    def setPalette(arg__1: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, /) -> None: ...
    @staticmethod
    def showText(pos: PySide6.QtCore.QPoint, text: str, /, w: PySide6.QtWidgets.QWidget | None = ..., rect: PySide6.QtCore.QRect = ..., msecShowTime: int = ...) -> None: ...
    @staticmethod
    def text() -> str: ...


class QTreeView(PySide6.QtWidgets.QAbstractItemView):

    collapsed                : typing.ClassVar[Signal] = ... # collapsed(QModelIndex)
    expanded                 : typing.ClassVar[Signal] = ... # expanded(QModelIndex)

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, autoExpandDelay: int | None = ..., indentation: int | None = ..., rootIsDecorated: bool | None = ..., uniformRowHeights: bool | None = ..., itemsExpandable: bool | None = ..., sortingEnabled: bool | None = ..., animated: bool | None = ..., allColumnsShowFocus: bool | None = ..., wordWrap: bool | None = ..., headerHidden: bool | None = ..., expandsOnDoubleClick: bool | None = ...) -> None: ...

    def allColumnsShowFocus(self, /) -> bool: ...
    def autoExpandDelay(self, /) -> int: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def collapse(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def collapseAll(self, /) -> None: ...
    def columnAt(self, x: int, /) -> int: ...
    def columnCountChanged(self, oldCount: int, newCount: int, /) -> None: ...
    def columnMoved(self, /) -> None: ...
    def columnResized(self, column: int, oldSize: int, newSize: int, /) -> None: ...
    def columnViewportPosition(self, column: int, /) -> int: ...
    def columnWidth(self, column: int, /) -> int: ...
    def currentChanged(self, current: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, previous: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def dataChanged(self, topLeft: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, bottomRight: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, roles: collections.abc.Sequence[int] = ...) -> None: ...
    def doItemsLayout(self, /) -> None: ...
    def dragMoveEvent(self, event: PySide6.QtGui.QDragMoveEvent, /) -> None: ...
    def drawBranches(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def drawRow(self, painter: PySide6.QtGui.QPainter, options: PySide6.QtWidgets.QStyleOptionViewItem, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def drawTree(self, painter: PySide6.QtGui.QPainter, region: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect, /) -> None: ...
    def expand(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def expandAll(self, /) -> None: ...
    def expandRecursively(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, depth: int = ...) -> None: ...
    def expandToDepth(self, depth: int, /) -> None: ...
    def expandsOnDoubleClick(self, /) -> bool: ...
    def header(self, /) -> PySide6.QtWidgets.QHeaderView: ...
    def hideColumn(self, column: int, /) -> None: ...
    def horizontalOffset(self, /) -> int: ...
    def horizontalScrollbarAction(self, action: int, /) -> None: ...
    def indentation(self, /) -> int: ...
    def indexAbove(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def indexAt(self, p: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QModelIndex: ...
    def indexBelow(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def indexRowSizeHint(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> int: ...
    def isAnimated(self, /) -> bool: ...
    def isColumnHidden(self, column: int, /) -> bool: ...
    def isExpanded(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def isFirstColumnSpanned(self, row: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def isHeaderHidden(self, /) -> bool: ...
    def isIndexHidden(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def isRowHidden(self, row: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def isSortingEnabled(self, /) -> bool: ...
    def itemsExpandable(self, /) -> bool: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def keyboardSearch(self, search: str, /) -> None: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def moveCursor(self, cursorAction: PySide6.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide6.QtCore.Qt.KeyboardModifier, /) -> PySide6.QtCore.QModelIndex: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def reexpand(self, /) -> None: ...
    def reset(self, /) -> None: ...
    def resetIndentation(self, /) -> None: ...
    def resizeColumnToContents(self, column: int, /) -> None: ...
    def rootIsDecorated(self, /) -> bool: ...
    def rowHeight(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> int: ...
    def rowsAboutToBeRemoved(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, start: int, end: int, /) -> None: ...
    def rowsInserted(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, start: int, end: int, /) -> None: ...
    def rowsRemoved(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, first: int, last: int, /) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int, /) -> None: ...
    def scrollTo(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectAll(self, /) -> None: ...
    def selectedIndexes(self, /) -> typing.List[PySide6.QtCore.QModelIndex]: ...
    def selectionChanged(self, selected: PySide6.QtCore.QItemSelection, deselected: PySide6.QtCore.QItemSelection, /) -> None: ...
    def setAllColumnsShowFocus(self, enable: bool, /) -> None: ...
    def setAnimated(self, enable: bool, /) -> None: ...
    def setAutoExpandDelay(self, delay: int, /) -> None: ...
    def setColumnHidden(self, column: int, hide: bool, /) -> None: ...
    def setColumnWidth(self, column: int, width: int, /) -> None: ...
    def setExpanded(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, expand: bool, /) -> None: ...
    def setExpandsOnDoubleClick(self, enable: bool, /) -> None: ...
    def setFirstColumnSpanned(self, row: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, span: bool, /) -> None: ...
    def setHeader(self, header: PySide6.QtWidgets.QHeaderView, /) -> None: ...
    def setHeaderHidden(self, hide: bool, /) -> None: ...
    def setIndentation(self, i: int, /) -> None: ...
    def setItemsExpandable(self, enable: bool, /) -> None: ...
    def setModel(self, model: PySide6.QtCore.QAbstractItemModel | None, /) -> None: ...
    def setRootIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def setRootIsDecorated(self, show: bool, /) -> None: ...
    def setRowHidden(self, row: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, hide: bool, /) -> None: ...
    def setSelection(self, rect: PySide6.QtCore.QRect, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag, /) -> None: ...
    def setSelectionModel(self, selectionModel: PySide6.QtCore.QItemSelectionModel, /) -> None: ...
    def setSortingEnabled(self, enable: bool, /) -> None: ...
    def setTreePosition(self, logicalIndex: int, /) -> None: ...
    def setUniformRowHeights(self, uniform: bool, /) -> None: ...
    def setWordWrap(self, on: bool, /) -> None: ...
    def showColumn(self, column: int, /) -> None: ...
    def sizeHintForColumn(self, column: int, /) -> int: ...
    def sortByColumn(self, column: int, order: PySide6.QtCore.Qt.SortOrder, /) -> None: ...
    def timerEvent(self, event: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def treePosition(self, /) -> int: ...
    def uniformRowHeights(self, /) -> bool: ...
    def updateGeometries(self, /) -> None: ...
    def verticalOffset(self, /) -> int: ...
    def verticalScrollbarValueChanged(self, value: int, /) -> None: ...
    def viewportEvent(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def viewportSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def visualRect(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide6.QtCore.QItemSelection, /) -> PySide6.QtGui.QRegion: ...
    def wordWrap(self, /) -> bool: ...


class QTreeWidget(PySide6.QtWidgets.QTreeView):

    currentItemChanged       : typing.ClassVar[Signal] = ... # currentItemChanged(QTreeWidgetItem*,QTreeWidgetItem*)
    itemActivated            : typing.ClassVar[Signal] = ... # itemActivated(QTreeWidgetItem*,int)
    itemChanged              : typing.ClassVar[Signal] = ... # itemChanged(QTreeWidgetItem*,int)
    itemClicked              : typing.ClassVar[Signal] = ... # itemClicked(QTreeWidgetItem*,int)
    itemCollapsed            : typing.ClassVar[Signal] = ... # itemCollapsed(QTreeWidgetItem*)
    itemDoubleClicked        : typing.ClassVar[Signal] = ... # itemDoubleClicked(QTreeWidgetItem*,int)
    itemEntered              : typing.ClassVar[Signal] = ... # itemEntered(QTreeWidgetItem*,int)
    itemExpanded             : typing.ClassVar[Signal] = ... # itemExpanded(QTreeWidgetItem*)
    itemPressed              : typing.ClassVar[Signal] = ... # itemPressed(QTreeWidgetItem*,int)
    itemSelectionChanged     : typing.ClassVar[Signal] = ... # itemSelectionChanged()

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, columnCount: int | None = ..., topLevelItemCount: int | None = ...) -> None: ...

    def addTopLevelItem(self, item: PySide6.QtWidgets.QTreeWidgetItem, /) -> None: ...
    def addTopLevelItems(self, items: collections.abc.Sequence[PySide6.QtWidgets.QTreeWidgetItem], /) -> None: ...
    def clear(self, /) -> None: ...
    def closePersistentEditor(self, item: PySide6.QtWidgets.QTreeWidgetItem, /, column: int | None = ...) -> None: ...
    def collapseItem(self, item: PySide6.QtWidgets.QTreeWidgetItem, /) -> None: ...
    def columnCount(self, /) -> int: ...
    def currentColumn(self, /) -> int: ...
    def currentItem(self, /) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def dropEvent(self, event: PySide6.QtGui.QDropEvent, /) -> None: ...
    def dropMimeData(self, parent: PySide6.QtWidgets.QTreeWidgetItem, index: int, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, /) -> bool: ...
    def editItem(self, item: PySide6.QtWidgets.QTreeWidgetItem, /, column: int | None = ...) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def expandItem(self, item: PySide6.QtWidgets.QTreeWidgetItem, /) -> None: ...
    def findItems(self, text: str, flags: PySide6.QtCore.Qt.MatchFlag, /, column: int | None = ...) -> typing.List[PySide6.QtWidgets.QTreeWidgetItem]: ...
    def headerItem(self, /) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def indexFromItem(self, item: PySide6.QtWidgets.QTreeWidgetItem, /, column: int | None = ...) -> PySide6.QtCore.QModelIndex: ...
    def indexOfTopLevelItem(self, item: PySide6.QtWidgets.QTreeWidgetItem, /) -> int: ...
    def insertTopLevelItem(self, index: int, item: PySide6.QtWidgets.QTreeWidgetItem, /) -> None: ...
    def insertTopLevelItems(self, index: int, items: collections.abc.Sequence[PySide6.QtWidgets.QTreeWidgetItem], /) -> None: ...
    def invisibleRootItem(self, /) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    @typing.overload
    def isPersistentEditorOpen(self, item: PySide6.QtWidgets.QTreeWidgetItem, /, column: int | None = ...) -> bool: ...
    @typing.overload
    def isPersistentEditorOpen(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def itemAbove(self, item: PySide6.QtWidgets.QTreeWidgetItem, /) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    @typing.overload
    def itemAt(self, p: PySide6.QtCore.QPoint, /) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    @typing.overload
    def itemAt(self, x: int, y: int, /) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def itemBelow(self, item: PySide6.QtWidgets.QTreeWidgetItem, /) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def itemFromIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def itemWidget(self, item: PySide6.QtWidgets.QTreeWidgetItem, column: int, /) -> PySide6.QtWidgets.QWidget: ...
    def mimeData(self, items: collections.abc.Sequence[PySide6.QtWidgets.QTreeWidgetItem], /) -> PySide6.QtCore.QMimeData: ...
    def mimeTypes(self, /) -> typing.List[str]: ...
    def openPersistentEditor(self, item: PySide6.QtWidgets.QTreeWidgetItem, /, column: int | None = ...) -> None: ...
    def removeItemWidget(self, item: PySide6.QtWidgets.QTreeWidgetItem, column: int, /) -> None: ...
    def scrollToItem(self, item: PySide6.QtWidgets.QTreeWidgetItem, /, hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectedItems(self, /) -> typing.List[PySide6.QtWidgets.QTreeWidgetItem]: ...
    def setColumnCount(self, columns: int, /) -> None: ...
    @typing.overload
    def setCurrentItem(self, item: PySide6.QtWidgets.QTreeWidgetItem, /) -> None: ...
    @typing.overload
    def setCurrentItem(self, item: PySide6.QtWidgets.QTreeWidgetItem, column: int, /) -> None: ...
    @typing.overload
    def setCurrentItem(self, item: PySide6.QtWidgets.QTreeWidgetItem, column: int, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag, /) -> None: ...
    def setHeaderItem(self, item: PySide6.QtWidgets.QTreeWidgetItem, /) -> None: ...
    def setHeaderLabel(self, label: str, /) -> None: ...
    def setHeaderLabels(self, labels: collections.abc.Sequence[str], /) -> None: ...
    def setItemWidget(self, item: PySide6.QtWidgets.QTreeWidgetItem, column: int, widget: PySide6.QtWidgets.QWidget | None, /) -> None: ...
    def setModel(self, model: PySide6.QtCore.QAbstractItemModel | None, /) -> None: ...
    def setSelectionModel(self, selectionModel: PySide6.QtCore.QItemSelectionModel, /) -> None: ...
    def sortColumn(self, /) -> int: ...
    def sortItems(self, column: int, order: PySide6.QtCore.Qt.SortOrder, /) -> None: ...
    def supportedDropActions(self, /) -> PySide6.QtCore.Qt.DropAction: ...
    def takeTopLevelItem(self, index: int, /) -> PySide6.QtWidgets.QTreeWidgetItem | None: ...
    def topLevelItem(self, index: int, /) -> PySide6.QtWidgets.QTreeWidgetItem | None: ...
    def topLevelItemCount(self, /) -> int: ...
    def visualItemRect(self, item: PySide6.QtWidgets.QTreeWidgetItem, /) -> PySide6.QtCore.QRect: ...


class QTreeWidgetItem(Shiboken.Object):

    class ChildIndicatorPolicy(enum.Enum):

        ShowIndicator             = ...  # 0x0
        DontShowIndicator         = ...  # 0x1
        DontShowIndicatorWhenChildless = ...  # 0x2

    class ItemType(enum.IntEnum):

        Type                      = ...  # 0x0
        UserType                  = ...  # 0x3e8


    @typing.overload
    def __init__(self, treeview: PySide6.QtWidgets.QTreeWidget, after: PySide6.QtWidgets.QTreeWidgetItem, /, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, treeview: PySide6.QtWidgets.QTreeWidget, strings: collections.abc.Sequence[str], /, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, treeview: PySide6.QtWidgets.QTreeWidget, /, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtWidgets.QTreeWidgetItem, /) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtWidgets.QTreeWidgetItem, after: PySide6.QtWidgets.QTreeWidgetItem, /, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtWidgets.QTreeWidgetItem, strings: collections.abc.Sequence[str], /, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtWidgets.QTreeWidgetItem, /, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, strings: collections.abc.Sequence[str], /, type: int = ...) -> None: ...
    @typing.overload
    def __init__(self, /, type: int = ...) -> None: ...

    def __hash__(self, /) -> int: ...
    def __lshift__(self, out: PySide6.QtCore.QDataStream, /) -> PySide6.QtCore.QDataStream: ...
    def __lt__(self, other: PySide6.QtWidgets.QTreeWidgetItem, /) -> bool: ...
    def __rshift__(self, in_: PySide6.QtCore.QDataStream, /) -> PySide6.QtCore.QDataStream: ...
    def addChild(self, child: PySide6.QtWidgets.QTreeWidgetItem, /) -> None: ...
    def addChildren(self, children: collections.abc.Sequence[PySide6.QtWidgets.QTreeWidgetItem], /) -> None: ...
    def background(self, column: int, /) -> PySide6.QtGui.QBrush: ...
    def checkState(self, column: int, /) -> PySide6.QtCore.Qt.CheckState: ...
    def child(self, index: int, /) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def childCount(self, /) -> int: ...
    def childIndicatorPolicy(self, /) -> PySide6.QtWidgets.QTreeWidgetItem.ChildIndicatorPolicy: ...
    def clone(self, /) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def columnCount(self, /) -> int: ...
    def data(self, column: int, role: int, /) -> typing.Any: ...
    def emitDataChanged(self, /) -> None: ...
    def flags(self, /) -> PySide6.QtCore.Qt.ItemFlag: ...
    def font(self, column: int, /) -> PySide6.QtGui.QFont: ...
    def foreground(self, column: int, /) -> PySide6.QtGui.QBrush: ...
    def icon(self, column: int, /) -> PySide6.QtGui.QIcon: ...
    def indexOfChild(self, child: PySide6.QtWidgets.QTreeWidgetItem, /) -> int: ...
    def insertChild(self, index: int, child: PySide6.QtWidgets.QTreeWidgetItem, /) -> None: ...
    def insertChildren(self, index: int, children: collections.abc.Sequence[PySide6.QtWidgets.QTreeWidgetItem], /) -> None: ...
    def isDisabled(self, /) -> bool: ...
    def isExpanded(self, /) -> bool: ...
    def isFirstColumnSpanned(self, /) -> bool: ...
    def isHidden(self, /) -> bool: ...
    def isSelected(self, /) -> bool: ...
    def parent(self, /) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def read(self, in_: PySide6.QtCore.QDataStream, /) -> None: ...
    def removeChild(self, child: PySide6.QtWidgets.QTreeWidgetItem, /) -> None: ...
    def setBackground(self, column: int, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, /) -> None: ...
    def setCheckState(self, column: int, state: PySide6.QtCore.Qt.CheckState, /) -> None: ...
    def setChildIndicatorPolicy(self, policy: PySide6.QtWidgets.QTreeWidgetItem.ChildIndicatorPolicy, /) -> None: ...
    def setData(self, column: int, role: int, value: typing.Any, /) -> None: ...
    def setDisabled(self, disabled: bool, /) -> None: ...
    def setExpanded(self, expand: bool, /) -> None: ...
    def setFirstColumnSpanned(self, span: bool, /) -> None: ...
    def setFlags(self, flags: PySide6.QtCore.Qt.ItemFlag, /) -> None: ...
    def setFont(self, column: int, font: PySide6.QtGui.QFont | str | collections.abc.Sequence[str], /) -> None: ...
    def setForeground(self, column: int, brush: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap, /) -> None: ...
    def setHidden(self, hide: bool, /) -> None: ...
    def setIcon(self, column: int, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, /) -> None: ...
    def setSelected(self, select: bool, /) -> None: ...
    def setSizeHint(self, column: int, size: PySide6.QtCore.QSize, /) -> None: ...
    def setStatusTip(self, column: int, statusTip: str, /) -> None: ...
    def setText(self, column: int, text: str, /) -> None: ...
    @typing.overload
    def setTextAlignment(self, column: int, alignment: PySide6.QtCore.Qt.AlignmentFlag, /) -> None: ...
    @typing.overload
    def setTextAlignment(self, column: int, alignment: int, /) -> None: ...
    def setToolTip(self, column: int, toolTip: str, /) -> None: ...
    def setWhatsThis(self, column: int, whatsThis: str, /) -> None: ...
    def sizeHint(self, column: int, /) -> PySide6.QtCore.QSize: ...
    def sortChildren(self, column: int, order: PySide6.QtCore.Qt.SortOrder, /) -> None: ...
    def statusTip(self, column: int, /) -> str: ...
    def takeChild(self, index: int, /) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def takeChildren(self, /) -> typing.List[PySide6.QtWidgets.QTreeWidgetItem]: ...
    def text(self, column: int, /) -> str: ...
    def textAlignment(self, column: int, /) -> int: ...
    def toolTip(self, column: int, /) -> str: ...
    def treeWidget(self, /) -> PySide6.QtWidgets.QTreeWidget: ...
    def type(self, /) -> int: ...
    def whatsThis(self, column: int, /) -> str: ...
    def write(self, out: PySide6.QtCore.QDataStream, /) -> None: ...


class QTreeWidgetItemIterator(Shiboken.Object):

    class IteratorFlag(enum.Flag):

        All                       = ...  # 0x0
        Hidden                    = ...  # 0x1
        NotHidden                 = ...  # 0x2
        Selected                  = ...  # 0x4
        Unselected                = ...  # 0x8
        Selectable                = ...  # 0x10
        NotSelectable             = ...  # 0x20
        DragEnabled               = ...  # 0x40
        DragDisabled              = ...  # 0x80
        DropEnabled               = ...  # 0x100
        DropDisabled              = ...  # 0x200
        HasChildren               = ...  # 0x400
        NoChildren                = ...  # 0x800
        Checked                   = ...  # 0x1000
        NotChecked                = ...  # 0x2000
        Enabled                   = ...  # 0x4000
        Disabled                  = ...  # 0x8000
        Editable                  = ...  # 0x10000
        NotEditable               = ...  # 0x20000
        UserFlag                  = ...  # 0x1000000


    @typing.overload
    def __init__(self, widget: PySide6.QtWidgets.QTreeWidget, /, flags: PySide6.QtWidgets.QTreeWidgetItemIterator.IteratorFlag = ...) -> None: ...
    @typing.overload
    def __init__(self, item: PySide6.QtWidgets.QTreeWidgetItem, /, flags: PySide6.QtWidgets.QTreeWidgetItemIterator.IteratorFlag = ...) -> None: ...
    @typing.overload
    def __init__(self, it: PySide6.QtWidgets.QTreeWidgetItemIterator, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __iadd__(self, n: int, /) -> PySide6.QtWidgets.QTreeWidgetItemIterator: ...
    def __isub__(self, n: int, /) -> PySide6.QtWidgets.QTreeWidgetItemIterator: ...
    def __iter__(self, /) -> object: ...
    def __next__(self, /) -> object: ...
    def value(self, /) -> PySide6.QtWidgets.QTreeWidgetItem: ...


class QUndoView(PySide6.QtWidgets.QListView):

    @typing.overload
    def __init__(self, group: PySide6.QtGui.QUndoGroup, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, emptyLabel: str | None = ..., cleanIcon: PySide6.QtGui.QIcon | None = ...) -> None: ...
    @typing.overload
    def __init__(self, stack: PySide6.QtGui.QUndoStack, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, emptyLabel: str | None = ..., cleanIcon: PySide6.QtGui.QIcon | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, emptyLabel: str | None = ..., cleanIcon: PySide6.QtGui.QIcon | None = ...) -> None: ...

    def cleanIcon(self, /) -> PySide6.QtGui.QIcon: ...
    def emptyLabel(self, /) -> str: ...
    def group(self, /) -> PySide6.QtGui.QUndoGroup: ...
    def setCleanIcon(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, /) -> None: ...
    def setEmptyLabel(self, label: str, /) -> None: ...
    def setGroup(self, group: PySide6.QtGui.QUndoGroup, /) -> None: ...
    def setStack(self, stack: PySide6.QtGui.QUndoStack, /) -> None: ...
    def stack(self, /) -> PySide6.QtGui.QUndoStack: ...


class QVBoxLayout(PySide6.QtWidgets.QBoxLayout):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtWidgets.QWidget, /) -> None: ...


class QWhatsThis(Shiboken.Object):
    @staticmethod
    def createAction(parent: PySide6.QtCore.QObject | None = ...) -> PySide6.QtGui.QAction: ...
    @staticmethod
    def enterWhatsThisMode() -> None: ...
    @staticmethod
    def hideText() -> None: ...
    @staticmethod
    def inWhatsThisMode() -> bool: ...
    @staticmethod
    def leaveWhatsThisMode() -> None: ...
    @staticmethod
    def showText(pos: PySide6.QtCore.QPoint, text: str, /, w: PySide6.QtWidgets.QWidget | None = ...) -> None: ...


class QWidget(PySide6.QtCore.QObject, PySide6.QtGui.QPaintDevice):

    customContextMenuRequested: typing.ClassVar[Signal] = ... # customContextMenuRequested(QPoint)
    windowIconChanged        : typing.ClassVar[Signal] = ... # windowIconChanged(QIcon)
    windowIconTextChanged    : typing.ClassVar[Signal] = ... # windowIconTextChanged(QString)
    windowTitleChanged       : typing.ClassVar[Signal] = ... # windowTitleChanged(QString)

    class RenderFlag(enum.Flag):

        DrawWindowBackground      = ...  # 0x1
        DrawChildren              = ...  # 0x2
        IgnoreMask                = ...  # 0x4


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., f: PySide6.QtCore.Qt.WindowType = ..., *, modal: bool | None = ..., windowModality: PySide6.QtCore.Qt.WindowModality | None = ..., enabled: bool | None = ..., geometry: PySide6.QtCore.QRect | None = ..., frameGeometry: PySide6.QtCore.QRect | None = ..., normalGeometry: PySide6.QtCore.QRect | None = ..., x: int | None = ..., y: int | None = ..., pos: PySide6.QtCore.QPoint | None = ..., frameSize: PySide6.QtCore.QSize | None = ..., size: PySide6.QtCore.QSize | None = ..., width: int | None = ..., height: int | None = ..., rect: PySide6.QtCore.QRect | None = ..., childrenRect: PySide6.QtCore.QRect | None = ..., childrenRegion: PySide6.QtGui.QRegion | None = ..., sizePolicy: PySide6.QtWidgets.QSizePolicy | None = ..., minimumSize: PySide6.QtCore.QSize | None = ..., maximumSize: PySide6.QtCore.QSize | None = ..., minimumWidth: int | None = ..., minimumHeight: int | None = ..., maximumWidth: int | None = ..., maximumHeight: int | None = ..., sizeIncrement: PySide6.QtCore.QSize | None = ..., baseSize: PySide6.QtCore.QSize | None = ..., palette: PySide6.QtGui.QPalette | None = ..., font: PySide6.QtGui.QFont | None = ..., cursor: PySide6.QtGui.QCursor | None = ..., mouseTracking: bool | None = ..., tabletTracking: bool | None = ..., isActiveWindow: bool | None = ..., focusPolicy: PySide6.QtCore.Qt.FocusPolicy | None = ..., focus: bool | None = ..., contextMenuPolicy: PySide6.QtCore.Qt.ContextMenuPolicy | None = ..., updatesEnabled: bool | None = ..., visible: bool | None = ..., minimized: bool | None = ..., maximized: bool | None = ..., fullScreen: bool | None = ..., sizeHint: PySide6.QtCore.QSize | None = ..., minimumSizeHint: PySide6.QtCore.QSize | None = ..., acceptDrops: bool | None = ..., windowTitle: str | None = ..., windowIcon: PySide6.QtGui.QIcon | None = ..., windowIconText: str | None = ..., windowOpacity: float | None = ..., windowModified: bool | None = ..., toolTip: str | None = ..., toolTipDuration: int | None = ..., statusTip: str | None = ..., whatsThis: str | None = ..., accessibleName: str | None = ..., accessibleDescription: str | None = ..., accessibleIdentifier: str | None = ..., layoutDirection: PySide6.QtCore.Qt.LayoutDirection | None = ..., autoFillBackground: bool | None = ..., styleSheet: str | None = ..., locale: PySide6.QtCore.QLocale | None = ..., windowFilePath: str | None = ..., inputMethodHints: PySide6.QtCore.Qt.InputMethodHint | None = ...) -> None: ...

    def __repr__(self, /) -> str: ...
    def acceptDrops(self, /) -> bool: ...
    def accessibleDescription(self, /) -> str: ...
    def accessibleIdentifier(self, /) -> str: ...
    def accessibleName(self, /) -> str: ...
    def actionEvent(self, event: PySide6.QtGui.QActionEvent, /) -> None: ...
    def actions(self, /) -> typing.List[PySide6.QtGui.QAction]: ...
    def activateWindow(self, /) -> None: ...
    @typing.overload
    def addAction(self, action: PySide6.QtGui.QAction, /) -> None: ...
    @typing.overload
    def addAction(self, text: str, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, text: str, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, text: str, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, text: str, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, text: str, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, callable: object, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, text: str, callable: object, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, shortcut: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, callable: object, /) -> PySide6.QtGui.QAction: ...
    @typing.overload
    def addAction(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, text: str, callable: object, /) -> PySide6.QtGui.QAction: ...
    def addActions(self, actions: collections.abc.Sequence[PySide6.QtGui.QAction], /) -> None: ...
    def adjustSize(self, /) -> None: ...
    def autoFillBackground(self, /) -> bool: ...
    def backgroundRole(self, /) -> PySide6.QtGui.QPalette.ColorRole: ...
    def backingStore(self, /) -> PySide6.QtGui.QBackingStore: ...
    def baseSize(self, /) -> PySide6.QtCore.QSize: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    @typing.overload
    def childAt(self, p: PySide6.QtCore.QPoint, /) -> PySide6.QtWidgets.QWidget | None: ...
    @typing.overload
    def childAt(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> PySide6.QtWidgets.QWidget | None: ...
    @typing.overload
    def childAt(self, x: int, y: int, /) -> PySide6.QtWidgets.QWidget | None: ...
    def childrenRect(self, /) -> PySide6.QtCore.QRect: ...
    def childrenRegion(self, /) -> PySide6.QtGui.QRegion: ...
    def clearFocus(self, /) -> None: ...
    def clearMask(self, /) -> None: ...
    def close(self, /) -> bool: ...
    def closeEvent(self, event: PySide6.QtGui.QCloseEvent, /) -> None: ...
    def contentsMargins(self, /) -> PySide6.QtCore.QMargins: ...
    def contentsRect(self, /) -> PySide6.QtCore.QRect: ...
    def contextMenuEvent(self, event: PySide6.QtGui.QContextMenuEvent, /) -> None: ...
    def contextMenuPolicy(self, /) -> PySide6.QtCore.Qt.ContextMenuPolicy: ...
    def create(self, /, arg__1: int | None = ..., initializeWindow: bool = ..., destroyOldWindow: bool = ...) -> None: ...
    def createWinId(self, /) -> None: ...
    @staticmethod
    def createWindowContainer(window: PySide6.QtGui.QWindow, /, parent: PySide6.QtWidgets.QWidget | None = ..., flags: PySide6.QtCore.Qt.WindowType = ...) -> PySide6.QtWidgets.QWidget: ...
    def cursor(self, /) -> PySide6.QtGui.QCursor: ...
    def destroy(self, /, destroyWindow: bool = ..., destroySubWindows: bool = ...) -> None: ...
    def devType(self, /) -> int: ...
    def dragEnterEvent(self, event: PySide6.QtGui.QDragEnterEvent, /) -> None: ...
    def dragLeaveEvent(self, event: PySide6.QtGui.QDragLeaveEvent, /) -> None: ...
    def dragMoveEvent(self, event: PySide6.QtGui.QDragMoveEvent, /) -> None: ...
    def dropEvent(self, event: PySide6.QtGui.QDropEvent, /) -> None: ...
    def effectiveWinId(self, /) -> int: ...
    def ensurePolished(self, /) -> None: ...
    def enterEvent(self, event: PySide6.QtGui.QEnterEvent, /) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    @staticmethod
    def find(arg__1: int, /) -> PySide6.QtWidgets.QWidget | None: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusNextChild(self, /) -> bool: ...
    def focusNextPrevChild(self, next: bool, /) -> bool: ...
    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent, /) -> None: ...
    def focusPolicy(self, /) -> PySide6.QtCore.Qt.FocusPolicy: ...
    def focusPreviousChild(self, /) -> bool: ...
    def focusProxy(self, /) -> PySide6.QtWidgets.QWidget | None: ...
    def focusWidget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def font(self, /) -> PySide6.QtGui.QFont: ...
    def fontInfo(self, /) -> PySide6.QtGui.QFontInfo: ...
    def fontMetrics(self, /) -> PySide6.QtGui.QFontMetrics: ...
    def foregroundRole(self, /) -> PySide6.QtGui.QPalette.ColorRole: ...
    def frameGeometry(self, /) -> PySide6.QtCore.QRect: ...
    def frameSize(self, /) -> PySide6.QtCore.QSize: ...
    def geometry(self, /) -> PySide6.QtCore.QRect: ...
    def grab(self, /, rectangle: PySide6.QtCore.QRect = ...) -> PySide6.QtGui.QPixmap: ...
    def grabGesture(self, type: PySide6.QtCore.Qt.GestureType, /, flags: PySide6.QtCore.Qt.GestureFlag = ...) -> None: ...
    def grabKeyboard(self, /) -> None: ...
    @typing.overload
    def grabMouse(self, /) -> None: ...
    @typing.overload
    def grabMouse(self, arg__1: PySide6.QtGui.QCursor | PySide6.QtCore.Qt.CursorShape | PySide6.QtGui.QPixmap, /) -> None: ...
    def grabShortcut(self, key: PySide6.QtGui.QKeySequence | PySide6.QtCore.QKeyCombination | PySide6.QtGui.QKeySequence.StandardKey | str | int, /, context: PySide6.QtCore.Qt.ShortcutContext = ...) -> int: ...
    def graphicsEffect(self, /) -> PySide6.QtWidgets.QGraphicsEffect | None: ...
    def graphicsProxyWidget(self, /) -> PySide6.QtWidgets.QGraphicsProxyWidget | None: ...
    def hasFocus(self, /) -> bool: ...
    def hasHeightForWidth(self, /) -> bool: ...
    def hasMouseTracking(self, /) -> bool: ...
    def hasTabletTracking(self, /) -> bool: ...
    def height(self, /) -> int: ...
    def heightForWidth(self, arg__1: int, /) -> int: ...
    def hide(self, /) -> None: ...
    def hideEvent(self, event: PySide6.QtGui.QHideEvent, /) -> None: ...
    def initPainter(self, painter: PySide6.QtGui.QPainter, /) -> None: ...
    def inputMethodEvent(self, event: PySide6.QtGui.QInputMethodEvent, /) -> None: ...
    def inputMethodHints(self, /) -> PySide6.QtCore.Qt.InputMethodHint: ...
    def inputMethodQuery(self, arg__1: PySide6.QtCore.Qt.InputMethodQuery, /) -> typing.Any: ...
    def insertAction(self, before: PySide6.QtGui.QAction, action: PySide6.QtGui.QAction, /) -> None: ...
    def insertActions(self, before: PySide6.QtGui.QAction, actions: collections.abc.Sequence[PySide6.QtGui.QAction], /) -> None: ...
    def internalWinId(self, /) -> int: ...
    def isActiveWindow(self, /) -> bool: ...
    def isAncestorOf(self, child: PySide6.QtWidgets.QWidget, /) -> bool: ...
    def isEnabled(self, /) -> bool: ...
    def isEnabledTo(self, arg__1: PySide6.QtWidgets.QWidget, /) -> bool: ...
    def isFullScreen(self, /) -> bool: ...
    def isHidden(self, /) -> bool: ...
    def isLeftToRight(self, /) -> bool: ...
    def isMaximized(self, /) -> bool: ...
    def isMinimized(self, /) -> bool: ...
    def isModal(self, /) -> bool: ...
    def isRightToLeft(self, /) -> bool: ...
    def isTopLevel(self, /) -> bool: ...
    def isVisible(self, /) -> bool: ...
    def isVisibleTo(self, arg__1: PySide6.QtWidgets.QWidget, /) -> bool: ...
    def isWindow(self, /) -> bool: ...
    def isWindowModified(self, /) -> bool: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    def keyReleaseEvent(self, event: PySide6.QtGui.QKeyEvent, /) -> None: ...
    @staticmethod
    def keyboardGrabber() -> PySide6.QtWidgets.QWidget | None: ...
    def layout(self, /) -> PySide6.QtWidgets.QLayout | None: ...
    def layoutDirection(self, /) -> PySide6.QtCore.Qt.LayoutDirection: ...
    def leaveEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def locale(self, /) -> PySide6.QtCore.QLocale: ...
    def lower(self, /) -> None: ...
    @typing.overload
    def mapFrom(self, arg__1: PySide6.QtWidgets.QWidget, arg__2: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def mapFrom(self, arg__1: PySide6.QtWidgets.QWidget, arg__2: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapFromGlobal(self, arg__1: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def mapFromGlobal(self, arg__1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapFromParent(self, arg__1: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def mapFromParent(self, arg__1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapTo(self, arg__1: PySide6.QtWidgets.QWidget, arg__2: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def mapTo(self, arg__1: PySide6.QtWidgets.QWidget, arg__2: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapToGlobal(self, arg__1: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def mapToGlobal(self, arg__1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def mapToParent(self, arg__1: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def mapToParent(self, arg__1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint | PySide6.QtGui.QPainterPath.Element, /) -> PySide6.QtCore.QPointF: ...
    def mask(self, /) -> PySide6.QtGui.QRegion: ...
    def maximumHeight(self, /) -> int: ...
    def maximumSize(self, /) -> PySide6.QtCore.QSize: ...
    def maximumWidth(self, /) -> int: ...
    def metric(self, arg__1: PySide6.QtGui.QPaintDevice.PaintDeviceMetric, /) -> int: ...
    def minimumHeight(self, /) -> int: ...
    def minimumSize(self, /) -> PySide6.QtCore.QSize: ...
    def minimumSizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def minimumWidth(self, /) -> int: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    @staticmethod
    def mouseGrabber() -> PySide6.QtWidgets.QWidget | None: ...
    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent, /) -> None: ...
    @typing.overload
    def move(self, arg__1: PySide6.QtCore.QPoint, /) -> None: ...
    @typing.overload
    def move(self, x: int, y: int, /) -> None: ...
    def moveEvent(self, event: PySide6.QtGui.QMoveEvent, /) -> None: ...
    def nativeEvent(self, eventType: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, message: int, /) -> object: ...
    def nativeParentWidget(self, /) -> PySide6.QtWidgets.QWidget | None: ...
    def nextInFocusChain(self, /) -> PySide6.QtWidgets.QWidget | None: ...
    def normalGeometry(self, /) -> PySide6.QtCore.QRect: ...
    def overrideWindowFlags(self, type: PySide6.QtCore.Qt.WindowType, /) -> None: ...
    def overrideWindowState(self, state: PySide6.QtCore.Qt.WindowState, /) -> None: ...
    def paintEngine(self, /) -> PySide6.QtGui.QPaintEngine: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def palette(self, /) -> PySide6.QtGui.QPalette: ...
    def parentWidget(self, /) -> PySide6.QtWidgets.QWidget | None: ...
    def pos(self, /) -> PySide6.QtCore.QPoint: ...
    def previousInFocusChain(self, /) -> PySide6.QtWidgets.QWidget | None: ...
    def raise_(self, /) -> None: ...
    def rect(self, /) -> PySide6.QtCore.QRect: ...
    def redirected(self, offset: PySide6.QtCore.QPoint, /) -> PySide6.QtGui.QPaintDevice: ...
    def releaseKeyboard(self, /) -> None: ...
    def releaseMouse(self, /) -> None: ...
    def releaseShortcut(self, id: int, /) -> None: ...
    def removeAction(self, action: PySide6.QtGui.QAction, /) -> None: ...
    @typing.overload
    def render(self, target: PySide6.QtGui.QPaintDevice, /, targetOffset: PySide6.QtCore.QPoint = ..., sourceRegion: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect = ..., renderFlags: PySide6.QtWidgets.QWidget.RenderFlag = ...) -> None: ...
    @typing.overload
    def render(self, painter: PySide6.QtGui.QPainter, targetOffset: PySide6.QtCore.QPoint, /, sourceRegion: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect = ..., renderFlags: PySide6.QtWidgets.QWidget.RenderFlag = ...) -> None: ...
    @typing.overload
    def repaint(self, /) -> None: ...
    @typing.overload
    def repaint(self, arg__1: PySide6.QtCore.QRect, /) -> None: ...
    @typing.overload
    def repaint(self, arg__1: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect, /) -> None: ...
    @typing.overload
    def repaint(self, x: int, y: int, w: int, h: int, /) -> None: ...
    @typing.overload
    def resize(self, arg__1: PySide6.QtCore.QSize, /) -> None: ...
    @typing.overload
    def resize(self, w: int, h: int, /) -> None: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def restoreGeometry(self, geometry: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bool: ...
    def saveGeometry(self, /) -> PySide6.QtCore.QByteArray: ...
    def screen(self, /) -> PySide6.QtGui.QScreen: ...
    @typing.overload
    def scroll(self, dx: int, dy: int, /) -> None: ...
    @typing.overload
    def scroll(self, dx: int, dy: int, arg__3: PySide6.QtCore.QRect, /) -> None: ...
    def setAcceptDrops(self, on: bool, /) -> None: ...
    def setAccessibleDescription(self, description: str, /) -> None: ...
    def setAccessibleIdentifier(self, identifier: str, /) -> None: ...
    def setAccessibleName(self, name: str, /) -> None: ...
    def setAttribute(self, arg__1: PySide6.QtCore.Qt.WidgetAttribute, /, on: bool = ...) -> None: ...
    def setAutoFillBackground(self, enabled: bool, /) -> None: ...
    def setBackgroundRole(self, arg__1: PySide6.QtGui.QPalette.ColorRole, /) -> None: ...
    @typing.overload
    def setBaseSize(self, arg__1: PySide6.QtCore.QSize, /) -> None: ...
    @typing.overload
    def setBaseSize(self, basew: int, baseh: int, /) -> None: ...
    @typing.overload
    def setContentsMargins(self, margins: PySide6.QtCore.QMargins, /) -> None: ...
    @typing.overload
    def setContentsMargins(self, left: int, top: int, right: int, bottom: int, /) -> None: ...
    def setContextMenuPolicy(self, policy: PySide6.QtCore.Qt.ContextMenuPolicy, /) -> None: ...
    def setCursor(self, arg__1: PySide6.QtGui.QCursor | PySide6.QtCore.Qt.CursorShape | PySide6.QtGui.QPixmap, /) -> None: ...
    def setDisabled(self, arg__1: bool, /) -> None: ...
    def setEnabled(self, arg__1: bool, /) -> None: ...
    def setFixedHeight(self, h: int, /) -> None: ...
    @typing.overload
    def setFixedSize(self, arg__1: PySide6.QtCore.QSize, /) -> None: ...
    @typing.overload
    def setFixedSize(self, w: int, h: int, /) -> None: ...
    def setFixedWidth(self, w: int, /) -> None: ...
    @typing.overload
    def setFocus(self, /) -> None: ...
    @typing.overload
    def setFocus(self, reason: PySide6.QtCore.Qt.FocusReason, /) -> None: ...
    def setFocusPolicy(self, policy: PySide6.QtCore.Qt.FocusPolicy, /) -> None: ...
    def setFocusProxy(self, arg__1: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setFont(self, arg__1: PySide6.QtGui.QFont | str | collections.abc.Sequence[str], /) -> None: ...
    def setForegroundRole(self, arg__1: PySide6.QtGui.QPalette.ColorRole, /) -> None: ...
    @typing.overload
    def setGeometry(self, arg__1: PySide6.QtCore.QRect, /) -> None: ...
    @typing.overload
    def setGeometry(self, x: int, y: int, w: int, h: int, /) -> None: ...
    def setGraphicsEffect(self, effect: PySide6.QtWidgets.QGraphicsEffect, /) -> None: ...
    def setHidden(self, hidden: bool, /) -> None: ...
    def setInputMethodHints(self, hints: PySide6.QtCore.Qt.InputMethodHint, /) -> None: ...
    def setLayout(self, arg__1: PySide6.QtWidgets.QLayout, /) -> None: ...
    def setLayoutDirection(self, direction: PySide6.QtCore.Qt.LayoutDirection, /) -> None: ...
    def setLocale(self, locale: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language, /) -> None: ...
    @typing.overload
    def setMask(self, arg__1: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect, /) -> None: ...
    @typing.overload
    def setMask(self, arg__1: PySide6.QtGui.QBitmap | str, /) -> None: ...
    def setMaximumHeight(self, maxh: int, /) -> None: ...
    @typing.overload
    def setMaximumSize(self, arg__1: PySide6.QtCore.QSize, /) -> None: ...
    @typing.overload
    def setMaximumSize(self, maxw: int, maxh: int, /) -> None: ...
    def setMaximumWidth(self, maxw: int, /) -> None: ...
    def setMinimumHeight(self, minh: int, /) -> None: ...
    @typing.overload
    def setMinimumSize(self, arg__1: PySide6.QtCore.QSize, /) -> None: ...
    @typing.overload
    def setMinimumSize(self, minw: int, minh: int, /) -> None: ...
    def setMinimumWidth(self, minw: int, /) -> None: ...
    def setMouseTracking(self, enable: bool, /) -> None: ...
    def setPalette(self, arg__1: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, /) -> None: ...
    @typing.overload
    def setParent(self, parent: PySide6.QtWidgets.QWidget | None, /) -> None: ...
    @typing.overload
    def setParent(self, parent: PySide6.QtWidgets.QWidget | None, f: PySide6.QtCore.Qt.WindowType, /) -> None: ...
    def setScreen(self, arg__1: PySide6.QtGui.QScreen, /) -> None: ...
    def setShortcutAutoRepeat(self, id: int, /, enable: bool = ...) -> None: ...
    def setShortcutEnabled(self, id: int, /, enable: bool = ...) -> None: ...
    @typing.overload
    def setSizeIncrement(self, arg__1: PySide6.QtCore.QSize, /) -> None: ...
    @typing.overload
    def setSizeIncrement(self, w: int, h: int, /) -> None: ...
    @typing.overload
    def setSizePolicy(self, horizontal: PySide6.QtWidgets.QSizePolicy.Policy, vertical: PySide6.QtWidgets.QSizePolicy.Policy, /) -> None: ...
    @typing.overload
    def setSizePolicy(self, arg__1: PySide6.QtWidgets.QSizePolicy, /) -> None: ...
    def setStatusTip(self, arg__1: str, /) -> None: ...
    def setStyle(self, arg__1: PySide6.QtWidgets.QStyle, /) -> None: ...
    def setStyleSheet(self, styleSheet: str, /) -> None: ...
    @staticmethod
    def setTabOrder(arg__1: PySide6.QtWidgets.QWidget, arg__2: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setTabletTracking(self, enable: bool, /) -> None: ...
    def setToolTip(self, arg__1: str, /) -> None: ...
    def setToolTipDuration(self, msec: int, /) -> None: ...
    def setUpdatesEnabled(self, enable: bool, /) -> None: ...
    def setVisible(self, visible: bool, /) -> None: ...
    def setWhatsThis(self, arg__1: str, /) -> None: ...
    def setWindowFilePath(self, filePath: str, /) -> None: ...
    def setWindowFlag(self, arg__1: PySide6.QtCore.Qt.WindowType, /, on: bool = ...) -> None: ...
    def setWindowFlags(self, type: PySide6.QtCore.Qt.WindowType, /) -> None: ...
    def setWindowIcon(self, icon: PySide6.QtGui.QIcon | PySide6.QtGui.QPixmap, /) -> None: ...
    def setWindowIconText(self, arg__1: str, /) -> None: ...
    def setWindowModality(self, windowModality: PySide6.QtCore.Qt.WindowModality, /) -> None: ...
    def setWindowModified(self, arg__1: bool, /) -> None: ...
    def setWindowOpacity(self, level: float, /) -> None: ...
    def setWindowRole(self, arg__1: str, /) -> None: ...
    def setWindowState(self, state: PySide6.QtCore.Qt.WindowState, /) -> None: ...
    def setWindowTitle(self, arg__1: str, /) -> None: ...
    def sharedPainter(self, /) -> PySide6.QtGui.QPainter: ...
    def show(self, /) -> None: ...
    def showEvent(self, event: PySide6.QtGui.QShowEvent, /) -> None: ...
    def showFullScreen(self, /) -> None: ...
    def showMaximized(self, /) -> None: ...
    def showMinimized(self, /) -> None: ...
    def showNormal(self, /) -> None: ...
    def size(self, /) -> PySide6.QtCore.QSize: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def sizeIncrement(self, /) -> PySide6.QtCore.QSize: ...
    def sizePolicy(self, /) -> PySide6.QtWidgets.QSizePolicy: ...
    def stackUnder(self, arg__1: PySide6.QtWidgets.QWidget, /) -> None: ...
    def statusTip(self, /) -> str: ...
    def style(self, /) -> PySide6.QtWidgets.QStyle: ...
    def styleSheet(self, /) -> str: ...
    def tabletEvent(self, event: PySide6.QtGui.QTabletEvent, /) -> None: ...
    def testAttribute(self, arg__1: PySide6.QtCore.Qt.WidgetAttribute, /) -> bool: ...
    def toolTip(self, /) -> str: ...
    def toolTipDuration(self, /) -> int: ...
    def topLevelWidget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def underMouse(self, /) -> bool: ...
    def ungrabGesture(self, type: PySide6.QtCore.Qt.GestureType, /) -> None: ...
    def unsetCursor(self, /) -> None: ...
    def unsetLayoutDirection(self, /) -> None: ...
    def unsetLocale(self, /) -> None: ...
    @typing.overload
    def update(self, /) -> None: ...
    @typing.overload
    def update(self, arg__1: PySide6.QtCore.QRect, /) -> None: ...
    @typing.overload
    def update(self, arg__1: PySide6.QtGui.QRegion | PySide6.QtGui.QBitmap | PySide6.QtGui.QPolygon | PySide6.QtCore.QRect, /) -> None: ...
    @typing.overload
    def update(self, x: int, y: int, w: int, h: int, /) -> None: ...
    def updateGeometry(self, /) -> None: ...
    def updateMicroFocus(self, /, query: PySide6.QtCore.Qt.InputMethodQuery = ...) -> None: ...
    def updatesEnabled(self, /) -> bool: ...
    def visibleRegion(self, /) -> PySide6.QtGui.QRegion: ...
    def whatsThis(self, /) -> str: ...
    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent, /) -> None: ...
    def width(self, /) -> int: ...
    def winId(self, /) -> int: ...
    def window(self, /) -> PySide6.QtWidgets.QWidget: ...
    def windowFilePath(self, /) -> str: ...
    def windowFlags(self, /) -> PySide6.QtCore.Qt.WindowType: ...
    def windowHandle(self, /) -> PySide6.QtGui.QWindow: ...
    def windowIcon(self, /) -> PySide6.QtGui.QIcon: ...
    def windowIconText(self, /) -> str: ...
    def windowModality(self, /) -> PySide6.QtCore.Qt.WindowModality: ...
    def windowOpacity(self, /) -> float: ...
    def windowRole(self, /) -> str: ...
    def windowState(self, /) -> PySide6.QtCore.Qt.WindowState: ...
    def windowTitle(self, /) -> str: ...
    def windowType(self, /) -> PySide6.QtCore.Qt.WindowType: ...
    def x(self, /) -> int: ...
    def y(self, /) -> int: ...


class QWidgetAction(PySide6.QtGui.QAction):

    def __init__(self, parent: PySide6.QtCore.QObject, /) -> None: ...

    def createWidget(self, parent: PySide6.QtWidgets.QWidget, /) -> PySide6.QtWidgets.QWidget: ...
    def createdWidgets(self, /) -> typing.List[PySide6.QtWidgets.QWidget]: ...
    def defaultWidget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def deleteWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def event(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    def eventFilter(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent, /) -> bool: ...
    def releaseWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def requestWidget(self, parent: PySide6.QtWidgets.QWidget, /) -> PySide6.QtWidgets.QWidget: ...
    def setDefaultWidget(self, w: PySide6.QtWidgets.QWidget, /) -> None: ...


class QWidgetItem(PySide6.QtWidgets.QLayoutItem):

    def __init__(self, w: PySide6.QtWidgets.QWidget, /) -> None: ...

    def controlTypes(self, /) -> PySide6.QtWidgets.QSizePolicy.ControlType: ...
    def expandingDirections(self, /) -> PySide6.QtCore.Qt.Orientation: ...
    def geometry(self, /) -> PySide6.QtCore.QRect: ...
    def hasHeightForWidth(self, /) -> bool: ...
    def heightForWidth(self, arg__1: int, /) -> int: ...
    def isEmpty(self, /) -> bool: ...
    def maximumSize(self, /) -> PySide6.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1: int, /) -> int: ...
    def minimumSize(self, /) -> PySide6.QtCore.QSize: ...
    def setGeometry(self, arg__1: PySide6.QtCore.QRect, /) -> None: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def widget(self, /) -> PySide6.QtWidgets.QWidget: ...


class QWizard(PySide6.QtWidgets.QDialog):

    currentIdChanged         : typing.ClassVar[Signal] = ... # currentIdChanged(int)
    customButtonClicked      : typing.ClassVar[Signal] = ... # customButtonClicked(int)
    helpRequested            : typing.ClassVar[Signal] = ... # helpRequested()
    pageAdded                : typing.ClassVar[Signal] = ... # pageAdded(int)
    pageRemoved              : typing.ClassVar[Signal] = ... # pageRemoved(int)

    class WizardButton(enum.Enum):

        NoButton                  = ...  # -1
        BackButton                = ...  # 0x0
        NextButton                = ...  # 0x1
        CommitButton              = ...  # 0x2
        FinishButton              = ...  # 0x3
        CancelButton              = ...  # 0x4
        HelpButton                = ...  # 0x5
        CustomButton1             = ...  # 0x6
        NStandardButtons          = ...  # 0x6
        CustomButton2             = ...  # 0x7
        CustomButton3             = ...  # 0x8
        NButtons                  = ...  # 0x9
        Stretch                   = ...  # 0x9

    class WizardOption(enum.Flag):

        IndependentPages          = ...  # 0x1
        IgnoreSubTitles           = ...  # 0x2
        ExtendedWatermarkPixmap   = ...  # 0x4
        NoDefaultButton           = ...  # 0x8
        NoBackButtonOnStartPage   = ...  # 0x10
        NoBackButtonOnLastPage    = ...  # 0x20
        DisabledBackButtonOnLastPage = ...  # 0x40
        HaveNextButtonOnLastPage  = ...  # 0x80
        HaveFinishButtonOnEarlyPages = ...  # 0x100
        NoCancelButton            = ...  # 0x200
        CancelButtonOnLeft        = ...  # 0x400
        HaveHelpButton            = ...  # 0x800
        HelpButtonOnRight         = ...  # 0x1000
        HaveCustomButton1         = ...  # 0x2000
        HaveCustomButton2         = ...  # 0x4000
        HaveCustomButton3         = ...  # 0x8000
        NoCancelButtonOnLastPage  = ...  # 0x10000

    class WizardPixmap(enum.Enum):

        WatermarkPixmap           = ...  # 0x0
        LogoPixmap                = ...  # 0x1
        BannerPixmap              = ...  # 0x2
        BackgroundPixmap          = ...  # 0x3
        NPixmaps                  = ...  # 0x4

    class WizardStyle(enum.Enum):

        ClassicStyle              = ...  # 0x0
        ModernStyle               = ...  # 0x1
        MacStyle                  = ...  # 0x2
        AeroStyle                 = ...  # 0x3
        NStyles                   = ...  # 0x4


    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., flags: PySide6.QtCore.Qt.WindowType = ..., *, wizardStyle: PySide6.QtWidgets.QWizard.WizardStyle | None = ..., options: PySide6.QtWidgets.QWizard.WizardOption | None = ..., titleFormat: PySide6.QtCore.Qt.TextFormat | None = ..., subTitleFormat: PySide6.QtCore.Qt.TextFormat | None = ..., startId: int | None = ..., currentId: int | None = ...) -> None: ...

    def addPage(self, page: PySide6.QtWidgets.QWizardPage, /) -> int: ...
    def back(self, /) -> None: ...
    def button(self, which: PySide6.QtWidgets.QWizard.WizardButton, /) -> PySide6.QtWidgets.QAbstractButton: ...
    def buttonText(self, which: PySide6.QtWidgets.QWizard.WizardButton, /) -> str: ...
    def cleanupPage(self, id: int, /) -> None: ...
    def currentId(self, /) -> int: ...
    def currentPage(self, /) -> PySide6.QtWidgets.QWizardPage: ...
    def done(self, result: int, /) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def field(self, name: str, /) -> typing.Any: ...
    def hasVisitedPage(self, id: int, /) -> bool: ...
    def initializePage(self, id: int, /) -> None: ...
    def nativeEvent(self, eventType: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, message: int, /) -> object: ...
    def next(self, /) -> None: ...
    def nextId(self, /) -> int: ...
    def options(self, /) -> PySide6.QtWidgets.QWizard.WizardOption: ...
    def page(self, id: int, /) -> PySide6.QtWidgets.QWizardPage: ...
    def pageIds(self, /) -> typing.List[int]: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent, /) -> None: ...
    def pixmap(self, which: PySide6.QtWidgets.QWizard.WizardPixmap, /) -> PySide6.QtGui.QPixmap: ...
    def removePage(self, id: int, /) -> None: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent, /) -> None: ...
    def restart(self, /) -> None: ...
    def setButton(self, which: PySide6.QtWidgets.QWizard.WizardButton, button: PySide6.QtWidgets.QAbstractButton, /) -> None: ...
    def setButtonLayout(self, layout: collections.abc.Sequence[PySide6.QtWidgets.QWizard.WizardButton], /) -> None: ...
    def setButtonText(self, which: PySide6.QtWidgets.QWizard.WizardButton, text: str, /) -> None: ...
    def setCurrentId(self, id: int, /) -> None: ...
    def setDefaultProperty(self, className: bytes | bytearray | memoryview, property: bytes | bytearray | memoryview, changedSignal: bytes | bytearray | memoryview, /) -> None: ...
    def setField(self, name: str, value: typing.Any, /) -> None: ...
    def setOption(self, option: PySide6.QtWidgets.QWizard.WizardOption, /, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide6.QtWidgets.QWizard.WizardOption, /) -> None: ...
    def setPage(self, id: int, page: PySide6.QtWidgets.QWizardPage, /) -> None: ...
    def setPixmap(self, which: PySide6.QtWidgets.QWizard.WizardPixmap, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, /) -> None: ...
    def setSideWidget(self, widget: PySide6.QtWidgets.QWidget, /) -> None: ...
    def setStartId(self, id: int, /) -> None: ...
    def setSubTitleFormat(self, format: PySide6.QtCore.Qt.TextFormat, /) -> None: ...
    def setTitleFormat(self, format: PySide6.QtCore.Qt.TextFormat, /) -> None: ...
    def setVisible(self, visible: bool, /) -> None: ...
    def setWizardStyle(self, style: PySide6.QtWidgets.QWizard.WizardStyle, /) -> None: ...
    def sideWidget(self, /) -> PySide6.QtWidgets.QWidget: ...
    def sizeHint(self, /) -> PySide6.QtCore.QSize: ...
    def startId(self, /) -> int: ...
    def subTitleFormat(self, /) -> PySide6.QtCore.Qt.TextFormat: ...
    def testOption(self, option: PySide6.QtWidgets.QWizard.WizardOption, /) -> bool: ...
    def titleFormat(self, /) -> PySide6.QtCore.Qt.TextFormat: ...
    def validateCurrentPage(self, /) -> bool: ...
    def visitedIds(self, /) -> typing.List[int]: ...
    def wizardStyle(self, /) -> PySide6.QtWidgets.QWizard.WizardStyle: ...


class QWizardPage(PySide6.QtWidgets.QWidget):

    completeChanged          : typing.ClassVar[Signal] = ... # completeChanged()

    def __init__(self, /, parent: PySide6.QtWidgets.QWidget | None = ..., *, title: str | None = ..., subTitle: str | None = ...) -> None: ...

    def buttonText(self, which: PySide6.QtWidgets.QWizard.WizardButton, /) -> str: ...
    def cleanupPage(self, /) -> None: ...
    def field(self, name: str, /) -> typing.Any: ...
    def initializePage(self, /) -> None: ...
    def isCommitPage(self, /) -> bool: ...
    def isComplete(self, /) -> bool: ...
    def isFinalPage(self, /) -> bool: ...
    def nextId(self, /) -> int: ...
    def pixmap(self, which: PySide6.QtWidgets.QWizard.WizardPixmap, /) -> PySide6.QtGui.QPixmap: ...
    @typing.overload
    def registerField(self, name: str, widget: PySide6.QtWidgets.QWidget, property: str, changedSignal: PySide6.QtCore.SignalInstance, /) -> None: ...
    @typing.overload
    def registerField(self, name: str, widget: PySide6.QtWidgets.QWidget, /, property: str | None = ..., changed_signal: str | None = ...) -> None: ...
    def setButtonText(self, which: PySide6.QtWidgets.QWizard.WizardButton, text: str, /) -> None: ...
    def setCommitPage(self, commitPage: bool, /) -> None: ...
    def setField(self, name: str, value: typing.Any, /) -> None: ...
    def setFinalPage(self, finalPage: bool, /) -> None: ...
    def setPixmap(self, which: PySide6.QtWidgets.QWizard.WizardPixmap, pixmap: PySide6.QtGui.QPixmap | PySide6.QtGui.QImage, /) -> None: ...
    def setSubTitle(self, subTitle: str, /) -> None: ...
    def setTitle(self, title: str, /) -> None: ...
    def subTitle(self, /) -> str: ...
    def title(self, /) -> str: ...
    def validatePage(self, /) -> bool: ...
    def wizard(self, /) -> PySide6.QtWidgets.QWizard: ...


@typing.overload
def qDrawPlainRect(p: PySide6.QtGui.QPainter, r: PySide6.QtCore.QRect, arg__3: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, /, lineWidth: int = ..., fill: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap | None = ...) -> None: ...
@typing.overload
def qDrawPlainRect(p: PySide6.QtGui.QPainter, x: int, y: int, w: int, h: int, arg__6: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, /, lineWidth: int = ..., fill: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap | None = ...) -> None: ...
@typing.overload
def qDrawPlainRoundedRect(painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, rx: float, ry: float, lineColor: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, /, lineWidth: int = ..., fill: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap | None = ...) -> None: ...
@typing.overload
def qDrawPlainRoundedRect(p: PySide6.QtGui.QPainter, x: int, y: int, w: int, h: int, rx: float, ry: float, arg__8: PySide6.QtGui.QColor | str | PySide6.QtGui.QRgba64 | typing.Any | PySide6.QtCore.Qt.GlobalColor | int, /, lineWidth: int = ..., fill: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap | None = ...) -> None: ...
@typing.overload
def qDrawShadeLine(p: PySide6.QtGui.QPainter, p1: PySide6.QtCore.QPoint, p2: PySide6.QtCore.QPoint, pal: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, /, sunken: bool = ..., lineWidth: int = ..., midLineWidth: int | None = ...) -> None: ...
@typing.overload
def qDrawShadeLine(p: PySide6.QtGui.QPainter, x1: int, y1: int, x2: int, y2: int, pal: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, /, sunken: bool = ..., lineWidth: int = ..., midLineWidth: int | None = ...) -> None: ...
@typing.overload
def qDrawShadePanel(p: PySide6.QtGui.QPainter, r: PySide6.QtCore.QRect, pal: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, /, sunken: bool = ..., lineWidth: int = ..., fill: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap | None = ...) -> None: ...
@typing.overload
def qDrawShadePanel(p: PySide6.QtGui.QPainter, x: int, y: int, w: int, h: int, pal: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, /, sunken: bool = ..., lineWidth: int = ..., fill: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap | None = ...) -> None: ...
@typing.overload
def qDrawShadeRect(p: PySide6.QtGui.QPainter, r: PySide6.QtCore.QRect, pal: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, /, sunken: bool = ..., lineWidth: int = ..., midLineWidth: int | None = ..., fill: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap | None = ...) -> None: ...
@typing.overload
def qDrawShadeRect(p: PySide6.QtGui.QPainter, x: int, y: int, w: int, h: int, pal: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, /, sunken: bool = ..., lineWidth: int = ..., midLineWidth: int | None = ..., fill: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap | None = ...) -> None: ...
@typing.overload
def qDrawWinButton(p: PySide6.QtGui.QPainter, r: PySide6.QtCore.QRect, pal: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, /, sunken: bool = ..., fill: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap | None = ...) -> None: ...
@typing.overload
def qDrawWinButton(p: PySide6.QtGui.QPainter, x: int, y: int, w: int, h: int, pal: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, /, sunken: bool = ..., fill: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap | None = ...) -> None: ...
@typing.overload
def qDrawWinPanel(p: PySide6.QtGui.QPainter, r: PySide6.QtCore.QRect, pal: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, /, sunken: bool = ..., fill: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap | None = ...) -> None: ...
@typing.overload
def qDrawWinPanel(p: PySide6.QtGui.QPainter, x: int, y: int, w: int, h: int, pal: PySide6.QtGui.QPalette | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor, /, sunken: bool = ..., fill: PySide6.QtGui.QBrush | PySide6.QtCore.Qt.BrushStyle | PySide6.QtCore.Qt.GlobalColor | PySide6.QtGui.QColor | PySide6.QtGui.QGradient | PySide6.QtGui.QImage | PySide6.QtGui.QPixmap | None = ...) -> None: ...


# eof
