/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.qtproject.qt.android.QtNative;

class BackgroundActionsTracker {
    private int m_maxActions = -1;
    private final ConcurrentLinkedQueue<Runnable> m_backgroundActionsQueue = new ConcurrentLinkedQueue();
    private final AtomicInteger m_actionsCount = new AtomicInteger(0);

    BackgroundActionsTracker() {
    }

    public void setMaxAllowedActions(int n) {
        this.m_maxActions = n;
    }

    public void enqueue(Runnable runnable) {
        if (this.m_maxActions == 0 || runnable == null) {
            return;
        }
        if (this.m_maxActions > 0 && this.m_actionsCount.get() >= this.m_maxActions) {
            this.m_backgroundActionsQueue.poll();
            this.m_actionsCount.decrementAndGet();
        }
        this.m_backgroundActionsQueue.offer(runnable);
        this.m_actionsCount.incrementAndGet();
    }

    public void processActions() {
        Runnable runnable;
        while ((runnable = this.m_backgroundActionsQueue.poll()) != null) {
            this.m_actionsCount.decrementAndGet();
            QtNative.runAction(runnable);
        }
    }

    public int getActionsCount() {
        return this.m_actionsCount.get();
    }
}

