/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Size;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowInsetsController;
import android.view.WindowManager;
import android.view.WindowMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.qtproject.qt.android.UsedFromNativeCode;

class QtDisplayManager {
    private static String QtTAG = "QtDisplayManager";
    private boolean m_isFullScreen = false;
    private boolean m_expandedToCutout = false;
    private static int m_previousRotation = -1;
    private final DisplayManager.DisplayListener m_displayListener;
    private final Activity m_activity;

    static native void setDisplayMetrics(int var0, int var1, int var2, int var3, int var4, int var5, double var6, double var8, double var10, double var12, float var14);

    static native void handleOrientationChanged(int var0, int var1);

    static native void handleRefreshRateChanged(float var0);

    static native void handleUiDarkModeChanged(int var0);

    static native void handleScreenAdded(int var0);

    static native void handleScreenChanged(int var0);

    static native void handleScreenRemoved(int var0);

    QtDisplayManager(Activity activity) {
        this.m_activity = activity;
        this.m_displayListener = new DisplayManager.DisplayListener(){

            public void onDisplayAdded(int n) {
                QtDisplayManager.handleScreenAdded(n);
            }

            public void onDisplayChanged(int n) {
                Display display = Build.VERSION.SDK_INT < 30 ? QtDisplayManager.this.m_activity.getWindowManager().getDefaultDisplay() : QtDisplayManager.this.m_activity.getDisplay();
                float f = QtDisplayManager.getRefreshRate(display);
                QtDisplayManager.handleRefreshRateChanged(f);
                QtDisplayManager.handleScreenChanged(n);
            }

            public void onDisplayRemoved(int n) {
                QtDisplayManager.handleScreenRemoved(n);
            }
        };
    }

    static void handleOrientationChanges(Activity activity) {
        int n = QtDisplayManager.getDisplayRotation(activity);
        if (m_previousRotation == n) {
            return;
        }
        int n2 = QtDisplayManager.getNativeOrientation(activity, n);
        QtDisplayManager.handleOrientationChanged(n, n2);
        m_previousRotation = n;
    }

    static int getDisplayRotation(Activity activity) {
        Display display = Build.VERSION.SDK_INT < 30 ? activity.getWindowManager().getDefaultDisplay() : activity.getDisplay();
        return display != null ? display.getRotation() : 0;
    }

    private static int getNativeOrientation(Activity activity, int n) {
        boolean bl;
        int n2 = activity.getResources().getConfiguration().orientation;
        boolean bl2 = n == 1 || n == 3;
        boolean bl3 = bl = n2 == 2;
        if (bl && !bl2 || !bl && bl2) {
            return 2;
        }
        return 1;
    }

    static float getRefreshRate(Display display) {
        return display != null ? display.getRefreshRate() : 60.0f;
    }

    void registerDisplayListener() {
        DisplayManager displayManager = (DisplayManager)this.m_activity.getSystemService("display");
        displayManager.registerDisplayListener(this.m_displayListener, null);
    }

    void unregisterDisplayListener() {
        DisplayManager displayManager = (DisplayManager)this.m_activity.getSystemService("display");
        displayManager.unregisterDisplayListener(this.m_displayListener);
    }

    void setSystemUiVisibility(boolean bl, boolean bl2) {
        int n;
        WindowManager.LayoutParams layoutParams;
        int n2;
        if (this.m_isFullScreen == bl && this.m_expandedToCutout == bl2) {
            return;
        }
        this.m_isFullScreen = bl;
        this.m_expandedToCutout = bl2;
        Window window = this.m_activity.getWindow();
        View view = window.getDecorView();
        if (Build.VERSION.SDK_INT >= 30) {
            if (this.m_isFullScreen || this.m_expandedToCutout) {
                window.setDecorFitsSystemWindows(false);
                n2 = 1;
            } else {
                window.setDecorFitsSystemWindows(true);
                n2 = 0;
            }
            layoutParams = window.getAttributes();
            layoutParams.layoutInDisplayCutoutMode = n2;
            window.setAttributes(layoutParams);
            WindowInsetsController windowInsetsController = window.getInsetsController();
            if (windowInsetsController != null) {
                if (this.m_isFullScreen) {
                    windowInsetsController.hide(WindowInsets.Type.systemBars());
                    n = 2;
                } else {
                    windowInsetsController.show(WindowInsets.Type.systemBars());
                    n = 1;
                }
                windowInsetsController.setSystemBarsBehavior(n);
            }
        } else {
            if (this.m_isFullScreen || this.m_expandedToCutout) {
                n2 = 1536;
                if (this.m_isFullScreen) {
                    n2 |= 0x1106;
                }
            } else {
                n2 = 0;
            }
            view.setSystemUiVisibility(n2);
        }
        if (this.m_expandedToCutout) {
            window.setStatusBarColor(0);
            window.setNavigationBarColor(0);
        } else {
            Resources.Theme theme = this.m_activity.getTheme();
            layoutParams = new TypedValue();
            theme.resolveAttribute(16843857, (TypedValue)layoutParams, true);
            int n3 = layoutParams.data;
            window.setStatusBarColor(n3);
            theme.resolveAttribute(16843858, (TypedValue)layoutParams, true);
            n = layoutParams.data;
            window.setNavigationBarColor(n);
        }
        view.post(() -> view.requestApplyInsets());
    }

    boolean isFullScreen() {
        return this.m_isFullScreen;
    }

    boolean expandedToCutout() {
        return this.m_expandedToCutout;
    }

    void reinstateFullScreen() {
        if (this.m_isFullScreen) {
            this.m_isFullScreen = false;
            this.setSystemUiVisibility(true, this.m_expandedToCutout);
        }
    }

    @UsedFromNativeCode
    static Display getDisplay(Context context, int n) {
        DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
        if (displayManager != null) {
            return displayManager.getDisplay(n);
        }
        return null;
    }

    @UsedFromNativeCode
    static List<Display> getAvailableDisplays(Context context) {
        DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
        if (displayManager != null) {
            Display[] displayArray = displayManager.getDisplays();
            return Arrays.asList(displayArray);
        }
        return new ArrayList<Display>();
    }

    @UsedFromNativeCode
    static Size getDisplaySize(Context context, Display display) {
        if (display == null || context == null) {
            return new Size(0, 0);
        }
        if (Build.VERSION.SDK_INT < 30) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            display.getRealMetrics(displayMetrics);
            return new Size(displayMetrics.widthPixels, displayMetrics.heightPixels);
        }
        try {
            WindowManager windowManager = (WindowManager)context.getSystemService(WindowManager.class);
            if (windowManager != null) {
                WindowMetrics windowMetrics = windowManager.getCurrentWindowMetrics();
                Rect rect = windowMetrics.getBounds();
                return new Size(rect.width(), rect.height());
            }
            Log.e((String)QtTAG, (String)("getDisplaySize(): WindowManager null, display ID" + display.getDisplayId()));
        }
        catch (Exception exception) {
            Log.e((String)QtTAG, (String)("Failed to retrieve display metrics with " + exception));
        }
        return new Size(0, 0);
    }

    static void setApplicationDisplayMetrics(Activity activity, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        WindowMetrics windowMetrics;
        Display display;
        if (activity == null) {
            return;
        }
        WindowInsets windowInsets = activity.getWindow().getDecorView().getRootWindowInsets();
        WindowManager windowManager = activity.getWindowManager();
        if (Build.VERSION.SDK_INT < 30) {
            display = windowManager.getDefaultDisplay();
            windowMetrics = new DisplayMetrics();
            display.getRealMetrics((DisplayMetrics)windowMetrics);
            n6 = windowMetrics.widthPixels;
            n5 = windowMetrics.heightPixels;
            n4 = windowInsets.getStableInsetLeft();
            n3 = windowInsets.getStableInsetTop();
        } else {
            display = activity.getDisplay();
            windowMetrics = windowManager.getMaximumWindowMetrics();
            n6 = windowMetrics.getBounds().width();
            n5 = windowMetrics.getBounds().height();
            n4 = windowInsets.getInsetsIgnoringVisibility((int)WindowInsets.Type.systemBars()).left;
            n3 = windowInsets.getInsetsIgnoringVisibility((int)WindowInsets.Type.systemBars()).top;
        }
        windowMetrics = activity.getResources().getDisplayMetrics();
        double d = windowMetrics.density;
        double d2 = windowMetrics.scaledDensity;
        QtDisplayManager.setDisplayMetrics(n6, n5, n4, n3, n, n2, QtDisplayManager.getXDpi((DisplayMetrics)windowMetrics), QtDisplayManager.getYDpi((DisplayMetrics)windowMetrics), d2, d, QtDisplayManager.getRefreshRate(display));
    }

    static float getXDpi(DisplayMetrics displayMetrics) {
        if (displayMetrics.xdpi < 120.0f) {
            return 120.0f;
        }
        return displayMetrics.xdpi;
    }

    static float getYDpi(DisplayMetrics displayMetrics) {
        if (displayMetrics.ydpi < 120.0f) {
            return 120.0f;
        }
        return displayMetrics.ydpi;
    }
}

