/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.widget.PopupMenu;
import java.util.HashSet;
import org.qtproject.qt.android.BackendRegister;
import org.qtproject.qt.android.QtActivityDelegateBase;
import org.qtproject.qt.android.QtDisplayManager;
import org.qtproject.qt.android.QtEditText;
import org.qtproject.qt.android.QtEmbeddedViewInterface;
import org.qtproject.qt.android.QtEmbeddedViewInterfaceFactory;
import org.qtproject.qt.android.QtInputInterface;
import org.qtproject.qt.android.QtMenuInterface;
import org.qtproject.qt.android.QtNative;
import org.qtproject.qt.android.QtView;
import org.qtproject.qt.android.QtWindow;
import org.qtproject.qt.android.QtWindowInterface;

class QtEmbeddedDelegate
extends QtActivityDelegateBase
implements QtNative.AppStateDetailsListener,
QtEmbeddedViewInterface,
QtWindowInterface,
QtMenuInterface {
    private static final String QtTAG = "QtEmbeddedDelegate";
    private final HashSet<QtView> m_views = new HashSet();
    private QtNative.ApplicationStateDetails m_stateDetails = QtNative.getStateDetails();
    private boolean m_backendsRegistered = false;

    QtEmbeddedDelegate(Activity activity) {
        super(activity);
        QtNative.registerAppStateListener(this);
        this.m_activity.getApplication().registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle bundle) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
                if (QtEmbeddedDelegate.this.m_activity == activity && ((QtEmbeddedDelegate)QtEmbeddedDelegate.this).m_stateDetails.isStarted) {
                    QtNative.setApplicationState(4);
                    QtWindow.updateWindows();
                }
            }

            public void onActivityPaused(Activity activity) {
                if (QtEmbeddedDelegate.this.m_activity == activity && ((QtEmbeddedDelegate)QtEmbeddedDelegate.this).m_stateDetails.isStarted && (Build.VERSION.SDK_INT < 24 || !activity.isInMultiWindowMode())) {
                    QtNative.setApplicationState(2);
                }
            }

            public void onActivityStopped(Activity activity) {
                if (QtEmbeddedDelegate.this.m_activity == activity && ((QtEmbeddedDelegate)QtEmbeddedDelegate.this).m_stateDetails.isStarted) {
                    QtNative.setApplicationState(0);
                }
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            }

            public void onActivityDestroyed(Activity activity) {
                if (QtEmbeddedDelegate.this.m_activity == activity && ((QtEmbeddedDelegate)QtEmbeddedDelegate.this).m_stateDetails.isStarted && !activity.isChangingConfigurations()) {
                    QtEmbeddedDelegate.this.m_activity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
                    QtNative.unregisterAppStateListener(QtEmbeddedDelegate.this);
                    QtEmbeddedViewInterfaceFactory.remove((Context)QtEmbeddedDelegate.this.m_activity);
                    QtNative.quitQt();
                    QtNative.setActivity(null);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAppStateDetailsChanged(QtNative.ApplicationStateDetails applicationStateDetails) {
        QtEmbeddedDelegate qtEmbeddedDelegate = this;
        synchronized (qtEmbeddedDelegate) {
            this.m_stateDetails = applicationStateDetails;
            if (applicationStateDetails.isStarted && !this.m_backendsRegistered) {
                if (BackendRegister.isNull()) {
                    return;
                }
                this.m_backendsRegistered = true;
                BackendRegister.registerBackend(QtWindowInterface.class, this);
                BackendRegister.registerBackend(QtMenuInterface.class, this);
                BackendRegister.registerBackend(QtInputInterface.class, this.m_inputDelegate);
            } else if (!applicationStateDetails.isStarted && this.m_backendsRegistered) {
                this.m_backendsRegistered = false;
                if (BackendRegister.isNull()) {
                    return;
                }
                BackendRegister.unregisterBackend(QtWindowInterface.class);
                BackendRegister.unregisterBackend(QtMenuInterface.class);
                BackendRegister.unregisterBackend(QtInputInterface.class);
            }
        }
    }

    @Override
    public void onNativePluginIntegrationReadyChanged(boolean bl) {
        if (bl) {
            QtNative.runAction(() -> {
                DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
                QtDisplayManager.setApplicationDisplayMetrics(this.m_activity, displayMetrics.widthPixels, displayMetrics.heightPixels);
            });
        }
    }

    @Override
    void startNativeApplicationImpl(String string2, String string3) {
        QtNative.startApplication(string2, string3);
    }

    @Override
    public void startQtApplication(String string2, String string3) {
        super.startNativeApplication(string2, string3);
    }

    @Override
    public void addView(QtView qtView) {
        if (this.m_views.add(qtView)) {
            QtNative.runAction(() -> this.createRootWindow(qtView));
        }
    }

    @Override
    public void removeView(QtView qtView) {
        this.m_views.remove(qtView);
    }

    private void createRootWindow(QtView qtView) {
        if (this.m_views.contains(qtView)) {
            QtView.createRootWindow((View)qtView, qtView.getLeft(), qtView.getTop(), qtView.getWidth(), qtView.getHeight());
        }
    }

    @Override
    public void resetOptionsMenu() {
        QtNative.runAction(() -> ((Activity)this.m_activity).invalidateOptionsMenu());
    }

    @Override
    public void openOptionsMenu() {
        QtNative.runAction(() -> ((Activity)this.m_activity).openOptionsMenu());
    }

    @Override
    public void closeContextMenu() {
        QtNative.runAction(() -> ((Activity)this.m_activity).closeContextMenu());
    }

    @Override
    public void openContextMenu(int n, int n2, int n3, int n4) {
        QtEditText qtEditText = this.m_inputDelegate.getCurrentQtEditText();
        if (qtEditText == null) {
            Log.w((String)QtTAG, (String)"No focused view when trying to open context menu");
            return;
        }
        qtEditText.postDelayed(() -> {
            PopupMenu popupMenu2 = new PopupMenu((Context)this.m_activity, (View)qtEditText);
            QtNative.fillContextMenu(popupMenu2.getMenu());
            popupMenu2.setOnMenuItemClickListener(arg_0 -> ((Activity)this.m_activity).onContextItemSelected(arg_0));
            popupMenu2.setOnDismissListener(popupMenu -> this.m_activity.onContextMenuClosed(popupMenu.getMenu()));
            popupMenu2.show();
        }, 100L);
    }
}

