/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.ResultReceiver;
import android.text.method.MetaKeyKeyListener;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowInsets;
import android.view.WindowInsetsAnimationControlListener;
import android.view.WindowInsetsAnimationController;
import android.view.inputmethod.InputMethodManager;
import org.qtproject.qt.android.QtEditText;
import org.qtproject.qt.android.QtInputConnection;
import org.qtproject.qt.android.QtInputInterface;
import org.qtproject.qt.android.QtLayout;
import org.qtproject.qt.android.QtNative;
import org.qtproject.qt.android.QtNativeInputConnection;

class QtInputDelegate
implements QtInputConnection.QtInputConnectionListener,
QtInputInterface {
    private static final String TAG = "QtInputDelegate";
    private QtEditText m_currentEditText = null;
    private InputMethodManager m_imm;
    private static final float KEYBOARD_TO_SCREEN_RATIO = 0.15f;
    private boolean m_keyboardTransitionInProgress = false;
    private boolean m_keyboardIsVisible = false;
    private boolean m_isKeyboardHidingAnimationOngoing = false;
    private long m_showHideTimeStamp = System.nanoTime();
    private int m_portraitKeyboardHeight = 0;
    private int m_landscapeKeyboardHeight = 0;
    private int m_probeKeyboardHeightDelayMs = 50;
    private int m_softInputMode = 0;
    private static Boolean m_tabletEventSupported = null;
    private static int m_oldX;
    private static int m_oldY;
    private long m_metaState;
    private int m_lastChar = 0;
    private boolean m_backKeyPressedSent = false;
    private final KeyboardVisibilityListener m_keyboardVisibilityListener;
    private final ViewTreeObserver.OnGlobalLayoutListener keyboardListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            if (!QtInputDelegate.this.isKeyboardHidden()) {
                QtInputDelegate.this.setKeyboardTransitionInProgress(false);
            }
        }
    };

    static native void keyDown(int var0, int var1, int var2, boolean var3);

    static native void keyUp(int var0, int var1, int var2, boolean var3);

    static native void keyboardVisibilityChanged(boolean var0);

    static native void keyboardGeometryChanged(int var0, int var1, int var2, int var3);

    static native boolean dispatchGenericMotionEvent(MotionEvent var0);

    static native boolean dispatchKeyEvent(KeyEvent var0);

    static native void handleLocationChanged(int var0, int var1, int var2);

    QtInputDelegate(KeyboardVisibilityListener keyboardVisibilityListener) {
        this.m_keyboardVisibilityListener = keyboardVisibilityListener;
    }

    void initInputMethodManager(Activity activity) {
        this.m_imm = (InputMethodManager)activity.getSystemService("input_method");
        if (this.m_imm == null) {
            Log.w((String)TAG, (String)"getSystemService() returned a null InputMethodManager instance");
        }
        if (Build.VERSION.SDK_INT >= 30) {
            View view2 = activity.getWindow().getDecorView();
            view2.setOnApplyWindowInsetsListener((view, windowInsets) -> {
                WindowInsets windowInsets2 = view.onApplyWindowInsets(windowInsets);
                if (this.m_keyboardIsVisible != windowInsets2.isVisible(WindowInsets.Type.ime())) {
                    this.setKeyboardVisibility_internal(!this.m_keyboardIsVisible, System.nanoTime());
                }
                return windowInsets2;
            });
        }
    }

    private void setKeyboardTransitionInProgress(boolean bl) {
        if (this.m_keyboardTransitionInProgress == bl || this.m_currentEditText == null) {
            return;
        }
        this.m_keyboardTransitionInProgress = bl;
        ViewTreeObserver viewTreeObserver = this.m_currentEditText.getViewTreeObserver();
        if (bl) {
            viewTreeObserver.addOnGlobalLayoutListener(this.keyboardListener);
        } else {
            viewTreeObserver.removeOnGlobalLayoutListener(this.keyboardListener);
        }
    }

    @Override
    public void updateSelection(int n, int n2, int n3, int n4) {
        if (this.m_imm != null) {
            QtNative.runAction(() -> {
                if (this.m_imm != null) {
                    this.m_imm.updateSelection((View)this.m_currentEditText, n, n2, n3, n4);
                }
            });
        }
    }

    private void showKeyboard(final Activity activity, final int n, final int n2, final int n3, final int n4, final int n5, final int n6) {
        if (Build.VERSION.SDK_INT >= 30) {
            activity.getWindow().getInsetsController().controlWindowInsetsAnimation(WindowInsets.Type.ime(), -1L, null, null, new WindowInsetsAnimationControlListener(){

                public void onCancelled(WindowInsetsAnimationController windowInsetsAnimationController) {
                }

                public void onReady(WindowInsetsAnimationController windowInsetsAnimationController, int n7) {
                }

                public void onFinished(WindowInsetsAnimationController windowInsetsAnimationController) {
                    QtNativeInputConnection.updateCursorPosition();
                    if (QtInputDelegate.this.m_softInputMode == 0) {
                        QtInputDelegate.this.probeForKeyboardHeight(activity, n, n2, n3, n4, n5, n6);
                    }
                }
            });
            activity.getWindow().getInsetsController().show(WindowInsets.Type.ime());
        } else {
            if (this.m_imm == null) {
                return;
            }
            this.m_imm.showSoftInput((View)this.m_currentEditText, 0, new ResultReceiver(new Handler()){

                protected void onReceiveResult(int n7, Bundle bundle) {
                    switch (n7) {
                        case 2: {
                            QtNativeInputConnection.updateCursorPosition();
                        }
                        case 0: {
                            QtInputDelegate.this.setKeyboardVisibility(true, System.nanoTime());
                            if (QtInputDelegate.this.m_softInputMode != 0) break;
                            QtInputDelegate.this.probeForKeyboardHeight(activity, n, n2, n3, n4, n5, n6);
                            break;
                        }
                        case 1: 
                        case 3: {
                            QtInputDelegate.this.setKeyboardVisibility(false, System.nanoTime());
                        }
                    }
                }
            });
        }
    }

    @Override
    public void showSoftwareKeyboard(Activity activity, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.m_imm == null) {
            return;
        }
        QtNative.runAction(() -> {
            if (this.m_imm == null || this.m_currentEditText == null) {
                return;
            }
            if (this.updateSoftInputMode(activity, n4)) {
                return;
            }
            this.m_currentEditText.setEditTextOptions(n6, n5);
            this.m_currentEditText.setLayoutParams(new QtLayout.LayoutParams(n3, n4, n, n2));
            this.m_currentEditText.requestFocus();
            this.m_currentEditText.postDelayed(() -> {
                this.showKeyboard(activity, n, n2, n3, n4, n5, n6);
                if (this.m_currentEditText.m_optionsChanged) {
                    this.m_imm.restartInput((View)this.m_currentEditText);
                    this.m_currentEditText.m_optionsChanged = false;
                }
            }, 15L);
        });
    }

    @Override
    public int getSelectionHandleWidth() {
        return this.m_currentEditText == null ? 0 : this.m_currentEditText.getSelectionHandleWidth();
    }

    @Override
    public void updateHandles(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        QtNative.runAction(() -> {
            if (this.m_currentEditText != null) {
                this.m_currentEditText.updateHandles(n, n2, n3, n4, n5, n6, n7, n8, bl);
            }
        });
    }

    @Override
    public QtInputConnection.QtInputConnectionListener getInputConnectionListener() {
        return this;
    }

    @Override
    public void resetSoftwareKeyboard() {
        if (this.m_imm == null || this.m_currentEditText == null) {
            return;
        }
        this.m_currentEditText.postDelayed(() -> {
            if (this.m_imm == null || this.m_currentEditText == null) {
                return;
            }
            this.m_imm.restartInput((View)this.m_currentEditText);
            this.m_currentEditText.m_optionsChanged = false;
        }, 5L);
    }

    @Override
    public void hideSoftwareKeyboard() {
        if (this.m_imm == null || this.m_currentEditText == null) {
            return;
        }
        this.m_isKeyboardHidingAnimationOngoing = true;
        QtNative.runAction(() -> {
            if (this.m_imm == null || this.m_currentEditText == null) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 30) {
                Activity activity = QtNative.activity();
                if (activity == null) {
                    Log.w((String)TAG, (String)"hideSoftwareKeyboard: The activity reference is null");
                    return;
                }
                activity.getWindow().getInsetsController().hide(WindowInsets.Type.ime());
            } else {
                this.m_imm.hideSoftInputFromWindow(this.m_currentEditText.getWindowToken(), 0, new ResultReceiver(new Handler()){

                    protected void onReceiveResult(int n, Bundle bundle) {
                        switch (n) {
                            case 0: 
                            case 2: {
                                QtInputDelegate.this.setKeyboardVisibility(true, System.nanoTime());
                                break;
                            }
                            case 1: 
                            case 3: {
                                QtInputDelegate.this.setKeyboardVisibility(false, System.nanoTime());
                            }
                        }
                    }
                });
            }
        });
    }

    @Override
    public boolean isSoftwareKeyboardVisible() {
        return this.isKeyboardVisible() && !this.m_isKeyboardHidingAnimationOngoing;
    }

    @Override
    public boolean keyboardTransitionInProgress() {
        return this.m_keyboardTransitionInProgress;
    }

    @Override
    public boolean isKeyboardHidden() {
        Activity activity = QtNative.activity();
        if (activity == null) {
            Log.w((String)TAG, (String)"isKeyboardHidden: The activity reference is null");
            return true;
        }
        if (Build.VERSION.SDK_INT < 30) {
            Rect rect = new Rect();
            activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
            DisplayMetrics displayMetrics = new DisplayMetrics();
            activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            int n = displayMetrics.heightPixels;
            int n2 = n - rect.bottom;
            return (float)n2 < (float)n * 0.15f;
        }
        return !this.m_keyboardIsVisible;
    }

    @Override
    public void onSetClosing(boolean bl) {
        if (!bl) {
            this.setKeyboardVisibility(true, System.nanoTime());
        }
    }

    @Override
    public void onHideKeyboardRunnableDone(boolean bl, long l) {
        this.setKeyboardVisibility(bl, l);
    }

    @Override
    public void onSendKeyEventDefaultCase() {
        this.hideSoftwareKeyboard();
    }

    @Override
    public void onEditTextChanged(QtEditText qtEditText) {
        this.setFocusedView(qtEditText);
    }

    boolean isKeyboardVisible() {
        return this.m_keyboardIsVisible;
    }

    void setSoftInputMode(int n) {
        this.m_softInputMode = n;
    }

    QtEditText getCurrentQtEditText() {
        return this.m_currentEditText;
    }

    private void keyboardVisibilityUpdated(boolean bl) {
        this.m_isKeyboardHidingAnimationOngoing = false;
        QtInputDelegate.keyboardVisibilityChanged(bl);
    }

    void setKeyboardVisibility(boolean bl, long l) {
        if (Build.VERSION.SDK_INT < 30) {
            this.setKeyboardVisibility_internal(bl, l);
        }
    }

    private void setKeyboardVisibility_internal(boolean bl, long l) {
        if (this.m_showHideTimeStamp > l) {
            return;
        }
        this.m_showHideTimeStamp = l;
        if (this.m_keyboardIsVisible == bl) {
            return;
        }
        this.m_keyboardIsVisible = bl;
        this.keyboardVisibilityUpdated(this.m_keyboardIsVisible);
        this.setKeyboardTransitionInProgress(bl);
        if (!bl) {
            this.m_keyboardVisibilityListener.onKeyboardVisibilityChange();
            if (this.m_currentEditText != null) {
                this.m_currentEditText.clearFocus();
            }
        }
    }

    void setFocusedView(QtEditText qtEditText) {
        this.setKeyboardTransitionInProgress(false);
        this.m_currentEditText = qtEditText;
    }

    private boolean updateSoftInputMode(Activity activity, int n) {
        int n2;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        if (displayMetrics.widthPixels < displayMetrics.heightPixels) {
            n2 = this.m_portraitKeyboardHeight != 0 ? this.m_portraitKeyboardHeight : displayMetrics.heightPixels * 3 / 5;
        } else {
            int n3 = n2 = this.m_landscapeKeyboardHeight != 0 ? this.m_landscapeKeyboardHeight : displayMetrics.heightPixels / 3;
        }
        if (this.m_softInputMode != 0) {
            activity.getWindow().setSoftInputMode(this.m_softInputMode);
            int n4 = 2;
            return (this.m_softInputMode & n4) != 0;
        }
        int n5 = 1;
        if (n > n2) {
            int n6 = 16;
            activity.getWindow().setSoftInputMode(n5 | n6);
        } else {
            int n7 = 32;
            activity.getWindow().setSoftInputMode(n5 | n7);
        }
        return false;
    }

    private void probeForKeyboardHeight(Activity activity, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.m_currentEditText == null) {
            Log.w((String)TAG, (String)"probeForKeyboardHeight: null QtEditText");
            return;
        }
        this.m_currentEditText.postDelayed(() -> {
            if (!this.m_keyboardIsVisible) {
                return;
            }
            DisplayMetrics displayMetrics = new DisplayMetrics();
            activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            Rect rect = new Rect();
            activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
            if (displayMetrics.heightPixels != rect.bottom) {
                if (displayMetrics.widthPixels > displayMetrics.heightPixels) {
                    if (this.m_landscapeKeyboardHeight != rect.bottom) {
                        this.m_landscapeKeyboardHeight = rect.bottom;
                        this.showSoftwareKeyboard(activity, n, n2, n3, n4, n5, n6);
                    }
                } else if (this.m_portraitKeyboardHeight != rect.bottom) {
                    this.m_portraitKeyboardHeight = rect.bottom;
                    this.showSoftwareKeyboard(activity, n, n2, n3, n4, n5, n6);
                }
            } else if (this.m_probeKeyboardHeightDelayMs < 1000) {
                this.m_probeKeyboardHeightDelayMs *= 2;
            }
        }, this.m_probeKeyboardHeightDelayMs);
    }

    boolean onKeyDown(int n, KeyEvent keyEvent) {
        int n2;
        this.m_metaState = MetaKeyKeyListener.handleKeyDown((long)this.m_metaState, (int)n, (KeyEvent)keyEvent);
        int n3 = MetaKeyKeyListener.getMetaState((long)this.m_metaState) | keyEvent.getMetaState();
        int n4 = n2 = keyEvent.getUnicodeChar(n3);
        this.m_metaState = MetaKeyKeyListener.adjustMetaAfterKeypress((long)this.m_metaState);
        if ((n2 & Integer.MIN_VALUE) != 0) {
            n2 &= Integer.MAX_VALUE;
            n2 = KeyEvent.getDeadChar((int)this.m_lastChar, (int)n2);
        }
        if ((n == 24 || n == 25 || n == 91) && System.getenv("QT_ANDROID_VOLUME_KEYS") == null) {
            return false;
        }
        this.m_lastChar = n4;
        if (n == 4) {
            boolean bl = this.m_backKeyPressedSent = !this.isKeyboardVisible();
            if (!this.m_backKeyPressedSent) {
                return true;
            }
        }
        QtInputDelegate.keyDown(n, n2, keyEvent.getMetaState(), keyEvent.getRepeatCount() > 0);
        return true;
    }

    boolean onKeyUp(int n, KeyEvent keyEvent) {
        if ((n == 24 || n == 25 || n == 91) && System.getenv("QT_ANDROID_VOLUME_KEYS") == null) {
            return false;
        }
        if (n == 4 && !this.m_backKeyPressedSent) {
            this.hideSoftwareKeyboard();
            this.setKeyboardVisibility(false, System.nanoTime());
            return true;
        }
        this.m_metaState = MetaKeyKeyListener.handleKeyUp((long)this.m_metaState, (int)n, (KeyEvent)keyEvent);
        boolean bl = keyEvent.getRepeatCount() > 0;
        QtInputDelegate.keyUp(n, keyEvent.getUnicodeChar(), keyEvent.getMetaState(), bl);
        return true;
    }

    boolean handleDispatchKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getAction() == 2 && keyEvent.getCharacters() != null && keyEvent.getCharacters().length() == 1 && keyEvent.getKeyCode() == 0) {
            QtInputDelegate.keyDown(0, keyEvent.getCharacters().charAt(0), keyEvent.getMetaState(), keyEvent.getRepeatCount() > 0);
            QtInputDelegate.keyUp(0, keyEvent.getCharacters().charAt(0), keyEvent.getMetaState(), keyEvent.getRepeatCount() > 0);
        }
        return QtInputDelegate.dispatchKeyEvent(keyEvent);
    }

    boolean handleDispatchGenericMotionEvent(MotionEvent motionEvent) {
        return QtInputDelegate.dispatchGenericMotionEvent(motionEvent);
    }

    static native boolean isTabletEventSupported();

    static native void tabletEvent(int var0, int var1, long var2, int var4, int var5, int var6, float var7, float var8, float var9);

    static native void mouseDown(int var0, int var1, int var2, int var3);

    static native void mouseUp(int var0, int var1, int var2, int var3);

    static native void mouseMove(int var0, int var1, int var2, int var3);

    static native void mouseWheel(int var0, int var1, int var2, float var3, float var4);

    static native void touchBegin(int var0);

    static native void touchAdd(int var0, int var1, int var2, boolean var3, int var4, int var5, float var6, float var7, float var8, float var9);

    static native void touchEnd(int var0, int var1);

    static native void touchCancel(int var0);

    static native void longPress(int var0, int var1, int var2);

    private static int getAction(int n, MotionEvent motionEvent) {
        int n2 = motionEvent.getActionMasked();
        if (n2 == 2) {
            int n3 = motionEvent.getHistorySize();
            if (n3 > 0) {
                float f = motionEvent.getX(n);
                float f2 = motionEvent.getY(n);
                for (int i = 0; i < n3; ++i) {
                    if (motionEvent.getHistoricalX(n, i) == f && motionEvent.getHistoricalY(n, i) == f2) continue;
                    return 1;
                }
                return 2;
            }
            return 1;
        }
        if (n2 == 0 || n2 == 5 && n == motionEvent.getActionIndex()) {
            return 0;
        }
        if (n2 == 1 || n2 == 6 && n == motionEvent.getActionIndex()) {
            return 3;
        }
        return 2;
    }

    static void sendTouchEvent(MotionEvent motionEvent, int n) {
        int n2 = 0;
        if (m_tabletEventSupported == null) {
            m_tabletEventSupported = QtInputDelegate.isTabletEventSupported();
        }
        switch (motionEvent.getToolType(0)) {
            case 2: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 3;
            }
        }
        if (motionEvent.getToolType(0) == 3) {
            QtInputDelegate.sendMouseEvent(motionEvent, n);
        } else if (m_tabletEventSupported.booleanValue() && n2 != 0) {
            QtInputDelegate.tabletEvent(n, motionEvent.getDeviceId(), motionEvent.getEventTime(), motionEvent.getActionMasked(), n2, motionEvent.getButtonState(), motionEvent.getX(), motionEvent.getY(), motionEvent.getPressure());
        } else {
            QtInputDelegate.touchBegin(n);
            for (int i = 0; i < motionEvent.getPointerCount(); ++i) {
                QtInputDelegate.touchAdd(n, motionEvent.getPointerId(i), QtInputDelegate.getAction(i, motionEvent), i == 0, (int)motionEvent.getX(i), (int)motionEvent.getY(i), motionEvent.getTouchMajor(i), motionEvent.getTouchMinor(i), motionEvent.getOrientation(i), motionEvent.getPressure(i));
            }
            switch (motionEvent.getAction()) {
                case 0: {
                    QtInputDelegate.touchEnd(n, 0);
                    break;
                }
                case 1: {
                    QtInputDelegate.touchEnd(n, 2);
                    break;
                }
                case 3: {
                    QtInputDelegate.touchCancel(n);
                    break;
                }
                default: {
                    QtInputDelegate.touchEnd(n, 1);
                }
            }
        }
    }

    static void sendTrackballEvent(MotionEvent motionEvent, int n) {
        QtInputDelegate.sendMouseEvent(motionEvent, n);
    }

    static boolean sendGenericMotionEvent(MotionEvent motionEvent, int n) {
        boolean bl;
        int n2 = 15;
        int n3 = motionEvent.getSource() & 2;
        boolean bl2 = bl = n3 == 2;
        if ((motionEvent.getAction() & n2) == 0 || !bl) {
            return false;
        }
        return QtInputDelegate.sendMouseEvent(motionEvent, n);
    }

    static boolean sendMouseEvent(MotionEvent motionEvent, int n) {
        switch (motionEvent.getActionMasked()) {
            case 1: {
                QtInputDelegate.mouseUp(n, (int)motionEvent.getX(), (int)motionEvent.getY(), motionEvent.getButtonState());
                break;
            }
            case 0: {
                QtInputDelegate.mouseDown(n, (int)motionEvent.getX(), (int)motionEvent.getY(), motionEvent.getButtonState());
                m_oldX = (int)motionEvent.getX();
                m_oldY = (int)motionEvent.getY();
                break;
            }
            case 2: 
            case 7: {
                if (motionEvent.getToolType(0) == 3) {
                    QtInputDelegate.mouseMove(n, (int)motionEvent.getX(), (int)motionEvent.getY(), motionEvent.getButtonState());
                    break;
                }
                int n2 = (int)(motionEvent.getX() - (float)m_oldX);
                int n3 = (int)(motionEvent.getY() - (float)m_oldY);
                if (Math.abs(n2) <= 5 && Math.abs(n3) <= 5) break;
                QtInputDelegate.mouseMove(n, (int)motionEvent.getX(), (int)motionEvent.getY(), motionEvent.getButtonState());
                m_oldX = (int)motionEvent.getX();
                m_oldY = (int)motionEvent.getY();
                break;
            }
            case 8: {
                QtInputDelegate.mouseWheel(n, (int)motionEvent.getX(), (int)motionEvent.getY(), motionEvent.getAxisValue(10), motionEvent.getAxisValue(9));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    static interface KeyboardVisibilityListener {
        public void onKeyboardVisibilityChange();
    }
}

