/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.annotation.SuppressLint;
import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Insets;
import android.os.Build;
import android.view.DisplayCutout;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowInsets;
import java.util.HashMap;
import org.qtproject.qt.android.QtActivityBase;
import org.qtproject.qt.android.QtEditText;
import org.qtproject.qt.android.QtInputConnection;
import org.qtproject.qt.android.QtInputDelegate;
import org.qtproject.qt.android.QtLayout;
import org.qtproject.qt.android.QtNative;
import org.qtproject.qt.android.QtSurface;
import org.qtproject.qt.android.QtSurfaceInterface;
import org.qtproject.qt.android.QtTextureView;
import org.qtproject.qt.android.UsedFromNativeCode;

@SuppressLint(value={"ViewConstructor"})
class QtWindow
extends QtLayout
implements QtSurfaceInterface {
    private View m_surfaceContainer;
    private View m_nativeView;
    private final HashMap<Integer, QtWindow> m_childWindows = new HashMap();
    private QtWindow m_parentWindow;
    private GestureDetector m_gestureDetector;
    private final QtEditText m_editText;
    private final QtInputConnection.QtInputConnectionListener m_inputConnectionListener;
    private boolean m_firstSafeMarginsDelivered = false;
    private int m_actionBarHeight = -1;

    private static native void setSurface(int var0, Surface var1);

    private static native void safeAreaMarginsChanged(Insets var0, int var1);

    static native void windowFocusChanged(boolean var0, int var1);

    static native void updateWindows();

    QtWindow(Context context, boolean bl, QtWindow qtWindow, QtInputConnection.QtInputConnectionListener qtInputConnectionListener) {
        super(context);
        this.setId(View.generateViewId());
        this.m_inputConnectionListener = qtInputConnectionListener;
        this.setParent(qtWindow);
        this.setFocusableInTouchMode(true);
        this.setDefaultFocusHighlightEnabled(false);
        this.setImportantForAccessibility(2);
        this.setVisible(false);
        if (!bl && context instanceof Activity) {
            this.m_editText = new QtEditText(context, qtInputConnectionListener);
            this.m_editText.setImportantForAccessibility(2);
            QtLayout.LayoutParams layoutParams = new QtLayout.LayoutParams(-2, -2);
            QtNative.runAction(() -> this.addView(this.m_editText, layoutParams));
        } else {
            this.m_editText = null;
        }
        QtNative.runAction(() -> {
            this.m_gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

                public void onLongPress(MotionEvent motionEvent) {
                    QtInputDelegate.longPress(QtWindow.this.getId(), (int)motionEvent.getX(), (int)motionEvent.getY());
                }
            });
            this.m_gestureDetector.setIsLongpressEnabled(true);
        });
        this.registerSafeAreaMarginsListener();
    }

    void registerSafeAreaMarginsListener() {
        Object object;
        if (!(this.getContext() instanceof QtActivityBase)) {
            return;
        }
        this.setOnApplyWindowInsetsListener((view, windowInsets) -> {
            WindowInsets windowInsets2 = view.onApplyWindowInsets(windowInsets);
            this.reportSafeAreaMargins(windowInsets2, this.getId());
            return windowInsets2;
        });
        if (this.isAttachedToWindow()) {
            object = this.getRootWindowInsets();
            if (object != null) {
                this.getRootView().post(() -> this.lambda$registerSafeAreaMarginsListener$3((WindowInsets)object));
                this.m_firstSafeMarginsDelivered = true;
            }
        } else {
            this.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View view) {
                    view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    view.requestApplyInsets();
                }

                public void onViewDetachedFromWindow(View view) {
                }
            });
        }
        if (!this.m_firstSafeMarginsDelivered) {
            object = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    WindowInsets windowInsets;
                    if (QtWindow.this.isAttachedToWindow() && (windowInsets = QtWindow.this.getRootWindowInsets()) != null) {
                        QtWindow.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        QtWindow.this.getRootView().post(() -> QtWindow.this.reportSafeAreaMargins(windowInsets, QtWindow.this.getId()));
                        QtWindow.this.m_firstSafeMarginsDelivered = true;
                        return true;
                    }
                    QtWindow.this.requestApplyInsets();
                    return true;
                }
            };
            this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)object);
        }
        this.addOnLayoutChangeListener((view, n, n2, n3, n4, n5, n6, n7, n8) -> {
            WindowInsets windowInsets = this.getRootWindowInsets();
            if (windowInsets != null) {
                this.getRootView().post(() -> this.reportSafeAreaMargins(windowInsets, this.getId()));
            }
        });
    }

    Insets getSafeInsets(View view, WindowInsets windowInsets) {
        int n;
        ActionBar actionBar;
        if (Build.VERSION.SDK_INT >= 30) {
            int n2 = WindowInsets.Type.displayCutout() | WindowInsets.Type.systemBars();
            return windowInsets.getInsets(n2);
        }
        int n3 = windowInsets.getSystemWindowInsetLeft();
        int n4 = windowInsets.getSystemWindowInsetTop();
        int n5 = windowInsets.getSystemWindowInsetRight();
        int n6 = windowInsets.getSystemWindowInsetBottom();
        DisplayCutout displayCutout = windowInsets.getDisplayCutout();
        if (displayCutout != null) {
            n3 = Math.max(n3, displayCutout.getSafeInsetLeft());
            n4 = Math.max(n4, displayCutout.getSafeInsetTop());
            n5 = Math.max(n5, displayCutout.getSafeInsetRight());
            n6 = Math.max(n6, displayCutout.getSafeInsetBottom());
        }
        if (!((actionBar = ((Activity)this.getContext()).getActionBar()) != null && actionBar.isShowing() || (n = n4 - this.actionBarHeight()) <= 0)) {
            n4 = n;
        }
        return Insets.of((int)n3, (int)n4, (int)n5, (int)n6);
    }

    private void reportSafeAreaMargins(WindowInsets windowInsets, int n) {
        View view = this.getRootView();
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        int n2 = nArray[0];
        int n3 = nArray[1];
        int[] nArray2 = new int[2];
        this.getLocationOnScreen(nArray2);
        int n4 = nArray2[0];
        int n5 = nArray2[1];
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        int n8 = n2 + view.getWidth() - (n4 + this.getWidth());
        int n9 = n3 + view.getHeight() - (n5 + this.getHeight());
        Insets insets = this.getSafeInsets(view, windowInsets);
        int n10 = Math.max(0, Math.min(insets.left, insets.left - n6));
        int n11 = Math.max(0, Math.min(insets.top, insets.top - n7));
        int n12 = Math.max(0, Math.min(insets.right, insets.right - n8));
        int n13 = Math.max(0, Math.min(insets.bottom, insets.bottom - n9));
        QtWindow.safeAreaMarginsChanged(Insets.of((int)n10, (int)n11, (int)n12, (int)n13), n);
    }

    private int actionBarHeight() {
        if (this.m_actionBarHeight == -1) {
            TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(new int[]{16843499});
            try {
                this.m_actionBarHeight = typedArray.getDimensionPixelSize(0, 0);
            }
            finally {
                typedArray.recycle();
            }
        }
        return this.m_actionBarHeight;
    }

    @UsedFromNativeCode
    void setVisible(boolean bl) {
        QtNative.runAction(() -> {
            if (bl) {
                this.setVisibility(0);
            } else {
                this.setVisibility(4);
            }
        });
    }

    @Override
    public void onSurfaceChanged(Surface surface) {
        QtWindow.setSurface(this.getId(), surface);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        QtWindow.windowFocusChanged(true, this.getId());
        if (this.m_editText != null && this.m_inputConnectionListener != null) {
            this.m_inputConnectionListener.onEditTextChanged(this.m_editText);
        }
        QtInputDelegate.sendTouchEvent(motionEvent, this.getId());
        this.m_gestureDetector.onTouchEvent(motionEvent);
        return true;
    }

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        QtInputDelegate.sendTrackballEvent(motionEvent, this.getId());
        return true;
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return QtInputDelegate.sendGenericMotionEvent(motionEvent, this.getId());
    }

    @UsedFromNativeCode
    void removeWindow() {
        if (this.m_parentWindow != null) {
            this.m_parentWindow.removeChildWindow(this.getId());
        }
    }

    @UsedFromNativeCode
    void createSurface(boolean bl, int n, boolean bl2, int n2) {
        QtNative.runAction(() -> {
            if (this.m_surfaceContainer != null) {
                this.removeView(this.m_surfaceContainer);
            }
            this.m_surfaceContainer = n2 == 0 ? new QtSurface(this.getContext(), this, bl, n) : new QtTextureView(this.getContext(), this, bl2);
            this.m_surfaceContainer.setLayoutParams((ViewGroup.LayoutParams)new QtLayout.LayoutParams(-1, -1));
            this.addView(this.m_surfaceContainer, 0);
        });
    }

    @UsedFromNativeCode
    void destroySurface() {
        QtNative.runAction(() -> {
            if (this.m_surfaceContainer != null) {
                this.removeView(this.m_surfaceContainer);
                this.m_surfaceContainer = null;
            }
        }, false);
    }

    @UsedFromNativeCode
    void setGeometry(int n, int n2, int n3, int n4) {
        QtNative.runAction(() -> {
            if (this.getContext() instanceof QtActivityBase) {
                this.setLayoutParams(new QtLayout.LayoutParams(n3, n4, n, n2));
            }
        });
    }

    void addChildWindow(QtWindow qtWindow) {
        QtNative.runAction(() -> {
            this.m_childWindows.put(qtWindow.getId(), qtWindow);
            this.addView((View)qtWindow, this.getChildCount());
        });
    }

    void removeChildWindow(int n) {
        QtNative.runAction(() -> {
            if (this.m_childWindows.containsKey(n)) {
                this.removeView((View)this.m_childWindows.remove(n));
            }
        });
    }

    @UsedFromNativeCode
    void setNativeView(View view) {
        QtNative.runAction(() -> {
            if (this.m_nativeView != null) {
                this.removeView(this.m_nativeView);
            }
            this.m_nativeView = view;
            this.m_nativeView.setLayoutParams((ViewGroup.LayoutParams)new QtLayout.LayoutParams(-1, -1));
            this.addView(this.m_nativeView);
        });
    }

    @UsedFromNativeCode
    void bringChildToFront(int n) {
        QtNative.runAction(() -> {
            View view = (View)this.m_childWindows.get(n);
            if (view != null && this.getChildCount() > 0) {
                this.moveChild(view, this.getChildCount() - 1);
            }
        });
    }

    @UsedFromNativeCode
    void bringChildToBack(int n) {
        QtNative.runAction(() -> {
            View view = (View)this.m_childWindows.get(n);
            if (view != null) {
                this.moveChild(view, 0);
            }
        });
    }

    @UsedFromNativeCode
    void removeNativeView() {
        QtNative.runAction(() -> {
            if (this.m_nativeView != null) {
                this.removeView(this.m_nativeView);
                this.m_nativeView = null;
            }
        });
    }

    void setParent(QtWindow qtWindow) {
        if (this.m_parentWindow == qtWindow) {
            return;
        }
        if (this.m_parentWindow != null) {
            this.m_parentWindow.removeChildWindow(this.getId());
        }
        this.m_parentWindow = qtWindow;
        if (this.m_parentWindow != null) {
            this.m_parentWindow.addChildWindow(this);
        }
    }

    @UsedFromNativeCode
    void updateFocusedEditText() {
        if (this.m_editText != null && this.m_inputConnectionListener != null) {
            this.m_inputConnectionListener.onEditTextChanged(this.m_editText);
        }
    }

    private /* synthetic */ void lambda$registerSafeAreaMarginsListener$3(WindowInsets windowInsets) {
        this.reportSafeAreaMargins(windowInsets, this.getId());
    }
}

